/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.impl;

import com.hp.hpl.jena.graph.BulkUpdateHandler;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphEventManager;
import com.hp.hpl.jena.graph.GraphUtil;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Reifier;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.impl.GraphBase;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SimpleBulkUpdateHandler
implements BulkUpdateHandler {
    private GraphBase graph;
    private GraphEventManager manager;

    public SimpleBulkUpdateHandler(GraphBase graphBase) {
        this.graph = graphBase;
        this.manager = graphBase.getEventManager();
    }

    public void add(Triple[] tripleArray) {
        for (int i = 0; i < tripleArray.length; ++i) {
            this.graph.performAdd(tripleArray[i]);
        }
        this.manager.notifyAddArray(tripleArray);
    }

    public void add(List list) {
        this.add(list, true);
    }

    protected void add(List list, boolean bl) {
        for (int i = 0; i < list.size(); ++i) {
            this.graph.performAdd((Triple)list.get(i));
        }
        if (bl) {
            this.manager.notifyAddList(list);
        }
    }

    public void add(Iterator iterator) {
        this.addIterator(iterator, true);
    }

    public void addIterator(Iterator iterator, boolean bl) {
        List list = GraphUtil.iteratorToList(iterator);
        this.add(list, false);
        if (bl) {
            this.manager.notifyAddIterator(list);
        }
    }

    public void add(Graph graph) {
        this.add(graph, false);
    }

    public void add(Graph graph, boolean bl) {
        this.addIterator(GraphUtil.findAll(graph), false);
        if (bl) {
            SimpleBulkUpdateHandler.addReifications(this.graph, graph);
        }
        this.manager.notifyAddGraph(graph);
    }

    public static void addReifications(Graph graph, Graph graph2) {
        Reifier reifier = graph2.getReifier();
        ExtendedIterator extendedIterator = reifier.allNodes();
        while (extendedIterator.hasNext()) {
            Node node = (Node)extendedIterator.next();
            graph.getReifier().reifyAs(node, reifier.getTriple(node));
        }
    }

    public static void deleteReifications(Graph graph, Graph graph2) {
        Reifier reifier = graph2.getReifier();
        ExtendedIterator extendedIterator = reifier.allNodes();
        while (extendedIterator.hasNext()) {
            Node node = (Node)extendedIterator.next();
            graph.getReifier().remove(node, reifier.getTriple(node));
        }
    }

    public void delete(Triple[] tripleArray) {
        for (int i = 0; i < tripleArray.length; ++i) {
            this.graph.performDelete(tripleArray[i]);
        }
        this.manager.notifyDeleteArray(tripleArray);
    }

    public void delete(List list) {
        this.delete(list, true);
    }

    protected void delete(List list, boolean bl) {
        for (int i = 0; i < list.size(); ++i) {
            this.graph.performDelete((Triple)list.get(i));
        }
        if (bl) {
            this.manager.notifyDeleteList(list);
        }
    }

    public void delete(Iterator iterator) {
        this.deleteIterator(iterator, true);
    }

    public void deleteIterator(Iterator iterator, boolean bl) {
        List list = GraphUtil.iteratorToList(iterator);
        this.delete(list, false);
        if (bl) {
            this.manager.notifyDeleteIterator(list);
        }
    }

    private List triplesOf(Graph graph) {
        ArrayList arrayList = new ArrayList();
        ExtendedIterator extendedIterator = graph.find(null, null, null);
        while (extendedIterator.hasNext()) {
            arrayList.add(extendedIterator.next());
        }
        return arrayList;
    }

    public void delete(Graph graph) {
        this.delete(graph, false);
    }

    public void delete(Graph graph, boolean bl) {
        if (graph.dependsOn(this.graph)) {
            this.delete(this.triplesOf(graph));
        } else {
            this.deleteIterator(GraphUtil.findAll(graph), false);
        }
        if (bl) {
            SimpleBulkUpdateHandler.deleteReifications(this.graph, graph);
        }
        this.manager.notifyDeleteGraph(graph);
    }
}

