/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.query;

import com.hp.hpl.jena.graph.query.IndexValues;
import com.hp.hpl.jena.graph.query.Valuator;
import com.hp.hpl.jena.graph.query.VariableIndexes;
import com.hp.hpl.jena.graph.query.VariableValues;
import java.util.HashSet;
import java.util.Set;

public interface Expression {
    public static final Expression TRUE = new BoolConstant(true);
    public static final Expression FALSE = new BoolConstant(false);

    public boolean evalBool(VariableValues var1);

    public Valuator prepare(VariableIndexes var1);

    public boolean isVariable();

    public String getName();

    public boolean isLiteral();

    public Object getValue();

    public boolean isApply();

    public String getFun();

    public int argCount();

    public Expression getArg(int var1);

    public static class BoolConstant
    extends Base
    implements Expression,
    Valuator {
        private boolean value;

        public BoolConstant(boolean bl) {
            this.value = bl;
        }

        public boolean isLiteral() {
            return true;
        }

        public Object getValue() {
            return this.value ? Boolean.TRUE : Boolean.FALSE;
        }

        public Valuator prepare(VariableIndexes variableIndexes) {
            return this;
        }

        public boolean evalBool(VariableValues variableValues) {
            return this.value;
        }

        public boolean evalBool(IndexValues indexValues) {
            return this.value;
        }
    }

    public static class Valof
    implements VariableValues {
        private VariableIndexes map;
        private IndexValues dom;

        public Valof(VariableIndexes variableIndexes) {
            this.map = variableIndexes;
        }

        public final Object get(String string) {
            return this.dom.get(this.map.indexOf(string));
        }

        public final Valof setDomain(IndexValues indexValues) {
            this.dom = indexValues;
            return this;
        }
    }

    public static class Util {
        public static Set variablesOf(Expression expression) {
            return Util.addVariablesOf(new HashSet(), expression);
        }

        public static Set addVariablesOf(Set set, Expression expression) {
            if (expression.isVariable()) {
                set.add(expression.getName());
            } else if (expression.isApply()) {
                for (int i = 0; i < expression.argCount(); ++i) {
                    Util.addVariablesOf(set, expression.getArg(i));
                }
            }
            return set;
        }

        public static Valuator prepare(Expression expression, VariableIndexes variableIndexes) {
            Valof valof = new Valof(variableIndexes);
            return new Valuator(expression, valof){
                private final /* synthetic */ Expression val$e;
                private final /* synthetic */ Valof val$valof;
                {
                    this.val$e = expression;
                    this.val$valof = valof;
                }

                public boolean evalBool(IndexValues indexValues) {
                    return this.val$e.evalBool(this.val$valof.setDomain(indexValues));
                }
            };
        }
    }

    public static abstract class Application
    extends Base {
        public boolean isApply() {
            return true;
        }

        public abstract int argCount();

        public abstract String getFun();

        public abstract Expression getArg(int var1);
    }

    public static abstract class Variable
    extends Base {
        public boolean isVariable() {
            return true;
        }

        public abstract String getName();
    }

    public static abstract class Literal
    extends Base {
        public boolean isLiteral() {
            return true;
        }

        public abstract Object getValue();
    }

    public static abstract class Base
    implements Expression {
        public boolean isVariable() {
            return false;
        }

        public boolean isApply() {
            return false;
        }

        public boolean isLiteral() {
            return false;
        }

        public String getName() {
            return null;
        }

        public Object getValue() {
            return null;
        }

        public int argCount() {
            return 0;
        }

        public String getFun() {
            return null;
        }

        public Expression getArg(int n) {
            return null;
        }

        public Valuator prepare(VariableIndexes variableIndexes) {
            return Util.prepare(this, variableIndexes);
        }
    }
}

