/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.query;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphUtil;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.query.Expression;
import com.hp.hpl.jena.graph.query.ExpressionSet;
import com.hp.hpl.jena.graph.query.NamedGraphMap;
import com.hp.hpl.jena.graph.query.NamedTripleBunches;
import com.hp.hpl.jena.graph.query.SimpleQueryEngine;
import com.hp.hpl.jena.graph.query.TripleSorter;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.ArrayList;
import java.util.List;

public class Query {
    public static final Node ANY = Node.ANY;
    public static final Node S = Node.createVariable("S");
    public static final Node P = Node.createVariable("P");
    public static final Node O = Node.createVariable("O");
    public static final Node X = Node.createVariable("X");
    public static final Node Y = Node.createVariable("Y");
    public static final Node Z = Node.createVariable("Z");
    private ExpressionSet constraint = new ExpressionSet();
    private SimpleQueryEngine lastQueryEngine = null;
    private NamedTripleBunches triples = new NamedTripleBunches();
    private NamedGraphMap argMap = new NamedGraphMap();
    public static final TripleSorter dontSort = TripleSorter.dontSort;
    private TripleSorter sortMethod = TripleSorter.dontSort;

    public Query() {
    }

    public Query(Graph graph) {
        this.addMatches(graph);
    }

    public Query addMatch(Node node, Node node2, Node node3) {
        return this.addNamedMatch("<this>", node, node2, node3);
    }

    public Query addMatch(Triple triple) {
        this.triples.add("<this>", triple);
        return this;
    }

    public Query addMatch(String string, Node node, Node node2, Node node3) {
        return this.addNamedMatch(string, node, node2, node3);
    }

    public ExpressionSet getConstraints() {
        return this.constraint;
    }

    public Query addConstraint(Expression expression) {
        if (expression.isApply() && expression.getFun().equals("http://jena.hpl.hp.com/query/functions#AND")) {
            for (int i = 0; i < expression.argCount(); ++i) {
                this.addConstraint(expression.getArg(i));
            }
        } else {
            this.constraint.add(expression);
        }
        return this;
    }

    private void addMatches(Graph graph) {
        ExtendedIterator extendedIterator = GraphUtil.findAll(graph);
        while (extendedIterator.hasNext()) {
            this.addMatch((Triple)extendedIterator.next());
        }
    }

    public ExtendedIterator executeBindings(Graph graph, Node[] nodeArray) {
        return this.executeBindings(this.args().put("<this>", graph), nodeArray);
    }

    public ExtendedIterator executeBindings(Graph graph, List list, Node[] nodeArray) {
        return this.executeBindings(list, this.args().put("<this>", graph), nodeArray);
    }

    public ExtendedIterator executeBindings(NamedGraphMap namedGraphMap, Node[] nodeArray) {
        return this.executeBindings(new ArrayList(), namedGraphMap, nodeArray);
    }

    public ExtendedIterator executeBindings(List list, NamedGraphMap namedGraphMap, Node[] nodeArray) {
        SimpleQueryEngine simpleQueryEngine = new SimpleQueryEngine(this.triples, this.sortMethod, this.constraint);
        ExtendedIterator extendedIterator = simpleQueryEngine.executeBindings(list, namedGraphMap, nodeArray);
        this.lastQueryEngine = simpleQueryEngine;
        return extendedIterator;
    }

    public NamedTripleBunches getTriples() {
        return this.triples;
    }

    public NamedGraphMap args() {
        return this.argMap;
    }

    private Query addNamedMatch(String string, Node node, Node node2, Node node3) {
        this.triples.add(string, new Triple(node, node2, node3));
        return this;
    }

    public TripleSorter getSorter() {
        return this.sortMethod;
    }

    public void setTripleSorter(TripleSorter tripleSorter) {
        this.sortMethod = tripleSorter == null ? TripleSorter.dontSort : tripleSorter;
    }

    public int getVariableCount() {
        return this.lastQueryEngine.getVariableCount();
    }

    public static class UnboundVariableException
    extends JenaException {
        public UnboundVariableException(Node node) {
            super(node.toString());
        }
    }
}

