/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.query;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.query.BufferPipe;
import com.hp.hpl.jena.graph.query.ConstraintStage;
import com.hp.hpl.jena.graph.query.ExpressionSet;
import com.hp.hpl.jena.graph.query.Mapping;
import com.hp.hpl.jena.graph.query.NamedGraphMap;
import com.hp.hpl.jena.graph.query.NamedTripleBunches;
import com.hp.hpl.jena.graph.query.Pipe;
import com.hp.hpl.jena.graph.query.Stage;
import com.hp.hpl.jena.graph.query.TripleSorter;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.NiceIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SimpleQueryEngine {
    private ExpressionSet constraint;
    private NamedTripleBunches triples;
    private TripleSorter sortMethod;
    private int variableCount;

    public SimpleQueryEngine(NamedTripleBunches namedTripleBunches, TripleSorter tripleSorter, ExpressionSet expressionSet) {
        this.constraint = expressionSet;
        this.triples = namedTripleBunches;
        this.sortMethod = tripleSorter;
    }

    int getVariableCount() {
        return this.variableCount;
    }

    public ExtendedIterator executeBindings(List list, NamedGraphMap namedGraphMap, Node[] nodeArray) {
        Mapping mapping = new Mapping(nodeArray);
        ArrayList<ConstraintStage> arrayList = new ArrayList<ConstraintStage>();
        this.addStages(arrayList, namedGraphMap, mapping);
        if (this.constraint.isComplex()) {
            arrayList.add(new ConstraintStage(mapping, this.constraint));
        }
        list.addAll(arrayList);
        this.variableCount = mapping.size();
        return this.filter(this.connectStages(arrayList, this.variableCount));
    }

    private ExtendedIterator filter(final Stage stage) {
        final Pipe pipe = stage.deliver(new BufferPipe());
        return new NiceIterator(){

            public void close() {
                stage.close();
                this.clearPipe();
            }

            public Object next() {
                return pipe.get();
            }

            public boolean hasNext() {
                return pipe.hasNext();
            }

            private void clearPipe() {
                int n = 0;
                while (this.hasNext()) {
                    ++n;
                    this.next();
                }
            }
        };
    }

    public static Cons cons(Triple triple, Object object) {
        return new Cons(triple, (Cons)object);
    }

    private void addStages(ArrayList arrayList, NamedGraphMap namedGraphMap, Mapping mapping) {
        Iterator iterator = this.triples.entrySetIterator();
        while (iterator.hasNext()) {
            int n;
            Map.Entry entry = (Map.Entry)iterator.next();
            String string = (String)entry.getKey();
            Cons cons = (Cons)entry.getValue();
            Graph graph = namedGraphMap.get(string);
            int n2 = n = Cons.size(cons);
            Triple[] tripleArray = new Triple[n];
            while (cons != null) {
                tripleArray[--n2] = cons.head;
                cons = cons.tail;
            }
            tripleArray = this.sortTriples(tripleArray);
            Stage stage = graph.queryHandler().patternStage(mapping, this.constraint, tripleArray);
            arrayList.add(stage);
        }
    }

    private Triple[] sortTriples(Triple[] tripleArray) {
        return this.sortMethod.sort(tripleArray);
    }

    private Stage connectStages(ArrayList arrayList, int n) {
        Stage stage = Stage.initial(n);
        for (int i = 0; i < arrayList.size(); ++i) {
            stage = ((Stage)arrayList.get(i)).connectFrom(stage);
        }
        return stage;
    }

    private static class Cons {
        Triple head;
        Cons tail;

        Cons(Triple triple, Cons cons) {
            this.head = triple;
            this.tail = cons;
        }

        static int size(Cons cons) {
            int n = 0;
            while (cons != null) {
                ++n;
                cons = cons.tail;
            }
            return n;
        }
    }
}

