/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.query.test;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Node_Literal;
import com.hp.hpl.jena.graph.query.Expression;
import com.hp.hpl.jena.graph.query.IndexValues;
import com.hp.hpl.jena.graph.query.Valuator;
import com.hp.hpl.jena.graph.query.VariableIndexes;
import com.hp.hpl.jena.graph.query.VariableValues;
import com.hp.hpl.jena.graph.query.test.BaseExampleExpression;
import java.util.List;

public class ExampleCreate {
    public static BaseExampleExpression NE(Node node, Node node2) {
        return new Dyadic(node, node2){

            public boolean evalBool(VariableValues variableValues) {
                return !this.L.eval(variableValues).equals(this.R.eval(variableValues));
            }

            public String getFun() {
                return "http://jena.hpl.hp.com/constraints/NE";
            }

            public Valuator prepare(VariableIndexes variableIndexes) {
                return new DyadicValuator(this, (ObjectValuator)this.L.prepare(variableIndexes), (ObjectValuator)this.R.prepare(variableIndexes)){
                    private final /* synthetic */ 2 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public boolean evalBool(IndexValues indexValues) {
                        return !this.L.eval(indexValues).equals(this.R.eval(indexValues));
                    }
                };
            }
        };
    }

    public static BaseExampleExpression EQ(Node node, Node node2) {
        return new Dyadic(node, node2){

            public boolean evalBool(VariableValues variableValues) {
                return this.L.eval(variableValues).equals(this.R.eval(variableValues));
            }

            public String getFun() {
                return "http://jena.hpl.hp.com/constraints/EQ";
            }

            public Valuator prepare(VariableIndexes variableIndexes) {
                return new DyadicValuator(this, (ObjectValuator)this.L.prepare(variableIndexes), (ObjectValuator)this.R.prepare(variableIndexes)){
                    private final /* synthetic */ 4 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public boolean evalBool(IndexValues indexValues) {
                        return this.L.eval(indexValues).equals(this.R.eval(indexValues));
                    }
                };
            }
        };
    }

    public static BaseExampleExpression MATCHES(Node node, Node node2) {
        return new Dyadic(node, node2){

            public String getFun() {
                return "http://jena.hpl.hp.com/constraints/MATCHES";
            }

            private String asString(Object object) {
                if (object instanceof Node_Literal) {
                    return ((Node)object).getLiteral().getLexicalForm();
                }
                return object.toString();
            }

            public boolean matches(Object object, Object object2) {
                String string;
                String string2 = this.asString(object);
                return string2.indexOf(string = this.asString(object2)) > -1;
            }

            public boolean evalBool(VariableValues variableValues) {
                return this.matches(this.L.eval(variableValues), this.R.eval(variableValues));
            }

            public Valuator prepare(VariableIndexes variableIndexes) {
                return new DyadicValuator(this, (ObjectValuator)this.L.prepare(variableIndexes), (ObjectValuator)this.R.prepare(variableIndexes)){
                    private final /* synthetic */ 6 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public String toString() {
                        return super.toString() + " :: MATCHES()";
                    }

                    public boolean evalBool(IndexValues indexValues) {
                        return this.this$0.matches(this.L.eval(indexValues), this.R.eval(indexValues));
                    }
                };
            }
        };
    }

    public static abstract class Dyadic
    extends BaseExampleExpression {
        protected BaseExampleExpression L;
        protected BaseExampleExpression R;
        protected List args;

        public Dyadic(Node node, Node node2) {
            this.L = this.asExpression(node);
            this.R = this.asExpression(node2);
        }

        public boolean isApply() {
            return true;
        }

        public int argCount() {
            return 2;
        }

        public Expression getArg(int n) {
            return n == 0 ? this.L : this.R;
        }

        public BaseExampleExpression asExpression(Node node) {
            return new BaseExampleExpression(this, node){
                private final /* synthetic */ Node val$x;
                private final /* synthetic */ Dyadic this$0;
                {
                    this.this$0 = dyadic;
                    this.val$x = node;
                }

                public boolean evalBool(VariableValues variableValues) {
                    if (this.val$x.isVariable()) {
                        return (Boolean)variableValues.get(this.val$x.getName());
                    }
                    return false;
                }

                public boolean isVariable() {
                    return this.val$x.isVariable();
                }

                public String getName() {
                    return this.val$x.getName();
                }

                public Object eval(VariableValues variableValues) {
                    if (this.val$x.isVariable()) {
                        return variableValues.get(this.val$x.getName());
                    }
                    return this.val$x;
                }

                public Valuator prepare(VariableIndexes variableIndexes) {
                    if (this.val$x.isVariable()) {
                        return new SlotValuator(variableIndexes.indexOf(this.val$x.getName()));
                    }
                    return new FixedValuator(this.val$x);
                }
            };
        }
    }

    public static class SlotValuator
    implements ObjectValuator {
        private int index;

        SlotValuator(int n) {
            this.index = n;
        }

        public boolean evalBool(IndexValues indexValues) {
            return (Boolean)this.eval(indexValues);
        }

        public Object eval(IndexValues indexValues) {
            return indexValues.get(this.index);
        }
    }

    public static class FixedValuator
    implements ObjectValuator {
        private Object value;

        FixedValuator(Object object) {
            this.value = object;
        }

        public boolean evalBool(IndexValues indexValues) {
            return (Boolean)this.eval(indexValues);
        }

        public Object eval(IndexValues indexValues) {
            return this.value;
        }
    }

    public static abstract class DyadicValuator
    extends BaseExampleExpression.BaseExampleValuator
    implements ObjectValuator {
        ObjectValuator L;
        ObjectValuator R;

        DyadicValuator(ObjectValuator objectValuator, ObjectValuator objectValuator2) {
            this.L = objectValuator;
            this.R = objectValuator2;
        }

        public Object eval(IndexValues indexValues) {
            return this.evalBool(indexValues);
        }
    }

    static interface ObjectValuator
    extends Valuator {
        public Object eval(IndexValues var1);
    }
}

