/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.query.test;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.query.Expression;
import com.hp.hpl.jena.graph.query.IndexValues;
import com.hp.hpl.jena.graph.query.Mapping;
import com.hp.hpl.jena.graph.query.Query;
import com.hp.hpl.jena.graph.query.Valuator;
import com.hp.hpl.jena.graph.query.VariableValues;
import com.hp.hpl.jena.graph.query.test.BaseExampleExpression;
import com.hp.hpl.jena.graph.query.test.ExampleCreate;
import com.hp.hpl.jena.graph.test.GraphTestBase;
import com.hp.hpl.jena.util.iterator.Map1;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.TestSuite;

public class TestExpressionConstraints
extends GraphTestBase {
    protected static final Node X = Query.X;
    protected static final Node Y = Query.Y;
    protected static final Node Z = Query.Z;
    protected static final Node ANY = Query.ANY;
    protected static final Expression eTRUE = Expression.TRUE;
    protected static final Expression eFALSE = Expression.FALSE;
    protected static final Map1 getFirst = new Map1(){

        public Object map1(Object object) {
            return ((List)object).get(0);
        }
    };
    static /* synthetic */ Class class$com$hp$hpl$jena$graph$query$test$TestExpressionConstraints;

    public TestExpressionConstraints(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(class$com$hp$hpl$jena$graph$query$test$TestExpressionConstraints == null ? (class$com$hp$hpl$jena$graph$query$test$TestExpressionConstraints = TestExpressionConstraints.class$("com.hp.hpl.jena.graph.query.test.TestExpressionConstraints")) : class$com$hp$hpl$jena$graph$query$test$TestExpressionConstraints);
    }

    public void testConstraintFALSE() {
        Graph graph = TestExpressionConstraints.graphWith("x R y; a P b");
        Query query = new Query().addMatch(X, ANY, ANY).addConstraint(eFALSE);
        TestExpressionConstraints.assertFalse((boolean)query.executeBindings(graph, new Node[]{X}).hasNext());
    }

    public void testConstraintTRUE() {
        Graph graph = TestExpressionConstraints.graphWith("x R y; a P b");
        Query query = new Query().addMatch(X, ANY, ANY).addConstraint(eTRUE);
        TestExpressionConstraints.assertTrue((boolean)query.executeBindings(graph, new Node[]{X}).hasNext());
    }

    private BaseExampleExpression notEqual(Node node, Node node2) {
        return ExampleCreate.NE(node, node2);
    }

    private BaseExampleExpression areEqual(Node node, Node node2) {
        return ExampleCreate.EQ(node, node2);
    }

    protected BaseExampleExpression matches(Node node, Node node2) {
        return ExampleCreate.MATCHES(node, node2);
    }

    public void testConstraintNE1() {
        Graph graph = TestExpressionConstraints.graphWith("x R y; a P a");
        Query query = new Query().addMatch(X, ANY, Y).addConstraint(this.notEqual(X, Y));
        HashSet<Node> hashSet = new HashSet<Node>();
        hashSet.add(TestExpressionConstraints.node("x"));
        TestExpressionConstraints.assertEquals(hashSet, (Object)TestExpressionConstraints.iteratorToSet(query.executeBindings(graph, new Node[]{X}).mapWith(getFirst)));
    }

    public void testConstraintNE2() {
        Graph graph = TestExpressionConstraints.graphWith("x R y; a P a");
        Query query = new Query().addMatch(X, ANY, Y).addConstraint(this.notEqual(X, Y));
        HashSet<Node> hashSet = new HashSet<Node>();
        hashSet.add(TestExpressionConstraints.node("x"));
        TestExpressionConstraints.assertEquals(hashSet, (Object)TestExpressionConstraints.iteratorToSet(query.executeBindings(graph, new Node[]{X}).mapWith(getFirst)));
    }

    public void testConstraintNE3() {
        Graph graph = TestExpressionConstraints.graphWith("x R a; y P b; z Q c");
        Query query = new Query().addMatch(X, ANY, ANY).addConstraint(this.notEqual(X, TestExpressionConstraints.node("y")));
        HashSet<Node> hashSet = new HashSet<Node>();
        hashSet.add(TestExpressionConstraints.node("x"));
        hashSet.add(TestExpressionConstraints.node("z"));
        TestExpressionConstraints.assertEquals(hashSet, (Object)TestExpressionConstraints.iteratorToSet(query.executeBindings(graph, new Node[]{X}).mapWith(getFirst)));
    }

    public void testConstraintNE4() {
        Graph graph = TestExpressionConstraints.graphWith("x R a; y P b; z Q c");
        Query query = new Query().addMatch(X, ANY, ANY).addConstraint(this.notEqual(X, TestExpressionConstraints.node("y"))).addConstraint(this.notEqual(X, TestExpressionConstraints.node("x")));
        HashSet<Node> hashSet = new HashSet<Node>();
        hashSet.add(TestExpressionConstraints.node("z"));
        TestExpressionConstraints.assertEquals(hashSet, (Object)TestExpressionConstraints.iteratorToSet(query.executeBindings(graph, new Node[]{X}).mapWith(getFirst)));
    }

    public void testVV() {
        VV vV = new VV().set("X", "1").set("Y", "2").set("Z", "3");
        TestExpressionConstraints.assertEquals((Object)"1", (Object)vV.get("X"));
        TestExpressionConstraints.assertEquals((Object)"2", (Object)vV.get("Y"));
        TestExpressionConstraints.assertEquals((Object)"3", (Object)vV.get("Z"));
    }

    public void testNE() {
        BaseExampleExpression baseExampleExpression = this.areEqual(X, Y);
        VV vV = new VV().set("X", "1").set("Y", "2");
        TestExpressionConstraints.assertEquals((boolean)false, (boolean)baseExampleExpression.evalBool(vV));
    }

    public void testVVTrue() {
        TestExpressionConstraints.assertEquals((boolean)true, (boolean)Expression.TRUE.evalBool(new VV()));
    }

    public void testVVFalse() {
        TestExpressionConstraints.assertEquals((boolean)false, (boolean)Expression.FALSE.evalBool(new VV()));
    }

    public void testVVMatches() {
        VV vV = new VV().set("X", "hello").set("Y", "ell");
        TestExpressionConstraints.assertEquals((boolean)true, (boolean)this.matches(X, Y).evalBool(vV));
    }

    public void testPrepareTRUE() {
        IndexValues indexValues = new IndexValues(){

            public Object get(int n) {
                return null;
            }
        };
        Valuator valuator = Expression.TRUE.prepare(new Mapping(new Node[0]));
        TestExpressionConstraints.assertEquals((boolean)true, (boolean)valuator.evalBool(indexValues));
    }

    public void testPrepareFALSE() {
        IndexValues indexValues = new IndexValues(){

            public Object get(int n) {
                return null;
            }
        };
        Valuator valuator = Expression.FALSE.prepare(new Mapping(new Node[0]));
        TestExpressionConstraints.assertEquals((boolean)false, (boolean)valuator.evalBool(indexValues));
    }

    public void testPrepareNE() {
        BaseExampleExpression baseExampleExpression = this.notEqual(X, Y);
        Mapping mapping = new Mapping(new Node[2]);
    }

    public void testURIs() {
        TestExpressionConstraints.assertEquals((String)"http://jena.hpl.hp.com/constraints/NE", (String)this.notEqual(X, Y).getFun());
        TestExpressionConstraints.assertEquals((String)"http://jena.hpl.hp.com/constraints/EQ", (String)this.areEqual(X, Y).getFun());
        TestExpressionConstraints.assertEquals((String)"http://jena.hpl.hp.com/constraints/MATCHES", (String)this.matches(X, Y).getFun());
    }

    public void testLiterals() {
        TestExpressionConstraints.assertTrue((boolean)Expression.TRUE.isLiteral());
        TestExpressionConstraints.assertTrue((boolean)Expression.FALSE.isLiteral());
        TestExpressionConstraints.assertFalse((boolean)this.notEqual(X, Y).isLiteral());
        TestExpressionConstraints.assertEquals((Object)Boolean.TRUE, (Object)Expression.TRUE.getValue());
        TestExpressionConstraints.assertEquals((Object)Boolean.FALSE, (Object)Expression.FALSE.getValue());
    }

    public void testDetectAnd() {
        BaseExampleExpression baseExampleExpression = this.notEqual(X, Y);
        BaseExampleExpression baseExampleExpression2 = this.notEqual(X, Z);
        Query query = new Query().addConstraint(baseExampleExpression.and(baseExampleExpression2));
        HashSet<BaseExampleExpression> hashSet = new HashSet<BaseExampleExpression>();
        hashSet.add(baseExampleExpression);
        hashSet.add(baseExampleExpression2);
        Set set = TestExpressionConstraints.iteratorToSet(query.getConstraints().iterator());
        TestExpressionConstraints.assertEquals(hashSet, (Object)set);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class VV
    implements VariableValues {
        private Map values = new HashMap();

        public VV set(String string, String string2) {
            this.values.put(string, string2);
            return this;
        }

        public Object get(String string) {
            return this.values.get(string);
        }
    }
}

