/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.query.test;

import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.query.SimpleTripleSorter;
import com.hp.hpl.jena.graph.query.TripleSorter;
import com.hp.hpl.jena.graph.test.GraphTestBase;
import java.util.Arrays;
import junit.framework.TestSuite;

public class TestSimpleTripleSorter
extends GraphTestBase {
    private TripleSorter sorter = new SimpleTripleSorter();
    static /* synthetic */ Class class$com$hp$hpl$jena$graph$query$test$TestSimpleTripleSorter;

    public TestSimpleTripleSorter(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(class$com$hp$hpl$jena$graph$query$test$TestSimpleTripleSorter == null ? (class$com$hp$hpl$jena$graph$query$test$TestSimpleTripleSorter = TestSimpleTripleSorter.class$("com.hp.hpl.jena.graph.query.test.TestSimpleTripleSorter")) : class$com$hp$hpl$jena$graph$query$test$TestSimpleTripleSorter);
    }

    public void testEmpty() {
        Triple[] tripleArray = new Triple[]{};
        TestSimpleTripleSorter.assertEquals((int)0, (int)this.sorter.sort(tripleArray).length);
    }

    public void testSingle() {
        this.testSingle("S P O");
        this.testSingle("S ?P O");
        this.testSingle("S P ?O");
        this.testSingle("?S ?P O");
        this.testSingle("?S P ?O");
        this.testSingle("S ?P ?O");
        this.testSingle("?S ?P ?O");
        this.testSingle("?? P O");
        this.testSingle("S ?? O");
        this.testSingle("S P ??O");
        this.testSingle("?? ?? O");
        this.testSingle("?? P ??");
        this.testSingle("S ?? ??");
        this.testSingle("?? ?? ??");
    }

    public void testSingle(String string) {
        Triple triple = Triple.create(string);
        TestSimpleTripleSorter.assertEquals(Arrays.asList(triple), Arrays.asList(this.sorter.sort(new Triple[]{triple})));
    }

    public void testConcreteFirst() {
        this.testReordersTo("S P O; ?s ?p ?o", "S P O; ?s ?p ?o");
        this.testReordersTo("S P O; ?s ?p ?o", "?s ?p ?o; S P O");
        this.testReordersTo("S P O; ?s ?p ?o; ?a ?b ?c", "?s ?p ?o; ?a ?b ?c; S P O");
        this.testReordersTo("S P O; ?s ?p ?o; ?a ?b ?c", "?s ?p ?o; S P O; ?a ?b ?c");
    }

    public void testBoundFirst() {
        this.testReordersTo("?s R a; ?s ?p ?o", "?s ?p ?o; ?s R a");
        this.testReordersTo("?s R a; ?s ?p b;", "?s ?p b; ?s R a");
        this.testReordersTo("?a P b; ?c Q d; ?a P ?c", "?a P b; ?a P ?c; ?c Q d");
    }

    public void testANY() {
        this.testReordersTo("?? C d; ?a X ?b", "?a X ?b; ?? C d");
        this.testReordersTo("?a B c; ?? D e", "?? D e; ?a B c");
    }

    public void testInteraction() {
        this.testReordersTo("?a P b; ?a Q ?b; ?b R ?c", "?b R ?c; ?a Q ?b; ?a P b");
    }

    public void testSortByMass() {
        this.testReordersTo("?b c d; ?a b c; ?b ?c d; ?a ?b ?d", "?a b c; ?b c d; ?b ?c d; ?a ?b ?d");
    }

    public void testReordersTo(String string, String string2) {
        Triple[] tripleArray = TestSimpleTripleSorter.tripleArray(string2);
        Triple[] tripleArray2 = TestSimpleTripleSorter.tripleArray(string);
        TestSimpleTripleSorter.assertEquals(Arrays.asList(tripleArray2), Arrays.asList(this.sorter.sort(tripleArray)));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

