/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.test;

import com.hp.hpl.jena.graph.Factory;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Reifier;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.test.GraphTestBase;
import com.hp.hpl.jena.shared.AlreadyReifiedException;
import com.hp.hpl.jena.shared.CannotReifyException;
import com.hp.hpl.jena.shared.ReificationStyle;
import com.hp.hpl.jena.vocabulary.RDF;

public abstract class AbstractTestReifier
extends GraphTestBase {
    protected static final ReificationStyle Minimal = ReificationStyle.Minimal;
    protected static final ReificationStyle Standard = ReificationStyle.Standard;
    protected static final ReificationStyle Convenient = ReificationStyle.Convenient;

    public AbstractTestReifier(String string) {
        super(string);
    }

    public Graph getGraph() {
        return this.getGraph(Minimal);
    }

    public abstract Graph getGraph(ReificationStyle var1);

    protected final Graph getGraphWith(String string) {
        Graph graph = this.getGraph();
        AbstractTestReifier.graphAdd(graph, string);
        return graph;
    }

    protected final Graph graphWithUnless(boolean bl, String string) {
        return AbstractTestReifier.graphWith(bl ? "" : string);
    }

    protected final Graph graphWithIf(boolean bl, String string) {
        return this.graphWithUnless(!bl, string);
    }

    public void testStyle() {
        AbstractTestReifier.assertSame((Object)Minimal, (Object)this.getGraph(Minimal).getReifier().getStyle());
        AbstractTestReifier.assertSame((Object)Standard, (Object)this.getGraph(Standard).getReifier().getStyle());
        AbstractTestReifier.assertSame((Object)Convenient, (Object)this.getGraph(Convenient).getReifier().getStyle());
    }

    public void testEmptyReifiers() {
        AbstractTestReifier.assertEquals((String)"no reified triples", (int)0, (int)this.getGraphWith("x R y").getReifier().getHiddenTriples().size());
        AbstractTestReifier.assertEquals((String)"no reified triples", (int)0, (int)this.getGraphWith("x R y; p S q").getReifier().getHiddenTriples().size());
    }

    public void testSameReifier() {
        Graph graph = this.getGraph();
        Reifier reifier = graph.getReifier();
        graph.add(AbstractTestReifier.triple("x R y"));
        AbstractTestReifier.assertTrue((String)"same reifier", (reifier == graph.getReifier() ? 1 : 0) != 0);
    }

    public void testParent() {
        Graph graph = this.getGraph();
        Graph graph2 = this.getGraph();
        AbstractTestReifier.assertTrue((String)"correct reifier (G)", (graph == graph.getReifier().getParentGraph() ? 1 : 0) != 0);
        AbstractTestReifier.assertTrue((String)"correct reifier (H)", (graph2 == graph2.getReifier().getParentGraph() ? 1 : 0) != 0);
    }

    public void testIntercept() {
        Graph graph = this.getGraph(Convenient);
        Reifier reifier = graph.getReifier();
        Node node = AbstractTestReifier.node("sub");
        Node node2 = AbstractTestReifier.node("obj");
        Node node3 = AbstractTestReifier.node("http://example.org/type");
        AbstractTestReifier.assertFalse((String)"reifier must not intercept quadlet", (boolean)reifier.handledAdd(new Triple(node, RDF.Nodes.type, node3)));
        AbstractTestReifier.assertFalse((String)"reifier must not intercept quadlet", (boolean)reifier.handledAdd(new Triple(node, node, RDF.Nodes.subject)));
        AbstractTestReifier.assertFalse((String)"reifier must not intercept quadlet", (boolean)reifier.handledAdd(new Triple(node, node, RDF.Nodes.type)));
        AbstractTestReifier.assertTrue((String)"reifier must intercept quadlet", (boolean)reifier.handledAdd(new Triple(node, RDF.Nodes.predicate, node2)));
        AbstractTestReifier.assertTrue((String)"reifier must intercept quadlet", (boolean)reifier.handledAdd(new Triple(node, RDF.Nodes.type, RDF.Nodes.Statement)));
    }

    public void testStandard() {
        Graph graph = this.getGraph(Standard);
        AbstractTestReifier.assertFalse((boolean)graph.getReifier().hasTriple(AbstractTestReifier.triple("s p o")));
        graph.add(Triple.create("x rdf:subject s"));
        AbstractTestReifier.assertEquals((int)1, (int)graph.size());
        graph.add(Triple.create("x rdf:predicate p"));
        AbstractTestReifier.assertEquals((int)2, (int)graph.size());
        graph.add(Triple.create("x rdf:object o"));
        AbstractTestReifier.assertEquals((int)3, (int)graph.size());
        graph.add(Triple.create("x rdf:type rdf:Statement"));
        AbstractTestReifier.assertEquals((int)4, (int)graph.size());
        AbstractTestReifier.assertTrue((boolean)graph.getReifier().hasTriple(AbstractTestReifier.triple("s p o")));
    }

    public void testStandardExplode() {
        Graph graph = this.getGraph(Standard);
        graph.getReifier().reifyAs(AbstractTestReifier.node("a"), AbstractTestReifier.triple("p Q r"));
        Graph graph2 = Factory.createDefaultGraph(Minimal);
        AbstractTestReifier.graphAdd(graph2, "a rdf:type rdf:Statement; a rdf:subject p; a rdf:predicate Q; a rdf:object r");
        AbstractTestReifier.assertEquals((int)4, (int)graph.size());
        AbstractTestReifier.assertIsomorphic(graph2, graph);
    }

    public void testMinimalExplode() {
        Graph graph = this.getGraph(Minimal);
        graph.getReifier().reifyAs(AbstractTestReifier.node("a"), AbstractTestReifier.triple("p Q r"));
        AbstractTestReifier.assertEquals((int)0, (int)graph.size());
    }

    public void testReificationTriplesConvenient() {
        this.testReificationTriples(Convenient);
    }

    public void testReificationTriplesStandard() {
        this.testReificationTriples(Standard);
    }

    public void testReificationQuadletsMinimal() {
        this.testReificationTriples(Minimal);
    }

    protected void testReificationTriples(ReificationStyle reificationStyle) {
        Graph graph = this.getGraph(reificationStyle);
        Graph graph2 = graph.getReifier().getReificationTriples();
        String string = "SSS rdf:predicate PPP";
        String string2 = "SSS rdf:subject SSS";
        graph.add(AbstractTestReifier.triple(string));
        AbstractTestReifier.assertIsomorphic(this.graphWithUnless(reificationStyle == Minimal, string), graph2);
        graph.add(AbstractTestReifier.triple(string2));
        AbstractTestReifier.assertIsomorphic(this.graphWithUnless(reificationStyle == Minimal, string + "; " + string2), graph2);
        AbstractTestReifier.assertEquals((String)"convenient hides quadlets", (reificationStyle == Convenient ? 1 : 0) != 0, (graph.size() == 0 ? 1 : 0) != 0);
    }

    public void testManifestQuadsStandard() {
        this.testManifestQuads(Standard);
    }

    public void testManifestQuadsConvenient() {
        this.testManifestQuads(Convenient);
    }

    public void testManifestQuadsMinimal() {
        this.testManifestQuads(Minimal);
    }

    public void testManifestQuads(ReificationStyle reificationStyle) {
        Graph graph = this.getGraph(reificationStyle);
        Reifier reifier = graph.getReifier();
        reifier.reifyAs(AbstractTestReifier.node("A"), AbstractTestReifier.triple("S P O"));
        String string = "A rdf:type rdf:Statement; A rdf:subject S; A rdf:predicate P; A rdf:object O";
        AbstractTestReifier.assertIsomorphic(this.graphWithIf(reificationStyle == Standard, string), graph);
    }

    public void testHiddenVsReificationMinimal() {
        this.testHiddenVsReification(Minimal);
    }

    public void testHiddenVsStandard() {
        this.testHiddenVsReification(Standard);
    }

    public void testHiddenVsReificationConvenient() {
        this.testHiddenVsReification(Convenient);
    }

    public void testHiddenVsReification(ReificationStyle reificationStyle) {
        Graph graph = this.getGraph(reificationStyle);
        Reifier reifier = graph.getReifier();
        reifier.reifyAs(AbstractTestReifier.node("A"), AbstractTestReifier.triple("S P O"));
        AbstractTestReifier.assertEquals((reificationStyle == Standard ? 1 : 0) != 0, (boolean)reifier.getHiddenTriples().isEmpty());
    }

    public void testRetrieveTriplesByNode() {
        Graph graph = this.getGraph();
        Reifier reifier = graph.getReifier();
        Node node = Node.createAnon();
        Node node2 = Node.createAnon();
        reifier.reifyAs(node, AbstractTestReifier.triple("x R y"));
        AbstractTestReifier.assertEquals((String)"gets correct triple", (Object)AbstractTestReifier.triple("x R y"), (Object)reifier.getTriple(node));
        reifier.reifyAs(node2, AbstractTestReifier.triple("p S q"));
        AbstractTestReifier.assertDiffer("the anon nodes must be distinct", node, node2);
        AbstractTestReifier.assertEquals((String)"gets correct triple", (Object)AbstractTestReifier.triple("p S q"), (Object)reifier.getTriple(node2));
        AbstractTestReifier.assertTrue((String)"node is known bound", (boolean)reifier.hasTriple(node2));
        AbstractTestReifier.assertTrue((String)"node is known bound", (boolean)reifier.hasTriple(node));
        AbstractTestReifier.assertFalse((String)"node is known unbound", (boolean)reifier.hasTriple(Node.createURI("any:thing")));
    }

    public void testRetrieveTriplesByTriple() {
        Graph graph = this.getGraph();
        Reifier reifier = graph.getReifier();
        Triple triple = AbstractTestReifier.triple("x R y");
        Triple triple2 = AbstractTestReifier.triple("y R x");
        Node node = AbstractTestReifier.node("someNode");
        reifier.reifyAs(node, triple);
        AbstractTestReifier.assertTrue((String)"R must have T", (boolean)reifier.hasTriple(triple));
        AbstractTestReifier.assertFalse((String)"R must not have T2", (boolean)reifier.hasTriple(triple2));
    }

    public void testReifyAs() {
        Graph graph = this.getGraph();
        Reifier reifier = graph.getReifier();
        Node node = Node.createURI("some:uri");
        AbstractTestReifier.assertEquals((String)"node used", (Object)node, (Object)reifier.reifyAs(node, AbstractTestReifier.triple("x R y")));
        AbstractTestReifier.assertEquals((String)"retrieves correctly", (Object)AbstractTestReifier.triple("x R y"), (Object)reifier.getTriple(node));
    }

    public void testAllNodes() {
        Reifier reifier = this.getGraph().getReifier();
        reifier.reifyAs(AbstractTestReifier.node("x"), AbstractTestReifier.triple("cows eat grass"));
        reifier.reifyAs(AbstractTestReifier.node("y"), AbstractTestReifier.triple("pigs can fly"));
        reifier.reifyAs(AbstractTestReifier.node("z"), AbstractTestReifier.triple("dogs may bark"));
        AbstractTestReifier.assertEquals((String)"", (Object)this.nodeSet("z y x"), (Object)AbstractTestReifier.iteratorToSet(reifier.allNodes()));
    }

    public void testRemoveByNode() {
        Graph graph = this.getGraph();
        Reifier reifier = graph.getReifier();
        Node node = AbstractTestReifier.node("x");
        Node node2 = AbstractTestReifier.node("y");
        reifier.reifyAs(node, AbstractTestReifier.triple("x R a"));
        reifier.reifyAs(node2, AbstractTestReifier.triple("y R a"));
        reifier.remove(node, AbstractTestReifier.triple("x R a"));
        AbstractTestReifier.assertFalse((String)"triple X has gone", (boolean)reifier.hasTriple(node));
        AbstractTestReifier.assertEquals((String)"triple Y still there", (Object)AbstractTestReifier.triple("y R a"), (Object)reifier.getTriple(node2));
    }

    public void testException() {
        Graph graph = this.getGraph();
        Reifier reifier = graph.getReifier();
        Node node = AbstractTestReifier.node("x");
        reifier.reifyAs(node, AbstractTestReifier.triple("x R y"));
        reifier.reifyAs(node, AbstractTestReifier.triple("x R y"));
        try {
            reifier.reifyAs(node, AbstractTestReifier.triple("x R z"));
            AbstractTestReifier.fail((String)"did not detect already reified node");
        }
        catch (AlreadyReifiedException alreadyReifiedException) {
            // empty catch block
        }
    }

    public void testKevinCaseA() {
        Graph graph = this.getGraph(Standard);
        Node node = AbstractTestReifier.node("x");
        Node node2 = AbstractTestReifier.node("a");
        Node node3 = AbstractTestReifier.node("b");
        Node node4 = AbstractTestReifier.node("c");
        graph.add(new Triple(node, RDF.Nodes.type, RDF.Nodes.Statement));
        graph.getReifier().reifyAs(node, new Triple(node2, node3, node4));
    }

    public void testKevinCaseB() {
        Graph graph = this.getGraph(Standard);
        Node node = AbstractTestReifier.node("x");
        Node node2 = AbstractTestReifier.node("y");
        Node node3 = AbstractTestReifier.node("a");
        Node node4 = AbstractTestReifier.node("b");
        Node node5 = AbstractTestReifier.node("c");
        graph.add(new Triple(node, RDF.Nodes.subject, node2));
        try {
            graph.getReifier().reifyAs(node, new Triple(node3, node4, node5));
            AbstractTestReifier.fail((String)"X already has subject Y: cannot make it a");
        }
        catch (CannotReifyException cannotReifyException) {
            AbstractTestReifier.pass();
        }
    }

    public void testDynamicHiddenTriples() {
        Graph graph = this.getGraph();
        Reifier reifier = graph.getReifier();
        Graph graph2 = reifier.getHiddenTriples();
        Graph graph3 = AbstractTestReifier.graphWith("x rdf:type rdf:Statement; x rdf:subject a; x rdf:predicate B; x rdf:object c");
        AbstractTestReifier.assertTrue((boolean)graph2.isEmpty());
        reifier.reifyAs(AbstractTestReifier.node("x"), AbstractTestReifier.triple("a B c"));
        AbstractTestReifier.assertIsomorphic(graph3, graph2);
    }

    public void testQuadRemove() {
        Graph graph = this.getGraph(Standard);
        AbstractTestReifier.assertEquals((int)0, (int)graph.size());
        Triple triple = Triple.create("x rdf:subject s");
        Triple triple2 = Triple.create("x rdf:predicate p");
        Triple triple3 = Triple.create("x rdf:object o");
        Triple triple4 = Triple.create("x rdf:type rdf:Statement");
        graph.add(triple);
        graph.add(triple2);
        graph.add(triple3);
        graph.add(triple4);
        AbstractTestReifier.assertEquals((int)4, (int)graph.size());
        graph.delete(triple);
        graph.delete(triple2);
        graph.delete(triple3);
        graph.delete(triple4);
        AbstractTestReifier.assertEquals((int)0, (int)graph.size());
    }
}

