/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.test;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeVisitor;
import com.hp.hpl.jena.graph.Node_ANY;
import com.hp.hpl.jena.graph.Node_Blank;
import com.hp.hpl.jena.graph.Node_Literal;
import com.hp.hpl.jena.graph.Node_URI;
import com.hp.hpl.jena.graph.Node_Variable;
import com.hp.hpl.jena.graph.impl.LiteralLabel;
import com.hp.hpl.jena.graph.test.GraphTestBase;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.vocabulary.DC;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RSS;
import com.hp.hpl.jena.vocabulary.VCARD;
import junit.framework.Assert;
import junit.framework.TestSuite;

public class TestNode
extends GraphTestBase {
    private static final String U = "http://some.domain.name/magic/spells.incant";
    private static final String N = "Alice";
    private static final LiteralLabel L = new LiteralLabel("ashes are burning", "en", false);
    private static final AnonId A = new AnonId();
    static /* synthetic */ Class class$com$hp$hpl$jena$graph$test$TestNode;

    public TestNode(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(class$com$hp$hpl$jena$graph$test$TestNode == null ? (class$com$hp$hpl$jena$graph$test$TestNode = TestNode.class$("com.hp.hpl.jena.graph.test.TestNode")) : class$com$hp$hpl$jena$graph$test$TestNode);
    }

    public void testBlanks() {
        TestNode.assertTrue((String)"anonymous nodes are blank", (boolean)Node.createAnon().isBlank());
        TestNode.assertFalse((String)"anonymous nodes aren't literal", (boolean)Node.createAnon().isLiteral());
        TestNode.assertFalse((String)"anonymous nodes aren't URIs", (boolean)Node.createAnon().isURI());
        TestNode.assertFalse((String)"anonymous nodes aren't variables", (boolean)Node.createAnon().isVariable());
        TestNode.assertEquals((String)"anonymous nodes have the right id", (Object)Node.createAnon(A).getBlankNodeId(), (Object)A);
    }

    public void testLiterals() {
        TestNode.assertFalse((String)"literal nodes aren't blank", (boolean)Node.createLiteral(L).isBlank());
        TestNode.assertTrue((String)"literal nodes are literal", (boolean)Node.createLiteral(L).isLiteral());
        TestNode.assertFalse((String)"literal nodes aren't variables", (boolean)Node.createLiteral(L).isVariable());
        TestNode.assertFalse((String)"literal nodes aren't URIs", (boolean)Node.createLiteral(L).isURI());
        TestNode.assertEquals((String)"literal nodes preserve value", (Object)Node.createLiteral(L).getLiteral(), (Object)L);
    }

    public void testURIs() {
        TestNode.assertFalse((String)"URI nodes aren't blank", (boolean)Node.createURI(U).isBlank());
        TestNode.assertFalse((String)"URI nodes aren't literal", (boolean)Node.createURI(U).isLiteral());
        TestNode.assertFalse((String)"URI nodes aren't variables", (boolean)Node.createURI(U).isVariable());
        TestNode.assertTrue((String)"URI nodes are URIs", (boolean)Node.createURI(U).isURI());
        TestNode.assertEquals((String)"URI nodes preserve URI", (String)Node.createURI(U).getURI(), (String)U);
    }

    public void testVariables() {
        TestNode.assertFalse((String)"variable nodes aren't blank", (boolean)Node.createVariable(N).isBlank());
        TestNode.assertFalse((String)"variable nodes aren't literal", (boolean)Node.createVariable(N).isLiteral());
        TestNode.assertFalse((String)"variable nodes aren't URIs", (boolean)Node.createVariable(N).isURI());
        TestNode.assertTrue((String)"variable nodes are variable", (boolean)Node.createVariable(N).isVariable());
        TestNode.assertEquals((String)"variable nodes keep their name", (String)N, (String)Node.createVariable(N).getName());
        TestNode.assertEquals((String)"variable nodes keep their name", (String)"Alicex", (String)Node.createVariable("Alicex").getName());
    }

    public void testANY() {
        TestNode.assertFalse((String)"ANY nodes aren't blank", (boolean)Node.ANY.isBlank());
        TestNode.assertFalse((String)"ANY nodes aren't literals", (boolean)Node.ANY.isLiteral());
        TestNode.assertFalse((String)"ANY nodes aren't URIs", (boolean)Node.ANY.isURI());
        TestNode.assertFalse((String)"ANY nodes aren't variables", (boolean)Node.ANY.isVariable());
        TestNode.assertFalse((String)"ANY nodes aren't blank", (boolean)Node.ANY.isBlank());
        TestNode.assertFalse((String)"ANY nodes aren't blank", (boolean)Node.ANY.isBlank());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[][] eqTestCases() {
        try {
            Node.cache(false);
            AnonId anonId = new AnonId();
            LiteralLabel literalLabel = new LiteralLabel(anonId.toString(), "", false);
            String string = anonId.toString();
            String string2 = anonId.toString();
            Object[][] objectArray = new Object[][]{{Node.ANY, "0"}, {Node.createAnon(anonId), "1"}, {Node.createAnon(), "2"}, {Node.createAnon(anonId), "1"}, {Node.createLiteral(L), "3"}, {Node.createLiteral(literalLabel), "4"}, {Node.createLiteral(L), "3"}, {Node.createURI(U), "5"}, {Node.createURI(string), "6"}, {Node.createURI(U), "5"}, {Node.createVariable(N), "7"}, {Node.createVariable(string2), "8"}, {Node.createVariable(N), "7"}};
            return objectArray;
        }
        finally {
            Node.cache(true);
        }
    }

    public void testNodeEquals() {
        Object[][] objectArray = this.eqTestCases();
        for (int i = 0; i < objectArray.length; ++i) {
            Object[] objectArray2 = objectArray[i];
            TestNode.assertFalse((String)(objectArray2[0] + " should not equal null"), (boolean)objectArray2[0].equals(null));
            TestNode.assertFalse((String)(objectArray2[0] + "should not equal 'String'"), (boolean)objectArray2[0].equals("String"));
            for (int j = 0; j < objectArray.length; ++j) {
                Object[] objectArray3 = objectArray[j];
                this.testEquality(objectArray2[1].equals(objectArray3[1]), objectArray2[0], objectArray3[0]);
            }
        }
    }

    private void testEquality(boolean bl, Object object, Object object2) {
        String string = this.getType(object) + " " + object + " and " + this.getType(object2) + " " + object2;
        if (bl) {
            TestNode.assertEquals((String)(string + "should be equal"), (Object)object, (Object)object2);
        } else {
            TestNode.assertDiffer(string + " should differ", object, object2);
        }
    }

    private String getType(Object object) {
        String string = object.getClass().getName();
        return string.substring(string.lastIndexOf(46) + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEquals() {
        try {
            Node.cache(false);
            TestNode.assertDiffer("different variables", Node.createVariable("xx"), Node.createVariable("yy"));
            TestNode.assertEquals((String)"same vars", (Object)Node.createVariable("aa"), (Object)Node.createVariable("aa"));
            TestNode.assertEquals((String)"same URI", (Object)Node.createURI(U), (Object)Node.createURI(U));
            TestNode.assertEquals((String)"same anon", (Object)Node.createAnon(A), (Object)Node.createAnon(A));
            TestNode.assertEquals((String)"same literal", (Object)Node.createLiteral(L), (Object)Node.createLiteral(L));
            TestNode.assertFalse((String)"distinct URIs", (Node.createURI(U) == Node.createURI(U) ? 1 : 0) != 0);
            TestNode.assertFalse((String)"distinct blanks", (Node.createAnon(A) == Node.createAnon(A) ? 1 : 0) != 0);
            TestNode.assertFalse((String)"distinct literals", (Node.createLiteral(L) == Node.createLiteral(L) ? 1 : 0) != 0);
            TestNode.assertFalse((String)"distinct vars", (Node.createVariable("aa") == Node.createVariable("aa") ? 1 : 0) != 0);
        }
        finally {
            Node.cache(true);
        }
    }

    public void testLabels() {
        AnonId anonId = new AnonId();
        TestNode.assertEquals((String)"get URI value", (String)U, (String)Node.createURI(U).getURI());
        TestNode.assertEquals((String)"get blank value", (Object)anonId, (Object)Node.createAnon(anonId).getBlankNodeId());
        TestNode.assertEquals((String)"get literal value", (Object)L, (Object)Node.createLiteral(L).getLiteral());
        TestNode.assertEquals((String)"get variable name", (String)N, (String)Node.createVariable(N).getName());
    }

    public void testFailingLabels() {
        Node node = Node.createURI(U);
        Node node2 = Node.createAnon();
        Node node3 = Node.createLiteral(L);
        Node node4 = Node.createVariable(N);
        Node node5 = Node.ANY;
        this.testGetURIFails(node5);
        this.testGetURIFails(node2);
        this.testGetURIFails(node3);
        this.testGetURIFails(node4);
        this.testGetLiteralFails(node5);
        this.testGetLiteralFails(node);
        this.testGetLiteralFails(node2);
        this.testGetLiteralFails(node4);
        this.testGetNameFails(node5);
        this.testGetNameFails(node);
        this.testGetNameFails(node2);
        this.testGetNameFails(node3);
        this.testGetBlankNodeIdFails(node5);
        this.testGetBlankNodeIdFails(node);
        this.testGetBlankNodeIdFails(node3);
        this.testGetBlankNodeIdFails(node4);
    }

    public void testGetBlankNodeIdFails(Node node) {
        try {
            node.getBlankNodeId();
            TestNode.fail((String)(node.getClass() + " should fail getName()"));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testGetURIFails(Node node) {
        try {
            node.getURI();
            TestNode.fail((String)(node.getClass() + " should fail getURI()"));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testGetNameFails(Node node) {
        try {
            node.getName();
            TestNode.fail((String)(node.getClass() + " should fail getName()"));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testGetLiteralFails(Node node) {
        try {
            node.getLiteral();
            TestNode.fail((String)(node.getClass() + " should fail getLiteral()"));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testVariableSupport() {
        TestNode.assertEquals((Object)Node_Variable.variable("xxx"), (Object)Node_Variable.variable("xxx"));
        TestNode.assertDiffer(Node_Variable.variable("xxx"), Node_Variable.variable("yyy"));
        TestNode.assertEquals((Object)Node_Variable.variable("aaa"), (Object)Node_Variable.variable("aaa"));
        TestNode.assertDiffer(Node_Variable.variable("aaa"), Node_Variable.variable("yyy"));
    }

    public void testCache() {
        TestNode.assertEquals((Object)Node_Variable.variable("xxx"), (Object)Node_Variable.variable("xxx"));
        TestNode.assertTrue((String)"remembers URI", (Node.createURI(U) == Node.createURI(U) ? 1 : 0) != 0);
        TestNode.assertTrue((String)"remembers literal", (Node.createLiteral(L) == Node.createLiteral(L) ? 1 : 0) != 0);
        TestNode.assertTrue((String)"remembers blanks", (Node.createAnon(A) == Node.createAnon(A) ? 1 : 0) != 0);
        TestNode.assertTrue((String)"remembers variables", (Node.createVariable(N) == Node.createVariable(N) ? 1 : 0) != 0);
        TestNode.assertFalse((String)"is not confused", (Node.createVariable(N) == Node.createURI(N) ? 1 : 0) != 0);
    }

    public void testCreateBadString() {
        try {
            Node.create(null);
            TestNode.fail((String)"must catch null argument");
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (JenaException jenaException) {
            // empty catch block
        }
        try {
            Node.create("");
            TestNode.fail((String)"must catch empty argument");
        }
        catch (JenaException jenaException) {
            // empty catch block
        }
    }

    public void testCreateAnon() {
        String string = "_xxx";
        String string2 = "_yyy";
        Node node = Node.create(string);
        Node node2 = Node.create(string2);
        TestNode.assertTrue((String)"both must be bnodes", (node.isBlank() && node2.isBlank() ? 1 : 0) != 0);
        TestNode.assertEquals((Object)new AnonId(string), (Object)node.getBlankNodeId());
        TestNode.assertEquals((Object)new AnonId(string2), (Object)node2.getBlankNodeId());
    }

    public void testCreateVariable() {
        String string = "wobbly";
        Node node = Node.create("?" + string);
        TestNode.assertTrue((String)"must be a variable", (boolean)node.isVariable());
        TestNode.assertEquals((String)"name must be correct", (String)string, (String)node.getName());
    }

    public void testCreateANY() {
        TestNode.assertEquals((String)"?? must denote ANY", (Object)Node.ANY, (Object)Node.create("??"));
    }

    public void testCreateURI() {
        String string = "http://www.electric-hedgehog.net/";
        this.testCreateURI(string);
        this.testCreateURI("rdf:trinket", "http://www.w3.org/1999/02/22-rdf-syntax-ns#trinket");
        this.testCreateURI("rdfs:device", "http://www.w3.org/2000/01/rdf-schema#device");
        this.testCreateURI("dc:creator", DC.getURI() + "creator");
        this.testCreateURI("rss:something", RSS.getURI() + "something");
        this.testCreateURI("vcard:TITLE", VCARD.getURI() + "TITLE");
        this.testCreateURI("owl:wol", OWL.NAMESPACE + "wol");
    }

    public void testCreateURIOtherMap() {
        String string = "eh:foo/bar#";
        String string2 = "something";
        PrefixMapping prefixMapping = PrefixMapping.Factory.create().setNsPrefix("mine", string);
        Node node = Node.create(prefixMapping, "mine:" + string2);
        TestNode.assertEquals((String)(string + string2), (String)node.getURI());
    }

    private void testCreateURI(String string) {
        this.testCreateURI(string, string);
    }

    private void testCreateURI(String string, String string2) {
        String string3 = Node.create(string).getURI();
        if (!string2.equals(string3)) {
            if (string.equals(string2)) {
                TestNode.fail((String)("should preserve " + string));
            } else {
                TestNode.fail((String)("should translate " + string + " to " + string2 + " not " + string3));
            }
        }
    }

    public void testCreatePrefixed() {
        PrefixMapping prefixMapping = PrefixMapping.Factory.create();
        Node.create(prefixMapping, "xyz");
    }

    public void testToStringWithPrefixMapping() {
        PrefixMapping prefixMapping = PrefixMapping.Factory.create();
        String string = "spoo";
        String string2 = "abc:def/ghi#";
        prefixMapping.setNsPrefix(string, string2);
        String string3 = "bamboozle";
        TestNode.assertEquals((String)(string + ":" + string3), (String)Node.create(string2 + string3).toString(prefixMapping));
    }

    public void testNodeHelp() {
        TestNode.assertTrue((String)"node() making URIs", (boolean)TestNode.node("hello").isURI());
        TestNode.assertTrue((String)"node() making literals", (boolean)TestNode.node("123").isLiteral());
        TestNode.assertTrue((String)"node() making literals", (boolean)TestNode.node("'hello'").isLiteral());
        TestNode.assertTrue((String)"node() making blanks", (boolean)TestNode.node("_x").isBlank());
        TestNode.assertTrue((String)"node() making variables", (boolean)TestNode.node("?x").isVariable());
    }

    public void testVisitorPatternNode() {
        NodeVisitor nodeVisitor = new NodeVisitor(){

            public Object visitAny(Node_ANY node_ANY) {
                return node_ANY;
            }

            public Object visitBlank(Node_Blank node_Blank, AnonId anonId) {
                return node_Blank;
            }

            public Object visitLiteral(Node_Literal node_Literal, LiteralLabel literalLabel) {
                return node_Literal;
            }

            public Object visitURI(Node_URI node_URI, String string) {
                return node_URI;
            }

            public Object visitVariable(Node_Variable node_Variable, String string) {
                return node_Variable;
            }
        };
        this.testVisitorPatternNode("sortOfURI", nodeVisitor);
        this.testVisitorPatternNode("?variable", nodeVisitor);
        this.testVisitorPatternNode("_anon", nodeVisitor);
        this.testVisitorPatternNode("11", nodeVisitor);
        this.testVisitorPatternNode("??", nodeVisitor);
    }

    private void testVisitorPatternNode(String string, NodeVisitor nodeVisitor) {
        Node node = TestNode.node(string);
        TestNode.assertEquals((Object)node, (Object)node.visitWith(nodeVisitor));
    }

    private void visitExamples(NodeVisitor nodeVisitor) {
        TestNode.node("sortOfURI").visitWith(nodeVisitor);
        TestNode.node("?variableI").visitWith(nodeVisitor);
        TestNode.node("_anon").visitWith(nodeVisitor);
        TestNode.node("11").visitWith(nodeVisitor);
        TestNode.node("??").visitWith(nodeVisitor);
    }

    public void testVisitorPatternValue() {
        NodeVisitor nodeVisitor = new NodeVisitor(){

            public Object visitAny(Node_ANY node_ANY) {
                return null;
            }

            public Object visitBlank(Node_Blank node_Blank, AnonId anonId) {
                Assert.assertTrue((node_Blank.getBlankNodeId() == anonId ? 1 : 0) != 0);
                return null;
            }

            public Object visitLiteral(Node_Literal node_Literal, LiteralLabel literalLabel) {
                Assert.assertTrue((node_Literal.getLiteral() == literalLabel ? 1 : 0) != 0);
                return null;
            }

            public Object visitURI(Node_URI node_URI, String string) {
                Assert.assertTrue((node_URI.getURI() == string ? 1 : 0) != 0);
                return null;
            }

            public Object visitVariable(Node_Variable node_Variable, String string) {
                Assert.assertEquals((String)node_Variable.getName(), (String)string);
                return null;
            }
        };
        this.visitExamples(nodeVisitor);
    }

    public void testVisitorPatternCalled() {
        final String[] stringArray = new String[]{""};
        NodeVisitor nodeVisitor = new NodeVisitor(){

            public Object visitAny(Node_ANY node_ANY) {
                stringArray[0] = stringArray[0] + " any";
                return null;
            }

            public Object visitBlank(Node_Blank node_Blank, AnonId anonId) {
                stringArray[0] = stringArray[0] + " blank";
                return null;
            }

            public Object visitLiteral(Node_Literal node_Literal, LiteralLabel literalLabel) {
                stringArray[0] = stringArray[0] + " literal";
                return null;
            }

            public Object visitURI(Node_URI node_URI, String string) {
                stringArray[0] = stringArray[0] + " uri";
                return null;
            }

            public Object visitVariable(Node_Variable node_Variable, String string) {
                stringArray[0] = stringArray[0] + " variable";
                return null;
            }
        };
        String string = " uri variable blank literal any";
        this.visitExamples(nodeVisitor);
        TestNode.assertEquals((String)"all vists must have been made", (String)string, (String)stringArray[0]);
    }

    public void testSimpleMatches() {
        TestNode.assertTrue((boolean)Node.create("S").matches(Node.create("S")));
        TestNode.assertFalse((String)"", (boolean)Node.create("S").matches(Node.create("T")));
        TestNode.assertFalse((String)"", (boolean)Node.create("S").matches(null));
        TestNode.assertTrue((boolean)Node.create("_X").matches(Node.create("_X")));
        TestNode.assertFalse((String)"", (boolean)Node.create("_X").matches(Node.create("_Y")));
        TestNode.assertFalse((String)"", (boolean)Node.create("_X").matches(null));
        TestNode.assertTrue((boolean)Node.create("10").matches(Node.create("10")));
        TestNode.assertFalse((String)"", (boolean)Node.create("10").matches(Node.create("11")));
        TestNode.assertFalse((String)"", (boolean)Node.create("10").matches(null));
        TestNode.assertTrue((boolean)Node.ANY.matches(Node.create("S")));
        TestNode.assertTrue((boolean)Node.ANY.matches(Node.create("_X")));
        TestNode.assertTrue((boolean)Node.ANY.matches(Node.create("10")));
        TestNode.assertFalse((String)"", (boolean)Node.ANY.matches(null));
    }

    public void testDataMatches() {
        TypeMapper typeMapper = TypeMapper.getInstance();
        RDFDatatype rDFDatatype = typeMapper.getTypeByValue(new Integer(10));
        RDFDatatype rDFDatatype2 = typeMapper.getTypeByValue(new Short(10));
        Node node = Node.createLiteral("10", "", rDFDatatype);
        Node node2 = Node.createLiteral("10", "", rDFDatatype2);
        TestNode.assertDiffer("types must make a difference", node, node2);
        TestNode.assertTrue((String)"A and B must express the same value", (boolean)node.sameValueAs(node2));
        TestNode.assertTrue((String)"matching literals must respect sameValueAs", (boolean)node.matches(node2));
    }

    public void testLiteralToString() {
        TypeMapper typeMapper = TypeMapper.getInstance();
        RDFDatatype rDFDatatype = typeMapper.getTypeByValue(new Integer(10));
        Node node = Node.createLiteral("rhubarb", "", false);
        Node node2 = Node.createLiteral("eccentric", "en_UK", false);
        Node node3 = Node.createLiteral("10", "", rDFDatatype);
        TestNode.assertEquals((String)"rhubarb", (String)node.toString());
        TestNode.assertEquals((String)"eccentric~en_UK", (String)node2.toString());
        TestNode.assertEquals((String)"10:http://www.w3.org/2001/XMLSchema#int", (String)node3.toString());
    }

    public void testConcrete() {
        TestNode.assertTrue((boolean)Node.create("S").isConcrete());
        TestNode.assertTrue((boolean)Node.create("_P").isConcrete());
        TestNode.assertTrue((boolean)Node.create("11").isConcrete());
        TestNode.assertTrue((boolean)Node.create("'hello'").isConcrete());
        TestNode.assertFalse((boolean)Node.create("??").isConcrete());
        TestNode.assertFalse((boolean)Node.create("?x").isConcrete());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

