/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.n3;

import java.io.IOException;
import java.io.Writer;
import java.security.AccessController;
import sun.security.action.GetPropertyAction;

class IndentedWriter {
    String lineSeparator = AccessController.doPrivileged(new GetPropertyAction("line.separator"));
    Writer writer;
    int column;
    int row;
    int currentIndent;

    public IndentedWriter(Writer writer) {
        this.writer = writer;
        this.column = 0;
        this.row = 0;
        this.currentIndent = 0;
    }

    public Writer getWriter() {
        return this.writer;
    }

    public int getRow() {
        return this.row;
    }

    public int getCol() {
        return this.column;
    }

    public int getIndent() {
        return this.currentIndent;
    }

    public void incIndent(int n) {
        this.currentIndent += n;
    }

    public void decIndent(int n) {
        this.currentIndent -= n;
    }

    public void setIndent(int n) {
        this.currentIndent = n;
    }

    public void print(String string) {
        try {
            this.writer.write(string);
            this.column += string.length();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void println(String string) {
        try {
            this.writer.write(string);
            this.println();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void println() {
        try {
            this.writer.write(this.lineSeparator);
            this.writer.flush();
            this.column = 0;
            ++this.row;
            this.padTo();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void padTo() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.currentIndent; ++i) {
            this.writer.write(32);
        }
        this.column += this.currentIndent;
    }

    public void flush() {
        try {
            this.writer.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void close() {
        try {
            this.writer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

