/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.n3.test;

import com.hp.hpl.jena.n3.N3EventPrinter;
import com.hp.hpl.jena.n3.N3Parser;
import com.hp.hpl.jena.n3.N3ParserEventHandler;
import com.hp.hpl.jena.n3.NullN3EventHandler;
import java.io.PrintWriter;
import java.io.StringReader;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class N3InternalTests
extends TestSuite {
    public static final String QUOTE3 = "\"\"\"";
    public static boolean VERBOSE = false;
    PrintWriter pw = null;

    public static TestSuite suite() {
        return new N3InternalTests();
    }

    N3InternalTests() {
        super("N3 Parser Syntactic tests");
        if (VERBOSE) {
            this.pw = new PrintWriter(System.out);
        }
        this.addTest((junit.framework.Test)new Test("a:subj a:prop a:d ."));
        this.addTest((junit.framework.Test)new Test("a:subj a:prop a:d . "));
        this.addTest((junit.framework.Test)new Test("a:subj a:prop a:d."));
        this.addTest((junit.framework.Test)new Test("a:subj a:prop a:d. "));
        this.addTest((junit.framework.Test)new Test("rdf: rdf:type :_."));
        this.addTest((junit.framework.Test)new Test("@prefix start: <somewhere>."));
        this.addTest((junit.framework.Test)new Test("<http://here/subj> <http://here/prep> <http://here/obj>."));
        this.addTest((junit.framework.Test)new Test("a:subj\ta:prop\ta:d.\t"));
        this.addTest((junit.framework.Test)new Test("       a:subj\ta:prop\ta:d.     "));
        this.addTest((junit.framework.Test)new Test("a:subj a:prop a:d.  "));
        this.addTest((junit.framework.Test)new Test(""));
        this.addTest((junit.framework.Test)new Test(" #Comment"));
        this.addTest((junit.framework.Test)new Test("a:subj a:prop a:d.  # Comment"));
        this.addTest((junit.framework.Test)new Test("a:subj a:prop a:d.# Comment"));
        this.addTest((junit.framework.Test)new Test("a:subj a:prop 'string1'."));
        this.addTest((junit.framework.Test)new Test("a:subj a:prop \"string2\"."));
        this.addTest((junit.framework.Test)new Test("a:subj a:prop '''string3'''."));
        this.addTest((junit.framework.Test)new Test("a:subj a:prop \"\"\"string3\"\"\"."));
        this.addTest((junit.framework.Test)new Test("a:subj a:prop 'string1'^^x:dt."));
        this.addTest((junit.framework.Test)new Test("a:subj a:prop 'string1'^^<uriref>."));
        this.addTest((junit.framework.Test)new Test("a: :p 2."));
        this.addTest((junit.framework.Test)new Test("a: :p +2."));
        this.addTest((junit.framework.Test)new Test("a: :p -2 ."));
        this.addTest((junit.framework.Test)new Test("a: :p 2e6."));
        this.addTest((junit.framework.Test)new Test("a: :p 2e-6."));
        this.addTest((junit.framework.Test)new Test("a: :p -2e-6."));
        this.addTest((junit.framework.Test)new Test("a: :p 2.0e-6."));
        this.addTest((junit.framework.Test)new Test("a: :p 2.0."));
        this.addTest((junit.framework.Test)new Test("a: _: 2:."));
        this.addTest((junit.framework.Test)new Test("2.9 9:p 2.0."));
        this.addTest((junit.framework.Test)new Test("_:a :2 :_2 ."));
        this.addTest((junit.framework.Test)new Test("2.0 :p 2.0."));
        this.addTest((junit.framework.Test)new Test("a:subj 'prop'^^<uriref> 'string'."));
        this.addTest((junit.framework.Test)new Test("a:subj a:prop 'string1'^^'stringDT'."));
        this.addTest((junit.framework.Test)new Test("a:subj a:prop1 ?x ^^ x:dt."));
        this.addTest((junit.framework.Test)new Test("a:subj a:prop2 ?x ^^ ?x."));
        this.addTest((junit.framework.Test)new Test("a:subj a:prop \"\\'string2\\'\"."));
        this.addTest((junit.framework.Test)new Test("a:subj a:prop \"\\\"string2\\\"\"."));
        this.addTest((junit.framework.Test)new Test("a:subj a:prop '\\'string1\\''."));
        this.addTest((junit.framework.Test)new Test("a:subj a:prop '\\\"string1\\\"'."));
        this.addTest((junit.framework.Test)new Test("a:q21 a:prop \"\"\"start\"finish\"\"\"."));
        this.addTest((junit.framework.Test)new Test("a:q22 a:prop \"\"\"start\"\"finish\"\"\"."));
        this.addTest((junit.framework.Test)new Test("a:q2e3 a:prop \"\"\"start\\\"\\\"\\\"finish\"\"\"."));
        this.addTest((junit.framework.Test)new Test("a:q13 a:prop \"\"\"start'''finish\"\"\"."));
        this.addTest((junit.framework.Test)new Test("a:q11 a:prop '''start'finish'''."));
        this.addTest((junit.framework.Test)new Test("a:q12 a:prop '''start''finish'''."));
        this.addTest((junit.framework.Test)new Test("a:q12 a:prop '''start\\'\\'\\'finish'''."));
        this.addTest((junit.framework.Test)new Test("a:q23 a:prop '''start\"\"\"finish'''."));
        this.addTest((junit.framework.Test)new Test("this a:prop x:y ."));
        this.addTest((junit.framework.Test)new Test("a:subj  a   x:y ."));
        this.addTest((junit.framework.Test)new Test("a:subj  =   x:y ."));
        this.addTest((junit.framework.Test)new Test("a:subj  =>  x:y ."));
        this.addTest((junit.framework.Test)new Test("a:subj  <=  x:y ."));
        this.addTest((junit.framework.Test)new Test("a:subj  >- x:y -> 'value' ."));
        this.addTest((junit.framework.Test)new Test("a:subj  >- x:y -> 'value1', 'value2' ."));
        this.addTest((junit.framework.Test)new Test("a:subj <a>  x:y ."));
        this.addTest((junit.framework.Test)new Test("<this>  a   x:y ."));
        this.addTest((junit.framework.Test)new Test("@prefix has: <uri>."));
        this.addTest((junit.framework.Test)new Test("has:s a:a :of."));
        this.addTest((junit.framework.Test)new Test("<>   has a:prop  x:y ."));
        this.addTest((junit.framework.Test)new Test("x:v  is a:prop of  <>."));
        this.addTest((junit.framework.Test)new Test("x:v  is a:prop of  a:s1, a:s2."));
        this.addTest((junit.framework.Test)new Test("<>   a:prop  x:y ."));
        this.addTest((junit.framework.Test)new Test("<#>  a:prop  x:y ."));
        this.addTest((junit.framework.Test)new Test("a:subj a:prop a:d, a:e."));
        this.addTest((junit.framework.Test)new Test("a:subj a:prop a:d, '123'."));
        this.addTest((junit.framework.Test)new Test("a:subj a:prop '123', a:e."));
        this.addTest((junit.framework.Test)new Test("a:subj a:p1 a:v1 ;  a:p2 a:v2 ."));
        this.addTest((junit.framework.Test)new Test("a:subj a:p1 a:v1, a:v2 ;  a:p2 a:v2 ; a:p3 'v4' ,'v5' ."));
        this.addTest((junit.framework.Test)new Test("[a:prop a:val]."));
        this.addTest((junit.framework.Test)new Test("[] a:prop a:val."));
        this.addTest((junit.framework.Test)new Test("[] a:prop []."));
        this.addTest((junit.framework.Test)new Test("{:x :y :z} => {:x :y :z}."));
        this.addTest((junit.framework.Test)new Test("{:x :y :z} => {:x :y :z . }."));
        this.addTest((junit.framework.Test)new Test("{:x :y :z. } => {:x :y :z}."));
        this.addTest((junit.framework.Test)new Test("?who ?knows ?what ."));
        this.addTest((junit.framework.Test)new Test("{?who ?knows ?what} => {'somesort' 'of' 'logic'}."));
        this.addTest((junit.framework.Test)new Test("{ this a \"string2\". } => { this a 'string1'} ."));
        this.addTest((junit.framework.Test)new Test("{ @prefix : <a> } => { this a 'string1'} ."));
        this.addTest((junit.framework.Test)new Test("{ @prefix : <a> . a:x <b> 'c'} => { this a 'string1'} ."));
        this.addTest((junit.framework.Test)new Test("() ."));
        this.addTest((junit.framework.Test)new Test("<here> <list> ()."));
        this.addTest((junit.framework.Test)new Test(" ( a:i1 a:i2 a:i3 ) a daml:list."));
        this.addTest((junit.framework.Test)new Test(":x!:y <prop> []."));
        this.addTest((junit.framework.Test)new Test(":x!:y!:z <prop> []."));
        this.addTest((junit.framework.Test)new Test(":x^:y <prop> []."));
        this.addTest((junit.framework.Test)new Test(":x^:y^:z <prop> []."));
        this.addTest((junit.framework.Test)new Test("[] <prop> :x!:y^:z."));
        this.addTest((junit.framework.Test)new Test("[] :x^:y!:z []."));
        this.addTest((junit.framework.Test)new Test(":x.:y <prop> []."));
        this.addTest((junit.framework.Test)new Test(":x.:y.:z <prop> []."));
        this.addTest((junit.framework.Test)new Test("[] <prop> :a.:c."));
        this.addTest((junit.framework.Test)new Test("<thing>.:y  <prop> []."));
        this.addTest((junit.framework.Test)new Test("x:x.<thing>.:y  <prop> []."));
        this.addTest((junit.framework.Test)new Test("<thing>.:y^:z  <prop> []."));
        this.addTest((junit.framework.Test)new Test(":y.<thing>.:z  <prop> []."));
        this.addTest((junit.framework.Test)new Test("<thing> :px.:py.:pz [] . "));
        this.addTest((junit.framework.Test)new Test("<thing> :px!:py!:pz [] . "));
        this.addTest((junit.framework.Test)new Test("{ :a.:b.:c . }."));
        this.addTest((junit.framework.Test)new Test("{ :a.:b.<c>.}."));
        this.addTest((junit.framework.Test)new Test("_:anon :- [a:p a:v] ."));
        this.addTest((junit.framework.Test)new Test("<uri> :- [a:p [ a:p a:v] ] ."));
        this.addTest((junit.framework.Test)new Test("_:anon :- (\"1\") ."));
        this.addTest((junit.framework.Test)new Test("_:anon :- { ?a ?b ?c } ."));
        this.addTest((junit.framework.Test)new Test("a:subj a:prop '123'^^xsd:integer ."));
        this.addTest((junit.framework.Test)new Test("a:subj a:prop '123'^^<uri> ."));
        this.addTest((junit.framework.Test)new Test("a:subj a:prop '<tag>text</tag>'^^rdf:XMLLiteral ."));
        this.addTest((junit.framework.Test)new Test("a:subj a:prop 'text'@en ."));
        this.addTest((junit.framework.Test)new Test("a:subj a:prop 'text'^^a:lang@en ."));
        this.addTest((junit.framework.Test)new Test("a:subj a:prop 'text'@en^^a:lang ."));
        this.addTest((junit.framework.Test)new Test("a:subj a:prop '<tag>text</tag>'@fr^^rdf:XMLLiteral ."));
        this.addTest((junit.framework.Test)new Test("a:subj a:prop '<tag>text</tag>'^^rdf:XMLLiteral@fr ."));
        this.addTest((junit.framework.Test)new Test("a:subj a:prop ?x^^xsd:integer ."));
        this.addTest((junit.framework.Test)new Test("a:subj a:prop '123'^^?x ."));
        this.addTest((junit.framework.Test)new Test("a:subj a:prop ?x^^?y ."));
        this.addTest((junit.framework.Test)new Test("a:subj a:prop '\u00e9'."));
        this.addTest((junit.framework.Test)new Test("a:subj a:prop ';1'."));
        this.addTest((junit.framework.Test)new Test("\u00e9:subj a:prop '\u00e9'."));
        this.addTest((junit.framework.Test)new Test("a:subj-\u00e9 a:prop '\u00e9'."));
        this.addTest((junit.framework.Test)new Test("\u03b1:subj a:prop '\u03b1'."));
        this.addTest((junit.framework.Test)new Test("a:subj-\u03b1 a:prop '\u03b1'."));
    }

    class Test
    extends TestCase {
        N3ParserEventHandler handler;
        String testString;
        boolean stoppingPoint = false;

        Test(String string) {
            this(string, false);
        }

        Test(String string, boolean bl) {
            super("N3 Internal test: " + (string != null ? string.replace(',', '_') : "<skipped test>"));
            this.testString = string;
            this.handler = VERBOSE ? new N3EventPrinter(N3InternalTests.this.pw) : new NullN3EventHandler();
            this.stoppingPoint = bl;
        }

        protected void runTest() throws Throwable {
            if (this.testString == null) {
                if (N3InternalTests.this.pw != null) {
                    N3InternalTests.this.pw.println("Skipped test");
                }
                return;
            }
            if (this.stoppingPoint) {
                this.stoppingPoint = false;
            }
            if (N3InternalTests.this.pw != null) {
                N3InternalTests.this.pw.println("Input: " + this.testString);
            }
            N3Parser n3Parser = new N3Parser(new StringReader(this.testString), this.handler);
            n3Parser.parse();
            if (N3InternalTests.this.pw != null) {
                N3InternalTests.this.pw.println();
                N3InternalTests.this.pw.flush();
            }
        }
    }
}

