/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology;

import com.hp.hpl.jena.ontology.OntDocumentManager;
import com.hp.hpl.jena.ontology.OntologyException;
import com.hp.hpl.jena.ontology.Profile;
import com.hp.hpl.jena.ontology.ProfileRegistry;
import com.hp.hpl.jena.ontology.impl.OntModelImpl;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.ModelMaker;
import com.hp.hpl.jena.rdf.model.ModelSpec;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.impl.ModelSpecImpl;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerFactory;
import com.hp.hpl.jena.reasoner.ReasonerRegistry;
import com.hp.hpl.jena.reasoner.rulesys.DAMLMicroReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.OWLFBRuleReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.RDFSRuleReasonerFactory;
import com.hp.hpl.jena.reasoner.transitiveReasoner.TransitiveReasonerFactory;
import com.hp.hpl.jena.vocabulary.JMS;

public class OntModelSpec
extends ModelSpecImpl
implements ModelSpec {
    public static final OntModelSpec OWL_MEM = new OntModelSpec(ModelFactory.createMemModelMaker(), null, null, ProfileRegistry.OWL_LANG);
    public static final OntModelSpec OWL_MEM_RDFS_INF = new OntModelSpec(ModelFactory.createMemModelMaker(), null, RDFSRuleReasonerFactory.theInstance(), ProfileRegistry.OWL_LANG);
    public static final OntModelSpec OWL_MEM_TRANS_INF = new OntModelSpec(ModelFactory.createMemModelMaker(), null, TransitiveReasonerFactory.theInstance(), ProfileRegistry.OWL_LANG);
    public static final OntModelSpec OWL_MEM_RULE_INF = new OntModelSpec(ModelFactory.createMemModelMaker(), null, OWLFBRuleReasonerFactory.theInstance(), ProfileRegistry.OWL_LANG);
    public static final OntModelSpec OWL_DL_MEM = new OntModelSpec(ModelFactory.createMemModelMaker(), null, null, "http://www.w3.org/TR/owl-features/#term_OWLDL");
    public static final OntModelSpec OWL_DL_MEM_RDFS_INF = new OntModelSpec(ModelFactory.createMemModelMaker(), null, RDFSRuleReasonerFactory.theInstance(), "http://www.w3.org/TR/owl-features/#term_OWLDL");
    public static final OntModelSpec OWL_DL_MEM_TRANS_INF = new OntModelSpec(ModelFactory.createMemModelMaker(), null, TransitiveReasonerFactory.theInstance(), "http://www.w3.org/TR/owl-features/#term_OWLDL");
    public static final OntModelSpec OWL_DL_MEM_RULE_INF = new OntModelSpec(ModelFactory.createMemModelMaker(), null, OWLFBRuleReasonerFactory.theInstance(), "http://www.w3.org/TR/owl-features/#term_OWLDL");
    public static final OntModelSpec OWL_LITE_MEM = new OntModelSpec(ModelFactory.createMemModelMaker(), null, null, "http://www.w3.org/TR/owl-features/#term_OWLLite");
    public static final OntModelSpec OWL_LITE_MEM_TRANS_INF = new OntModelSpec(ModelFactory.createMemModelMaker(), null, TransitiveReasonerFactory.theInstance(), "http://www.w3.org/TR/owl-features/#term_OWLLite");
    public static final OntModelSpec OWL_LITE_MEM_RDFS_INF = new OntModelSpec(ModelFactory.createMemModelMaker(), null, RDFSRuleReasonerFactory.theInstance(), "http://www.w3.org/TR/owl-features/#term_OWLLite");
    public static final OntModelSpec OWL_LITE_MEM_RULES_INF = new OntModelSpec(ModelFactory.createMemModelMaker(), null, OWLFBRuleReasonerFactory.theInstance(), "http://www.w3.org/TR/owl-features/#term_OWLLite");
    public static final OntModelSpec DAML_MEM = new OntModelSpec(ModelFactory.createMemModelMaker(), null, null, "http://www.daml.org/2001/03/daml+oil#");
    public static final OntModelSpec DAML_MEM_TRANS_INF = new OntModelSpec(ModelFactory.createMemModelMaker(), null, TransitiveReasonerFactory.theInstance(), "http://www.daml.org/2001/03/daml+oil#");
    public static final OntModelSpec DAML_MEM_RDFS_INF = new OntModelSpec(ModelFactory.createMemModelMaker(), null, RDFSRuleReasonerFactory.theInstance(), "http://www.daml.org/2001/03/daml+oil#");
    public static final OntModelSpec DAML_MEM_RULE_INF = new OntModelSpec(ModelFactory.createMemModelMaker(), null, DAMLMicroReasonerFactory.theInstance(), "http://www.daml.org/2001/03/daml+oil#");
    public static final OntModelSpec RDFS_MEM = new OntModelSpec(ModelFactory.createMemModelMaker(), null, null, ProfileRegistry.RDFS_LANG);
    public static final OntModelSpec RDFS_MEM_TRANS_INF = new OntModelSpec(ModelFactory.createMemModelMaker(), null, TransitiveReasonerFactory.theInstance(), ProfileRegistry.RDFS_LANG);
    public static final OntModelSpec RDFS_MEM_RDFS_INF = new OntModelSpec(ModelFactory.createMemModelMaker(), null, RDFSRuleReasonerFactory.theInstance(), ProfileRegistry.RDFS_LANG);
    protected OntDocumentManager m_docManager = null;
    protected Reasoner m_reasoner = null;
    protected String m_languageURI;
    protected Profile m_profile = null;
    protected ReasonerFactory m_rFactory = null;

    public OntModelSpec(ModelMaker modelMaker, OntDocumentManager ontDocumentManager, ReasonerFactory reasonerFactory, String string) {
        super(modelMaker);
        this.setDocumentManager(ontDocumentManager);
        this.setReasonerFactory(reasonerFactory);
        if (string == null) {
            throw new IllegalArgumentException("Cannot create OntModelSpec with a null ontology language");
        }
        this.setLanguage(string);
    }

    public OntModelSpec(OntModelSpec ontModelSpec) {
        this(ontModelSpec.getModelMaker(), ontModelSpec.getDocumentManager(), ontModelSpec.getReasonerFactory(), ontModelSpec.getLanguage());
    }

    public OntModelSpec(Model model) {
        this(OntModelSpec.findRootByType(model, JMS.OntModelSpec), model);
    }

    public OntModelSpec(Resource resource, Model model) {
        this(OntModelSpec.getImportMaker(model, resource), OntModelSpec.getDocumentManager(model, resource), OntModelSpec.getReasonerFactory(model, resource), OntModelSpec.getLanguage(model, resource));
    }

    public static OntModelSpec getDefaultSpec(String string) {
        if (string.equals(ProfileRegistry.OWL_LANG)) {
            return OWL_MEM_RDFS_INF;
        }
        if (string.equals("http://www.w3.org/TR/owl-features/#term_OWLDL")) {
            return OWL_DL_MEM_RDFS_INF;
        }
        if (string.equals("http://www.w3.org/TR/owl-features/#term_OWLLite")) {
            return OWL_LITE_MEM_RDFS_INF;
        }
        if (string.equals("http://www.daml.org/2001/03/daml+oil#")) {
            return DAML_MEM_RULE_INF;
        }
        if (string.equals(ProfileRegistry.RDFS_LANG)) {
            return RDFS_MEM_RDFS_INF;
        }
        throw new OntologyException("Did not recognise this language URI, so cannot determine default model spec: " + string);
    }

    public OntDocumentManager getDocumentManager() {
        if (this.m_docManager == null) {
            this.m_docManager = OntDocumentManager.getInstance();
        }
        return this.m_docManager;
    }

    public void setDocumentManager(OntDocumentManager ontDocumentManager) {
        this.m_docManager = ontDocumentManager;
    }

    public void setModelMaker(ModelMaker modelMaker) {
        this.maker = modelMaker;
    }

    public Reasoner getReasoner() {
        if (this.m_reasoner == null && this.m_rFactory != null) {
            this.m_reasoner = this.m_rFactory.create(null);
        }
        return this.m_reasoner;
    }

    public void setReasoner(Reasoner reasoner) {
        this.m_reasoner = reasoner;
    }

    public void setReasonerFactory(ReasonerFactory reasonerFactory) {
        this.m_rFactory = reasonerFactory;
    }

    public ReasonerFactory getReasonerFactory() {
        return this.m_rFactory;
    }

    public String getLanguage() {
        return this.m_languageURI;
    }

    public void setLanguage(String string) {
        this.m_languageURI = string;
        this.m_profile = ProfileRegistry.getInstance().getProfile(this.m_languageURI);
        if (this.m_profile == null) {
            throw new OntologyException("Could not determine an ontology language profile for URI " + this.m_languageURI);
        }
    }

    public Profile getProfile() {
        return this.m_profile;
    }

    public Model createModel() {
        return new OntModelImpl(this, this.maker.createModel());
    }

    public Model createModelOver(String string) {
        return new OntModelImpl(this, this.maker.createModel(string, false));
    }

    public static ModelMaker getImportMaker(Model model, Resource resource) {
        Statement statement = model.getProperty(resource, JMS.importMaker);
        return statement == null ? ModelFactory.createMemModelMaker() : OntModelSpec.createMaker(statement.getResource(), model);
    }

    public static String getLanguage(Model model, Resource resource) {
        Statement statement = model.getRequiredProperty(resource, JMS.ontLanguage);
        return statement.getString();
    }

    public static OntDocumentManager getDocumentManager(Model model, Resource resource) {
        Statement statement = model.getProperty(resource, JMS.docManager);
        if (statement == null) {
            return null;
        }
        Resource resource2 = statement.getResource();
        Statement statement2 = model.getProperty(resource2, JMS.policyPath);
        if (statement2 == null) {
            return (OntDocumentManager)OntModelSpec.getValue(resource2);
        }
        return new OntDocumentManager(statement2.getString());
    }

    public static ReasonerFactory getReasonerFactory(Model model, Resource resource) {
        Statement statement = model.getProperty(resource, JMS.reasonsWith);
        if (statement == null) {
            return null;
        }
        Statement statement2 = model.getProperty(statement.getResource(), JMS.reasoner);
        String string = statement2.getResource().getURI();
        return ReasonerRegistry.theRegistry().getFactory(string);
    }

    public Model addDescription(Model model, Resource resource) {
        super.addDescription(model, resource);
        this.addLanguageDescription(model, resource, this.m_languageURI);
        this.addManagerDescription(model, resource, this.getDocumentManager());
        this.addReasonerDescription(model, resource, this.getReasonerFactory());
        return model;
    }

    public Property getMakerProperty() {
        return JMS.importMaker;
    }

    protected void addLanguageDescription(Model model, Resource resource, String string) {
        model.add(resource, JMS.ontLanguage, model.createLiteral(string));
    }

    protected void addManagerDescription(Model model, Resource resource, OntDocumentManager ontDocumentManager) {
        model.add(resource, JMS.docManager, OntModelSpec.createValue(ontDocumentManager));
    }

    protected void addReasonerDescription(Model model, Resource resource, ReasonerFactory reasonerFactory) {
        Resource resource2 = model.createResource();
        model.add(resource, JMS.reasonsWith, resource2);
        model.add(resource2, JMS.reasoner, model.createResource(reasonerFactory.getURI()));
    }
}

