/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.daml.impl;

import com.hp.hpl.jena.ontology.daml.DAMLModel;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DAMLLoader {
    public static final String FILE_URI_PREFIX = "file://";
    public static final long STATUS_OK = 0L;
    public static final long STATUS_INPUT_UNAVAILABLE = 1L;
    public static final long STATUS_IO_ERROR = 2L;
    public static final long STATUS_SYNTAX_ERROR = 4L;
    public static final long STATUS_MISC_ERROR = 8L;
    private long m_status = 0L;
    private DAMLModel m_damlModel = null;
    private List m_importBlockList = new ArrayList();
    private boolean m_useImportBlocking = true;

    DAMLLoader(DAMLModel dAMLModel) {
        this.m_damlModel = dAMLModel;
        this.initialiseImportBlockList();
    }

    public DAMLModel getDAMLModel() {
        return this.m_damlModel;
    }

    protected void initialiseImportBlockList() {
        this.m_importBlockList.add("http://www.daml.org/2000/12/daml+oil#");
        this.m_importBlockList.add("http://www.daml.org/2001/03/daml+oil#");
        this.m_importBlockList.add(RDFS.getURI());
    }

    public Iterator getImportBlockList() {
        return this.m_importBlockList.iterator();
    }

    public boolean isBlockedImport(String string) {
        return this.m_useImportBlocking && this.m_importBlockList.contains(string);
    }

    public void addImportBlock(String string) {
        if (!this.m_importBlockList.contains(string)) {
            this.m_importBlockList.add(string);
        }
    }

    public void removeImportBlock(String string) {
        this.m_importBlockList.remove(string);
    }

    public boolean getLoadImportedOntologies() {
        return this.m_damlModel.getDocumentManager().getProcessImports();
    }

    public void setLoadImportedOntologies(boolean bl) {
        this.m_damlModel.getDocumentManager().setProcessImports(bl);
    }

    public void setUseImportBlocking(boolean bl) {
        this.m_useImportBlocking = bl;
    }

    public boolean getUseImportBlocking() {
        return this.m_useImportBlocking;
    }

    public boolean isLoadedOntology(String string) {
        return this.m_damlModel.hasLoadedImport(string);
    }

    public long getStatus() {
        return this.m_status;
    }

    public void resetStatus() {
        this.m_status = 0L;
    }
}

