/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.daml.impl.test;

import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.ontology.OntDocumentManager;
import com.hp.hpl.jena.ontology.daml.DAMLClass;
import com.hp.hpl.jena.ontology.daml.DAMLCommon;
import com.hp.hpl.jena.ontology.daml.DAMLDataInstance;
import com.hp.hpl.jena.ontology.daml.DAMLDatatypeProperty;
import com.hp.hpl.jena.ontology.daml.DAMLInstance;
import com.hp.hpl.jena.ontology.daml.DAMLList;
import com.hp.hpl.jena.ontology.daml.DAMLModel;
import com.hp.hpl.jena.ontology.daml.DAMLObjectProperty;
import com.hp.hpl.jena.ontology.daml.DAMLProperty;
import com.hp.hpl.jena.ontology.daml.DAMLRestriction;
import com.hp.hpl.jena.ontology.daml.PropertyAccessor;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.DAML_OIL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.XSD;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import junit.framework.TestCase;
import org.apache.commons.logging.LogFactory;

public class DAMLTest
extends TestCase {
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$daml$DAMLInstance;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$daml$DAMLProperty;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$daml$DAMLClass;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$daml$DAMLObjectProperty;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$daml$DAMLList;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$daml$DAMLDataInstance;
    static /* synthetic */ Class class$java$lang$String;

    public DAMLTest(String string) {
        super(string);
    }

    public void setUp() {
        OntDocumentManager.getInstance().reset(true);
    }

    public void tearDown() {
    }

    public void testLoadOntology() {
        DAMLModel dAMLModel = ModelFactory.createDAMLModel();
        dAMLModel.getDocumentManager().setMetadataSearchPath("file:etc/ont-policy-test.rdf", true);
        dAMLModel.read("file:testing/ontology/daml/daml_oil_2001_03/daml+oil-ex.daml", "http://www.daml.org/2001/03/daml+oil-ex", null);
        DAMLTest.assertTrue((String)"Load success status should be true", (boolean)dAMLModel.getLoadSuccessful());
        DAMLTest.assertEquals((String)"Count of number of classes in daml store (2001/03, import)", (int)31, (int)this.countClasses(dAMLModel));
        DAMLTest.assertEquals((String)"Property count ", (int)68, (int)this.countProperties(dAMLModel));
        dAMLModel = ModelFactory.createDAMLModel();
        dAMLModel.getLoader().setLoadImportedOntologies(false);
        dAMLModel.read("file:testing/ontology/daml/daml_oil_2001_03/daml+oil-ex.daml", "http://www.daml.org/2001/03/daml+oil-ex", null);
        DAMLTest.assertTrue((String)"Load success status should be true", (boolean)dAMLModel.getLoadSuccessful());
        DAMLTest.assertEquals((String)"Count of number of classes in daml store (2001/03, no import)", (int)16, (int)this.countClasses(dAMLModel));
        dAMLModel = ModelFactory.createDAMLModel();
        dAMLModel.read("file:testing/ontology/daml/test-instance-load.daml");
        DAMLTest.assertTrue((String)"Load status should be true", (boolean)dAMLModel.getLoadSuccessful());
        Resource resource = dAMLModel.getResource("http://dickinson-i-4/daml/tests/test-instance-load.daml#pugh");
        DAMLTest.assertNotNull((String)"Resource for officer Pugh should not be null", (Object)resource);
        DAMLInstance dAMLInstance = (DAMLInstance)resource.as(class$com$hp$hpl$jena$ontology$daml$DAMLInstance == null ? (class$com$hp$hpl$jena$ontology$daml$DAMLInstance = DAMLTest.class$("com.hp.hpl.jena.ontology.daml.DAMLInstance")) : class$com$hp$hpl$jena$ontology$daml$DAMLInstance);
        DAMLTest.assertNotNull((Object)dAMLInstance);
        dAMLModel = ModelFactory.createDAMLModel();
        dAMLModel.read("file:testing/ontology/daml/daml_oil_2001_03/daml+oil-ex.daml", "http://www.daml.org/2001/03/daml+oil-ex", null);
        DAMLTest.assertTrue((String)"Load success status should be true", (boolean)dAMLModel.getLoadSuccessful());
        DAMLProperty dAMLProperty = (DAMLProperty)dAMLModel.getProperty("http://www.daml.org/2001/03/daml+oil-ex#shoesize").as(class$com$hp$hpl$jena$ontology$daml$DAMLProperty == null ? (class$com$hp$hpl$jena$ontology$daml$DAMLProperty = DAMLTest.class$("com.hp.hpl.jena.ontology.daml.DAMLProperty")) : class$com$hp$hpl$jena$ontology$daml$DAMLProperty);
        DAMLTest.assertNotNull((String)"Failed to find shoesize property in example ontology", (Object)dAMLProperty);
        DAMLTest.assertEquals((String)"shoesize should be a unique property", (boolean)true, (boolean)dAMLProperty.isUnique());
    }

    public void testRDFType() {
        String string = "http://dickinson-i-4/daml/tests/test-cases.daml#";
        DAMLModel dAMLModel = ModelFactory.createDAMLModel();
        dAMLModel.getDocumentManager().setMetadataSearchPath("file:etc/ont-policy-test.rdf", true);
        dAMLModel.read("file:testing/ontology/daml/test-cases.daml");
        DAMLInstance dAMLInstance = dAMLModel.getDAMLInstance(string + "fido");
        DAMLTest.assertNotNull((String)"fido instance should not be null", (Object)dAMLInstance);
        DAMLClass dAMLClass = dAMLModel.getDAMLClass(string + "Dog");
        DAMLTest.assertNotNull((String)"Dog class should not be null", (Object)dAMLClass);
        DAMLClass dAMLClass2 = dAMLModel.getDAMLClass(string + "Vertebrate");
        DAMLTest.assertNotNull((String)"Vertebrate class should not be null", (Object)dAMLClass2);
        DAMLClass dAMLClass3 = dAMLModel.getDAMLClass(string + "Pet");
        DAMLTest.assertNotNull((String)"Pet class should not be null", (Object)dAMLClass3);
        DAMLTest.assertTrue((String)"fido should be member of class Dog", (boolean)dAMLInstance.hasRDFType(dAMLClass));
        DAMLTest.assertTrue((String)"fido should be member of class Vertebrate", (boolean)dAMLInstance.hasRDFType(dAMLClass2));
        DAMLTest.assertTrue((String)"fido should be member of class Vertebrate (by URL)", (boolean)dAMLInstance.hasRDFType(string + "Vertebrate"));
        DAMLTest.assertTrue((String)"fido should be member of class Pet", (boolean)dAMLInstance.hasRDFType(dAMLClass3));
        DAMLTest.assertTrue((String)"fido should not be a class", (!dAMLInstance.hasRDFType(DAML_OIL.Class) ? 1 : 0) != 0);
        DAMLTest.assertTrue((String)"fido should be a companion", (boolean)dAMLInstance.hasRDFType(string + "Companion"));
        DAMLClass dAMLClass4 = dAMLModel.getDAMLClass(string + "A");
        DAMLTest.assertNotNull((String)"Class A should not be null", (Object)dAMLClass4);
        DAMLClass dAMLClass5 = dAMLModel.getDAMLClass(string + "B");
        DAMLTest.assertNotNull((String)"Class B should not be null", (Object)dAMLClass5);
        DAMLInstance dAMLInstance2 = dAMLModel.getDAMLInstance(string + "ab");
        DAMLTest.assertNotNull((String)"Instance ab should not be null", (Object)dAMLInstance2);
        DAMLTest.assertTrue((String)"ab should be an A", (boolean)dAMLInstance2.hasRDFType(dAMLClass4));
        DAMLTest.assertTrue((String)"ab should be a B", (boolean)dAMLInstance2.hasRDFType(dAMLClass5));
        DAMLTest.assertEquals((String)"Number of classes fido belongs to (closure) should be 8", (int)8, (int)this.countIteration(dAMLInstance.getRDFTypes(true), true, "fido member of class "));
        DAMLTest.assertEquals((String)"Number of classes fido belongs to (non-closure) should be 3", (int)3, (int)this.countIteration(dAMLInstance.getRDFTypes(false), true, "fido member of non-closed class "));
        DAMLProperty dAMLProperty = dAMLModel.getDAMLProperty(string + "queen-of");
        DAMLTest.assertNotNull((String)"queen-of property should be defined", (Object)dAMLProperty);
        DAMLTest.assertTrue((String)"an UnabmbiguousProperty should be an ObjectProperty", (boolean)dAMLProperty.hasRDFType(DAML_OIL.UnambiguousProperty));
        DAMLTest.assertTrue((String)"an UnabmbiguousProperty should be an ObjectProperty", (boolean)dAMLProperty.hasRDFType(DAML_OIL.ObjectProperty));
        DAMLTest.assertTrue((String)"an UnabmbiguousProperty should be an rdf:Property", (boolean)dAMLProperty.hasRDFType(RDF.Property));
    }

    public void testClass() {
        DAMLModel dAMLModel = ModelFactory.createDAMLModel();
        dAMLModel.getDocumentManager().setMetadataSearchPath("file:etc/ont-policy-test.rdf", true);
        dAMLModel.read("file:testing/ontology/daml/daml_oil_2001_03/daml+oil-ex.daml", "http://www.daml.org/2001/03/daml+oil-ex", null);
        DAMLTest.assertTrue((String)"loadStatus should be true for successful load", (boolean)dAMLModel.getLoadSuccessful());
        String string = "http://www.daml.org/2001/03/daml+oil-ex#";
        DAMLClass dAMLClass = dAMLModel.getDAMLClass(string + "Person");
        DAMLTest.assertNotNull((String)"Person class should not be null", (Object)dAMLClass);
        DAMLTest.assertTrue((String)"Person should be a named class", (boolean)dAMLClass.isNamedClass());
        int n = this.countIteration(dAMLClass.prop_subClassOf().getAll(), true, "super-class of Person (prop_subClassOf) ");
        int n2 = this.countIteration(dAMLClass.getSuperClasses(), true, "super-class of Person (getSuperClasses) ");
        DAMLTest.assertEquals((String)"person should have 10 super-classes (by prop_subClassOf)", (int)10, (int)n);
        DAMLTest.assertEquals((String)"person should have 9 super-classes (by getSuperClasses)", (int)9, (int)n2);
        DAMLTest.assertEquals((String)"person should have 3 sub-classes", (int)3, (int)this.countIteration(dAMLClass.getSubClasses(), true, "Person super-class of: "));
        DAMLTest.assertTrue((String)"Person should be a disjoint union", (boolean)dAMLClass.isDisjointUnion());
        DAMLList dAMLList = dAMLClass.prop_disjointUnionOf().getList();
        DAMLTest.assertNotNull((String)"Value of disjoint union should not be null", (Object)dAMLList);
        DAMLTest.assertEquals((String)"Person should be a disjoint union of size 2", (int)2, (int)dAMLList.getCount());
        DAMLClass dAMLClass2 = dAMLModel.getDAMLClass(string + "Female");
        DAMLTest.assertNotNull((String)"Class Female should not be null", (Object)dAMLClass2);
        DAMLClass dAMLClass3 = dAMLModel.getDAMLClass(string + "Male");
        DAMLTest.assertNotNull((String)"Class Male should not be null", (Object)dAMLClass3);
        DAMLTest.assertTrue((String)"Female should be disjoint with male", (boolean)dAMLClass2.prop_disjointWith().hasValue(dAMLClass3));
        DAMLClass dAMLClass4 = dAMLModel.getDAMLClass(string + "HumanBeing");
        DAMLTest.assertNotNull((String)"Class humanBeing should not be null", (Object)dAMLClass4);
        DAMLTest.assertTrue((String)"Person should be same class as HumanBeing", (boolean)dAMLClass4.prop_sameClassAs().hasValue(dAMLClass));
        DAMLClass dAMLClass5 = dAMLModel.getDAMLClass(string + "TallMan");
        DAMLTest.assertNotNull((String)"Class TallMan should not be null", (Object)dAMLClass5);
        DAMLList dAMLList2 = dAMLClass5.prop_intersectionOf().getList();
        DAMLTest.assertNotNull((String)"Value of intersection should not be null", (Object)dAMLList2);
        DAMLTest.assertEquals((String)"Tall man should be an intersection of size 2", (int)2, (int)dAMLList2.getCount());
        DAMLClass dAMLClass6 = dAMLModel.getDAMLClass(string + "Car");
        DAMLTest.assertNotNull((String)"Class Car should not be null", (Object)dAMLClass6);
        DAMLClass dAMLClass7 = (DAMLClass)dAMLClass6.getSuperClasses(false).next();
        DAMLTest.assertNotNull((String)"Car should have a super-class", (Object)dAMLClass7);
        DAMLTest.assertTrue((String)"Car super-class should be a complement", (boolean)dAMLClass7.isComplement());
        DAMLTest.assertTrue((String)"Car super-class should be a complement of Person", (boolean)dAMLClass7.prop_complementOf().hasValue(dAMLClass));
        DAMLClass dAMLClass8 = dAMLModel.getDAMLClass(string + "Height");
        DAMLTest.assertNotNull((String)"Class Height should not be null", (Object)dAMLClass8);
        DAMLTest.assertTrue((String)"Height should be an enumeration", (boolean)dAMLClass8.isEnumeration());
        DAMLTest.assertEquals((String)"Height should be an enumeration of 3 elements", (int)3, (int)dAMLClass8.prop_oneOf().getList().getCount());
        DAMLModel dAMLModel2 = ModelFactory.createDAMLModel();
        dAMLModel2.getLoader().setLoadImportedOntologies(true);
        dAMLModel2.read("file:testing/ontology/daml/test-cases.daml", "http://dickinson-i-4/daml/tests/test-cases.daml", null);
        String string2 = "http://dickinson-i-4/daml/tests/test-cases.daml#";
        DAMLClass dAMLClass9 = dAMLModel2.getDAMLClass(string2 + "SubClassBug0");
        DAMLClass dAMLClass10 = dAMLModel2.getDAMLClass(string2 + "SubClassBug1");
        DAMLTest.assertNotNull((String)"Class SubClassBug0 should not be null", (Object)dAMLClass9);
        DAMLTest.assertNotNull((String)"Class SubClassBug1 should not be null", (Object)dAMLClass10);
        DAMLTest.assertTrue((String)"SubClassBug1 should have SubClassBug0 as a super-class", (boolean)dAMLClass10.hasSuperClass(dAMLClass9));
        DAMLTest.assertTrue((String)"SubClassBug0 should have SubClassBug1 as a sub-class", (boolean)dAMLClass9.hasSubClass(dAMLClass10));
        DAMLClass dAMLClass11 = dAMLModel2.getDAMLClass(string2 + "DefProp0");
        DAMLClass dAMLClass12 = dAMLModel2.getDAMLClass(string2 + "DefProp1");
        DAMLClass dAMLClass13 = dAMLModel2.getDAMLClass(string2 + "DefProp2");
        DAMLTest.assertNotNull((String)"Class DefProp0 should not be null", (Object)dAMLClass11);
        DAMLTest.assertNotNull((String)"Class DefProp1 should not be null", (Object)dAMLClass12);
        DAMLTest.assertNotNull((String)"Class DefProp2 should not be null", (Object)dAMLClass13);
        int n4 = this.countIteration(dAMLClass11.getDefinedProperties(), true, "Defined property of DefProp0, closed");
        int n5 = this.countIteration(dAMLClass11.getDefinedProperties(false), true, "Defined property of DefProp0, not closed");
        int n6 = this.countIteration(dAMLClass12.getDefinedProperties(), true, "Defined property of DefProp1, closed");
        int n7 = this.countIteration(dAMLClass12.getDefinedProperties(false), true, "Defined property of DefProp1, not closed");
        int n8 = this.countIteration(dAMLClass13.getDefinedProperties(), true, "Defined property of DefProp2, closed");
        int n9 = this.countIteration(dAMLClass13.getDefinedProperties(false), true, "Defined property of DefProp2, not closed");
        DAMLTest.assertEquals((String)"Defined properties of DefProp0 should number 3", (int)3, (int)n4);
        DAMLTest.assertEquals((String)"Defined properties of DefProp0 (non-closed) should number 1", (int)1, (int)n5);
        DAMLTest.assertEquals((String)"Defined properties of DefProp1 should number 3", (int)3, (int)n6);
        DAMLTest.assertEquals((String)"Defined properties of DefProp1 (non-closed) should number 0", (int)0, (int)n7);
        DAMLTest.assertEquals((String)"Defined properties of DefProp2 should number 4", (int)4, (int)n8);
        DAMLTest.assertEquals((String)"Defined properties of DefProp2 (non-closed) should number 1", (int)1, (int)n9);
        DAMLClass dAMLClass14 = dAMLModel2.getDAMLClass(string2 + "tl_one");
        DAMLTest.assertNotNull((String)"Class tl_one should not be null", (Object)dAMLClass14);
        int n10 = this.countIteration(dAMLClass14.prop_subClassOf().getAll(), true, "prop_subClassOf ");
        int n11 = this.countIteration(dAMLClass14.getSuperClasses(false), true, "getSuperClasses ");
        DAMLTest.assertEquals((String)"Should be four super-classes of tl_one by prop_subClassOf", (int)4, (int)n10);
        DAMLTest.assertEquals((String)"Should be two super-classes of tl_one by getSuperClasses", (int)2, (int)n11);
        DAMLClass dAMLClass15 = dAMLModel2.getDAMLClass(string2 + "Researcher");
        DAMLTest.assertNotNull((String)"Class Researcher should not be null", (Object)dAMLClass15);
        int n12 = this.countIteration(dAMLClass15.getSuperClasses(false), true, "Super-class of researcher");
        DAMLTest.assertEquals((String)"Should be 2 super-classes of researcher", (int)2, (int)n12);
    }

    public void testEquivalence() {
        String string = "http://dickinson-i-4/daml/tests/test-cases.daml#";
        DAMLModel dAMLModel = ModelFactory.createDAMLModel();
        dAMLModel.read("file:testing/ontology/daml/test-cases.daml", "http://dickinson-i-4/daml/tests/test-cases.daml", null);
        DAMLInstance dAMLInstance = dAMLModel.getDAMLInstance(string + "x0");
        DAMLTest.assertNotNull((String)"Instance x0 should not be null", (Object)dAMLInstance);
        DAMLTest.assertEquals((String)"Number of elements in equivalence class should be 1", (int)1, (int)this.countIteration(dAMLInstance.getEquivalentValues(), true, "Member of equivalence class to x0: "));
        DAMLClass dAMLClass = dAMLModel.getDAMLClass(string + "C0");
        DAMLTest.assertNotNull((String)"Class C0 should not be null", (Object)dAMLClass);
        DAMLTest.assertEquals((String)"Number of elements in equivalence class should be 1", (int)1, (int)this.countIteration(dAMLClass.getSameClasses(), true, "sameClass as C0: "));
        DAMLProperty dAMLProperty = dAMLModel.getDAMLProperty(string + "p0");
        DAMLTest.assertNotNull((String)"Property p0 should not be null", (Object)dAMLProperty);
        DAMLTest.assertEquals((String)"Number of elements in equivalence class should be 1", (int)1, (int)this.countIteration(dAMLProperty.getSameProperties(), true, "sameProperty as p0: "));
        Resource resource = dAMLModel.getResource(string + "CDaml");
        DAMLTest.assertNotNull((String)"Resource dClass should not be null", (Object)resource);
        DAMLTest.assertTrue((String)"Resource dClass should be a daml class", (boolean)resource.canAs(class$com$hp$hpl$jena$ontology$daml$DAMLClass == null ? (class$com$hp$hpl$jena$ontology$daml$DAMLClass = DAMLTest.class$("com.hp.hpl.jena.ontology.daml.DAMLClass")) : class$com$hp$hpl$jena$ontology$daml$DAMLClass));
        DAMLClass dAMLClass2 = dAMLModel.getDAMLClass(string + "D0");
        DAMLClass dAMLClass3 = dAMLModel.getDAMLClass(string + "D1");
        DAMLInstance dAMLInstance2 = dAMLModel.getDAMLInstance(string + "d1");
        DAMLTest.assertNotNull((String)"Class D0 should not be null", (Object)dAMLClass2);
        DAMLTest.assertNotNull((String)"Class D1 should not be null", (Object)dAMLClass3);
        DAMLTest.assertNotNull((String)"Instance d1 should not be null", (Object)dAMLInstance2);
        DAMLTest.assertTrue((String)"Instance d1 should have class D1", (boolean)dAMLInstance2.hasRDFType(dAMLClass3));
        DAMLProperty dAMLProperty2 = dAMLModel.getDAMLProperty(string + "pd0");
        DAMLProperty dAMLProperty3 = dAMLModel.getDAMLProperty(string + "pd1");
        DAMLTest.assertNotNull((String)"Property pd0 should not be null", (Object)dAMLProperty2);
        DAMLTest.assertNotNull((String)"Property pd1 should not be null", (Object)dAMLProperty3);
        DAMLInstance dAMLInstance3 = dAMLModel.getDAMLInstance(string + "d2");
        DAMLTest.assertNotNull((String)"Instance d2 should not be null", (Object)dAMLInstance3);
        DAMLTest.assertTrue((String)"d2 should have d1 as a value for pd0", (boolean)dAMLInstance3.accessProperty(dAMLProperty2).hasValue(dAMLInstance2));
        DAMLProperty dAMLProperty4 = dAMLModel.getDAMLProperty(string + "pd2");
        DAMLProperty dAMLProperty5 = dAMLModel.getDAMLProperty(string + "pd3");
        DAMLTest.assertNotNull((String)"Property pd2 should not be null", (Object)dAMLProperty4);
        DAMLTest.assertNotNull((String)"Property pd3 should not be null", (Object)dAMLProperty5);
        DAMLTest.assertTrue((String)"d2 should have d1 as a value for pd3", (boolean)dAMLInstance3.accessProperty(dAMLProperty5).hasValue(dAMLInstance2));
    }

    public void testProperty() {
        Object object;
        DAMLModel dAMLModel = ModelFactory.createDAMLModel();
        dAMLModel.getDocumentManager().setMetadataSearchPath("file:etc/ont-policy-test.rdf", true);
        dAMLModel.read("file:testing/ontology/daml/daml_oil_2001_03/daml+oil-ex.daml", "http://www.daml.org/2001/03/daml+oil-ex", null);
        DAMLTest.assertTrue((String)"loadStatus should be true for successful load", (boolean)dAMLModel.getLoadSuccessful());
        String string = "http://www.daml.org/2001/03/daml+oil-ex#";
        DAMLProperty dAMLProperty = dAMLModel.getDAMLProperty(string + "hasMother");
        DAMLTest.assertNotNull((String)"hasMother property should not be null", (Object)dAMLProperty);
        DAMLTest.assertTrue((String)"hasMother property should be a unique property", (boolean)dAMLProperty.isUnique());
        DAMLProperty dAMLProperty2 = dAMLModel.getDAMLProperty(string + "hasParent");
        DAMLTest.assertNotNull((String)"hasParent property should not be null", (Object)dAMLProperty2);
        DAMLClass dAMLClass = dAMLModel.getDAMLClass(string + "Female");
        DAMLTest.assertNotNull((String)"Class Female should not be null", (Object)dAMLClass);
        DAMLClass dAMLClass2 = dAMLModel.getDAMLClass(string + "Animal");
        DAMLTest.assertNotNull((String)"Class Animal should not be null", (Object)dAMLClass2);
        DAMLClass dAMLClass3 = dAMLModel.getDAMLClass(string + "Person");
        DAMLTest.assertNotNull((String)"Class Person should not be null", (Object)dAMLClass3);
        DAMLTest.assertTrue((String)"Mother should have Female as range", (boolean)dAMLProperty.prop_range().hasValue(dAMLClass));
        DAMLTest.assertTrue((String)"Mother should not have Animal as local domain (prop_domain)", (!dAMLProperty.prop_domain().hasValue(dAMLClass2) ? 1 : 0) != 0);
        boolean bl = false;
        Object object2 = dAMLProperty.getDomainClasses();
        while (!bl && object2.hasNext()) {
            object = object2.next();
            bl = ((DAMLClass)object).equals(dAMLClass2);
        }
        object2 = (DAMLObjectProperty)dAMLModel.getDAMLProperty(string + "hasAncestor").as(class$com$hp$hpl$jena$ontology$daml$DAMLObjectProperty == null ? (class$com$hp$hpl$jena$ontology$daml$DAMLObjectProperty = DAMLTest.class$("com.hp.hpl.jena.ontology.daml.DAMLObjectProperty")) : class$com$hp$hpl$jena$ontology$daml$DAMLObjectProperty);
        DAMLTest.assertNotNull((String)"hasAncestor should not be null", (Object)object2);
        DAMLTest.assertTrue((String)"hasAncestor should be transitive", (boolean)object2.isTransitive());
        object = dAMLModel.getDAMLInstance(string + "Peter");
        DAMLTest.assertNotNull((String)"Instance Peter should not be null", object);
        DAMLProperty dAMLProperty3 = dAMLModel.getDAMLProperty(string + "shoesize");
        DAMLTest.assertNotNull((String)"Property shoesize should not be null", (Object)dAMLProperty3);
        PropertyAccessor propertyAccessor = object.accessProperty(dAMLProperty3);
        NodeIterator nodeIterator = propertyAccessor.getAll();
        DAMLTest.assertEquals((String)"iShoes iterator should have at least one value", (boolean)true, (boolean)nodeIterator.hasNext());
        Object e = nodeIterator.next();
        DAMLTest.assertNotNull((String)"size returned from property accessor iterator should not be null", e);
        DAMLTest.assertTrue((String)"size object should be a literal", (boolean)(e instanceof Literal));
        boolean bl2 = false;
        try {
            nodeIterator.next();
        }
        catch (NoSuchElementException noSuchElementException) {
            bl2 = true;
        }
        DAMLTest.assertEquals((String)"Accessing past end of property iterator should throw no such element exception", (boolean)true, (boolean)bl2);
        NodeIterator nodeIterator2 = dAMLClass3.prop_subClassOf().getAll();
        DAMLTest.assertNotNull((String)"Iterator over subClassOf values should not be null", (Object)nodeIterator2);
        DAMLTest.assertTrue((String)"Iteration of subClassOf should have at least one value", (boolean)nodeIterator2.hasNext());
        int n = this.countIteration(nodeIterator2, true, "direct super-class of Person = ");
        DAMLTest.assertEquals((String)"Should be 10 super-classes of Person", (int)10, (int)n);
        DAMLClass dAMLClass4 = dAMLModel.getDAMLClass(string + "Male");
        DAMLTest.assertNotNull((String)"Class Male should not be null", (Object)dAMLClass4);
        DAMLCommon dAMLCommon = (DAMLCommon)dAMLClass.prop_disjointWith().get();
        DAMLTest.assertNotNull((String)"Value for female.disjointWith should not be null", (Object)dAMLCommon);
        DAMLTest.assertTrue((String)"female.disjointWith should be male", (boolean)dAMLClass4.equals(dAMLCommon));
        dAMLModel.getLoader().setLoadImportedOntologies(false);
        dAMLModel.read("file:testing/ontology/daml/test-cases.daml", "http://dickinson-i-4/daml/tests/test-cases.daml", null);
        DAMLTest.assertTrue((String)"loadStatus should be true for successful load", (boolean)dAMLModel.getLoadSuccessful());
        string = "http://dickinson-i-4/daml/tests/test-cases.daml#";
        DAMLClass dAMLClass5 = (DAMLClass)dAMLModel.getDAMLValue(string + "subClassCheck3").as(class$com$hp$hpl$jena$ontology$daml$DAMLClass == null ? (class$com$hp$hpl$jena$ontology$daml$DAMLClass = DAMLTest.class$("com.hp.hpl.jena.ontology.daml.DAMLClass")) : class$com$hp$hpl$jena$ontology$daml$DAMLClass);
        DAMLTest.assertNotNull((String)"Class subClassCheck3 should not be null", (Object)dAMLClass5);
        ExtendedIterator extendedIterator = dAMLClass5.getSuperClasses(false);
        DAMLTest.assertNotNull((String)"Iterator over subClassOf values should not be null", (Object)nodeIterator2);
        DAMLTest.assertTrue((String)"Iteration of subClassOf should have at least one value", (boolean)extendedIterator.hasNext());
        n = this.countIteration(extendedIterator, true, "property access on subClassCheck3");
        DAMLTest.assertEquals((String)"Should be 1 non-closed super-classes of subClassCheck3", (int)1, (int)n);
        extendedIterator = dAMLClass5.getSuperClasses(true);
        DAMLTest.assertNotNull((String)"Iterator over subClassOf values should not be null", (Object)nodeIterator2);
        DAMLTest.assertTrue((String)"Iteration of subClassOf should have at least one value", (boolean)extendedIterator.hasNext());
        n = this.countIteration(extendedIterator, true, "property access on subClassCheck3 with closed = true ");
        DAMLTest.assertEquals((String)"Should be 3 closed super-classes of subClassCheck3", (int)3, (int)n);
        DAMLProperty dAMLProperty4 = dAMLModel.getDAMLProperty(string + "q");
        DAMLTest.assertNotNull((String)"Property q should not be null", (Object)dAMLProperty4);
        DAMLInstance dAMLInstance = dAMLModel.getDAMLInstance(string + "qX");
        DAMLTest.assertNotNull((String)"Instance qX should not be null", (Object)dAMLInstance);
        int n2 = dAMLInstance.accessProperty(dAMLProperty4).count();
        DAMLTest.assertEquals((String)"There should be 1 values for q of qX (equivalence off)", (int)1, (int)n2);
        DAMLObjectProperty dAMLObjectProperty = (DAMLObjectProperty)dAMLModel.getDAMLProperty(string + "TL_PropertyTest").as(class$com$hp$hpl$jena$ontology$daml$DAMLObjectProperty == null ? (class$com$hp$hpl$jena$ontology$daml$DAMLObjectProperty = DAMLTest.class$("com.hp.hpl.jena.ontology.daml.DAMLObjectProperty")) : class$com$hp$hpl$jena$ontology$daml$DAMLObjectProperty);
        DAMLTest.assertNotNull((String)"Property should not be null", (Object)dAMLObjectProperty);
        NodeIterator nodeIterator3 = dAMLObjectProperty.prop_domain().getAll();
        DAMLTest.assertEquals((String)"Property TL_PropertyTest should have a domain of two classes", (int)2, (int)this.countIteration(nodeIterator3, false, null));
        NodeIterator nodeIterator4 = dAMLObjectProperty.prop_range().getAll();
        DAMLTest.assertEquals((String)"Property TL_PropertyTest should have a range of two classes", (int)2, (int)this.countIteration(nodeIterator4, false, null));
        DAMLClass dAMLClass6 = (DAMLClass)dAMLModel.getDAMLValue(string + "HumanBody").as(class$com$hp$hpl$jena$ontology$daml$DAMLClass == null ? (class$com$hp$hpl$jena$ontology$daml$DAMLClass = DAMLTest.class$("com.hp.hpl.jena.ontology.daml.DAMLClass")) : class$com$hp$hpl$jena$ontology$daml$DAMLClass);
        DAMLTest.assertNotNull((String)"Class humanBody should not be null", (Object)dAMLClass6);
        PropertyAccessor propertyAccessor2 = dAMLClass6.prop_unionOf();
        DAMLTest.assertNotNull((String)"Property accessor should not be null", (Object)propertyAccessor2);
        DAMLTest.assertEquals((String)"Should be two value in union", (int)1, (int)propertyAccessor2.count());
        DAMLCommon dAMLCommon2 = propertyAccessor2.getDAMLValue();
        DAMLTest.assertNotNull((String)"Union should not be null", (Object)dAMLCommon2);
        DAMLTest.assertTrue((String)"Union value should be a list", (boolean)dAMLCommon2.canAs(class$com$hp$hpl$jena$ontology$daml$DAMLList == null ? (class$com$hp$hpl$jena$ontology$daml$DAMLList = DAMLTest.class$("com.hp.hpl.jena.ontology.daml.DAMLList")) : class$com$hp$hpl$jena$ontology$daml$DAMLList));
        DAMLTest.assertEquals((String)"Should be two values in list", (int)2, (int)((DAMLList)dAMLCommon2.as(class$com$hp$hpl$jena$ontology$daml$DAMLList == null ? (class$com$hp$hpl$jena$ontology$daml$DAMLList = DAMLTest.class$("com.hp.hpl.jena.ontology.daml.DAMLList")) : class$com$hp$hpl$jena$ontology$daml$DAMLList)).getCount());
    }

    public void testList() {
        DAMLModel dAMLModel = ModelFactory.createDAMLModel();
        dAMLModel.read("file:testing/ontology/daml/daml_oil_2001_03/daml+oil-ex.daml", "http://www.daml.org/2001/03/daml+oil-ex", null);
        DAMLTest.assertTrue((String)"loadStatus should be true for successful load", (boolean)dAMLModel.getLoadSuccessful());
        String string = "http://www.daml.org/2001/03/daml+oil-ex#";
        DAMLClass dAMLClass = dAMLModel.getDAMLClass(string + "Person");
        DAMLTest.assertNotNull((String)"Person class should not be null", (Object)dAMLClass);
        DAMLClass dAMLClass2 = dAMLModel.getDAMLClass(string + "Man");
        DAMLTest.assertNotNull((String)"Man class should not be null", (Object)dAMLClass2);
        DAMLClass dAMLClass3 = dAMLModel.getDAMLClass(string + "Woman");
        DAMLTest.assertNotNull((String)"Woman class should not be null", (Object)dAMLClass3);
        DAMLList dAMLList = (DAMLList)dAMLClass.prop_disjointUnionOf().get().as(class$com$hp$hpl$jena$ontology$daml$DAMLList == null ? (class$com$hp$hpl$jena$ontology$daml$DAMLList = DAMLTest.class$("com.hp.hpl.jena.ontology.daml.DAMLList")) : class$com$hp$hpl$jena$ontology$daml$DAMLList);
        DAMLTest.assertNotNull((String)"union should not be null", (Object)dAMLList);
        DAMLTest.assertEquals((String)"union should have two values", (int)2, (int)dAMLList.getCount());
        RDFNode rDFNode = dAMLList.getFirst();
        DAMLTest.assertEquals((String)"Man should be the first element in the list", (Object)dAMLClass2, (Object)rDFNode);
        DAMLList dAMLList2 = dAMLList.getRest();
        DAMLTest.assertNotNull((String)"Tail of list should not be null", (Object)dAMLList2);
        RDFNode rDFNode2 = dAMLList2.getFirst();
        DAMLTest.assertNotNull((String)"head of tail should not be null", (Object)rDFNode2);
        DAMLTest.assertEquals((String)"Woman should be the first element in the tail of the list", (Object)dAMLClass3, (Object)rDFNode2);
        DAMLList dAMLList3 = dAMLList2.getRest();
        DAMLTest.assertNotNull((String)"Tail of tail should not be null", (Object)dAMLList3);
        DAMLTest.assertTrue((String)"Remainder of list should be empty", (boolean)dAMLList3.isEmpty());
        DAMLClass dAMLClass4 = dAMLModel.getDAMLClass(string + "Car");
        DAMLTest.assertNotNull((String)"Class Car should not be null", (Object)dAMLClass4);
        dAMLList.add(dAMLClass4);
        DAMLTest.assertEquals((String)"Union should contain three elements", (int)3, (int)dAMLList.getCount());
    }

    public void testInstance() {
        DAMLModel dAMLModel = ModelFactory.createDAMLModel();
        dAMLModel.read("file:testing/ontology/daml/daml_oil_2001_03/daml+oil-ex.daml", "http://www.daml.org/2001/03/daml+oil-ex", null);
        DAMLTest.assertTrue((String)"loadStatus should be true for successful load", (boolean)dAMLModel.getLoadSuccessful());
        String string = "http://www.daml.org/2001/03/daml+oil-ex#";
        DAMLTest.assertEquals((String)"Number of instances should be 7", (int)7, (int)this.countIteration(dAMLModel.listDAMLInstances(), false, " instance = "));
        DAMLClass dAMLClass = dAMLModel.getDAMLClass(string + "Person");
        DAMLTest.assertNotNull((String)"Person DAML class should not be null", (Object)dAMLClass);
        int n = this.countIteration(dAMLClass.getInstances(), true, "instance of person");
        DAMLTest.assertEquals((String)"There should be 4 instances of Person in the model", (int)4, (int)n);
    }

    public void testDatatype() {
        DAMLModel dAMLModel = ModelFactory.createDAMLModel();
        dAMLModel.read("file:testing/ontology/daml/daml_oil_2001_03/daml+oil-ex.daml", "http://www.daml.org/2001/03/daml+oil-ex", null);
        DAMLTest.assertTrue((String)"loadStatus should be true for successful load", (boolean)dAMLModel.getLoadSuccessful());
        String string = "http://www.daml.org/2001/03/daml+oil-ex#";
        DAMLInstance dAMLInstance = dAMLModel.getDAMLInstance(string + "Ian");
        DAMLTest.assertNotNull((String)"Instance Ian should not be null", (Object)dAMLInstance);
        DAMLProperty dAMLProperty = dAMLModel.getDAMLProperty(string + "shirtsize");
        DAMLTest.assertNotNull((String)"Property shirtsize should not be null", (Object)dAMLProperty);
        DAMLProperty dAMLProperty2 = dAMLModel.getDAMLProperty(string + "shoesize");
        DAMLTest.assertNotNull((String)"Property shoesize should not be null", (Object)dAMLProperty2);
        DAMLDataInstance dAMLDataInstance = (DAMLDataInstance)dAMLInstance.getRequiredProperty(dAMLProperty).getObject().as(class$com$hp$hpl$jena$ontology$daml$DAMLDataInstance == null ? (class$com$hp$hpl$jena$ontology$daml$DAMLDataInstance = DAMLTest.class$("com.hp.hpl.jena.ontology.daml.DAMLDataInstance")) : class$com$hp$hpl$jena$ontology$daml$DAMLDataInstance);
        DAMLTest.assertNotNull((String)"Object ian should have a shirtsize", (Object)dAMLDataInstance);
        Object object = dAMLDataInstance.getValue();
        DAMLTest.assertNotNull((String)"Value of shirtsize should not be null", (Object)object);
        DAMLTest.assertEquals((String)"Shirt size should be a string", (Object)(class$java$lang$String == null ? (class$java$lang$String = DAMLTest.class$("java.lang.String")) : class$java$lang$String), object.getClass());
        DAMLTest.assertEquals((String)"Shirt size should be \"12\"", (Object)"12", (Object)object);
    }

    public void testDataInstance() {
        DAMLModel dAMLModel = ModelFactory.createDAMLModel();
        DAMLDataInstance dAMLDataInstance = dAMLModel.createDAMLDataInstance(new Integer(9));
        DAMLTest.assertNotNull((String)"Failed to create data instance ", (Object)dAMLDataInstance);
        DAMLTest.assertEquals((String)"data instance URI not correct ", (Object)TypeMapper.getInstance().getTypeByName(XSD.xint.getURI()), (Object)dAMLDataInstance.getDatatype());
        String string = "http://example.org/eg#";
        DAMLClass dAMLClass = dAMLModel.createDAMLClass(string + "Person");
        DAMLInstance dAMLInstance = dAMLModel.createDAMLInstance(dAMLClass, string + "peter");
        DAMLDatatypeProperty dAMLDatatypeProperty = dAMLModel.createDAMLDatatypeProperty(string + "shirtsize");
        dAMLInstance.addProperty((Property)dAMLDatatypeProperty, dAMLDataInstance);
    }

    public void testRemove() {
        OntDocumentManager.getInstance().setProcessImports(false);
        DAMLModel dAMLModel = ModelFactory.createDAMLModel();
        dAMLModel.read("file:testing/ontology/daml/daml_oil_2001_03/daml+oil-ex.daml", "http://www.daml.org/2001/03/daml+oil-ex", null);
        DAMLTest.assertTrue((String)"loadStatus should be true for successful load", (boolean)dAMLModel.getLoadSuccessful());
        ArrayList arrayList = new ArrayList();
        Object object = dAMLModel.listDAMLClasses();
        while (object.hasNext()) {
            arrayList.add(object.next());
        }
        while (!arrayList.isEmpty()) {
            object = (DAMLClass)arrayList.remove(0);
            object.remove();
        }
        object = dAMLModel.listDAMLInstances();
        while (object.hasNext()) {
            arrayList.add(object.next());
        }
        while (!arrayList.isEmpty()) {
            object = (DAMLInstance)arrayList.remove(0);
            object.remove();
        }
        object = dAMLModel.listDAMLProperties();
        while (object.hasNext()) {
            arrayList.add(object.next());
        }
        while (!arrayList.isEmpty()) {
            object = (DAMLProperty)arrayList.remove(0);
            object.remove();
        }
        boolean bl = false;
        ExtendedIterator extendedIterator = dAMLModel.listDAMLClasses();
        while (extendedIterator.hasNext()) {
            if (extendedIterator.next().equals(DAML_OIL.Thing)) continue;
            bl = true;
        }
        DAMLTest.assertFalse((String)"Should be no more classes", (boolean)bl);
        DAMLTest.assertFalse((String)"Should be no more properties", (boolean)dAMLModel.listDAMLProperties().hasNext());
        DAMLTest.assertFalse((String)"Should be no more instances", (boolean)dAMLModel.listDAMLInstances().hasNext());
    }

    public void testCreate() {
        DAMLModel dAMLModel = ModelFactory.createDAMLModel();
        String string = "http://dickinson-i-4/daml/tests/gen#A";
        DAMLClass dAMLClass = dAMLModel.createDAMLClass(string);
        DAMLTest.assertNotNull((String)("Failed to create new DAML Class " + string), (Object)dAMLClass);
        boolean bl = false;
        Object object = dAMLModel.listDAMLClasses();
        while (object.hasNext()) {
            if (!((DAMLClass)object.next()).equals(dAMLClass)) continue;
            bl = true;
        }
        DAMLTest.assertTrue((String)"Could not see class after it was created", (boolean)bl);
        object = (DAMLInstance)dAMLModel.createDAMLValue("http://dickinson-i-4/daml/tests/gen#x", dAMLClass);
        DAMLTest.assertNotNull((String)"Failed to create new DAML instance", (Object)object);
        bl = false;
        ExtendedIterator extendedIterator = dAMLModel.listDAMLInstances();
        while (extendedIterator.hasNext()) {
            if (!((DAMLInstance)extendedIterator.next()).equals(object)) continue;
            bl = true;
        }
        DAMLTest.assertTrue((String)"Could not see instance after it was created", (boolean)bl);
    }

    public void testRestriction() {
        DAMLModel dAMLModel = ModelFactory.createDAMLModel();
        dAMLModel.read("file:testing/ontology/daml/daml_oil_2001_03/daml+oil-ex.daml", "http://www.daml.org/2001/03/daml+oil-ex", null);
        DAMLTest.assertTrue((String)"loadStatus should be true for successful load", (boolean)dAMLModel.getLoadSuccessful());
        String string = "http://www.daml.org/2001/03/daml+oil-ex#";
        DAMLClass dAMLClass = dAMLModel.getDAMLClass(string + "Person");
        ExtendedIterator extendedIterator = dAMLClass.getSuperClasses();
        while (extendedIterator.hasNext()) {
            DAMLRestriction dAMLRestriction;
            PropertyAccessor propertyAccessor;
            int n;
            Resource resource = (Resource)extendedIterator.next();
            if (!(resource instanceof DAMLRestriction) || (n = (propertyAccessor = (dAMLRestriction = (DAMLRestriction)resource).prop_onProperty()).count()) < 1) continue;
            RDFNode rDFNode = propertyAccessor.get();
            Object object = propertyAccessor.getAll().next();
            DAMLTest.assertNotNull((String)"Failed to access value of property accessor on restriction", (Object)rDFNode);
            DAMLTest.assertNotNull((String)"Failed to access value of property accessor on restriction", (Object)object);
        }
    }

    public void testModelAdd() {
        DAMLModel dAMLModel = ModelFactory.createDAMLModel();
        dAMLModel.read("file:testing/ontology/daml/test-add-0.daml");
        DAMLTest.assertTrue((String)"loadStatus should be true for successful load", (boolean)dAMLModel.getLoadSuccessful());
        Model model = ModelFactory.createDefaultModel();
        model.read("file:testing/ontology/daml/test-add-1.daml");
        DAMLTest.assertEquals((String)"Instance count in DAML model should be 0", (int)0, (int)this.countIteration(dAMLModel.listDAMLInstances(), true, "instance in test add"));
        dAMLModel.add(model);
        DAMLTest.assertEquals((String)"Instance count in DAML model should be 1", (int)1, (int)this.countIteration(dAMLModel.listDAMLInstances(), true, "instance in test add"));
    }

    public void testDatatypeProperty() {
        this.eqTest(new EqualityTest("DatatypeProperty"){

            String xml() {
                return "<daml:DatatypeProperty/>";
            }

            void java(DAMLModel dAMLModel) {
                dAMLModel.createDAMLDatatypeProperty(null);
            }
        });
    }

    public void testObjectProperty() {
        this.eqTest(new EqualityTest("ObjectProperty"){

            String xml() {
                return "<daml:ObjectProperty/>";
            }

            void java(DAMLModel dAMLModel) {
                dAMLModel.createDAMLObjectProperty(null);
            }
        });
    }

    public void testPropertyEq() {
        this.eqTest(new EqualityTest("Property"){

            String xml() {
                return "<daml:Property/>";
            }

            void java(DAMLModel dAMLModel) {
                dAMLModel.createDAMLProperty(null);
            }
        });
    }

    public void testDatatypeEq2() {
        this.eqTest(new EqualityTest("Datatype"){

            String xml() {
                return "<daml:Datatype rdf:about='http://www.w3.org/2000/10/XMLSchema#string'/>";
            }

            void java(DAMLModel dAMLModel) {
                dAMLModel.createDAMLDatatype("http://www.w3.org/2000/10/XMLSchema#string");
            }
        });
    }

    public void testDatatypeRange() {
        this.eqTest(new EqualityTest("Datatype Range"){

            String xml() {
                return "<daml:DatatypeProperty rdf:ID='shoesize'> <rdf:type rdf:resource='http://www.daml.org/2001/03/daml+oil#UniqueProperty'/> <daml:range rdf:resource='http://www.w3.org/2000/10/XMLSchema#decimal'/></daml:DatatypeProperty><daml:Datatype rdf:about='http://www.w3.org/2000/10/XMLSchema#decimal'/>";
            }

            void java(DAMLModel dAMLModel) {
                DAMLDatatypeProperty dAMLDatatypeProperty = dAMLModel.createDAMLDatatypeProperty("http://example.org/#shoesize");
                dAMLDatatypeProperty.setIsUnique(true);
                dAMLDatatypeProperty.prop_range().add(dAMLModel.createDAMLDatatype("http://www.w3.org/2000/10/XMLSchema#decimal"));
            }
        });
    }

    private void eqTest(EqualityTest equalityTest) {
        DAMLModel dAMLModel = ModelFactory.createDAMLModel();
        equalityTest.java(dAMLModel);
        Model model = ModelFactory.createDefaultModel();
        StringReader stringReader = new StringReader("<rdf:RDF xmlns:daml='http://www.daml.org/2001/03/daml+oil#' xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#'>" + equalityTest.xml() + "</rdf:RDF>");
        model.read(stringReader, "http://example.org/");
        if (!dAMLModel.getBaseModel().isIsomorphicWith(model)) {
            System.out.println("Java:");
            dAMLModel.write(System.out, "RDF/XML-ABBREV");
            System.out.println("XML:");
            model.write(System.out, "RDF/XML-ABBREV");
        }
        DAMLTest.assertTrue((String)"java code and xml should be equivalent", (boolean)dAMLModel.getBaseModel().isIsomorphicWith(model));
    }

    public void dumpModel(Model model) {
        this.dumpModel(model, "model-out.rdf");
    }

    public void dumpModel(Model model, String string) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            model.write(fileOutputStream, "RDF/XML-ABBREV");
            ((OutputStream)fileOutputStream).close();
        }
        catch (Exception exception) {
            LogFactory.getLog(((Object)((Object)this)).getClass()).debug((Object)("Exception while dumping model: " + exception), (Throwable)exception);
        }
    }

    private int countIteration(Iterator iterator, boolean bl, String string) {
        int n = 0;
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (bl) {
                LogFactory.getLog(((Object)((Object)this)).getClass()).debug((Object)("counting iteration, " + string + e));
            }
            ++n;
        }
        return n;
    }

    private int countClasses(DAMLModel dAMLModel) {
        return this.countIteration(dAMLModel.listDAMLClasses(), true, "class = ");
    }

    private int countProperties(DAMLModel dAMLModel) {
        return this.countIteration(dAMLModel.listDAMLProperties(), true, "property = ");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static abstract class EqualityTest {
        String name;

        EqualityTest(String string) {
            this.name = string;
        }

        public String toString() {
            return this.name;
        }

        abstract void java(DAMLModel var1);

        abstract String xml();
    }
}

