/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl.test;

import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.graph.TransactionHandler;
import com.hp.hpl.jena.graph.impl.SimpleTransactionHandler;
import com.hp.hpl.jena.mem.GraphMem;
import com.hp.hpl.jena.ontology.AllDifferent;
import com.hp.hpl.jena.ontology.DatatypeProperty;
import com.hp.hpl.jena.ontology.EnumeratedClass;
import com.hp.hpl.jena.ontology.HasValueRestriction;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.IntersectionClass;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntDocumentManager;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.ontology.Restriction;
import com.hp.hpl.jena.ontology.SomeValuesFromRestriction;
import com.hp.hpl.jena.ontology.daml.DAMLClass;
import com.hp.hpl.jena.ontology.daml.DAMLInstance;
import com.hp.hpl.jena.ontology.daml.DAMLModel;
import com.hp.hpl.jena.ontology.daml.DAMLProperty;
import com.hp.hpl.jena.ontology.daml.PropertyAccessor;
import com.hp.hpl.jena.ontology.impl.OntClassImpl;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFList;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerRegistry;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import junit.framework.TestCase;

public class TestBugReports
extends TestCase {
    public static String NS = "http://example.org/test#";
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$OntClass;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$Individual;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$Restriction;

    public TestBugReports(String string) {
        super(string);
    }

    public void setUp() {
        OntDocumentManager.getInstance().reset(true);
    }

    public void test_dn_0() {
        OntModel ontModel = ModelFactory.createOntologyModel(OntModelSpec.OWL_LITE_MEM_RULES_INF, null);
        ontModel.read("file:doc/inference/data/owlDemoSchema.xml", null);
        int n = 0;
        ExtendedIterator extendedIterator = ontModel.listIndividuals();
        while (extendedIterator.hasNext()) {
            extendedIterator.next();
            ++n;
        }
        TestBugReports.assertEquals((String)"Expecting 3 individuals", (int)6, (int)n);
    }

    public void test_mra_01() {
        OntModel ontModel = ModelFactory.createOntologyModel(OntModelSpec.DAML_MEM, null, null);
        String string = "http://somewhere/myDictionaries/1.0#";
        String string2 = "http://www.daml.org/2001/03/daml+oil#";
        ontModel.setNsPrefix("DAML", string2);
        String string3 = string + "C1";
        OntClass ontClass = ontModel.createClass(string3);
        DatatypeProperty datatypeProperty = ontModel.createDatatypeProperty(string + "P1");
        datatypeProperty.setDomain(ontClass);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ontModel.write(byteArrayOutputStream, "RDF/XML-ABBREV", string);
    }

    public void test_hk_01() {
        String string = "http://jena.hpl.hp.com/test#";
        String string2 = "<rdf:RDF   xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"   xmlns:owl=\"http://www.w3.org/2002/07/owl#\">  <owl:Ontology rdf:about=\"\">    <owl:imports rdf:resource=\"http://www.w3.org/2002/07/owl\" />  </owl:Ontology></rdf:RDF>";
        OntModel ontModel = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM, null);
        ontModel.getDocumentManager().setMetadataSearchPath("file:etc/ont-policy-test.rdf", true);
        ontModel.read(new ByteArrayInputStream(string2.getBytes()), string);
        Resource resource = ontModel.getResource(OWL.Class.getURI());
        OntClass ontClass = (OntClass)resource.as(class$com$hp$hpl$jena$ontology$OntClass == null ? (class$com$hp$hpl$jena$ontology$OntClass = TestBugReports.class$("com.hp.hpl.jena.ontology.OntClass")) : class$com$hp$hpl$jena$ontology$OntClass);
        TestBugReports.assertNotNull((String)"OntClass c should not be null", (Object)ontClass);
    }

    public void test_hk_02() {
        OntModelSpec ontModelSpec = new OntModelSpec(OntModelSpec.OWL_MEM);
        ontModelSpec.setReasoner(null);
        OntModel ontModel = ModelFactory.createOntologyModel(ontModelSpec, null);
        ontModel.createAllDifferent();
        TestBugReports.assertTrue((boolean)ontModel.listAllDifferent().hasNext());
        AllDifferent allDifferent = (AllDifferent)ontModel.listAllDifferent().next();
        TestBugReports.assertFalse((boolean)allDifferent.listDistinctMembers().hasNext());
    }

    public void test_hk_03() {
        OntModelSpec ontModelSpec = new OntModelSpec(OntModelSpec.OWL_MEM);
        ontModelSpec.setReasoner(null);
        OntModel ontModel = ModelFactory.createOntologyModel(ontModelSpec, null);
        ObjectProperty objectProperty = ontModel.createObjectProperty("http://www.aldi.de#property");
        ontModel.createMinCardinalityRestriction(null, objectProperty, 42);
    }

    public void test_hk_04() {
        OntModel ontModel = ModelFactory.createOntologyModel();
        ontModel.getDocumentManager().addAltEntry("http://jena.hpl.hp.com/testing/ontology/relativenames", "file:testing/ontology/relativenames.rdf");
        ontModel.read("http://jena.hpl.hp.com/testing/ontology/relativenames");
        TestBugReports.assertTrue((String)"#A should be a class", (boolean)ontModel.getResource("http://jena.hpl.hp.com/testing/ontology/relativenames#A").canAs(class$com$hp$hpl$jena$ontology$OntClass == null ? (class$com$hp$hpl$jena$ontology$OntClass = TestBugReports.class$("com.hp.hpl.jena.ontology.OntClass")) : class$com$hp$hpl$jena$ontology$OntClass));
        TestBugReports.assertFalse((String)"file: #A should not be a class", (boolean)ontModel.getResource("file:testing/ontology/relativenames.rdf#A").canAs(class$com$hp$hpl$jena$ontology$OntClass == null ? (class$com$hp$hpl$jena$ontology$OntClass = TestBugReports.class$("com.hp.hpl.jena.ontology.OntClass")) : class$com$hp$hpl$jena$ontology$OntClass));
    }

    public void test_hk_05() {
        OntModelSpec ontModelSpec = new OntModelSpec(OntModelSpec.OWL_MEM);
        ontModelSpec.setReasoner(null);
        OntModel ontModel = ModelFactory.createOntologyModel(ontModelSpec, null);
        String string = "http://foo.bar/fu#";
        OntClass ontClass = ontModel.createClass(string + "A");
        OntClass ontClass2 = ontModel.createClass(string + "B");
        int n = this.getStatementCount(ontModel);
        RDFList rDFList = ontModel.createList(new RDFNode[]{ontClass, ontClass2});
        IntersectionClass intersectionClass = ontModel.createIntersectionClass(null, rDFList);
        intersectionClass.remove();
        TestBugReports.assertEquals((String)"Before and after statement counts are different", (int)n, (int)this.getStatementCount(ontModel));
    }

    public void test_hk_06() throws Exception {
        OntModel ontModel = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM, null);
        ontModel.read("file:testing/ontology/bugs/test_hk_06/a.owl");
        String string = "http://jena.hpl.hp.com/2003/03/testont/a#";
        String string2 = "http://jena.hpl.hp.com/2003/03/testont/b#";
        OntClass ontClass = ontModel.getOntClass(string + "A");
        TestBugReports.assertTrue((String)"class A should be in the base model", (boolean)ontModel.isInBaseModel(ontClass));
        OntClass ontClass2 = ontModel.getOntClass(string2 + "B");
        TestBugReports.assertFalse((String)"class B should not be in the base model", (boolean)ontModel.isInBaseModel(ontClass2));
        TestBugReports.assertTrue((String)"A rdf:type owl:Class should be in the base model", (boolean)ontModel.isInBaseModel(ontModel.createStatement((Resource)ontClass, RDF.type, OWL.Class)));
        TestBugReports.assertFalse((String)"B rdf:type owl:Class should not be in the base model", (boolean)ontModel.isInBaseModel(ontModel.createStatement((Resource)ontClass2, RDF.type, OWL.Class)));
    }

    public void test_fc_01() {
        OntModel ontModel = ModelFactory.createOntologyModel();
        ObjectProperty objectProperty = ontModel.createObjectProperty(NS + "p");
        Restriction restriction = ontModel.createRestriction(objectProperty);
        HasValueRestriction hasValueRestriction = restriction.convertToHasValueRestriction(ontModel.createLiteral(1L));
        RDFNode rDFNode = hasValueRestriction.getHasValue();
        TestBugReports.assertFalse((String)"Should not be able to convert literal to individual", (boolean)rDFNode.canAs(class$com$hp$hpl$jena$ontology$Individual == null ? (class$com$hp$hpl$jena$ontology$Individual = TestBugReports.class$("com.hp.hpl.jena.ontology.Individual")) : class$com$hp$hpl$jena$ontology$Individual));
    }

    public void test_ck_01() {
        GraphMem graphMem = new GraphMem(){
            TransactionHandler m_t;
            {
                this.m_t = new MockTransactionHandler();
            }

            public TransactionHandler getTransactionHandler() {
                return this.m_t;
            }
        };
        Model model = ModelFactory.createModelForGraph(graphMem);
        OntModel ontModel = ModelFactory.createOntologyModel(OntModelSpec.OWL_LITE_MEM, model);
        TestBugReports.assertFalse((String)"Transaction not started yet", (boolean)((MockTransactionHandler)ontModel.getGraph().getTransactionHandler()).m_inTransaction);
        ontModel.begin();
        TestBugReports.assertTrue((String)"Transaction started", (boolean)((MockTransactionHandler)ontModel.getGraph().getTransactionHandler()).m_inTransaction);
        ontModel.abort();
        TestBugReports.assertFalse((String)"Transaction aborted", (boolean)((MockTransactionHandler)ontModel.getGraph().getTransactionHandler()).m_inTransaction);
        TestBugReports.assertTrue((String)"Transaction aborted", (boolean)((MockTransactionHandler)ontModel.getGraph().getTransactionHandler()).m_aborted);
        ontModel.begin();
        TestBugReports.assertTrue((String)"Transaction started", (boolean)((MockTransactionHandler)ontModel.getGraph().getTransactionHandler()).m_inTransaction);
        ontModel.commit();
        TestBugReports.assertFalse((String)"Transaction committed", (boolean)((MockTransactionHandler)ontModel.getGraph().getTransactionHandler()).m_inTransaction);
        TestBugReports.assertTrue((String)"Transaction committed", (boolean)((MockTransactionHandler)ontModel.getGraph().getTransactionHandler()).m_committed);
    }

    public void test_ck_02() {
        OntModel ontModel = ModelFactory.createOntologyModel();
        ObjectProperty objectProperty = ontModel.createObjectProperty("p");
        OntClass ontClass = ontModel.createClass("A");
        OntModel ontModel2 = ModelFactory.createOntologyModel();
        Individual individual = ontModel2.createIndividual("uri1", ontClass);
        Individual individual2 = ontModel2.createIndividual("uri2", ontClass);
        ontModel2.createStatement((Resource)individual, (Property)objectProperty, individual2);
    }

    public void test_ck_03() {
        OntModel ontModel = ModelFactory.createOntologyModel(OntModelSpec.DAML_MEM, null);
        OntModel ontModel2 = ModelFactory.createOntologyModel(OntModelSpec.DAML_MEM_RULE_INF, null);
        Individual individual = ontModel.createIndividual("http://mytest#i1", ontModel.getProfile().CLASS());
        OntProperty ontProperty = ontModel.createOntProperty("http://mytest#");
        Individual individual2 = ontModel.createIndividual("http://mytest#i2", ontModel.getProfile().CLASS());
        OntProperty ontProperty2 = ontModel.createOntProperty("http://mytest#prob");
        Statement statement = ontModel.createStatement((Resource)individual, (Property)ontProperty, individual2);
        ontModel.add(statement);
        statement.createReifiedStatement().addProperty((Property)ontProperty2, 0.9);
        TestBugReports.assertTrue((String)"st should be reified", (boolean)statement.isReified());
        Statement statement2 = ontModel2.createStatement((Resource)individual, (Property)ontProperty, individual2);
        ontModel2.add(statement2);
        statement2.createReifiedStatement().addProperty((Property)ontProperty2, 0.3);
        TestBugReports.assertTrue((String)"st2 should be reified", (boolean)statement2.isReified());
        individual.addProperty((Property)ontProperty2, 0.3);
        individual.removeAll(ontProperty2).addProperty((Property)ontProperty2, 0.3);
        Individual individual3 = ontModel2.createIndividual("http://mytest#i1", ontModel.getProfile().CLASS());
        individual.addProperty((Property)ontProperty2, 0.3);
        individual.removeAll(ontProperty2);
        individual3.addProperty((Property)ontProperty2, 0.3);
        individual3.removeAll(ontProperty2);
    }

    public void test_sjooseng_01() {
        String string = "<rdf:RDF xmlns:daml='http://www.daml.org/2001/03/daml+oil#'    xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#'    xmlns:rdfs='http://www.w3.org/2000/01/rdf-schema#' >    <daml:Class rdf:about='http://localhost:8080/kc2c#C1'>        <daml:subClassOf>            <daml:Restriction>                <daml:onProperty rdf:resource='http://localhost:8080/kc2c#p1'/>                <daml:hasClass>                    <daml:Class>                        <daml:oneOf rdf:parseType=\"daml:collection\">                            <daml:Thing rdf:about='http://localhost:8080/kc2c#i1'/>                            <daml:Thing rdf:about='http://localhost:8080/kc2c#i2'/>                        </daml:oneOf>                    </daml:Class>                </daml:hasClass>            </daml:Restriction>        </daml:subClassOf>    </daml:Class>    <daml:ObjectProperty rdf:about='http://localhost:8080/kc2c#p1'>        <rdfs:label>p1</rdfs:label>    </daml:ObjectProperty></rdf:RDF>";
        OntModel ontModel = ModelFactory.createOntologyModel("http://www.daml.org/2001/03/daml+oil#");
        ontModel.read(new ByteArrayInputStream(string.getBytes()), "http://localhost:8080/kc2c");
        OntClass ontClass = ontModel.getOntClass("http://localhost:8080/kc2c#C1");
        boolean bl = false;
        ExtendedIterator extendedIterator = ontClass.listSuperClasses(false);
        while (extendedIterator.hasNext()) {
            SomeValuesFromRestriction someValuesFromRestriction;
            OntClass ontClass2;
            Restriction restriction;
            OntClass ontClass3 = (OntClass)extendedIterator.next();
            if (!ontClass3.isRestriction() || !(restriction = ontClass3.asRestriction()).isSomeValuesFromRestriction() || !(ontClass2 = (OntClass)(someValuesFromRestriction = restriction.asSomeValuesFromRestriction()).getSomeValuesFrom()).isEnumeratedClass()) continue;
            EnumeratedClass enumeratedClass = ontClass2.asEnumeratedClass();
            TestBugReports.assertEquals((String)"Enumeration size should be 2", (int)2, (int)enumeratedClass.getOneOf().size());
            bl = true;
        }
        TestBugReports.assertTrue((boolean)bl);
    }

    public void test_afs_01() {
        String string = "<rdf:RDF     xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#'    xmlns:rdfs='http://www.w3.org/2000/01/rdf-schema#'   xmlns:owl=\"http://www.w3.org/2002/07/owl#\">    <owl:Class rdf:about='http://example.org/foo#A'>   </owl:Class></rdf:RDF>";
        String string2 = "<rdf:RDF     xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#'    xmlns:rdfs='http://www.w3.org/2000/01/rdf-schema#'    xmlns:owl=\"http://www.w3.org/2002/07/owl#\">    <rdf:Description rdf:about='http://example.org/foo#x'>    <rdf:type rdf:resource='http://example.org/foo#A' />   </rdf:Description></rdf:RDF>";
        Model model = ModelFactory.createDefaultModel();
        model.read(new ByteArrayInputStream(string.getBytes()), "http://example.org/foo");
        Model model2 = ModelFactory.createDefaultModel();
        model2.read(new ByteArrayInputStream(string2.getBytes()), "http://example.org/foo");
        Reasoner reasoner = ReasonerRegistry.getOWLReasoner();
        reasoner = reasoner.bindSchema(model);
        OntModelSpec ontModelSpec = new OntModelSpec(OntModelSpec.OWL_MEM_RULE_INF);
        ontModelSpec.setReasoner(reasoner);
        OntModel ontModel = ModelFactory.createOntologyModel(ontModelSpec, model2);
        ArrayList arrayList = new ArrayList();
        ExtendedIterator extendedIterator = ontModel.listIndividuals();
        while (extendedIterator.hasNext()) {
            arrayList.add(extendedIterator.next());
        }
        TestBugReports.assertTrue((String)"x should be an individual", (boolean)arrayList.contains(ontModel.getResource("http://example.org/foo#x")));
    }

    public void test_to_01() {
        String string = "<rdf:RDF     xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#'    xmlns:rdfs='http://www.w3.org/2000/01/rdf-schema#'    xmlns:daml='http://www.daml.org/2001/03/daml+oil#'>  <daml:Class rdf:about='http://example.org/foo#A'>    <daml:intersectionOf rdf:parseType=\"daml:collection\">       <daml:Class rdf:ID=\"B\" />       <daml:Class rdf:ID=\"C\" />    </daml:intersectionOf>  </daml:Class></rdf:RDF>";
        OntModel ontModel = ModelFactory.createOntologyModel(OntModelSpec.DAML_MEM, null);
        ontModel.read(new ByteArrayInputStream(string.getBytes()), "http://example.org/foo");
        OntClass ontClass = ontModel.getOntClass("http://example.org/foo#A");
        TestBugReports.assertNotNull((Object)ontClass);
        IntersectionClass intersectionClass = ontClass.asIntersectionClass();
        TestBugReports.assertNotNull((Object)intersectionClass);
        RDFList rDFList = intersectionClass.getOperands();
        TestBugReports.assertNotNull((Object)rDFList);
        TestBugReports.assertEquals((int)2, (int)rDFList.size());
        TestBugReports.assertTrue((boolean)rDFList.contains(ontModel.getOntClass("http://example.org/foo#B")));
        TestBugReports.assertTrue((boolean)rDFList.contains(ontModel.getOntClass("http://example.org/foo#C")));
    }

    public void test_tl_01() {
        Resource resource;
        String string = "<rdf:RDF     xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#'    xmlns:rdfs='http://www.w3.org/2000/01/rdf-schema#'    xmlns:owl=\"http://www.w3.org/2002/07/owl#\">   <owl:SymmetricProperty rdf:about='http://example.org/foo#p1'>   </owl:SymmetricProperty>   <owl:TransitiveProperty rdf:about='http://example.org/foo#p2'>   </owl:TransitiveProperty>   <owl:InverseFunctionalProperty rdf:about='http://example.org/foo#p3'>   </owl:InverseFunctionalProperty></rdf:RDF>";
        OntModel ontModel = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM_RULE_INF, null);
        ontModel.read(new ByteArrayInputStream(string.getBytes()), "http://example.org/foo");
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        ExtendedIterator extendedIterator = ontModel.listOntProperties();
        while (extendedIterator.hasNext()) {
            resource = (Resource)extendedIterator.next();
            bl = bl || resource.getURI().equals("http://example.org/foo#p1");
            bl2 = bl2 || resource.getURI().equals("http://example.org/foo#p2");
            bl3 = bl3 || resource.getURI().equals("http://example.org/foo#p3");
        }
        TestBugReports.assertTrue((String)"p1 not listed", (boolean)bl);
        TestBugReports.assertTrue((String)"p2 not listed", (boolean)bl2);
        TestBugReports.assertTrue((String)"p3 not listed", (boolean)bl3);
        bl = false;
        bl2 = false;
        bl3 = false;
        extendedIterator = ontModel.listObjectProperties();
        while (extendedIterator.hasNext()) {
            resource = (Resource)extendedIterator.next();
            bl = bl || resource.getURI().equals("http://example.org/foo#p1");
            bl2 = bl2 || resource.getURI().equals("http://example.org/foo#p2");
            bl3 = bl3 || resource.getURI().equals("http://example.org/foo#p3");
        }
        TestBugReports.assertTrue((String)"p1 not listed", (boolean)bl);
        TestBugReports.assertTrue((String)"p2 not listed", (boolean)bl2);
        TestBugReports.assertTrue((String)"p3 not listed", (boolean)bl3);
    }

    public void test_der_01() {
        OntModel ontModel = ModelFactory.createOntologyModel(OntModelSpec.RDFS_MEM_TRANS_INF, null);
        Resource resource = ontModel.createResource("http://example.org#A");
        Resource resource2 = ontModel.createResource("http://example.org#B");
        OntClassImpl ontClassImpl = new OntClassImpl(resource.getNode(), (EnhGraph)((Object)ontModel)){

            protected boolean hasSuperClassDirect(Resource resource) {
                throw new RuntimeException("did not find direct reasoner");
            }
        };
        ontClassImpl.hasSuperClass(resource2, true);
    }

    public void test_if_01() {
        OntModel ontModel = ModelFactory.createOntologyModel();
        ontModel.getDocumentManager().addAltEntry("http://www.w3.org/2001/sw/WebOnt/guide-src/wine", "file:testing/reasoners/bugs/wine.owl");
        ontModel.getDocumentManager().addAltEntry("http://www.w3.org/2001/sw/WebOnt/guide-src/food", "file:testing/reasoners/bugs/food.owl");
        ontModel.getDocumentManager().setProcessImports(false);
        ontModel.read("http://www.w3.org/2001/sw/WebOnt/guide-src/wine");
        ontModel.getDocumentManager().setProcessImports(true);
        ontModel.getDocumentManager().loadImport(ontModel, "http://www.w3.org/2001/sw/WebOnt/guide-src/food");
        OntClass ontClass = ontModel.getOntClass("http://www.w3.org/2001/sw/WebOnt/guide-src/wine#Wine");
        int n = 0;
        int n2 = 0;
        int n4 = 0;
        ExtendedIterator extendedIterator = ontClass.listSuperClasses(true);
        while (extendedIterator.hasNext()) {
            OntClass ontClass2 = (OntClass)extendedIterator.next();
            if (!ontClass2.isAnon()) {
                ++n;
                continue;
            }
            if (ontClass2.canAs(class$com$hp$hpl$jena$ontology$Restriction == null ? TestBugReports.class$("com.hp.hpl.jena.ontology.Restriction") : class$com$hp$hpl$jena$ontology$Restriction)) {
                ontClass2.asRestriction();
                ++n2;
                continue;
            }
            ++n4;
        }
        TestBugReports.assertEquals((String)"Should be two named super classes ", (int)2, (int)n);
        TestBugReports.assertEquals((String)"Should be nine named super classes ", (int)9, (int)n2);
        TestBugReports.assertEquals((String)"Should be no named super classes ", (int)0, (int)n4);
    }

    public void test_lt_01() {
        OntModel ontModel = ModelFactory.createOntologyModel();
        DatatypeProperty datatypeProperty = ontModel.createDatatypeProperty(NS + "p");
        OntClass ontClass = ontModel.createClass(NS + "A");
        Individual individual = ontModel.createIndividual(NS + "i", ontClass);
        individual.addProperty((Property)datatypeProperty, "testData");
        int n = 0;
        NodeIterator nodeIterator = individual.listPropertyValues(datatypeProperty);
        while (nodeIterator.hasNext()) {
            nodeIterator.next();
            ++n;
        }
        TestBugReports.assertEquals((String)"i should have one property", (int)1, (int)n);
    }

    public void test_dk_01() {
        OntModel ontModel = ModelFactory.createOntologyModel();
        ontModel.read("file:testing/ontology/bugs/test_dk_01.xml");
        String string = "http://localhost:8080/Repository/QueryAgent/UserOntology/qgen-example-1#";
        String[] stringArray = new String[]{string + "C1", string + "C3", string + "C2"};
        for (int i = 0; i < stringArray.length; ++i) {
            OntClass ontClass = ontModel.getOntClass(stringArray[i]);
            ExtendedIterator extendedIterator = ontClass.listDeclaredProperties();
            while (extendedIterator.hasNext()) {
                extendedIterator.next();
            }
        }
    }

    public void test_ppds_01() {
        DAMLModel dAMLModel = ModelFactory.createDAMLModel();
        DAMLClass dAMLClass = dAMLModel.createDAMLClass(NS + "C");
        DAMLInstance dAMLInstance = dAMLModel.createDAMLInstance(dAMLClass, NS + "x");
        DAMLProperty dAMLProperty = dAMLModel.createDAMLProperty(NS + "p");
        dAMLInstance.addProperty((Property)dAMLProperty, "(s (s 0))");
        PropertyAccessor propertyAccessor = dAMLInstance.accessProperty(dAMLProperty);
        TestBugReports.assertNull((String)"Property accessor value should be null", (Object)propertyAccessor.getDAMLValue());
    }

    public void test_anon_0() {
        String string = "http://example.org/foo#";
        String string2 = "<rdf:RDF     xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#'    xmlns:rdfs='http://www.w3.org/2000/01/rdf-schema#'    xmlns:ex='http://example.org/foo#'    xmlns:owl='http://www.w3.org/2002/07/owl#'>   <owl:ObjectProperty rdf:about='http://example.org/foo#p' />   <owl:Class rdf:about='http://example.org/foo#A' />   <ex:A rdf:about='http://example.org/foo#x' />   <owl:Class rdf:about='http://example.org/foo#B'>     <owl:equivalentClass>      <owl:Restriction>        <owl:onProperty rdf:resource='http://example.org/foo#p' />        <owl:hasValue rdf:resource='http://example.org/foo#x' />      </owl:Restriction>     </owl:equivalentClass>   </owl:Class></rdf:RDF>";
        OntModel ontModel = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM, null);
        ontModel.read(new ByteArrayInputStream(string2.getBytes()), "http://example.org/foo");
        OntClass ontClass = ontModel.getOntClass(string + "B");
        Restriction restriction = ontClass.getEquivalentClass().asRestriction();
        HasValueRestriction hasValueRestriction = restriction.asHasValueRestriction();
        RDFNode rDFNode = hasValueRestriction.getHasValue();
        TestBugReports.assertTrue((String)"Should be an individual", (boolean)(rDFNode instanceof Individual));
    }

    private int getStatementCount(OntModel ontModel) {
        int n = 0;
        StmtIterator stmtIterator = ontModel.listStatements();
        while (stmtIterator.hasNext()) {
            ++n;
            stmtIterator.next();
        }
        return n;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class MockTransactionHandler
    extends SimpleTransactionHandler {
        boolean m_inTransaction = false;
        boolean m_aborted = false;
        boolean m_committed = false;

        MockTransactionHandler() {
        }

        public void begin() {
            this.m_inTransaction = true;
        }

        public void abort() {
            this.m_inTransaction = false;
            this.m_aborted = true;
        }

        public void commit() {
            this.m_inTransaction = false;
            this.m_committed = true;
        }
    }
}

