/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.tidy.test;

import com.hp.hpl.jena.ontology.tidy.test.SyntaxTest;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdql.Query;
import com.hp.hpl.jena.rdql.QueryEngine;
import com.hp.hpl.jena.rdql.QueryResults;
import com.hp.hpl.jena.rdql.ResultBinding;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.wg.TestInputStreamFactory;
import com.hp.hpl.jena.shared.wg.URI;
import com.hp.hpl.jena.vocabulary.OWLResults;
import com.hp.hpl.jena.vocabulary.OWLTest;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class WGTests {
    public static boolean internet = false;
    private static URI wgTestDir = URI.create("http://www.w3.org/2002/03owlt/");
    private static String BASE_RESULTS_URI = "http://jena.sourceforge.net/data/owl-syntax-results.rdf";
    private static boolean logging = false;
    private static TestInputStreamFactory factory;
    private static String[] skipThese;
    static boolean doLargeTests;
    private static String manifestURI;
    private static boolean manifestInFactory;
    private static Model testResults;
    private static Resource jena2;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$tidy$test$WGTests;

    public static Test suite() {
        QueryResults queryResults;
        InputStream inputStream;
        TestSuite testSuite = new TestSuite("OWL-Syntax");
        if (factory == null) {
            factory = internet ? new TestInputStreamFactory(wgTestDir, wgTestDir) : new TestInputStreamFactory(wgTestDir, "wg");
        }
        if (manifestInFactory) {
            inputStream = factory.open(manifestURI);
        } else {
            try {
                try {
                    inputStream = new URL(manifestURI).openStream();
                }
                catch (MalformedURLException malformedURLException) {
                    inputStream = new FileInputStream(manifestURI);
                }
            }
            catch (IOException iOException) {
                throw new JenaException(iOException);
            }
        }
        Model model = ModelFactory.createDefaultModel();
        model.read(inputStream, "");
        Query query = new Query("SELECT ?s, ?t, ?f, ?l WHERE (?f rdf:type  <http://www.w3.org/2000/10/rdf-tests/rdfcore/testSchema#RDF-XML-Document> ) (?t ?p ?f )  (?t rtest:status ?s)  (?f otest:level ?l ) AND ?s ne \"OBSOLETED\"USING rtest FOR <http://www.w3.org/2000/10/rdf-tests/rdfcore/testSchema#> otest FOR <http://www.w3.org/2002/03owlt/testOntology#>");
        query.setSource(model);
        QueryEngine queryEngine = new QueryEngine(query);
        QueryResults queryResults2 = queryResults = queryEngine.exec();
        while (queryResults2.hasNext()) {
            ResultBinding resultBinding = (ResultBinding)queryResults2.next();
            WGTests.addTest(testSuite, resultBinding, model);
        }
        queryResults.close();
        testSuite.addTest((Test)new DummyTest());
        return testSuite;
    }

    private static void addTest(TestSuite testSuite, ResultBinding resultBinding, Model model) {
        Object object = resultBinding.get("s");
        Resource resource = (Resource)resultBinding.get("t");
        Object object2 = resultBinding.get("f");
        Object object3 = resultBinding.get("l");
        String string = resource.getURI();
        for (int i = 0; i < skipThese.length; ++i) {
            if (!string.equals(skipThese[i])) continue;
            return;
        }
        if (!doLargeTests && resource.hasProperty(OWLTest.size, OWLTest.Large)) {
            return;
        }
        TestSuite testSuite2 = (TestSuite)WGTests.getTest(testSuite, ((Literal)object).getLexicalForm(), null);
        int n = string.lastIndexOf(47);
        int n2 = string.lastIndexOf(47, n - 1);
        int n4 = string.lastIndexOf(35);
        String string2 = string.substring(n2 + 1, n);
        TestSuite testSuite3 = (TestSuite)WGTests.getTest(testSuite2, string2, null);
        String string3 = string.substring(n4 - 3, n4);
        SyntaxTest syntaxTest = (SyntaxTest)WGTests.getTest(testSuite3, string3, string);
        String string4 = ((Resource)object2).getURI();
        syntaxTest.add(factory.open(string4), (Resource)object3, string4);
    }

    private static Test getTest(TestSuite testSuite, String string, String string2) {
        Object object;
        Enumeration enumeration = testSuite.tests();
        while (enumeration.hasMoreElements()) {
            object = (Test)enumeration.nextElement();
            if (!(string2 != null ? ((SyntaxTest)((Object)object)).getName() : ((TestSuite)object).getName()).equals(string)) continue;
            return object;
        }
        object = string2 == null ? new TestSuite(string) : new SyntaxTest(string, factory, string2);
        testSuite.addTest(object);
        return object;
    }

    private static void initResults() {
        logging = true;
        testResults = ModelFactory.createDefaultModel();
        jena2 = testResults.createResource(BASE_RESULTS_URI + "#jena2");
        jena2.addProperty(RDFS.comment, testResults.createLiteral("<a xmlns=\"http://www.w3.org/1999/xhtml\" href=\"http://jena.sourceforce.net/\">Jena2</a> includes an  OWL Syntax Checker. This does not produce an abstract syntax tree, but  instead merely recognises the RDF graph as OWL Lite, OWL DL or OWL Full  according to the grammar. The tested version is the developers version available from <a xmlns=\"http://www.w3.org/1999/xhtml\" href=\"http://www.sourceforce.net/projects/jena\">sourceforge</a> CVS.", true));
        jena2.addProperty(RDFS.label, "Jena2 (Syntax)");
        testResults.setNsPrefix("results", "http://www.w3.org/2002/03owlt/resultsOntology#");
    }

    static void logResult(String string, boolean bl) {
        if (!logging) {
            return;
        }
        Resource resource = testResults.createResource().addProperty(OWLResults.syntacticLevelTestFrom, testResults.createResource(string));
        Resource resource2 = testResults.createResource().addProperty(RDF.type, OWLResults.TestRun).addProperty(RDF.type, bl ? OWLResults.PassingRun : OWLResults.FailingRun).addProperty(OWLResults.test, resource).addProperty(OWLResults.system, jena2);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 1 && stringArray[0].equals("--editors-draft")) {
            manifestURI = "http://www.w3.org/2002/03owlt/editors-draft/draft/Manifest.rdf";
            manifestInFactory = false;
            factory = new TestInputStreamFactory(wgTestDir, URI.create("http://www.w3.org/2002/03owlt/."));
        } else {
            manifestURI = "file://localhost/home/jjc/WWW/2002/03owlt/editors-draft/draft/Manifest.rdf";
            manifestInFactory = false;
            factory = new TestInputStreamFactory(wgTestDir, URI.create("file://localhost/home/jjc/WWW/2002/03owlt/."));
        }
        doLargeTests = true;
        skipThese = new String[0];
        WGTests.initResults();
        junit.swingui.TestRunner.main((String[])new String[]{"-noloading", (class$com$hp$hpl$jena$ontology$tidy$test$WGTests == null ? (class$com$hp$hpl$jena$ontology$tidy$test$WGTests = WGTests.class$("com.hp.hpl.jena.ontology.tidy.test.WGTests")) : class$com$hp$hpl$jena$ontology$tidy$test$WGTests).getName()});
    }

    public static void test(boolean bl, String string) {
        internet = true;
        manifestInFactory = string.equals("file:testing/wg/OWLManifest.rdf");
        manifestURI = string;
        if (!bl) {
            junit.swingui.TestRunner.main((String[])new String[]{"-noloading", (class$com$hp$hpl$jena$ontology$tidy$test$WGTests == null ? (class$com$hp$hpl$jena$ontology$tidy$test$WGTests = WGTests.class$("com.hp.hpl.jena.ontology.tidy.test.WGTests")) : class$com$hp$hpl$jena$ontology$tidy$test$WGTests).getName()});
        } else {
            TestRunner.main((String[])new String[]{"-noloading", (class$com$hp$hpl$jena$ontology$tidy$test$WGTests == null ? (class$com$hp$hpl$jena$ontology$tidy$test$WGTests = WGTests.class$("com.hp.hpl.jena.ontology.tidy.test.WGTests")) : class$com$hp$hpl$jena$ontology$tidy$test$WGTests).getName()});
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        skipThese = new String[]{"http://www.w3.org/2002/03owlt/I5.8/Manifest016#test"};
        doLargeTests = false;
        manifestURI = "OWLManifest.rdf";
        manifestInFactory = true;
    }

    private static class DummyTest
    extends TestCase {
        DummyTest() {
            super("save results");
        }

        public void runTest() throws IOException {
            if (logging) {
                RDFWriter rDFWriter = testResults.getWriter("RDF/XML-ABBREV");
                rDFWriter.setProperty("xmlbase", BASE_RESULTS_URI);
                FileOutputStream fileOutputStream = new FileOutputStream("/tmp/owl-syntax-results.rdf");
                rDFWriter.write(testResults, fileOutputStream, BASE_RESULTS_URI);
                ((OutputStream)fileOutputStream).close();
            }
        }
    }
}

