/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.arp;

import com.hp.hpl.jena.rdf.arp.ALiteral;
import com.hp.hpl.jena.rdf.arp.ARP;
import com.hp.hpl.jena.rdf.arp.ARPErrorNumbers;
import com.hp.hpl.jena.rdf.arp.ARPHandler;
import com.hp.hpl.jena.rdf.arp.AResource;
import com.hp.hpl.jena.rdf.arp.ParseException;
import com.hp.hpl.jena.rdf.arp.StatementHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class NTriple
implements ARPErrorNumbers {
    private static StringBuffer line = new StringBuffer();
    private static ARP arp;
    private static String xmlBase;
    private static boolean numbers;
    static StatementHandler andMeToo;
    private static final Runtime rt;
    private static int startMem;
    private static boolean[] okURIChars;
    static /* synthetic */ Class class$com$hp$hpl$jena$rdf$arp$NTriple;

    public static void main(String[] stringArray) {
        NTriple.mainEh(stringArray, null, null);
    }

    public static void mainEh(String[] stringArray, ErrorHandler errorHandler, ARPHandler aRPHandler) {
        int n;
        boolean bl = false;
        startMem = -1;
        andMeToo = aRPHandler;
        arp = new ARP();
        arp.setStatementHandler(NTriple.getSH(true));
        if (aRPHandler != null) {
            arp.setNamespaceHandler(aRPHandler);
            arp.setExtendedHandler(aRPHandler);
        }
        if (errorHandler != null) {
            arp.setErrorHandler(errorHandler);
        }
        for (n = 0; n < stringArray.length - 1; ++n) {
            if (stringArray[n].startsWith("-")) {
                n += NTriple.processOpts(stringArray[n].substring(1), stringArray[n + 1]);
                continue;
            }
            bl = true;
            NTriple.process(stringArray[n]);
        }
        if (stringArray.length > 0) {
            if (stringArray[n].startsWith("-")) {
                if (bl || NTriple.processOpts(stringArray[n].substring(1), "100") == 1) {
                    NTriple.usage();
                }
            } else {
                bl = true;
                NTriple.process(stringArray[n]);
            }
        }
        if (!bl) {
            NTriple.process(System.in, "http://example.org/stdin", "standard input");
        }
        if (startMem != -1) {
            rt.gc();
            System.out.println(rt.totalMemory() - rt.freeMemory() - (long)startMem);
            rt.gc();
            System.out.println(rt.totalMemory() - rt.freeMemory() - (long)startMem);
            rt.gc();
            System.out.println(rt.totalMemory() - rt.freeMemory() - (long)startMem);
            rt.gc();
            System.out.println(rt.totalMemory() - rt.freeMemory() - (long)startMem);
        }
    }

    private static StatementHandler getSH(boolean bl) {
        StatementHandler statementHandler;
        StatementHandler statementHandler2 = statementHandler = bl ? new SH() : new NoSH();
        if (andMeToo != null) {
            statementHandler = new TwoSH(statementHandler, andMeToo);
        }
        return statementHandler;
    }

    private static void lineNumber() {
        Locator locator;
        if (numbers && (locator = arp.getLocator()) != null) {
            NTriple.print("# " + locator.getSystemId() + ":" + locator.getLineNumber() + "(" + locator.getColumnNumber() + ")\n");
        }
    }

    static void usage() {
        System.err.println("java <class-path> " + (class$com$hp$hpl$jena$rdf$arp$NTriple == null ? (class$com$hp$hpl$jena$rdf$arp$NTriple = NTriple.class$("com.hp.hpl.jena.rdf.arp.NTriple")) : class$com$hp$hpl$jena$rdf$arp$NTriple).getName() + " ( [ -[xstfu]][ -b xmlBase -[eiw] NNN[,NNN...] ] [ file ] [ url ] )... ");
        System.err.println("    All options, files and URLs can be intemingled in any order.");
        System.err.println("    They are processed from left-to-right.");
        System.err.println("    file      Converts (embedded) RDF in XML file into N-triples");
        System.err.println("    url       Converts (embedded) RDF from URL into N-triples");
        System.err.println("    -b uri    Sets XML Base to the absolute URI.");
        System.err.println("    -r        Content is RDF (no embedding, rdf:RDF tag may be omitted).");
        System.err.println("    -t        No n-triple output, error checking only.");
        System.err.println("    -x        Lax mode - warnings are suppressed.");
        System.err.println("    -s        Strict mode - most warnings are errors.");
        System.err.println("    -n        Show line and column numbers.");
        System.err.println("    -u        Allow unqualified attributes (defaults to warning).");
        System.err.println("    -f        All errors are fatal - report first one only.");
        System.err.println("    -b url    Sets XML Base to the absolute url.");
        System.err.println("    -e NNN[,NNN...]");
        System.err.println("              Treats numbered warning conditions as errrors.");
        System.err.println("    -w NNN[,NNN...]");
        System.err.println("              Treats numbered error conditions as warnings.");
        System.err.println("    -i NNN[,NNN...]");
        System.err.println("              Ignores numbered error/warning conditions.");
        System.exit(1);
    }

    private static int processOpts(String string, String string2) {
        boolean bl = false;
        block14: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if ("beiw".indexOf(c) != -1) {
                if (bl) {
                    NTriple.usage();
                }
                bl = true;
            }
            switch (c) {
                case 'D': {
                    rt.gc();
                    rt.gc();
                    startMem = (int)(rt.totalMemory() - rt.freeMemory());
                    arp.setStatementHandler(new StatementHandler(){
                        int debugC = 0;

                        public void statement(AResource aResource, AResource aResource2, AResource aResource3) {
                            this.statement(null, null, (ALiteral)null);
                        }

                        public void statement(AResource aResource, AResource aResource2, ALiteral aLiteral) {
                            if (++this.debugC % 100 == 0) {
                                System.out.println(this.debugC);
                                rt.gc();
                                System.out.println(rt.totalMemory() - rt.freeMemory() - (long)startMem);
                                rt.gc();
                                System.out.println(rt.totalMemory() - rt.freeMemory() - (long)startMem);
                                if (this.debugC == 500) {
                                    // empty if block
                                }
                            }
                        }
                    });
                    continue block14;
                }
                case 'x': {
                    arp.setLaxErrorMode();
                    continue block14;
                }
                case 's': {
                    arp.setStrictErrorMode();
                    continue block14;
                }
                case 't': {
                    arp.setStatementHandler(NTriple.getSH(false));
                    continue block14;
                }
                case 'r': {
                    arp.setEmbedding(false);
                    continue block14;
                }
                case 'n': {
                    numbers = true;
                    continue block14;
                }
                case 'b': {
                    xmlBase = string2;
                    continue block14;
                }
                case 'e': {
                    NTriple.setErrorMode(string2, 2);
                    continue block14;
                }
                case 'i': {
                    NTriple.setErrorMode(string2, 0);
                    continue block14;
                }
                case 'w': {
                    NTriple.setErrorMode(string2, 1);
                    continue block14;
                }
                case 'f': {
                    for (int j = 0; j < 400; ++j) {
                        if (arp.setErrorMode(j, -1) != 2) continue;
                        arp.setErrorMode(j, 3);
                    }
                    continue block14;
                }
                case 'u': {
                    arp.setErrorMode(102, 0);
                    arp.setErrorMode(101, 0);
                    continue block14;
                }
                default: {
                    NTriple.usage();
                }
            }
        }
        return bl ? 1 : 0;
    }

    private static void setErrorMode(String string, int n) {
        int[] nArray = new int[3];
        int n2 = 0;
        string = string + ",";
        block8: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    if (n2 == 3) {
                        NTriple.usage();
                    }
                    nArray[n2++] = c - 48;
                    continue block8;
                }
                case ' ': 
                case ',': 
                case ';': {
                    if (i == 0) {
                        NTriple.usage();
                    }
                    switch (n2) {
                        case 0: {
                            continue block8;
                        }
                        case 3: {
                            arp.setErrorMode(nArray[0] * 100 + nArray[1] * 10 + nArray[2], n);
                            n2 = 0;
                            continue block8;
                        }
                    }
                    NTriple.usage();
                    continue block8;
                }
                default: {
                    NTriple.usage();
                }
            }
        }
    }

    private static void process(String string) {
        String string2;
        InputStream inputStream;
        try {
            File file = new File(string);
            inputStream = new FileInputStream(file);
            URL uRL = file.toURL();
            string2 = uRL.toExternalForm();
            if (string2.startsWith("file:/") && !string2.startsWith("file://")) {
                string2 = "file://" + string2.substring(5);
            }
        }
        catch (Exception exception) {
            try {
                URL uRL = new URL(string);
                inputStream = uRL.openStream();
                string2 = uRL.toExternalForm();
            }
            catch (Exception exception2) {
                System.err.println("ARP: Failed to open: " + string);
                System.err.println("    " + ParseException.formatMessage(exception));
                System.err.println("    " + ParseException.formatMessage(exception2));
                return;
            }
        }
        NTriple.process(inputStream, string2, string);
    }

    private static void process(InputStream inputStream, String string, String string2) {
        String string3 = xmlBase == null ? string : xmlBase;
        try {
            arp.load(inputStream, string3);
        }
        catch (IOException iOException) {
            System.err.println("Error: " + string2 + ": " + ParseException.formatMessage(iOException));
        }
        catch (SAXParseException sAXParseException) {
        }
        catch (SAXException sAXException) {
            System.err.println("Error: " + string2 + ": " + ParseException.formatMessage(sAXException));
        }
    }

    private static void print(String string) {
        line.append(string);
    }

    private static void resource(AResource aResource) {
        if (aResource.isAnonymous()) {
            NTriple.print("_:j");
            NTriple.print(aResource.getAnonymousID());
            NTriple.print(" ");
        } else {
            NTriple.print("<");
            NTriple.escapeURI(aResource.getURI());
            NTriple.print("> ");
        }
    }

    private static void escape(String string) {
        int n = string.length();
        block7: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\\': {
                    NTriple.print("\\\\");
                    continue block7;
                }
                case '\"': {
                    NTriple.print("\\\"");
                    continue block7;
                }
                case '\n': {
                    NTriple.print("\\n");
                    continue block7;
                }
                case '\r': {
                    NTriple.print("\\r");
                    continue block7;
                }
                case '\t': {
                    NTriple.print("\\t");
                    continue block7;
                }
                default: {
                    if (c >= ' ' && c <= '~') {
                        line.append(c);
                        continue block7;
                    }
                    NTriple.print("\\u");
                    String string2 = Integer.toHexString(c).toUpperCase();
                    for (int j = 4 - string2.length(); j > 0; --j) {
                        NTriple.print("0");
                    }
                    NTriple.print(string2);
                }
            }
        }
    }

    private static void escapeURI(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c < okURIChars.length && okURIChars[c]) {
                line.append(c);
                continue;
            }
            NTriple.print("\\u");
            String string2 = Integer.toHexString(c).toUpperCase();
            for (int j = 4 - string2.length(); j > 0; --j) {
                NTriple.print("0");
            }
            NTriple.print(string2);
        }
    }

    private static void literal(ALiteral aLiteral) {
        String string;
        line.append('\"');
        NTriple.escape(((Object)aLiteral).toString());
        line.append('\"');
        String string2 = aLiteral.getLang();
        if (string2 != null && !string2.equals("")) {
            line.append('@');
            NTriple.print(string2);
        }
        if ((string = aLiteral.getDatatypeURI()) != null && !string.equals("")) {
            NTriple.print("^^<");
            NTriple.escapeURI(string);
            line.append('>');
        }
        line.append(' ');
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        xmlBase = null;
        numbers = false;
        andMeToo = null;
        rt = Runtime.getRuntime();
        startMem = -1;
        okURIChars = new boolean[128];
        for (int i = 32; i < 127; ++i) {
            NTriple.okURIChars[i] = true;
        }
        NTriple.okURIChars[60] = false;
        NTriple.okURIChars[62] = false;
        NTriple.okURIChars[92] = false;
    }

    private static class SH
    implements StatementHandler {
        private SH() {
        }

        public void statement(AResource aResource, AResource aResource2, AResource aResource3) {
            NTriple.lineNumber();
            NTriple.resource(aResource);
            NTriple.resource(aResource2);
            NTriple.resource(aResource3);
            line.append('.');
            System.out.println(line);
            line.setLength(0);
        }

        public void statement(AResource aResource, AResource aResource2, ALiteral aLiteral) {
            String string = aLiteral.getLang();
            String string2 = aLiteral.getParseType();
            NTriple.lineNumber();
            NTriple.resource(aResource);
            NTriple.resource(aResource2);
            NTriple.literal(aLiteral);
            line.append('.');
            System.out.println(line);
            line.setLength(0);
        }
    }

    private static class NoSH
    implements StatementHandler {
        private NoSH() {
        }

        public void statement(AResource aResource, AResource aResource2, AResource aResource3) {
        }

        public void statement(AResource aResource, AResource aResource2, ALiteral aLiteral) {
        }
    }

    private static class TwoSH
    implements StatementHandler {
        final StatementHandler a;
        final StatementHandler b;

        public void statement(AResource aResource, AResource aResource2, AResource aResource3) {
            this.a.statement(aResource, aResource2, aResource3);
            this.b.statement(aResource, aResource2, aResource3);
        }

        public void statement(AResource aResource, AResource aResource2, ALiteral aLiteral) {
            this.a.statement(aResource, aResource2, aLiteral);
            this.b.statement(aResource, aResource2, aLiteral);
        }

        TwoSH(StatementHandler statementHandler, StatementHandler statementHandler2) {
            this.a = statementHandler;
            this.b = statementHandler2;
        }
    }
}

