/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.arp;

import com.hp.hpl.jena.rdf.arp.ARPErrorNumbers;
import com.hp.hpl.jena.rdf.arp.Location;
import com.hp.hpl.jena.rdf.arp.RDFParserConstants;
import com.hp.hpl.jena.rdf.arp.Token;
import java.util.Arrays;
import java.util.BitSet;
import org.xml.sax.Locator;
import org.xml.sax.SAXParseException;

public class ParseException
extends SAXParseException
implements ARPErrorNumbers,
RDFParserConstants {
    private int id;
    private Location where;
    boolean specialConstructor;
    Token currentToken;
    private boolean isFatal;
    int[][] expectedTokenSequences;
    private String[] tokenImage;
    boolean promoteMe;
    private Token startAttributes;
    private static final int[] elementStriping = new int[]{1, 2, 3, 4, 6};
    static String eol;

    ParseException(Token token, int[][] nArray, String[] stringArray) {
        super(null, ParseException.publicId(token), ParseException.systemId(token), ParseException.line(token), ParseException.col(token));
        this.specialConstructor = true;
        this.where = token.location;
        this.currentToken = token;
        this.expectedTokenSequences = nArray;
        this.id = 201;
        this.tokenImage = stringArray;
    }

    private static String systemId(Token token) {
        return token.location != null ? token.location.inputName : null;
    }

    private static String publicId(Token token) {
        return null;
    }

    private static int line(Token token) {
        return token.location != null ? token.location.endLine : -1;
    }

    private static int col(Token token) {
        return token.location != null ? token.location.endColumn : -1;
    }

    ParseException(int n, Location location, String string, SAXParseException sAXParseException) {
        super(string, location.inputName, null, location.endLine, location.endColumn, sAXParseException);
        this.where = location;
        this.id = n;
        this.specialConstructor = false;
    }

    ParseException(int n, Location location, String string) {
        super(string, location.inputName, null, location.endLine, location.endColumn);
        this.where = location;
        this.id = n;
        this.specialConstructor = false;
    }

    ParseException(int n, String string) {
        super(string, (Locator)null);
        this.id = n;
        this.specialConstructor = false;
    }

    ParseException() {
        super((String)null, (Locator)null);
        this.specialConstructor = false;
    }

    SAXParseException rootCause() {
        Exception exception = this.getException();
        return exception == null ? this : (SAXParseException)exception;
    }

    public int getErrorNumber() {
        return this.id;
    }

    void setFatal(boolean bl) {
        this.isFatal = bl;
    }

    boolean getFatal() {
        return this.isFatal;
    }

    public void promote() {
        this.promoteMe = true;
    }

    void setStartAttribute(Token token) {
        this.startAttributes = token;
    }

    private void startAttrSkip(Token token) {
        Token token2 = this.startAttributes;
        while (token2 != token.next) {
            switch (token2.kind) {
                case 11: 
                case 26: 
                case 27: 
                case 28: 
                case 29: {
                    break;
                }
                default: {
                    this.startAttributes = token2;
                    return;
                }
            }
            token2 = token2.next;
        }
    }

    private String getAttributes(Token token) {
        String string = "";
        Token token2 = this.startAttributes;
        while (token2 != token.next) {
            switch (token2.kind) {
                case 14: {
                    string = string + ", rdf:type";
                    break;
                }
                case 9: {
                    string = string + ", rdf:about";
                    break;
                }
                case 24: {
                    string = string + ", rdf:datatype";
                    break;
                }
                case 10: {
                    string = string + ", rdf:nodeID";
                    break;
                }
                case 8: {
                    string = string + ", rdf:ID";
                    break;
                }
                case 18: {
                    string = string + ", rdf:parseType";
                    break;
                }
                case 23: {
                    string = string + ", rdf:resource";
                    break;
                }
                case 13: {
                    string = string + ", rdf:_NNN";
                    break;
                }
                case 12: {
                    string = string + ", a property attribute";
                    break;
                }
                case 19: {
                    string = string + "='Literal'";
                    break;
                }
                case 22: {
                    string = string + "='Resource'";
                    break;
                }
                case 20: {
                    string = string + "='daml:collection'";
                    break;
                }
                case 11: 
                case 29: {
                    break;
                }
                default: {
                    String string2 = "Internal mishap in ParseException.getAttributes()";
                    System.err.println(string2);
                    return string2;
                }
            }
            token2 = token2.next;
        }
        return string.length() > 2 ? string.substring(2) : string;
    }

    public String getMessage() {
        int n;
        String string;
        String string2 = this.id != 0 ? "{" + (this.id < 200 ? "W" : "E") + ("" + (1000 + this.id)).substring(1) + "} " : (string = "");
        if (!this.specialConstructor) {
            return string + super.getMessage();
        }
        Token token = this.currentToken.next;
        this.startAttrSkip(token);
        String string3 = "Syntax error when processing " + token.toString() + "." + eol;
        if (this.isElementStripingProblem(token)) {
            return string + string3 + "Cannot have another XML element here." + eol + "(Maybe one object has already been given as the value of the enclosing property).";
        }
        switch (token.kind) {
            case 1: {
                break;
            }
            case 0: {
                string3 = string3 + "Input to RDF parser ended prematurely. This is often related to an XML parser abort." + eol;
                break;
            }
            case 7: {
                return string + string3 + "rdf:Description elements generally may" + eol + "only occur to describe an object.";
            }
            case 5: {
                return string + string3 + "rdf:RDF element tags generally may not occur inside RDF content.";
            }
            case 12: 
            case 13: {
                if (this.startAttributes != null) {
                    if (this.startAttributes == token) {
                        return string + string3 + "Cannot have property attributes in this context.";
                    }
                    return string + string3 + "Cannot have property attributes with the following other attributes:" + eol + "    " + this.getAttributes(this.currentToken);
                }
            }
            case 14: {
                if (this.startAttributes != null) {
                    if (this.startAttributes == token) {
                        return string + string3 + "Cannot have rdf:type attribute in this context.";
                    }
                    return string + string3 + "Cannot have rdf:type attribute with the following other attributes:" + eol + "    " + this.getAttributes(this.currentToken);
                }
            }
            case 8: 
            case 9: 
            case 10: 
            case 18: 
            case 23: 
            case 24: {
                if (this.startAttributes != null) {
                    if (this.startAttributes == token) {
                        return string + string3 + "Cannot have " + this.tokenImage[token.kind] + " in this context.";
                    }
                    return string + string3 + "In this context, the following attributes are not allowed together:" + eol + "    " + this.getAttributes(token);
                }
            }
            default: {
                string3 = "Unusual " + string3;
            }
        }
        String string4 = "";
        int n2 = 0;
        BitSet bitSet = new BitSet();
        bitSet.set(29);
        block14: for (n = 0; n < this.expectedTokenSequences.length; ++n) {
            switch (this.expectedTokenSequences[n][0]) {
                case 15: {
                    bitSet.set(16);
                    bitSet.set(17);
                    continue block14;
                }
                case 12: {
                    bitSet.set(13);
                    continue block14;
                }
                case 1: {
                    bitSet.set(3);
                    bitSet.set(2);
                }
            }
        }
        for (n = 0; n < this.expectedTokenSequences.length; ++n) {
            if (bitSet.get(this.expectedTokenSequences[n][0])) continue;
            if (n2 < this.expectedTokenSequences[n].length) {
                n2 = this.expectedTokenSequences[n].length;
            }
            for (int i = 0; i < this.expectedTokenSequences[n].length; ++i) {
                string4 = string4 + this.tokenImage[this.expectedTokenSequences[n][i]] + " ";
            }
            string4 = string4 + eol + "    ";
        }
        string3 = string3 + "Encountered ";
        for (n = 0; n < n2; ++n) {
            if (n != 0) {
                string3 = string3 + " ";
            }
            string3 = string3 + token.toString();
            if (token.kind == 0) break;
            token = token.next;
        }
        string3 = this.expectedTokenSequences.length == 1 ? string3 + " Was expecting:" + eol + "    " : string3 + " Was expecting one of:" + eol + "    ";
        string3 = string3 + string4;
        return string + string3;
    }

    private boolean isElementStripingProblem(Token token) {
        int n;
        if (this.expectedTokenSequences.length != elementStriping.length) {
            return false;
        }
        int[] nArray = new int[elementStriping.length];
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = this.expectedTokenSequences[n][0];
        }
        Arrays.sort(nArray);
        for (n = 0; n < nArray.length; ++n) {
            if (nArray[n] == elementStriping[n]) continue;
            return false;
        }
        return true;
    }

    public static String formatMessage(Exception exception) {
        String string = exception.getMessage();
        if (string == null) {
            string = exception.toString();
        }
        if (exception instanceof SAXParseException) {
            String string2;
            SAXParseException sAXParseException = (SAXParseException)exception;
            String string3 = sAXParseException.getSystemId();
            if (string3 == null) {
                string3 = sAXParseException.getPublicId();
            }
            String string4 = string2 = string3 == null ? "" : string3;
            if (sAXParseException.getLineNumber() != -1) {
                if (sAXParseException.getColumnNumber() == -1) {
                    return string2 + "[" + sAXParseException.getLineNumber() + "]: " + string;
                }
                return string2 + "[" + sAXParseException.getLineNumber() + ":" + sAXParseException.getColumnNumber() + "]: " + string;
            }
            return (string3 != null ? string3 + ": " : "") + string;
        }
        return string;
    }

    static {
        Arrays.sort(elementStriping);
        try {
            eol = System.getProperty("line.separator", "\n");
        }
        catch (SecurityException securityException) {
            eol = "\n";
        }
    }
}

