/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.arp;

import com.hp.hpl.jena.rdf.arp.ARPErrorNumbers;
import com.hp.hpl.jena.rdf.arp.ARPFilter;
import com.hp.hpl.jena.rdf.arp.ARPQname;
import com.hp.hpl.jena.rdf.arp.ARPResource;
import com.hp.hpl.jena.rdf.arp.ARPString;
import com.hp.hpl.jena.rdf.arp.AResourceInternal;
import com.hp.hpl.jena.rdf.arp.CollectionAction;
import com.hp.hpl.jena.rdf.arp.Location;
import com.hp.hpl.jena.rdf.arp.ParseException;
import com.hp.hpl.jena.rdf.arp.ParserSupport;
import com.hp.hpl.jena.rdf.arp.RDFParserConstants;
import com.hp.hpl.jena.rdf.arp.StrToken;
import com.hp.hpl.jena.rdf.arp.Token;
import com.hp.hpl.jena.rdf.arp.TokenManager;
import com.hp.hpl.jena.rdf.arp.TokenPipe;
import com.hp.hpl.jena.rdf.arp.URIReference;
import com.hp.hpl.jena.rdf.arp.Warn;
import com.hp.hpl.jena.rdf.arp.WrappedException;
import com.hp.hpl.jena.rdf.arp.XMLContext;
import java.util.Enumeration;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import org.xml.sax.SAXException;

class RDFParser
implements ARPErrorNumbers,
RDFParserConstants {
    ARPFilter arp;
    ParserSupport X;
    Token startAttr;
    public TokenManager token_source;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    public boolean lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[77];
    private final int[] jj_la1_0 = new int[]{229536, 30, 30, 536870942, 536870942, 30, 30, 12, 12, 229504, 1792, 28672, 229376, 229504, 1792, 0x20000000, 0x20000000, 0x20000000, 0x20000000, 0x20000000, 28672, 0x20000000, 229376, 256, 0x20000000, 0x20000000, 0x20000000, 25457664, 0x20000000, 229376, 28672, 28672, 8680448, 229504, 1792, 28672, 229376, 229376, 229534, 0x20000000, 0x20000000, 0x800400, 30, 30, 0x24000000, 0x24000000, 0x20000000, 0x8000000, 0x20000000, 0x10000000, 0x20000000, 0x2000000, 229536, 0x20000000, 25458432, 229566, 0x20000000, 0x24000000, 0x24000000, 0x20000000, 0x8000000, 0x20000000, 0x10000000, 229566, 229504, 229536, 461666048, 25458432, 0x580800, 0x20000000, 0x4000000, 461666048, 229566, 0x20000000, 0x20000000, 229566, 229566};
    private final JJCalls[] jj_2_rtns = new JJCalls[4];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    RDFParser(TokenPipe tokenPipe, ARPFilter aRPFilter) {
        this(tokenPipe);
        this.arp = aRPFilter;
        this.X = new ParserSupport(aRPFilter);
    }

    public final void rdfFile(XMLContext xMLContext) throws ParseException {
        this.whiteOrErr();
        this.rdfFileSub(xMLContext);
        this.white1(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void rdfFileSub(XMLContext xMLContext) throws ParseException {
        ARPResource aRPResource = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 5: {
                this.rdf(xMLContext);
                break;
            }
            case 7: 
            case 15: 
            case 16: 
            case 17: {
                try {
                    this.arp.startRDF();
                    aRPResource = this.obj(xMLContext);
                    this.arp.endLocalScope(aRPResource);
                    this.arp.endRDF();
                    break;
                }
                catch (Throwable throwable) {
                    this.arp.endLocalScope(aRPResource);
                    this.arp.endRDF();
                    throw throwable;
                }
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void zwhite(boolean bl) throws ParseException {
        if (bl) {
            this.xwhite();
        } else {
            this.white();
        }
    }

    public final void white() throws ParseException {
        this.white1(true);
    }

    public final void xwhite() throws ParseException {
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
                default: {
                    this.jj_la1[1] = this.jj_gen;
                    break block3;
                }
            }
            this.xOneWhite();
        }
    }

    public final void white1(boolean bl) throws ParseException {
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
                default: {
                    this.jj_la1[2] = this.jj_gen;
                    break block3;
                }
            }
            this.oneWhite(bl);
        }
    }

    public final void whiteOrErr() throws ParseException {
        block8: {
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 29: {
                        break;
                    }
                    default: {
                        this.jj_la1[3] = this.jj_gen;
                        break block8;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        this.oneWhite(true);
                        continue block7;
                    }
                    case 29: {
                        this.warning();
                        continue block7;
                    }
                }
                break;
            }
            this.jj_la1[4] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
    }

    public final void xOneWhite() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 1: {
                Token token = this.jj_consume_token(1);
                this.X.checkWhite((StrToken)token, true);
                break;
            }
            case 2: {
                Token token = this.jj_consume_token(2);
                this.X.processingInstruction(token, true);
                break;
            }
            case 3: {
                this.jj_consume_token(3);
                break;
            }
            case 4: {
                this.saxEx();
                break;
            }
            default: {
                this.jj_la1[5] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void oneWhite(boolean bl) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 1: {
                Token token = this.jj_consume_token(1);
                this.X.checkWhite((StrToken)token, false);
                break;
            }
            case 2: {
                this.pi(bl);
                break;
            }
            case 3: {
                this.jj_consume_token(3);
                break;
            }
            case 4: {
                this.saxEx();
                break;
            }
            default: {
                this.jj_la1[6] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final Token saxEx() throws ParseException {
        Token token = this.jj_consume_token(4);
        this.X.saxException(token);
        return token;
    }

    public final void empty() throws ParseException {
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 2: 
                case 3: {
                    break;
                }
                default: {
                    this.jj_la1[7] = this.jj_gen;
                    break block3;
                }
            }
            this.oneEmpty();
        }
    }

    public final void oneEmpty() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 2: {
                this.pi(true);
                break;
            }
            case 3: {
                this.jj_consume_token(3);
                break;
            }
            default: {
                this.jj_la1[8] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final Token pi(boolean bl) throws ParseException {
        Token token = this.jj_consume_token(2);
        if (bl) {
            this.X.processingInstruction(token, false);
        }
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void rdf(XMLContext xMLContext) throws ParseException {
        ARPResource aRPResource = null;
        try {
            this.jj_consume_token(5);
            this.arp.startRDF();
            xMLContext = this.xmlAttrs(xMLContext);
            this.white();
            block11: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 7: 
                    case 15: 
                    case 16: 
                    case 17: {
                        break;
                    }
                    default: {
                        this.jj_la1[9] = this.jj_gen;
                        break block11;
                    }
                }
                try {
                    aRPResource = this.obj(xMLContext);
                }
                finally {
                    this.arp.endLocalScope(aRPResource);
                    aRPResource = null;
                }
                this.white();
            }
            this.jj_consume_token(6);
        }
        catch (ParseException parseException) {
            this.error_recovery(parseException);
        }
        finally {
            this.arp.endRDF();
        }
    }

    public final ARPResource obj(XMLContext xMLContext) throws ParseException {
        ARPResource aRPResource = new ARPResource(this.arp);
        try {
            this.description(xMLContext, aRPResource, false);
            return aRPResource;
        }
        catch (ParseException parseException) {
            this.arp.endLocalScope(aRPResource);
            throw parseException;
        }
        catch (RuntimeException runtimeException) {
            this.arp.endLocalScope(aRPResource);
            throw runtimeException;
        }
    }

    public final ARPResource xobj(XMLContext xMLContext) throws ParseException {
        ARPResource aRPResource = new ARPResource(this.arp);
        try {
            this.description(xMLContext, aRPResource, true);
            return aRPResource;
        }
        catch (ParseException parseException) {
            this.arp.endLocalScope(aRPResource);
            throw parseException;
        }
        catch (RuntimeException runtimeException) {
            this.arp.endLocalScope(aRPResource);
            throw runtimeException;
        }
    }

    public final void description(XMLContext xMLContext, ARPResource aRPResource, boolean bl) throws ParseException {
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 7: {
                    this.jj_consume_token(7);
                    xMLContext = this.xmlAttrs(xMLContext);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 8: 
                        case 9: 
                        case 10: {
                            this.idAboutAttr(xMLContext, aRPResource);
                            break;
                        }
                        default: {
                            this.jj_la1[10] = this.jj_gen;
                        }
                    }
                    block15: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 12: 
                            case 13: 
                            case 14: {
                                break;
                            }
                            default: {
                                this.jj_la1[11] = this.jj_gen;
                                break block15;
                            }
                        }
                        this.propAttr(xMLContext, aRPResource);
                    }
                    this.zwhite(bl);
                    block16: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 15: 
                            case 16: 
                            case 17: {
                                break;
                            }
                            default: {
                                this.jj_la1[12] = this.jj_gen;
                                break block16;
                            }
                        }
                        this.propertyElt(xMLContext, aRPResource);
                        this.zwhite(bl);
                    }
                    this.jj_consume_token(6);
                    break;
                }
                case 15: 
                case 16: 
                case 17: {
                    this.typedNode(xMLContext, aRPResource, bl);
                    break;
                }
                default: {
                    this.jj_la1[13] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        catch (ParseException parseException) {
            this.error_recovery(parseException);
        }
    }

    public final void idAboutAttr(XMLContext xMLContext, ARPResource aRPResource) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: {
                String string = this.idAttr(xMLContext);
                aRPResource.setAbout(string);
                break;
            }
            case 9: {
                this.aboutAttr(xMLContext, aRPResource);
                break;
            }
            case 10: {
                this.nodeIdAttr(xMLContext, aRPResource);
                break;
            }
            default: {
                this.jj_la1[14] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final String idAttr(XMLContext xMLContext) throws ParseException {
        this.jj_consume_token(8);
        String string = this.idSymbol(xMLContext);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 29: {
                    break;
                }
                default: {
                    this.jj_la1[15] = this.jj_gen;
                    break block3;
                }
            }
            this.warning();
        }
        return string;
    }

    public final void aboutAttr(XMLContext xMLContext, ARPResource aRPResource) throws ParseException {
        this.jj_consume_token(9);
        URIReference uRIReference = this.uriReference(xMLContext);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 29: {
                    break;
                }
                default: {
                    this.jj_la1[16] = this.jj_gen;
                    break block3;
                }
            }
            this.warning();
        }
        aRPResource.setAbout(uRIReference);
    }

    public final void nodeIdAttr(XMLContext xMLContext, ARPResource aRPResource) throws ParseException {
        this.jj_consume_token(10);
        Token token = this.jj_consume_token(11);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 29: {
                    break;
                }
                default: {
                    this.jj_la1[17] = this.jj_gen;
                    break block3;
                }
            }
            this.warning();
        }
        aRPResource.setNodeId(this.X.checkNodeID(token));
    }

    public final void propAttr(XMLContext xMLContext, ARPResource aRPResource) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 14: {
                this.typeAttr(xMLContext, aRPResource);
                break;
            }
            case 12: {
                Token token = this.jj_consume_token(12);
                Token token2 = this.jj_consume_token(11);
                block11: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 29: {
                            break;
                        }
                        default: {
                            this.jj_la1[18] = this.jj_gen;
                            break block11;
                        }
                    }
                    this.warning();
                }
                this.X.checkString(token2);
                aRPResource.setPredicateObject(((ARPQname)token).asURIReference(this.arp), new ARPString((StrToken)token2, xMLContext.getLang()));
                break;
            }
            case 13: {
                Token token = this.jj_consume_token(13);
                Token token3 = this.jj_consume_token(11);
                block12: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 29: {
                            break;
                        }
                        default: {
                            this.jj_la1[19] = this.jj_gen;
                            break block12;
                        }
                    }
                    this.warning();
                }
                this.X.checkString(token3);
                aRPResource.setPredicateObject(((ARPQname)token).asURIReference(this.arp), new ARPString((StrToken)token3, xMLContext.getLang()));
                break;
            }
            default: {
                this.jj_la1[20] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void typeAttr(XMLContext xMLContext, ARPResource aRPResource) throws ParseException {
        this.jj_consume_token(14);
        URIReference uRIReference = this.uriReference(xMLContext);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 29: {
                    break;
                }
                default: {
                    this.jj_la1[21] = this.jj_gen;
                    break block3;
                }
            }
            this.warning();
        }
        aRPResource.setType(uRIReference);
    }

    public final void propertyElt(XMLContext xMLContext, ARPResource aRPResource) throws ParseException {
        try {
            Token token = this.propertyEltTag();
            token = (Token)token.clone();
            token.next = null;
            xMLContext = this.xmlAttrs(xMLContext);
            this.propertyEltIdAndValue(xMLContext, aRPResource, token);
            this.jj_consume_token(6);
        }
        catch (ParseException parseException) {
            this.error_recovery(parseException);
        }
    }

    public final Token propertyEltTag() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 15: {
                Token token = this.jj_consume_token(15);
                return token;
            }
            case 16: {
                Token token = this.jj_consume_token(16);
                return token;
            }
            case 17: {
                Token token = this.jj_consume_token(17);
                return token;
            }
        }
        this.jj_la1[22] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void propertyEltIdAndValue(XMLContext xMLContext, ARPResource aRPResource, Token token) throws ParseException {
        String string = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: {
                string = this.idAttr(xMLContext);
                break;
            }
            default: {
                this.jj_la1[23] = this.jj_gen;
            }
        }
        Object object = this.propEltValue(xMLContext);
        try {
            this.X.createTriple(aRPResource, token, object, string);
        }
        finally {
            this.arp.endLocalScope(object);
        }
    }

    public final Object propEltValue(XMLContext xMLContext) throws ParseException {
        if (this.jj_2_1(2)) {
            this.jj_consume_token(18);
            Token token = this.jj_consume_token(19);
            String string = ((StrToken)token).value;
            Location location = token.location;
            token = null;
            block16: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 29: {
                        break;
                    }
                    default: {
                        this.jj_la1[24] = this.jj_gen;
                        break block16;
                    }
                }
                this.warning();
            }
            String string2 = this.litValue(xMLContext.getNamespaces(), location);
            return new ARPString(string2, xMLContext.getLang(), string);
        }
        if (this.jj_2_2(2)) {
            this.jj_consume_token(18);
            this.jj_consume_token(20);
            AResourceInternal[] aResourceInternalArray = new AResourceInternal[1];
            block17: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 29: {
                        break;
                    }
                    default: {
                        this.jj_la1[25] = this.jj_gen;
                        break block17;
                    }
                }
                this.warning();
            }
            this.white();
            this.collection(xMLContext, this.X.damlCollectionAction(aResourceInternalArray));
            return aResourceInternalArray[0];
        }
        if (this.jj_2_3(2)) {
            this.jj_consume_token(18);
            this.jj_consume_token(21);
            AResourceInternal[] aResourceInternalArray = new AResourceInternal[1];
            block18: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 29: {
                        break;
                    }
                    default: {
                        this.jj_la1[26] = this.jj_gen;
                        break block18;
                    }
                }
                this.warning();
            }
            this.white();
            this.collection(xMLContext, this.X.collectionAction(aResourceInternalArray));
            return aResourceInternalArray[0];
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 24: {
                URIReference uRIReference = this.datatypeAttr(xMLContext);
                ARPString aRPString = this.string(xMLContext);
                return this.X.createDatatypeLiteral(uRIReference, aRPString);
            }
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 18: 
            case 23: {
                ARPResource aRPResource = new ARPResource(this.arp);
                try {
                    this.propEltValueWithRes(xMLContext, aRPResource);
                    return aRPResource;
                }
                catch (ParseException parseException) {
                    this.arp.endLocalScope(aRPResource);
                    throw parseException;
                }
                catch (RuntimeException runtimeException) {
                    this.arp.endLocalScope(aRPResource);
                    throw runtimeException;
                }
            }
        }
        this.jj_la1[27] = this.jj_gen;
        Object object = this.value(xMLContext);
        return object;
    }

    public final void propEltValueWithRes(XMLContext xMLContext, ARPResource aRPResource) throws ParseException {
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 18: {
                this.jj_consume_token(18);
                this.jj_consume_token(22);
                block17: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 29: {
                            break;
                        }
                        default: {
                            this.jj_la1[28] = this.jj_gen;
                            break block17;
                        }
                    }
                    this.warning();
                }
                this.white();
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 15: 
                        case 16: 
                        case 17: {
                            break;
                        }
                        default: {
                            this.jj_la1[29] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.propertyElt(xMLContext, aRPResource);
                    this.white();
                }
            }
            case 10: 
            case 23: {
                this.resourceOrNodeIdAttr(xMLContext, aRPResource);
                block19: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 12: 
                        case 13: 
                        case 14: {
                            break;
                        }
                        default: {
                            this.jj_la1[30] = this.jj_gen;
                            break block19;
                        }
                    }
                    this.propAttr(xMLContext, aRPResource);
                }
                this.empty();
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                block20: while (true) {
                    this.propAttr(xMLContext, aRPResource);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 12: 
                        case 13: 
                        case 14: {
                            continue block20;
                        }
                    }
                    break;
                }
                this.jj_la1[31] = this.jj_gen;
                this.empty();
                break;
            }
            default: {
                this.jj_la1[32] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void collection(XMLContext xMLContext, CollectionAction collectionAction) throws ParseException {
        CollectionAction collectionAction2 = collectionAction;
        try {
            block6: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 7: 
                    case 15: 
                    case 16: 
                    case 17: {
                        break;
                    }
                    default: {
                        this.jj_la1[33] = this.jj_gen;
                        break block6;
                    }
                }
                collectionAction = this.objInCollection(xMLContext, collectionAction);
            }
            collectionAction.terminate();
        }
        catch (RuntimeException runtimeException) {
            collectionAction2.cleanUp();
            collectionAction.cleanUp();
            throw runtimeException;
        }
        catch (ParseException parseException) {
            collectionAction2.cleanUp();
            collectionAction.cleanUp();
            throw parseException;
        }
    }

    public final CollectionAction objInCollection(XMLContext xMLContext, CollectionAction collectionAction) throws ParseException {
        ARPResource aRPResource = this.obj(xMLContext);
        CollectionAction collectionAction2 = collectionAction.next(aRPResource);
        this.white();
        return collectionAction2;
    }

    public final void typedNode(XMLContext xMLContext, ARPResource aRPResource, boolean bl) throws ParseException {
        Token token = this.typedNodeTag();
        token = (Token)token.clone();
        token.next = null;
        xMLContext = this.xmlAttrs(xMLContext);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: 
            case 9: 
            case 10: {
                this.idAboutAttr(xMLContext, aRPResource);
                break;
            }
            default: {
                this.jj_la1[34] = this.jj_gen;
            }
        }
        aRPResource.setType(((ARPQname)token).asURIReference(this.arp));
        block9: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 12: 
                case 13: 
                case 14: {
                    break;
                }
                default: {
                    this.jj_la1[35] = this.jj_gen;
                    break block9;
                }
            }
            this.propAttr(xMLContext, aRPResource);
        }
        this.zwhite(bl);
        block10: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 15: 
                case 16: 
                case 17: {
                    break;
                }
                default: {
                    this.jj_la1[36] = this.jj_gen;
                    break block10;
                }
            }
            this.propertyElt(xMLContext, aRPResource);
            this.zwhite(bl);
        }
        this.jj_consume_token(6);
    }

    public final Token typedNodeTag() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 15: {
                Token token = this.jj_consume_token(15);
                return token;
            }
            case 17: {
                Token token = this.jj_consume_token(17);
                this.arp.parseWarning(114, token.location, ((ARPQname)token).qName + " is being used as a type.");
                return token;
            }
            case 16: {
                Token token = this.jj_consume_token(16);
                this.arp.parseWarning(204, token.location, ((ARPQname)token).qName + " is being used as a type.");
                return token;
            }
        }
        this.jj_la1[37] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Object value(XMLContext xMLContext) throws ParseException {
        if (this.jj_2_4(Integer.MAX_VALUE)) {
            ARPString aRPString = this.string(xMLContext);
            return aRPString;
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 15: 
            case 16: 
            case 17: {
                this.xwhite();
                ARPResource aRPResource = this.xobj(xMLContext);
                try {
                    this.xwhite();
                    return aRPResource;
                }
                catch (ParseException parseException) {
                    this.arp.endLocalScope(aRPResource);
                    throw parseException;
                }
                catch (RuntimeException runtimeException) {
                    this.arp.endLocalScope(aRPResource);
                    throw runtimeException;
                }
            }
        }
        this.jj_la1[38] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final void resourceAttr(XMLContext xMLContext, ARPResource aRPResource) throws ParseException {
        this.jj_consume_token(23);
        URIReference uRIReference = this.uriReference(xMLContext);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 29: {
                    break;
                }
                default: {
                    this.jj_la1[39] = this.jj_gen;
                    break block3;
                }
            }
            this.warning();
        }
        aRPResource.setAbout(uRIReference);
    }

    public final URIReference datatypeAttr(XMLContext xMLContext) throws ParseException {
        this.jj_consume_token(24);
        URIReference uRIReference = this.uriReference(xMLContext);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 29: {
                    break;
                }
                default: {
                    this.jj_la1[40] = this.jj_gen;
                    break block3;
                }
            }
            this.warning();
        }
        return uRIReference;
    }

    public final void resourceOrNodeIdAttr(XMLContext xMLContext, ARPResource aRPResource) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 23: {
                this.resourceAttr(xMLContext, aRPResource);
                break;
            }
            case 10: {
                this.nodeIdAttr(xMLContext, aRPResource);
                break;
            }
            default: {
                this.jj_la1[41] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final URIReference uriReference(XMLContext xMLContext) throws ParseException {
        Token token = this.jj_consume_token(11);
        return this.X.makeURIReference(xMLContext, token);
    }

    public final String idSymbol(XMLContext xMLContext) throws ParseException {
        Token token = this.jj_consume_token(11);
        StrToken strToken = (StrToken)token;
        String string = xMLContext.resolveSameDocRef(token.location, "#" + strToken.value);
        this.X.checkIdSymbol(xMLContext, strToken, string);
        return string;
    }

    public final ARPString string(XMLContext xMLContext) throws ParseException {
        Vector vector = new Vector();
        Token token = null;
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
                default: {
                    this.jj_la1[42] = this.jj_gen;
                    break block3;
                }
            }
            token = this.string1(vector);
        }
        ARPString aRPString = new ARPString(vector, xMLContext.getLang());
        this.X.checkNormalFormC(token, aRPString);
        return aRPString;
    }

    public final Token string1(Vector vector) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 1: {
                Token token = this.jj_consume_token(1);
                this.X.checkComposingChar(token);
                vector.add(token);
                return token;
            }
            case 3: {
                Token token = this.jj_consume_token(3);
                return token;
            }
            case 2: {
                Token token = this.pi(true);
                return token;
            }
            case 4: {
                Token token = this.saxEx();
                return token;
            }
        }
        this.jj_la1[43] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final XMLContext xmlAttrs(XMLContext xMLContext) throws ParseException {
        block29: {
            this.startAttr = this.getToken(1);
            block25: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 26: 
                    case 29: {
                        break;
                    }
                    default: {
                        this.jj_la1[44] = this.jj_gen;
                        break block29;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 29: {
                        this.warning();
                        continue block25;
                    }
                    case 26: {
                        xMLContext = this.xmlns(xMLContext);
                        continue block25;
                    }
                }
                break;
            }
            this.jj_la1[45] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        block7 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 27: {
                xMLContext = this.xmlBase(xMLContext);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 29: {
                            break;
                        }
                        default: {
                            this.jj_la1[46] = this.jj_gen;
                            break block7;
                        }
                    }
                    this.warning();
                }
            }
            default: {
                this.jj_la1[47] = this.jj_gen;
            }
        }
        block13 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 28: {
                xMLContext = this.xmlLang(xMLContext);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 29: {
                            break;
                        }
                        default: {
                            this.jj_la1[48] = this.jj_gen;
                            break block13;
                        }
                    }
                    this.warning();
                }
            }
            default: {
                this.jj_la1[49] = this.jj_gen;
            }
        }
        block19 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 25: {
                this.jj_consume_token(25);
                this.jj_consume_token(11);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 29: {
                            break;
                        }
                        default: {
                            this.jj_la1[50] = this.jj_gen;
                            break block19;
                        }
                    }
                    this.warning();
                }
            }
            default: {
                this.jj_la1[51] = this.jj_gen;
            }
        }
        return xMLContext;
    }

    public final XMLContext xmlns(XMLContext xMLContext) throws ParseException {
        Token token = this.jj_consume_token(26);
        Token token2 = this.jj_consume_token(11);
        this.X.checkNamespaceURI(token2);
        return xMLContext.addNamespace(token, token2);
    }

    public final XMLContext xmlBase(XMLContext xMLContext) throws ParseException {
        this.jj_consume_token(27);
        Token token = this.jj_consume_token(11);
        return this.X.changeXMLBase(xMLContext, token);
    }

    public final XMLContext xmlLang(XMLContext xMLContext) throws ParseException {
        this.jj_consume_token(28);
        Token token = this.jj_consume_token(11);
        StrToken strToken = (StrToken)token;
        this.X.checkXMLLang(strToken);
        return xMLContext.withLang(strToken.value);
    }

    public final void warning() throws ParseException {
        Token token = this.jj_consume_token(29);
        this.arp.parseWarning((Warn)token);
    }

    public final void embeddedFile(XMLContext xMLContext) throws ParseException {
        this.whiteOrErr();
        this.root(xMLContext);
        this.white1(false);
    }

    public final void root(XMLContext xMLContext) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 5: {
                this.rdf(xMLContext);
                break;
            }
            case 7: 
            case 15: 
            case 16: 
            case 17: {
                this.element(xMLContext);
                break;
            }
            default: {
                this.jj_la1[52] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void element(XMLContext xMLContext) throws ParseException {
        this.startElement();
        block9: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 29: {
                    break;
                }
                default: {
                    this.jj_la1[53] = this.jj_gen;
                    break block9;
                }
            }
            this.nowarning();
        }
        xMLContext = this.xmlAttrsNoWarnings(xMLContext);
        block10: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 8: 
                case 9: 
                case 10: 
                case 12: 
                case 13: 
                case 14: 
                case 18: 
                case 23: 
                case 24: {
                    break;
                }
                default: {
                    this.jj_la1[54] = this.jj_gen;
                    break block10;
                }
            }
            this.attr();
        }
        block11: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 7: 
                case 15: 
                case 16: 
                case 17: {
                    break;
                }
                default: {
                    this.jj_la1[55] = this.jj_gen;
                    break block11;
                }
            }
            this.content(xMLContext);
        }
        this.jj_consume_token(6);
    }

    public final void attr() throws ParseException {
        this.attrName();
        this.attrValue();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 29: {
                    break;
                }
                default: {
                    this.jj_la1[56] = this.jj_gen;
                    break block3;
                }
            }
            this.nowarning();
        }
    }

    public final void nowarning() throws ParseException {
        this.jj_consume_token(29);
    }

    public final XMLContext xmlAttrsNoWarnings(XMLContext xMLContext) throws ParseException {
        block22: {
            this.startAttr = this.getToken(1);
            block19: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 26: 
                    case 29: {
                        break;
                    }
                    default: {
                        this.jj_la1[57] = this.jj_gen;
                        break block22;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 29: {
                        this.warning();
                        continue block19;
                    }
                    case 26: {
                        xMLContext = this.xmlns(xMLContext);
                        continue block19;
                    }
                }
                break;
            }
            this.jj_la1[58] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        block7 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 27: {
                xMLContext = this.xmlBase(xMLContext);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 29: {
                            break;
                        }
                        default: {
                            this.jj_la1[59] = this.jj_gen;
                            break block7;
                        }
                    }
                    this.nowarning();
                }
            }
            default: {
                this.jj_la1[60] = this.jj_gen;
            }
        }
        block13 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 28: {
                xMLContext = this.xmlLang(xMLContext);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 29: {
                            break;
                        }
                        default: {
                            this.jj_la1[61] = this.jj_gen;
                            break block13;
                        }
                    }
                    this.nowarning();
                }
            }
            default: {
                this.jj_la1[62] = this.jj_gen;
            }
        }
        return xMLContext;
    }

    public final void content(XMLContext xMLContext) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 5: {
                this.rdf(xMLContext);
                break;
            }
            case 1: {
                this.jj_consume_token(1);
                break;
            }
            case 7: 
            case 15: 
            case 16: 
            case 17: {
                this.element(xMLContext);
                break;
            }
            case 3: {
                this.jj_consume_token(3);
                break;
            }
            case 2: {
                this.jj_consume_token(2);
                break;
            }
            case 4: {
                this.saxEx();
                break;
            }
            default: {
                this.jj_la1[63] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void startElement() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 7: {
                this.jj_consume_token(7);
                break;
            }
            case 16: {
                this.jj_consume_token(16);
                break;
            }
            case 15: {
                this.jj_consume_token(15);
                break;
            }
            case 17: {
                this.jj_consume_token(17);
                break;
            }
            default: {
                this.jj_la1[64] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final Token litStartElement() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 7: {
                Token token = this.jj_consume_token(7);
                return token;
            }
            case 16: {
                Token token = this.jj_consume_token(16);
                return token;
            }
            case 15: {
                Token token = this.jj_consume_token(15);
                return token;
            }
            case 17: {
                Token token = this.jj_consume_token(17);
                return token;
            }
            case 5: {
                Token token = this.jj_consume_token(5);
                return token;
            }
        }
        this.jj_la1[65] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Token litAttrName() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 9: {
                Token token = this.jj_consume_token(9);
                return token;
            }
            case 8: {
                Token token = this.jj_consume_token(8);
                return token;
            }
            case 12: {
                Token token = this.jj_consume_token(12);
                return token;
            }
            case 18: {
                Token token = this.jj_consume_token(18);
                return token;
            }
            case 24: {
                Token token = this.jj_consume_token(24);
                return token;
            }
            case 10: {
                Token token = this.jj_consume_token(10);
                return token;
            }
            case 13: {
                Token token = this.jj_consume_token(13);
                return token;
            }
            case 23: {
                Token token = this.jj_consume_token(23);
                return token;
            }
            case 14: {
                Token token = this.jj_consume_token(14);
                return token;
            }
            case 27: {
                Token token = this.jj_consume_token(27);
                return token;
            }
            case 28: {
                Token token = this.jj_consume_token(28);
                return token;
            }
            case 25: {
                Token token = this.jj_consume_token(25);
                return token;
            }
        }
        this.jj_la1[66] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final void attrName() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 9: {
                this.jj_consume_token(9);
                break;
            }
            case 8: {
                this.jj_consume_token(8);
                break;
            }
            case 12: {
                this.jj_consume_token(12);
                break;
            }
            case 18: {
                this.jj_consume_token(18);
                break;
            }
            case 13: {
                this.jj_consume_token(13);
                break;
            }
            case 23: {
                this.jj_consume_token(23);
                break;
            }
            case 14: {
                this.jj_consume_token(14);
                break;
            }
            case 10: {
                this.jj_consume_token(10);
                break;
            }
            case 24: {
                this.jj_consume_token(24);
                break;
            }
            default: {
                this.jj_la1[67] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final Token attrValue() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 11: {
                Token token = this.jj_consume_token(11);
                return token;
            }
            case 19: {
                Token token = this.jj_consume_token(19);
                return token;
            }
            case 20: {
                Token token = this.jj_consume_token(20);
                return token;
            }
            case 22: {
                Token token = this.jj_consume_token(22);
                return token;
            }
        }
        this.jj_la1[68] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final void litElement(StringBuffer stringBuffer, Map map, Map map2) throws ParseException {
        TreeMap treeMap = new TreeMap();
        TreeMap treeMap2 = new TreeMap();
        Token token = this.litStartElement();
        this.X.startLitElement(stringBuffer, token, treeMap);
        token = (Token)token.clone();
        token.next = null;
        this.startAttr = this.getToken(1);
        block12: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 29: {
                    break;
                }
                default: {
                    this.jj_la1[69] = this.jj_gen;
                    break block12;
                }
            }
            this.nowarning();
        }
        block13: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 26: {
                    break;
                }
                default: {
                    this.jj_la1[70] = this.jj_gen;
                    break block13;
                }
            }
            map = this.litXmlns(map, treeMap);
        }
        block14: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 8: 
                case 9: 
                case 10: 
                case 12: 
                case 13: 
                case 14: 
                case 18: 
                case 23: 
                case 24: 
                case 25: 
                case 27: 
                case 28: {
                    break;
                }
                default: {
                    this.jj_la1[71] = this.jj_gen;
                    break block14;
                }
            }
            this.litAttr(treeMap2, treeMap);
        }
        map2 = this.X.litAttributes(stringBuffer, treeMap2, treeMap, map2, map, token);
        stringBuffer.append('>');
        block15: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 7: 
                case 15: 
                case 16: 
                case 17: {
                    break;
                }
                default: {
                    this.jj_la1[72] = this.jj_gen;
                    break block15;
                }
            }
            this.litContent(stringBuffer, map, map2);
        }
        this.jj_consume_token(6);
        this.X.endLitElement(stringBuffer, token);
    }

    public final Map litXmlns(Map map, Map map2) throws ParseException {
        Token token = this.jj_consume_token(26);
        Token token2 = this.jj_consume_token(11);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 29: {
                    break;
                }
                default: {
                    this.jj_la1[73] = this.jj_gen;
                    break block3;
                }
            }
            this.nowarning();
        }
        return this.X.litNamespace(token, token2, map, map2);
    }

    public final void litAttr(Map map, Map map2) throws ParseException {
        Token token = this.litAttrName();
        String string = this.X.litAttrName(token, map2);
        Token token2 = this.attrValue();
        map.put(string, this.X.litAttribute(token, token2));
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 29: {
                    break;
                }
                default: {
                    this.jj_la1[74] = this.jj_gen;
                    break block3;
                }
            }
            this.nowarning();
        }
    }

    public final void litContent(StringBuffer stringBuffer, Map map, Map map2) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 1: {
                Token token = this.jj_consume_token(1);
                this.X.litText(stringBuffer, token);
                break;
            }
            case 3: {
                Token token = this.jj_consume_token(3);
                this.X.litComment(stringBuffer, token);
                break;
            }
            case 2: {
                Token token = this.jj_consume_token(2);
                this.X.litProcessingInstruction(stringBuffer, token);
                break;
            }
            case 5: 
            case 7: 
            case 15: 
            case 16: 
            case 17: {
                this.litElement(stringBuffer, map, map2);
                break;
            }
            case 4: {
                this.saxEx();
                break;
            }
            default: {
                this.jj_la1[75] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final String litValue(Map map, Location location) throws ParseException {
        StringBuffer stringBuffer = new StringBuffer();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 7: 
                case 15: 
                case 16: 
                case 17: {
                    break;
                }
                default: {
                    this.jj_la1[76] = this.jj_gen;
                    break block3;
                }
            }
            this.litContent(stringBuffer, map, ParserSupport.xmlNameSpace());
        }
        String string = stringBuffer.toString();
        this.X.checkEncoding(string, location);
        return string;
    }

    void error_recovery(ParseException parseException) throws ParseException, ParseException {
        parseException.setStartAttribute(this.startAttr);
        try {
            this.arp.userError(parseException);
        }
        catch (SAXException sAXException) {
            if (sAXException == parseException) {
                parseException.setFatal(true);
                throw parseException;
            }
            throw new WrappedException(sAXException);
        }
        if (parseException.getFatal()) {
            throw parseException;
        }
        int n = 1;
        do {
            Token token = this.getNextToken();
            switch (token.kind) {
                case 0: {
                    ParseException parseException2 = new ParseException(300, "Error recovery failed.");
                    parseException2.setFatal(true);
                    throw parseException2;
                }
                case 6: {
                    --n;
                    break;
                }
                case 4: {
                    this.X.saxException(token);
                    break;
                }
                case 29: {
                    this.arp.parseWarning((Warn)token);
                    break;
                }
                case 5: 
                case 7: 
                case 15: 
                case 16: 
                case 17: {
                    ++n;
                }
            }
        } while (n > 0);
    }

    private final boolean jj_2_1(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean bl = !this.jj_3_1();
        this.jj_save(0, n);
        return bl;
    }

    private final boolean jj_2_2(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean bl = !this.jj_3_2();
        this.jj_save(1, n);
        return bl;
    }

    private final boolean jj_2_3(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean bl = !this.jj_3_3();
        this.jj_save(2, n);
        return bl;
    }

    private final boolean jj_2_4(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean bl = !this.jj_3_4();
        this.jj_save(3, n);
        return bl;
    }

    private final boolean jj_3R_47() {
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_3() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(21)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_49() {
        if (this.jj_scan_token(4)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_1() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(19)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_48() {
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_2() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(20)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_45() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_46()) {
            this.jj_scanpos = token;
            if (this.jj_3R_47()) {
                this.jj_scanpos = token;
                if (this.jj_3R_48()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_49()) {
                        return true;
                    }
                    if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                        return false;
                    }
                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_46() {
        if (this.jj_scan_token(1)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_4() {
        Token token;
        block3: {
            do {
                token = this.jj_scanpos;
                if (this.jj_3R_45()) break block3;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = token;
        if (this.jj_scan_token(6)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    public RDFParser(TokenManager tokenManager) {
        int n;
        this.token_source = tokenManager;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 77; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public void ReInit(TokenManager tokenManager) {
        int n;
        this.token_source = tokenManager;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 77; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    private final Token jj_consume_token(int n) throws ParseException {
        Token token = this.token;
        this.token = token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == n) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls jJCalls = this.jj_2_rtns[i];
                    while (jJCalls != null) {
                        if (jJCalls.gen < this.jj_gen) {
                            jJCalls.first = null;
                        }
                        jJCalls = jJCalls.next;
                    }
                }
            }
            return this.token;
        }
        this.token = token;
        this.jj_kind = n;
        throw this.generateParseException();
    }

    private final boolean jj_scan_token(int n) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int n2 = 0;
            Token token = this.token;
            while (token != null && token != this.jj_scanpos) {
                ++n2;
                token = token.next;
            }
            if (token != null) {
                this.jj_add_error_token(n, n2);
            }
        }
        return this.jj_scanpos.kind != n;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int n) {
        Token token = this.lookingAhead ? this.jj_scanpos : this.token;
        for (int i = 0; i < n; ++i) {
            token = token.next != null ? token.next : (token.next = this.token_source.getNextToken());
        }
        return token;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int n, int n2) {
        if (n2 >= 100) {
            return;
        }
        if (n2 == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = n;
        } else if (this.jj_endpos != 0) {
            int n4;
            this.jj_expentry = new int[this.jj_endpos];
            for (n4 = 0; n4 < this.jj_endpos; ++n4) {
                this.jj_expentry[n4] = this.jj_lasttokens[n4];
            }
            n4 = 0;
            Enumeration enumeration = this.jj_expentries.elements();
            while (enumeration.hasMoreElements()) {
                int[] nArray = (int[])enumeration.nextElement();
                if (nArray.length != this.jj_expentry.length) continue;
                n4 = 1;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (nArray[i] == this.jj_expentry[i]) continue;
                    n4 = 0;
                    break;
                }
                if (n4 == 0) continue;
            }
            if (n4 == 0) {
                this.jj_expentries.addElement(this.jj_expentry);
            }
            if (n2 != 0) {
                this.jj_endpos = n2;
                this.jj_lasttokens[this.jj_endpos - 1] = n;
            }
        }
    }

    public final ParseException generateParseException() {
        int n;
        int n2;
        this.jj_expentries.removeAllElements();
        boolean[] blArray = new boolean[30];
        for (n2 = 0; n2 < 30; ++n2) {
            blArray[n2] = false;
        }
        if (this.jj_kind >= 0) {
            blArray[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (n2 = 0; n2 < 77; ++n2) {
            if (this.jj_la1[n2] != this.jj_gen) continue;
            for (n = 0; n < 32; ++n) {
                if ((this.jj_la1_0[n2] & 1 << n) == 0) continue;
                blArray[n] = true;
            }
        }
        for (n2 = 0; n2 < 30; ++n2) {
            if (!blArray[n2]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = n2;
            this.jj_expentries.addElement(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] nArrayArray = new int[this.jj_expentries.size()][];
        for (n = 0; n < this.jj_expentries.size(); ++n) {
            nArrayArray[n] = (int[])this.jj_expentries.elementAt(n);
        }
        return new ParseException(this.token, nArrayArray, RDFParserConstants.tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private final void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 4; ++i) {
            JJCalls jJCalls = this.jj_2_rtns[i];
            do {
                if (jJCalls.gen <= this.jj_gen) continue;
                this.jj_la = jJCalls.arg;
                this.jj_lastpos = this.jj_scanpos = jJCalls.first;
                switch (i) {
                    case 0: {
                        this.jj_3_1();
                        break;
                    }
                    case 1: {
                        this.jj_3_2();
                        break;
                    }
                    case 2: {
                        this.jj_3_3();
                        break;
                    }
                    case 3: {
                        this.jj_3_4();
                    }
                }
            } while ((jJCalls = jJCalls.next) != null);
        }
        this.jj_rescan = false;
    }

    private final void jj_save(int n, int n2) {
        JJCalls jJCalls = this.jj_2_rtns[n];
        while (jJCalls.gen > this.jj_gen) {
            if (jJCalls.next == null) {
                jJCalls = jJCalls.next = new JJCalls();
                break;
            }
            jJCalls = jJCalls.next;
        }
        jJCalls.gen = this.jj_gen + n2 - this.jj_la;
        jJCalls.first = this.token;
        jJCalls.arg = n2;
    }

    static {
        RDFParserConstants.tokenImage[9] = "attribute rdf:about";
        RDFParserConstants.tokenImage[8] = "attribute rdf:ID";
        RDFParserConstants.tokenImage[10] = "attribute rdf:nodeID";
        RDFParserConstants.tokenImage[12] = "property attributes";
        RDFParserConstants.tokenImage[18] = "rdf:parseType";
        RDFParserConstants.tokenImage[23] = "attribute rdf:resource";
        RDFParserConstants.tokenImage[14] = "attribute rdf:type";
        RDFParserConstants.tokenImage[24] = "attribute rdf:datatype";
        RDFParserConstants.tokenImage[13] = "attribute rdf:rdf_NNN";
        RDFParserConstants.tokenImage[28] = "attribute xml:lang";
        RDFParserConstants.tokenImage[25] = "attribute xml:space";
        RDFParserConstants.tokenImage[27] = "attribute xml:base";
        RDFParserConstants.tokenImage[22] = "'Resource'";
        RDFParserConstants.tokenImage[19] = "'Literal'";
        RDFParserConstants.tokenImage[11] = "attribute value";
        RDFParserConstants.tokenImage[1] = "XML ELEMENT CONTENT";
        RDFParserConstants.tokenImage[7] = "start element rdf:Description";
        RDFParserConstants.tokenImage[6] = "end element tag";
        RDFParserConstants.tokenImage[16] = "start element rdf:li";
        RDFParserConstants.tokenImage[15] = "general start element tag";
        RDFParserConstants.tokenImage[5] = "start element rdf:RDF";
        RDFParserConstants.tokenImage[17] = "start element rdf:rdf_NNN";
        RDFParserConstants.tokenImage[20] = "'daml:collection'";
        RDFParserConstants.tokenImage[21] = "'Collection'";
        RDFParserConstants.tokenImage[3] = "XML comment";
        RDFParserConstants.tokenImage[2] = "processing instruction";
        RDFParserConstants.tokenImage[26] = "namespace declaration";
        RDFParserConstants.tokenImage[29] = "";
        RDFParserConstants.tokenImage[4] = "";
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }
}

