/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.arp.test;

import com.hp.hpl.jena.rdf.arp.ARP;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.oro.text.awk.AwkCompiler;
import org.apache.oro.text.awk.AwkMatcher;
import org.apache.oro.text.regex.MalformedPatternException;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class TestErrorMsg
extends TestCase {
    static AwkCompiler awk = new AwkCompiler();
    static AwkMatcher matcher = new AwkMatcher();
    static /* synthetic */ Class class$com$hp$hpl$jena$rdf$arp$test$TestErrorMsg;

    public TestErrorMsg(String string) {
        super(string);
    }

    public String toString() {
        return this.getName();
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(class$com$hp$hpl$jena$rdf$arp$test$TestErrorMsg == null ? (class$com$hp$hpl$jena$rdf$arp$test$TestErrorMsg = TestErrorMsg.class$("com.hp.hpl.jena.rdf.arp.test.TestErrorMsg")) : class$com$hp$hpl$jena$rdf$arp$test$TestErrorMsg);
        testSuite.setName("ARP Error Messages");
        return testSuite;
    }

    private void check(String string, String string2) throws IOException, MalformedPatternException, SAXException {
        this.check(string, string2, null);
    }

    private void check(String string, String string2, String string3) throws IOException, MalformedPatternException {
        final StringBuffer stringBuffer = new StringBuffer();
        ARP aRP = new ARP();
        aRP.setErrorHandler(new ErrorHandler(){

            public void warning(SAXParseException sAXParseException) {
                stringBuffer.append(sAXParseException.getMessage());
                stringBuffer.append("\n");
            }

            public void error(SAXParseException sAXParseException) {
                this.warning(sAXParseException);
            }

            public void fatalError(SAXParseException sAXParseException) {
                this.warning(sAXParseException);
            }
        });
        FileInputStream fileInputStream = new FileInputStream("testing/arp/error-msgs/" + string + ".rdf");
        try {
            aRP.load(fileInputStream, "file:///" + string);
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        ((InputStream)fileInputStream).close();
        String string4 = stringBuffer.toString();
        if (string2 != null) {
            TestErrorMsg.assertTrue((String)("Should find /" + string2 + "/"), (boolean)matcher.contains(string4, awk.compile(string2)));
        }
        if (string3 != null) {
            TestErrorMsg.assertTrue((String)("Should not find /" + string3 + "/"), (!matcher.contains(string4, awk.compile(string3)) ? 1 : 0) != 0);
        }
        string4 = null;
    }

    public void testErrMsg01() throws Exception {
        this.check("test01", null, "Unusual");
    }

    public void testErrMsg02() throws Exception {
        this.check("test02", "parseType", "Unusual");
    }

    public void testErrMsg03() throws Exception {
        this.check("test03", "parseType", "Unusual");
    }

    public void testErrMsg04a() throws Exception {
        this.check("test04", null, "Unusual");
    }

    public void testErrMsg04b() throws Exception {
        this.check("test04", null, "parseType");
    }

    public void testErrMsg05() throws Exception {
        this.check("test05", null, "Unusual");
    }

    public void testUTF8() throws Exception {
        this.check("testutf8", "UTF", "Unusual");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

