/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.impl;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.impl.InfModelImpl;
import com.hp.hpl.jena.rdf.model.impl.ModelSpecImpl;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerRegistry;
import com.hp.hpl.jena.vocabulary.JMS;

public class InfModelSpec
extends ModelSpecImpl {
    protected Resource reasonerResource;

    public InfModelSpec(Resource resource, Model model) {
        super(InfModelSpec.getMaker(resource, model), model);
        Statement statement = model.getRequiredProperty(null, JMS.reasoner);
        this.reasonerResource = statement.getResource();
    }

    public Model createModel() {
        return this.createModel(this.maker.getGraphMaker().createGraph());
    }

    public Model createModelOver(String string) {
        return this.createModel(this.maker.getGraphMaker().createGraph(string));
    }

    protected Model createModel(Graph graph) {
        String string = this.reasonerResource.getURI();
        Reasoner reasoner = ReasonerRegistry.theRegistry().create(string, null);
        return new InfModelImpl(reasoner.bind(graph));
    }

    public Property getMakerProperty() {
        return JMS.maker;
    }

    public Model addDescription(Model model, Resource resource) {
        super.addDescription(model, resource);
        Resource resource2 = model.createResource();
        model.add(resource, JMS.reasonsWith, resource2);
        model.add(resource2, JMS.reasoner, this.reasonerResource);
        return model;
    }
}

