/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdql.parser;

import com.hp.hpl.jena.rdql.parser.Q_Query;
import com.hp.hpl.jena.rdql.parser.Q_URI;
import com.hp.hpl.jena.rdql.parser.RDQLParser;

public class Q_QuotedURI
extends Q_URI {
    String seen = "";
    boolean isAbsolute = false;
    static final String prefixOperator = ":";

    Q_QuotedURI(int n) {
        super(n);
    }

    Q_QuotedURI(RDQLParser rDQLParser, int n) {
        super(rDQLParser, n);
    }

    void set(String string) {
        this.seen = string;
    }

    public void jjtClose() {
        super.setURI(this.seen);
    }

    public void fixup(Q_Query q_Query) {
        if (!this.isAbsolute) {
            this.absolute(q_Query);
        }
    }

    private void absolute(Q_Query q_Query) {
        if (q_Query == null) {
            this.isAbsolute = true;
            return;
        }
        int n = this.seen.indexOf(prefixOperator);
        if (n < 0) {
            this.isAbsolute = true;
            return;
        }
        String string = this.seen.substring(0, n);
        String string2 = q_Query.getPrefix(string);
        if (string2 == null) {
            this.isAbsolute = true;
            return;
        }
        String string3 = this.seen.substring(n + prefixOperator.length());
        super.setURI(string2 + string3);
        this.isAbsolute = true;
    }

    public static Q_URI makeURI(String string) {
        Q_URI q_URI = new Q_URI(0);
        q_URI.setURI(string);
        return q_URI;
    }

    public String asQuotedString() {
        return "<" + this.seen + ">";
    }

    public String asUnquotedString() {
        return this.seen;
    }

    public String valueString() {
        return super.getURI();
    }

    public String toString() {
        return this.seen;
    }
}

