/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.dig;

import com.hp.hpl.jena.reasoner.dig.DIGConnectionPool;
import com.hp.hpl.jena.reasoner.dig.DIGErrorResponseException;
import com.hp.hpl.jena.reasoner.dig.DIGProfile;
import com.hp.hpl.jena.reasoner.dig.DIGReasonerException;
import com.hp.hpl.jena.reasoner.dig.DIGWrappedException;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringBufferInputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DIGConnection {
    public static final String DEFAULT_REASONER_URL = "http://localhost:8081";
    public static final String XSI = "http://www.w3.org/2001/XMLSchema-instance";
    protected String m_extReasonerURL = "http://localhost:8081";
    private String m_kbURI;
    protected DocumentBuilderFactory m_factory = DocumentBuilderFactory.newInstance();
    private List m_warnings = new ArrayList();
    protected boolean m_logCommunications = true;

    public Document sendDigVerb(Document document, DIGProfile dIGProfile) {
        try {
            Element element = document.getDocumentElement();
            if (!element.hasAttribute("uri")) {
                element.setAttribute("uri", this.m_kbURI);
            }
            URL uRL = new URL(this.m_extReasonerURL);
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            StringWriter stringWriter = new StringWriter();
            this.serialiseDocument(document, stringWriter);
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setRequestProperty("Content-Length", Integer.toString(stringWriter.getBuffer().length()));
            httpURLConnection.setRequestProperty("Content-Type", dIGProfile.getContentType());
            this.logMessage(true, document);
            httpURLConnection.connect();
            PrintStream printStream = new PrintStream(httpURLConnection.getOutputStream());
            printStream.print(stringWriter.getBuffer());
            printStream.flush();
            printStream.close();
            Document document2 = this.getDigResponse(httpURLConnection);
            this.logMessage(false, document2);
            this.errorCheck(document2);
            return document2;
        }
        catch (IOException iOException) {
            throw new DIGWrappedException(iOException);
        }
    }

    public void serialiseDocument(Document document, Writer writer) {
        try {
            XMLSerializer xMLSerializer = new XMLSerializer(writer, this.createXMLFormatter(document));
            xMLSerializer.asDOMSerializer();
            xMLSerializer.serialize(document);
        }
        catch (IOException iOException) {
            throw new DIGWrappedException(iOException);
        }
    }

    public void bindKB(boolean bl, DIGProfile dIGProfile) {
        Node node;
        Document document;
        if (bl && this.m_kbURI != null) {
            document = this.createDigVerb("releaseKB", dIGProfile);
            node = this.sendDigVerb(document, dIGProfile);
            this.errorCheck((Document)node);
            if (this.warningCheck((Document)node)) {
                LogFactory.getLog(this.getClass()).warn((Object)("DIG reasoner warning: " + this.getWarnings().next()));
            }
            this.m_kbURI = null;
        }
        if (this.m_kbURI == null) {
            document = this.sendDigVerb(this.createDigVerb("newKB", dIGProfile), dIGProfile);
            this.errorCheck(document);
            node = (Element)document.getDocumentElement().getElementsByTagName("kb").item(0);
            if (node == null) {
                throw new DIGReasonerException("Could not locate DIG KB identifier in return value from newKB");
            }
            this.m_kbURI = node.getAttribute("uri");
        }
    }

    public void errorCheck(Document document) {
        Element element = document.getDocumentElement();
        NodeList nodeList = element.getElementsByTagName("error");
        if (nodeList != null && nodeList.getLength() > 0) {
            Element element2 = (Element)nodeList.item(0);
            String string = element2.getAttribute("code");
            int n = string == null || string.length() == 0 ? 0 : Integer.parseInt(string);
            String string2 = element2.getAttribute("message");
            NodeList nodeList2 = element2.getChildNodes();
            String string3 = nodeList2.getLength() > 0 ? ((Text)nodeList2.item(0)).getNodeValue().trim() : "(no message)";
            throw new DIGErrorResponseException(string3, string2, n);
        }
    }

    public boolean warningCheck(Document document) {
        Element element;
        NodeList nodeList;
        Element element2 = document.getDocumentElement();
        NodeList nodeList2 = element2.getElementsByTagName("ok");
        this.m_warnings.clear();
        if (nodeList2 != null && nodeList2.getLength() > 0 && (nodeList = (element = (Element)nodeList2.item(0)).getElementsByTagName("warning")) != null && nodeList.getLength() > 0) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element3 = (Element)nodeList.item(i);
                this.m_warnings.add(element3.getAttribute("message"));
            }
            return true;
        }
        return false;
    }

    public Iterator getWarnings() {
        return this.m_warnings.iterator();
    }

    public void release() {
        DIGConnectionPool.getInstance().release(this);
    }

    public String getReasonerURL() {
        return this.m_extReasonerURL;
    }

    public void setReasonerURL(String string) {
        this.m_extReasonerURL = string;
        this.m_kbURI = null;
    }

    protected Document getDigResponse(HttpURLConnection httpURLConnection) {
        try {
            if (httpURLConnection.getResponseCode() != 200) {
                throw new DIGReasonerException("DIG reasoner returned failure code " + httpURLConnection.getResponseCode() + ": " + httpURLConnection.getResponseMessage());
            }
            BufferedInputStream bufferedInputStream = new BufferedInputStream(httpURLConnection.getInputStream());
            StringBuffer stringBuffer = new StringBuffer();
            int n = bufferedInputStream.read();
            while (n > 0) {
                stringBuffer.append((char)n);
                n = bufferedInputStream.read();
            }
            DocumentBuilder documentBuilder = this.m_factory.newDocumentBuilder();
            return documentBuilder.parse(new StringBufferInputStream(stringBuffer.toString()));
        }
        catch (Exception exception) {
            throw new DIGWrappedException(exception);
        }
    }

    protected OutputFormat createXMLFormatter(Document document) {
        OutputFormat outputFormat = new OutputFormat(document);
        outputFormat.setIndenting(true);
        outputFormat.setLineWidth(0);
        outputFormat.setPreserveSpace(false);
        return outputFormat;
    }

    protected Document createDigVerb(String string, DIGProfile dIGProfile) {
        try {
            DocumentBuilder documentBuilder = this.m_factory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element element = document.createElementNS(dIGProfile.getDIGNamespace(), string);
            document.appendChild(element);
            element.setAttribute("xmlns", dIGProfile.getDIGNamespace());
            element.setAttribute("xmlns:xsi", XSI);
            element.setAttributeNS(XSI, "xsi:schemaLocation", dIGProfile.getDIGNamespace() + " " + dIGProfile.getSchemaLocation());
            if (this.m_kbURI != null) {
                element.setAttribute("uri", this.m_kbURI);
            }
            return document;
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            throw new DIGWrappedException(factoryConfigurationError);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new DIGWrappedException(parserConfigurationException);
        }
    }

    protected void logMessage(boolean bl, Document document) {
        if (this.m_logCommunications) {
            StringWriter stringWriter = new StringWriter();
            this.serialiseDocument(document, stringWriter);
            LogFactory.getLog(this.getClass()).debug((Object)(bl ? "Sending to DIG reasoner ..." : "Received from DIG reasoner ..."));
            LogFactory.getLog(this.getClass()).debug((Object)stringWriter);
        }
    }
}

