/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.dig;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.compose.MultiUnion;
import com.hp.hpl.jena.reasoner.BaseInfGraph;
import com.hp.hpl.jena.reasoner.FGraph;
import com.hp.hpl.jena.reasoner.Finder;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.dig.DIGAdapter;
import com.hp.hpl.jena.reasoner.dig.DIGConnection;
import com.hp.hpl.jena.reasoner.dig.DIGConnectionPool;
import com.hp.hpl.jena.reasoner.dig.DIGReasoner;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;

public class DIGInfGraph
extends BaseInfGraph {
    protected DIGAdapter m_adapter;

    public DIGInfGraph(Graph graph, DIGReasoner dIGReasoner) {
        super(graph, dIGReasoner);
        if (dIGReasoner.getSchema() != null) {
            this.fdata = new FGraph(new MultiUnion(new Graph[]{graph, dIGReasoner.getSchema()}));
        }
        DIGConnection dIGConnection = DIGConnectionPool.getInstance().allocate(dIGReasoner.getReasonerURL());
        this.m_adapter = new DIGAdapter(dIGReasoner.getOntLangModelSpec(), this.fdata.getGraph(), dIGConnection);
    }

    public void prepare() {
        if (!this.isPrepared) {
            this.m_adapter.resetKB();
            this.m_adapter.uploadKB();
            this.isPrepared = true;
        }
    }

    public ExtendedIterator findWithContinuation(TriplePattern triplePattern, Finder finder) {
        this.prepare();
        ExtendedIterator extendedIterator = this.m_adapter.find(triplePattern);
        return finder == null ? extendedIterator : extendedIterator.andThen(finder.find(triplePattern));
    }

    public Graph getSchemaGraph() {
        return ((DIGReasoner)this.reasoner).getSchema();
    }

    public void rebind(Graph graph) {
        this.fdata = this.getSchemaGraph() == null ? new FGraph(graph) : new FGraph(new MultiUnion(new Graph[]{graph, this.getSchemaGraph()}));
        this.isPrepared = false;
    }

    public void setDerivationLogging(boolean bl) {
        throw new UnsupportedOperationException("Cannot set derivation logging on DIG reasoner");
    }
}

