/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.dig;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.dig.DIGAdapter;
import com.hp.hpl.jena.reasoner.dig.DIGConnection;
import com.hp.hpl.jena.reasoner.dig.DIGValueToNodeMapper;
import com.hp.hpl.jena.reasoner.dig.TripleObjectFiller;
import com.hp.hpl.jena.reasoner.dig.TripleSubjectFiller;
import com.hp.hpl.jena.reasoner.rulesys.Node_RuleVariable;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.xml.SimpleXMLPath;
import java.util.Iterator;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;

public abstract class DIGQueryTranslator {
    public static final String ALL = "*";
    private Node m_subject;
    private Node m_object;
    private Node m_pred;

    public DIGQueryTranslator(String string, String string2, String string3) {
        this.m_subject = this.mapNode(string);
        this.m_pred = this.mapNode(string2);
        this.m_object = this.mapNode(string3);
    }

    public ExtendedIterator find(TriplePattern triplePattern, DIGAdapter dIGAdapter) {
        Document document;
        boolean bl;
        DIGConnection dIGConnection = dIGAdapter.getConnection();
        Document document2 = this.translatePattern(triplePattern, dIGAdapter);
        if (document2 == null) {
            LogFactory.getLog(this.getClass()).warn((Object)("Could not find pattern translator for nested DIG query " + triplePattern));
        }
        if (bl = dIGConnection.warningCheck(document = dIGAdapter.getConnection().sendDigVerb(document2, dIGAdapter.getProfile()))) {
            Iterator iterator = dIGConnection.getWarnings();
            while (iterator.hasNext()) {
                LogFactory.getLog(this.getClass()).warn(iterator.next());
            }
        }
        return this.translateResponse(document, triplePattern, dIGAdapter);
    }

    public boolean trigger(TriplePattern triplePattern, DIGAdapter dIGAdapter) {
        return this.trigger(this.m_subject, triplePattern.getSubject()) && this.trigger(this.m_object, triplePattern.getObject()) && this.trigger(this.m_pred, triplePattern.getPredicate()) && this.checkSubject(triplePattern.getSubject(), dIGAdapter) && this.checkObject(triplePattern.getObject(), dIGAdapter) && this.checkPredicate(triplePattern.getPredicate(), dIGAdapter);
    }

    public boolean checkSubject(Node node, DIGAdapter dIGAdapter) {
        return true;
    }

    public boolean checkObject(Node node, DIGAdapter dIGAdapter) {
        return true;
    }

    public boolean checkPredicate(Node node, DIGAdapter dIGAdapter) {
        return true;
    }

    public abstract Document translatePattern(TriplePattern var1, DIGAdapter var2);

    public abstract ExtendedIterator translateResponse(Document var1, TriplePattern var2, DIGAdapter var3);

    protected Node mapNode(String string) {
        if (string == null) {
            return null;
        }
        return string.equals(ALL) ? Node_RuleVariable.WILD : Node.createURI(string);
    }

    protected boolean trigger(Node node, Node node2) {
        return node == null || node.equals(node2);
    }

    protected boolean isTrue(Document document) {
        return new SimpleXMLPath(true).appendElementPath("true").getAll(document).hasNext();
    }

    protected boolean isFalse(Document document) {
        return new SimpleXMLPath(true).appendElementPath("false").getAll(document).hasNext();
    }

    protected ExtendedIterator translateConceptSetResponse(Document document, TriplePattern triplePattern, boolean bl) {
        return this.translateNameSetResponse(document, triplePattern, bl, new String[]{"conceptSet", "synonyms", "catom"});
    }

    protected ExtendedIterator translateRoleSetResponse(Document document, TriplePattern triplePattern, boolean bl) {
        return this.translateNameSetResponse(document, triplePattern, bl, new String[]{"roleSet", "synonyms", "ratom"});
    }

    protected ExtendedIterator translateIndividualSetResponse(Document document, TriplePattern triplePattern, boolean bl) {
        return this.translateNameSetResponse(document, triplePattern, bl, new String[]{"individualSet", "individual"});
    }

    protected ExtendedIterator translateNameSetResponse(Document document, TriplePattern triplePattern, boolean bl, String[] stringArray) {
        SimpleXMLPath simpleXMLPath = new SimpleXMLPath(true);
        for (int i = 0; i < stringArray.length; ++i) {
            simpleXMLPath.appendElementPath(stringArray[i]);
        }
        simpleXMLPath.appendAttrPath("name");
        ExtendedIterator extendedIterator = simpleXMLPath.getAll(document).mapWith(new DIGValueToNodeMapper());
        if (bl) {
            return extendedIterator.mapWith(new TripleObjectFiller(triplePattern.getSubject(), triplePattern.getPredicate()));
        }
        return extendedIterator.mapWith(new TripleSubjectFiller(triplePattern.getPredicate(), triplePattern.getObject()));
    }
}

