/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.dig;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.ontology.ProfileRegistry;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.reasoner.IllegalParameterException;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerFactory;
import com.hp.hpl.jena.reasoner.dig.DIGInfGraph;
import com.hp.hpl.jena.reasoner.rulesys.Util;
import com.hp.hpl.jena.vocabulary.ReasonerVocabulary;

public class DIGReasoner
implements Reasoner {
    protected Graph m_tbox;
    protected ReasonerFactory m_factory;
    protected Resource m_configuration;
    protected String m_extReasonerURL = "http://localhost:8081";
    protected OntModelSpec m_ontLang = this.getModelSpec(ProfileRegistry.OWL_LANG);

    public DIGReasoner(Graph graph, ReasonerFactory reasonerFactory, Resource resource) {
        this.m_tbox = graph;
        this.m_factory = reasonerFactory;
        this.m_configuration = resource;
        this.configure(resource);
    }

    public Reasoner bindSchema(Graph graph) {
        return new DIGReasoner(graph, this.m_factory, this.m_configuration);
    }

    public Reasoner bindSchema(Model model) {
        return this.bindSchema(model.getGraph());
    }

    public InfGraph bind(Graph graph) {
        return new DIGInfGraph(graph, this);
    }

    public void setDerivationLogging(boolean bl) {
        throw new UnsupportedOperationException("DIG reasoner does not support derivation logging");
    }

    public Model getCapabilities() {
        return this.m_factory == null ? null : this.m_factory.getCapabilities();
    }

    public void addDescription(Model model, Resource resource) {
        if (this.m_configuration != null) {
            StmtIterator stmtIterator = this.m_configuration.listProperties();
            while (stmtIterator.hasNext()) {
                Statement statement = stmtIterator.nextStatement();
                model.add(resource, statement.getPredicate(), statement.getObject());
            }
        }
    }

    public boolean supportsProperty(Property property) {
        if (this.m_factory == null) {
            return false;
        }
        Model model = this.m_factory.getCapabilities();
        Resource resource = model.getResource(this.m_factory.getURI());
        return model.contains(resource, ReasonerVocabulary.supportsP, property);
    }

    public void setParameter(Property property, Object object) {
        if (!this.doSetParameter(property, object)) {
            throw new IllegalParameterException("DIGReasoner does not recognize configuration parameter " + property);
        }
        if (this.m_configuration == null) {
            Model model = ModelFactory.createDefaultModel();
            this.m_configuration = model.createResource();
        }
        Util.updateParameter(this.m_configuration, property, object);
    }

    public void configure(Resource resource) {
        if (resource != null) {
            StmtIterator stmtIterator = resource.listProperties();
            while (stmtIterator.hasNext()) {
                Statement statement = stmtIterator.nextStatement();
                if (this.doSetParameter(statement.getPredicate(), statement.getObject())) continue;
                throw new IllegalParameterException("DIGReasoner does not recognize configuration parameter " + statement.getPredicate());
            }
        }
    }

    public String getReasonerURL() {
        return this.m_extReasonerURL;
    }

    public OntModelSpec getOntLangModelSpec() {
        return this.m_ontLang;
    }

    public Graph getSchema() {
        return this.m_tbox;
    }

    protected boolean doSetParameter(Property property, Object object) {
        if (property.equals(ReasonerVocabulary.EXT_REASONER_URL)) {
            this.m_extReasonerURL = object instanceof Resource ? ((Resource)object).getURI() : object.toString();
            return true;
        }
        if (property.equals(ReasonerVocabulary.EXT_REASONER_ONT_LANG)) {
            String string = object instanceof Resource ? ((Resource)object).getURI() : object.toString();
            this.m_ontLang = this.getModelSpec(string);
            return true;
        }
        return false;
    }

    protected OntModelSpec getModelSpec(String string) {
        if (string.equals(ProfileRegistry.OWL_LANG) || string.equals("http://www.w3.org/TR/owl-features/#term_OWLDL") || string.equals("http://www.w3.org/TR/owl-features/#term_OWLLite")) {
            return OntModelSpec.OWL_MEM;
        }
        if (string.equals("http://www.daml.org/2001/03/daml+oil#")) {
            return OntModelSpec.DAML_MEM;
        }
        if (string.equals(ProfileRegistry.RDFS_LANG)) {
            return OntModelSpec.RDFS_MEM;
        }
        throw new IllegalParameterException("DIG reasoner did not recognise ontology language " + string);
    }
}

