/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.impl;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.reasoner.Finder;
import com.hp.hpl.jena.reasoner.ReasonerException;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.rulesys.Builtin;
import com.hp.hpl.jena.reasoner.rulesys.ClauseEntry;
import com.hp.hpl.jena.reasoner.rulesys.ForwardRuleInfGraphI;
import com.hp.hpl.jena.reasoner.rulesys.Functor;
import com.hp.hpl.jena.reasoner.rulesys.Node_RuleVariable;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import com.hp.hpl.jena.reasoner.rulesys.impl.FRuleEngineI;
import com.hp.hpl.jena.reasoner.rulesys.impl.RETEClauseFilter;
import com.hp.hpl.jena.reasoner.rulesys.impl.RETENode;
import com.hp.hpl.jena.reasoner.rulesys.impl.RETEQueue;
import com.hp.hpl.jena.reasoner.rulesys.impl.RETERuleContext;
import com.hp.hpl.jena.reasoner.rulesys.impl.RETESinkNode;
import com.hp.hpl.jena.reasoner.rulesys.impl.RETETerminal;
import com.hp.hpl.jena.util.OneToManyMap;
import com.hp.hpl.jena.util.PrintUtil;
import com.hp.hpl.jena.util.iterator.ConcatenatedIterator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RETEEngine
implements FRuleEngineI {
    protected ForwardRuleInfGraphI infGraph;
    protected List rules;
    protected OneToManyMap clauseIndex;
    protected List addsPending = new ArrayList();
    protected List deletesPending = new ArrayList();
    protected HashSet predicatesUsed;
    protected boolean wildcardRule;
    protected boolean recordDerivations;
    long nRulesFired = 0L;
    boolean processedAxioms = false;
    protected static Log logger = LogFactory.getLog((Class)(class$com$hp$hpl$jena$reasoner$rulesys$impl$FRuleEngine == null ? (class$com$hp$hpl$jena$reasoner$rulesys$impl$FRuleEngine = RETEEngine.class$("com.hp.hpl.jena.reasoner.rulesys.impl.FRuleEngine")) : class$com$hp$hpl$jena$reasoner$rulesys$impl$FRuleEngine));
    static /* synthetic */ Class class$com$hp$hpl$jena$reasoner$rulesys$impl$FRuleEngine;

    public RETEEngine(ForwardRuleInfGraphI forwardRuleInfGraphI, List list) {
        this.infGraph = forwardRuleInfGraphI;
        this.rules = list;
    }

    public RETEEngine(ForwardRuleInfGraphI forwardRuleInfGraphI) {
        this.infGraph = forwardRuleInfGraphI;
    }

    public void init(boolean bl, Finder finder) {
        this.compile(this.rules, bl);
        this.findAndProcessAxioms();
        this.fastInit(finder);
    }

    public void fastInit(Finder finder) {
        this.findAndProcessActions();
        if (this.infGraph.getRawGraph() != null) {
            if (this.wildcardRule) {
                ExtendedIterator extendedIterator = finder.find(new TriplePattern(null, null, null));
                while (extendedIterator.hasNext()) {
                    this.addTriple((Triple)extendedIterator.next(), false);
                }
            } else {
                Iterator iterator = this.predicatesUsed.iterator();
                while (iterator.hasNext()) {
                    Node node = (Node)iterator.next();
                    ExtendedIterator extendedIterator = finder.find(new TriplePattern(null, node, null));
                    while (extendedIterator.hasNext()) {
                        this.addTriple((Triple)extendedIterator.next(), false);
                    }
                }
            }
        }
        this.runAll();
    }

    public synchronized void add(Triple triple) {
        this.addTriple(triple, false);
        this.runAll();
    }

    public synchronized boolean delete(Triple triple) {
        this.deleteTriple(triple, false);
        this.runAll();
        return true;
    }

    public long getNRulesFired() {
        return this.nRulesFired;
    }

    public boolean shouldTrace() {
        return true;
    }

    public void setDerivationLogging(boolean bl) {
        this.recordDerivations = bl;
    }

    public Object getRuleStore() {
        return new RuleStore(this.clauseIndex, this.predicatesUsed, this.wildcardRule);
    }

    public void setRuleStore(Object object) {
        RuleStore ruleStore = (RuleStore)object;
        this.predicatesUsed = ruleStore.predicatesUsed;
        this.wildcardRule = ruleStore.wildcardRule;
        RETERuleContext rETERuleContext = new RETERuleContext(this.infGraph, this);
        HashMap hashMap = new HashMap();
        this.clauseIndex = new OneToManyMap();
        Iterator iterator = ruleStore.clauseIndex.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            this.clauseIndex.put(entry.getKey(), ((RETENode)entry.getValue()).clone(hashMap, rETERuleContext));
        }
    }

    public void compile(List list, boolean bl) {
        this.clauseIndex = new OneToManyMap();
        this.predicatesUsed = new HashSet();
        this.wildcardRule = false;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Rule rule = (Rule)iterator.next();
            if (bl && rule.isBackward()) continue;
            int n = rule.getNumVars();
            boolean[] blArray = new boolean[n];
            Object object = null;
            for (int i = 0; i < rule.bodyLength(); ++i) {
                ClauseEntry clauseEntry = rule.getBodyElement(i);
                if (!(clauseEntry instanceof TriplePattern)) continue;
                ArrayList arrayList = new ArrayList(n);
                RETEClauseFilter rETEClauseFilter = RETEClauseFilter.compile((TriplePattern)clauseEntry, n, arrayList);
                Node node = ((TriplePattern)clauseEntry).getPredicate();
                if (node.isVariable()) {
                    this.clauseIndex.put(Node.ANY, rETEClauseFilter);
                    this.wildcardRule = true;
                } else {
                    this.clauseIndex.put(node, rETEClauseFilter);
                    if (!this.wildcardRule) {
                        this.predicatesUsed.add(node);
                    }
                }
                ArrayList<Byte> arrayList2 = new ArrayList<Byte>(n);
                Object object2 = arrayList.iterator();
                while (object2.hasNext()) {
                    int n2 = ((Node_RuleVariable)object2.next()).getIndex();
                    if (blArray[n2]) {
                        arrayList2.add(new Byte((byte)n2));
                    }
                    blArray[n2] = true;
                }
                if (object == null) {
                    object = rETEClauseFilter;
                    continue;
                }
                object2 = new RETEQueue(arrayList2);
                RETEQueue rETEQueue = new RETEQueue(arrayList2);
                ((RETEQueue)object2).setSibling(rETEQueue);
                rETEQueue.setSibling((RETEQueue)object2);
                rETEClauseFilter.setContinuation(rETEQueue);
                object.setContinuation((RETESinkNode)object2);
                object = object2;
            }
            if (object == null) continue;
            RETETerminal rETETerminal = new RETETerminal(rule, this, this.infGraph);
            object.setContinuation(rETETerminal);
        }
        if (this.wildcardRule) {
            this.predicatesUsed = null;
        }
    }

    public synchronized void addTriple(Triple triple, boolean bl) {
        if (this.infGraph.shouldTrace()) {
            logger.debug((Object)("Add triple: " + PrintUtil.print(triple)));
        }
        if (this.deletesPending.size() > 0) {
            this.deletesPending.remove(triple);
        }
        this.addsPending.add(triple);
        if (bl) {
            this.infGraph.addDeduction(triple);
        }
    }

    public synchronized void deleteTriple(Triple triple, boolean bl) {
        this.addsPending.remove(triple);
        this.deletesPending.add(triple);
        if (bl) {
            this.infGraph.getDeductionsGraph().delete(triple);
            Graph graph = this.infGraph.getRawGraph();
            graph.delete(triple);
            if (graph.contains(triple)) {
                this.deletesPending.remove(triple);
            }
        }
    }

    protected void incRuleCount() {
        ++this.nRulesFired;
    }

    protected synchronized Triple nextAddTriple() {
        int n = this.addsPending.size();
        if (n > 0) {
            return (Triple)this.addsPending.remove(n - 1);
        }
        return null;
    }

    protected synchronized Triple nextDeleteTriple() {
        int n = this.deletesPending.size();
        if (n > 0) {
            return (Triple)this.deletesPending.remove(n - 1);
        }
        return null;
    }

    public void runAll() {
        block0: while (true) {
            boolean bl = false;
            Triple triple = this.nextDeleteTriple();
            if (triple == null) {
                triple = this.nextAddTriple();
                if (triple == null) {
                    return;
                }
                bl = true;
            }
            if (this.infGraph.shouldTrace()) {
                logger.debug((Object)((bl ? "Inserting" : "Deleting") + " triple: " + PrintUtil.print(triple)));
            }
            Iterator iterator = this.clauseIndex.getAll(triple.getPredicate());
            Iterator iterator2 = this.clauseIndex.getAll(Node.ANY);
            ConcatenatedIterator concatenatedIterator = new ConcatenatedIterator(iterator, iterator2);
            while (true) {
                if (!concatenatedIterator.hasNext()) continue block0;
                RETEClauseFilter rETEClauseFilter = (RETEClauseFilter)concatenatedIterator.next();
                rETEClauseFilter.fire(triple, bl);
            }
            break;
        }
    }

    public void testTripleInsert(Triple triple) {
        Iterator iterator = this.clauseIndex.getAll(triple.getPredicate());
        Iterator iterator2 = this.clauseIndex.getAll(Node.ANY);
        ConcatenatedIterator concatenatedIterator = new ConcatenatedIterator(iterator, iterator2);
        while (concatenatedIterator.hasNext()) {
            RETEClauseFilter rETEClauseFilter = (RETEClauseFilter)concatenatedIterator.next();
            rETEClauseFilter.fire(triple, true);
        }
    }

    protected void findAndProcessAxioms() {
        Iterator iterator = this.rules.iterator();
        while (iterator.hasNext()) {
            Rule rule = (Rule)iterator.next();
            if (rule.bodyLength() != 0) continue;
            for (int i = 0; i < rule.headLength(); ++i) {
                ClauseEntry clauseEntry = rule.getHeadElement(i);
                if (!(clauseEntry instanceof TriplePattern)) continue;
                TriplePattern triplePattern = (TriplePattern)clauseEntry;
                Triple triple = new Triple(triplePattern.getSubject(), triplePattern.getPredicate(), triplePattern.getObject());
                this.addTriple(triple, true);
            }
        }
        this.processedAxioms = true;
    }

    protected void findAndProcessActions() {
        RETERuleContext rETERuleContext = new RETERuleContext(this.infGraph, this);
        Iterator iterator = this.rules.iterator();
        while (iterator.hasNext()) {
            Rule rule = (Rule)iterator.next();
            if (rule.bodyLength() != 0) continue;
            for (int i = 0; i < rule.headLength(); ++i) {
                ClauseEntry clauseEntry = rule.getHeadElement(i);
                if (!(clauseEntry instanceof Functor)) continue;
                Functor functor = (Functor)clauseEntry;
                Builtin builtin = functor.getImplementor();
                if (builtin != null) {
                    rETERuleContext.setRule(rule);
                    builtin.headAction(functor.getArgs(), functor.getArgLength(), rETERuleContext);
                    continue;
                }
                throw new ReasonerException("Invoking undefined Functor " + functor.getName() + " in " + rule.toShortString());
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class RuleStore {
        protected OneToManyMap clauseIndex;
        protected HashSet predicatesUsed;
        protected boolean wildcardRule;

        RuleStore(OneToManyMap oneToManyMap, HashSet hashSet, boolean bl) {
            this.clauseIndex = oneToManyMap;
            this.predicatesUsed = hashSet;
            this.wildcardRule = bl;
        }
    }

    protected static class ClausePointer {
        protected Rule rule;
        protected int index;

        ClausePointer(Rule rule, int n) {
            this.rule = rule;
            this.index = n;
        }

        TriplePattern getClause() {
            return (TriplePattern)this.rule.getBodyElement(this.index);
        }
    }
}

