/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.impl;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.rulesys.BindingEnvironment;
import com.hp.hpl.jena.reasoner.rulesys.ForwardRuleInfGraphI;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import com.hp.hpl.jena.reasoner.rulesys.RuleContext;
import com.hp.hpl.jena.reasoner.rulesys.impl.RETEEngine;
import com.hp.hpl.jena.util.iterator.ClosableIterator;

public class RETERuleContext
implements RuleContext {
    protected BindingEnvironment env;
    protected Rule rule;
    protected ForwardRuleInfGraphI graph;
    protected RETEEngine engine;

    public RETERuleContext(ForwardRuleInfGraphI forwardRuleInfGraphI, RETEEngine rETEEngine) {
        this.graph = forwardRuleInfGraphI;
        this.engine = rETEEngine;
    }

    public BindingEnvironment getEnv() {
        return this.env;
    }

    public InfGraph getGraph() {
        return this.graph;
    }

    public RETEEngine getEngine() {
        return this.engine;
    }

    public Rule getRule() {
        return this.rule;
    }

    public void setRule(Rule rule) {
        this.rule = rule;
    }

    public void setEnv(BindingEnvironment bindingEnvironment) {
        this.env = bindingEnvironment;
    }

    public boolean contains(Triple triple) {
        return this.contains(triple.getSubject(), triple.getPredicate(), triple.getObject());
    }

    public boolean contains(Node node, Node node2, Node node3) {
        ClosableIterator closableIterator = this.find(node, node2, node3);
        boolean bl = closableIterator.hasNext();
        closableIterator.close();
        return bl;
    }

    public ClosableIterator find(Node node, Node node2, Node node3) {
        return this.graph.findDataMatches(node, node2, node3);
    }

    public void silentAdd(Triple triple) {
        this.graph.silentAdd(triple);
    }

    public void remove(Triple triple) {
        this.graph.delete(triple);
        this.engine.deleteTriple(triple, true);
    }

    public void add(Triple triple) {
        this.engine.addTriple(triple, true);
    }
}

