/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.impl.oldCode;

import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.rulesys.BackwardRuleInfGraphI;
import com.hp.hpl.jena.reasoner.rulesys.BindingEnvironment;
import com.hp.hpl.jena.reasoner.rulesys.ClauseEntry;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import com.hp.hpl.jena.reasoner.rulesys.RuleDerivation;
import com.hp.hpl.jena.reasoner.rulesys.impl.BindingVector;
import com.hp.hpl.jena.reasoner.rulesys.impl.RuleStore;
import com.hp.hpl.jena.reasoner.rulesys.impl.StateFlag;
import com.hp.hpl.jena.reasoner.rulesys.impl.oldCode.GoalResults;
import com.hp.hpl.jena.reasoner.rulesys.impl.oldCode.GoalState;
import com.hp.hpl.jena.reasoner.rulesys.impl.oldCode.GoalTable;
import com.hp.hpl.jena.reasoner.rulesys.impl.oldCode.RuleState;
import com.hp.hpl.jena.util.PrintUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BRuleEngine {
    protected LinkedList agenda = new LinkedList();
    protected GoalTable goalTable;
    protected BackwardRuleInfGraphI infGraph;
    protected RuleStore ruleStore;
    protected boolean traceOn = false;
    protected boolean recordDerivations;
    protected long nRulesFired = 0L;
    protected int batchSize = 100000;
    static Log logger = LogFactory.getLog((Class)(class$com$hp$hpl$jena$reasoner$rulesys$impl$oldCode$BRuleEngine == null ? (class$com$hp$hpl$jena$reasoner$rulesys$impl$oldCode$BRuleEngine = BRuleEngine.class$("com.hp.hpl.jena.reasoner.rulesys.impl.oldCode.BRuleEngine")) : class$com$hp$hpl$jena$reasoner$rulesys$impl$oldCode$BRuleEngine));
    static /* synthetic */ Class class$com$hp$hpl$jena$reasoner$rulesys$impl$oldCode$BRuleEngine;

    public BRuleEngine(BackwardRuleInfGraphI backwardRuleInfGraphI, RuleStore ruleStore) {
        this.infGraph = backwardRuleInfGraphI;
        this.goalTable = new GoalTable(this);
        this.ruleStore = ruleStore;
    }

    public BRuleEngine(BackwardRuleInfGraphI backwardRuleInfGraphI) {
        this.infGraph = backwardRuleInfGraphI;
        this.goalTable = new GoalTable(this);
        this.ruleStore = new RuleStore();
    }

    public synchronized void reset() {
        this.agenda.clear();
        this.goalTable.reset();
    }

    public void addRule(Rule rule) {
        this.ruleStore.addRule(rule);
    }

    public void deleteRule(Rule rule) {
        this.ruleStore.deleteRule(rule);
    }

    public List getAllRules() {
        return this.ruleStore.getAllRules();
    }

    public void deleteAllRules() {
        this.ruleStore.deleteAllRules();
    }

    public synchronized void halt() {
        Iterator iterator = this.agenda.iterator();
        while (iterator.hasNext()) {
            RuleState ruleState = (RuleState)iterator.next();
            if (ruleState.goalState == null) continue;
            ruleState.goalState.close();
        }
        this.agenda.clear();
        this.goalTable.removePartialGoals();
    }

    public synchronized GoalState findGoal(TriplePattern triplePattern) {
        return this.goalTable.findGoal(triplePattern);
    }

    public void setTraceOn(boolean bl) {
        this.traceOn = bl;
    }

    public boolean isTraceOn() {
        return this.traceOn;
    }

    public long getNRulesFired() {
        return this.nRulesFired;
    }

    public void setDerivationLogging(boolean bl) {
        this.recordDerivations = bl;
    }

    public void dump() {
        this.goalTable.dump();
    }

    public synchronized void appendToAgenda(RuleState ruleState) {
        if (!ruleState.isScheduled) {
            if (this.traceOn) {
                // empty if block
            }
            this.agenda.add(ruleState);
            ruleState.isScheduled = true;
        }
    }

    public synchronized void prependToAgenda(RuleState ruleState) {
        if (!ruleState.isScheduled) {
            if (this.traceOn) {
                // empty if block
            }
            this.agenda.add(0, ruleState);
            ruleState.isScheduled = true;
        }
    }

    public RuleState nextAgendaItem() {
        RuleState ruleState = (RuleState)this.agenda.removeFirst();
        ruleState.isScheduled = false;
        return ruleState;
    }

    public List rulesFor(TriplePattern triplePattern) {
        return this.ruleStore.rulesFor(triplePattern);
    }

    public BackwardRuleInfGraphI getInfGraph() {
        return this.infGraph;
    }

    public boolean processBuiltin(ClauseEntry clauseEntry, Rule rule, BindingEnvironment bindingEnvironment) {
        return this.infGraph.processBuiltin(clauseEntry, rule, bindingEnvironment);
    }

    public synchronized Triple next(GoalState goalState) {
        GoalResults goalResults = goalState.getGoalResultsEntry();
        int n = 0;
        BindingVector bindingVector = null;
        RuleState ruleState = null;
        RuleState ruleState2 = null;
        try {
            while (true) {
                Object object;
                Object object2;
                int n2;
                Object object3;
                Object object4;
                boolean bl = false;
                RuleState ruleState3 = null;
                if (ruleState == null) {
                    ruleState = this.nextAgendaItem();
                    n = 0;
                    if (this.traceOn) {
                        logger.debug((Object)("Waken:   " + ruleState));
                    }
                }
                if ((object4 = ruleState.next()) == StateFlag.FAIL) {
                    if (this.traceOn) {
                        logger.debug((Object)"Failed");
                    }
                    ruleState3 = ruleState;
                    ruleState = ruleState.prev;
                } else if (object4 == StateFlag.SUSPEND) {
                    if (this.traceOn) {
                        logger.debug((Object)("Suspend: " + ruleState));
                    }
                    object3 = ruleState.goalState.results;
                    ((GoalResults)object3).addDependent(ruleState);
                    ruleState = ruleState.prev;
                } else if (object4 == StateFlag.SATISFIED) {
                    bl = true;
                    bindingVector = ruleState.env;
                    ruleState3 = ruleState;
                    ruleState2 = ruleState.prev;
                } else {
                    bindingVector = ruleState.newEnvironment((Triple)object4);
                    if (bindingVector == null) continue;
                    object3 = ruleState.ruleInstance.rule;
                    boolean bl2 = false;
                    n2 = ((Rule)object3).bodyLength();
                    int n4 = ruleState.nextClauseIndex();
                    while (n4 < n2 && !bl2) {
                        if ((object2 = ((Rule)object3).getBodyElement(n4++)) instanceof TriplePattern) {
                            object = bindingVector.partInstantiate((TriplePattern)object2);
                            if (!((TriplePattern)object).isLegal()) {
                                ruleState3 = ruleState;
                                ruleState = ruleState.prev;
                            } else {
                                ruleState = new RuleState(ruleState, (TriplePattern)object, n4, bindingVector);
                            }
                            bl2 = true;
                            continue;
                        }
                        if (this.infGraph.processBuiltin((ClauseEntry)object2, (Rule)object3, bindingVector)) continue;
                        ruleState3 = ruleState;
                        ruleState = ruleState.prev;
                        bl2 = true;
                    }
                    if (!bl2) {
                        bl = true;
                        ruleState2 = ruleState;
                    }
                }
                if (bl) {
                    object3 = ruleState.ruleInstance.generator;
                    Triple triple = ruleState.getResult(bindingVector);
                    if (this.traceOn) {
                        logger.debug((Object)("Result:  " + PrintUtil.print(triple) + " <- " + ruleState + ", newenv=" + bindingVector));
                    }
                    n2 = ((GoalResults)object3).addResult(triple) ? 1 : 0;
                    if (ruleState3 != null) {
                        ruleState3.close();
                    }
                    ++n;
                    ruleState = ruleState2;
                    ++this.nRulesFired;
                    if (n2 != 0 && this.recordDerivations) {
                        Rule rule = ruleState.ruleInstance.rule;
                        object2 = new ArrayList(rule.bodyLength());
                        for (int i = 0; i < rule.bodyLength(); ++i) {
                            ClauseEntry clauseEntry = rule.getBodyElement(i);
                            if (!(clauseEntry instanceof TriplePattern)) continue;
                            object2.add(bindingVector.instantiate((TriplePattern)clauseEntry));
                        }
                        object = new RuleDerivation(rule, triple, (List)object2, this.infGraph);
                        this.infGraph.logDerivation(triple, object);
                    }
                    if (n2 != 0 && object3 == goalResults) {
                        if (ruleState != null) {
                            this.prependToAgenda(ruleState);
                        }
                        return triple;
                    }
                    if (n <= this.batchSize) continue;
                    if (ruleState != null) {
                        this.appendToAgenda(ruleState);
                    }
                    ruleState = null;
                    continue;
                }
                if (ruleState3 == null) continue;
                ruleState3.close();
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            if (this.traceOn) {
                logger.debug((Object)"Completed all");
            }
            this.goalTable.setAllComplete();
            return null;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

