/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.test;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.compose.Union;
import com.hp.hpl.jena.mem.GraphMem;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.rulesys.FBRuleInfGraph;
import com.hp.hpl.jena.reasoner.rulesys.FBRuleReasoner;
import com.hp.hpl.jena.reasoner.rulesys.GenericRuleReasoner;
import com.hp.hpl.jena.reasoner.rulesys.GenericRuleReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.OWLFBRuleReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.RDFSFBRuleReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.RDFSRuleReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import com.hp.hpl.jena.reasoner.rulesys.Util;
import com.hp.hpl.jena.reasoner.rulesys.impl.oldCode.OWLExptRuleReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.impl.oldCode.OWLRuleReasonerFactory;
import com.hp.hpl.jena.util.ModelLoader;
import com.hp.hpl.jena.util.PrintUtil;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DebugOWL {
    Reasoner reasoner;
    Graph testdata = new GraphMem();
    Graph schema = null;
    InfGraph infgraph;
    Node[] concepts;
    Node[] instances;
    Node[] properties;
    static Log logger = LogFactory.getLog((Class)(class$com$hp$hpl$jena$reasoner$rulesys$test$DebugOWL == null ? (class$com$hp$hpl$jena$reasoner$rulesys$test$DebugOWL = DebugOWL.class$("com.hp.hpl.jena.reasoner.rulesys.test.DebugOWL")) : class$com$hp$hpl$jena$reasoner$rulesys$test$DebugOWL));
    public static final int EXPT = 1;
    public static final int OWLFB = 2;
    public static final int OWL = 3;
    public static final int RDFSFB = 4;
    public static final int RDFSFinal = 5;
    public static final int OWLExpt = 6;
    public static final int RDFSLPExpt = 7;
    static /* synthetic */ Class class$com$hp$hpl$jena$reasoner$rulesys$test$DebugOWL;

    public DebugOWL(int n) {
        switch (n) {
            case 1: {
                this.reasoner = GenericRuleReasonerFactory.theInstance().create(null);
                GenericRuleReasoner genericRuleReasoner = (GenericRuleReasoner)this.reasoner;
                genericRuleReasoner.setMode(GenericRuleReasoner.HYBRID);
                try {
                    genericRuleReasoner.setRules(Rule.parseRules(Util.loadResourceFile("etc/expt.rules")));
                }
                catch (IOException iOException) {
                    System.out.println("Failed to open rules file: " + iOException);
                    System.exit(1);
                }
                break;
            }
            case 2: {
                this.reasoner = OWLFBRuleReasonerFactory.theInstance().create(null);
                break;
            }
            case 3: {
                this.reasoner = OWLRuleReasonerFactory.theInstance().create(null);
                break;
            }
            case 4: {
                this.reasoner = RDFSFBRuleReasonerFactory.theInstance().create(null);
                break;
            }
            case 5: {
                this.reasoner = RDFSRuleReasonerFactory.theInstance().create(null);
                break;
            }
            case 6: {
                this.reasoner = OWLExptRuleReasonerFactory.theInstance().create(null);
                break;
            }
            case 7: {
                try {
                    List list = Rule.parseRules(Util.loadResourceFile("etc/expt.rules"));
                    this.reasoner = new FBRuleReasoner(list);
                    break;
                }
                catch (IOException iOException) {
                    System.out.println("Failed to open rules file: " + iOException);
                    System.exit(1);
                }
            }
        }
    }

    public void load(String string) {
        this.testdata = ModelLoader.loadModel(string).getGraph();
        this.schema = null;
    }

    public void load(String string, String string2) {
        this.testdata = ModelLoader.loadModel(string2).getGraph();
        this.schema = ModelLoader.loadModel(string).getGraph();
    }

    public void createTest(int n, int n2, int n4, boolean bl) {
        int n5;
        int n6 = 0;
        int n7 = 1;
        for (n5 = 0; n5 < n; ++n5) {
            n6 += (n7 *= n2);
        }
        this.concepts = new Node[n6];
        this.properties = new Node[n6];
        this.instances = new Node[n6 * n4];
        logger.info((Object)("Classes: " + n6 + " Instances: " + n6 * n4 + (bl ? " with properties" : "")));
        this.testdata = new GraphMem();
        n5 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        for (int i = 0; i < n; ++i) {
            Node node;
            int n11;
            Node node2;
            int n12;
            Node node3 = null;
            if (i == 0) {
                for (n12 = 0; n12 < n2; ++n12) {
                    node2 = Node.createURI("concept" + n5);
                    if (bl) {
                        this.properties[n5] = node3 = Node.createURI("prop" + n5);
                    }
                    this.concepts[n5++] = node2;
                }
            } else {
                for (n12 = n8; n12 < n9; ++n12) {
                    node2 = this.concepts[n12];
                    for (n11 = 0; n11 < n2; ++n11) {
                        node = Node.createURI("concept" + n5);
                        if (bl) {
                            this.properties[n5] = node3 = Node.createURI("prop" + n5);
                        }
                        this.concepts[n5++] = node;
                        this.testdata.add(new Triple(node, RDFS.subClassOf.asNode(), node2));
                    }
                }
            }
            n8 = n9;
            n9 = n5;
            for (n12 = n8; n12 < n9; ++n12) {
                node2 = this.concepts[n12];
                for (n11 = 0; n11 < n4; ++n11) {
                    node = Node.createURI("instance" + n10);
                    this.testdata.add(new Triple(node, RDF.type.asNode(), node2));
                    if (bl && (n11 - 1) % 3 == 0) {
                        this.testdata.add(new Triple(this.instances[n10 - 1], node3, node));
                    }
                    this.instances[n10++] = node;
                }
            }
        }
    }

    public void init() {
        this.infgraph = this.schema == null ? this.reasoner.bind(this.testdata) : this.reasoner.bind(new Union(this.schema, this.testdata));
        if (this.infgraph instanceof FBRuleInfGraph) {
            System.out.println("Starting prepare");
            ((FBRuleInfGraph)this.infgraph).prepare();
            System.out.println(".. finished");
        }
    }

    long listC0(boolean bl) {
        return this.list(null, RDF.type.asNode(), this.concepts[0], bl);
    }

    long list(Node node, Node node2, Node node3, boolean bl) {
        long l = System.currentTimeMillis();
        this.init();
        int n = 0;
        ExtendedIterator extendedIterator = this.infgraph.find(node, node2, node3);
        while (extendedIterator.hasNext()) {
            Triple triple = (Triple)extendedIterator.next();
            ++n;
            if (!bl) continue;
            logger.info((Object)PrintUtil.print(triple));
        }
        long l2 = System.currentTimeMillis();
        System.out.println("Found " + n + " results");
        return l2 - l;
    }

    public void runListClassesTest(int n, int n2, int n4, boolean bl) {
        this.createTest(n, n2, n4, bl);
        long l = this.list(null, RDF.type.asNode(), RDFS.Class.asNode(), false);
        System.out.println("Took " + l + "ms");
    }

    public void runVolz(int n, int n2, int n4, boolean bl) {
        this.createTest(n, n2, n4, bl);
        long l = this.listC0(false);
        System.out.println("Took " + l + "ms");
        if (this.infgraph instanceof FBRuleInfGraph) {
            ((FBRuleInfGraph)this.infgraph).printLPProfile();
        }
    }

    public void runVolz() {
        this.runVolz(3, 5, 10, false);
        this.runVolz(3, 5, 10, false);
        this.runVolz(4, 5, 10, false);
        this.runVolz(5, 5, 10, false);
    }

    public void listClassesOn(String string) {
        this.load(string);
        System.out.println("Testing: " + string);
        long l = this.list(null, RDF.type.asNode(), RDFS.Class.asNode(), false);
        System.out.println("Took " + l + "ms");
    }

    public static void main(String[] stringArray) {
        try {
            String string = "file:testing/ontology/owl/list-syntax/test-with-import.rdf";
            String string2 = "file:vocabularies/owl.owl";
            String string3 = "file:testing/reasoners/bugs/owl-partial.owl";
            String string4 = "file:testing/reasoners/bugs/test.owl";
            String string5 = "file:testing/reasoners/bugs/food.owl";
            System.out.println("Volz tests on normal RDFS, tgc + type rules");
            new DebugOWL(5).runVolz();
        }
        catch (Exception exception) {
            System.out.println("Problem: " + exception);
            exception.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

