/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.test;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerFactory;
import com.hp.hpl.jena.reasoner.ValidityReport;
import com.hp.hpl.jena.reasoner.rulesys.RDFSFBRuleReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.RDFSRuleReasonerFactory;
import com.hp.hpl.jena.reasoner.test.ReasonerTestBase;
import com.hp.hpl.jena.reasoner.test.ReasonerTester;
import com.hp.hpl.jena.reasoner.test.WGReasonerTester;
import com.hp.hpl.jena.vocabulary.RDFS;
import com.hp.hpl.jena.vocabulary.ReasonerVocabulary;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Iterator;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TestRDFSReasoners
extends ReasonerTestBase {
    public static final String NAMESPACE = "http://www.hpl.hp.com/semweb/2003/query_tester/";
    protected static Log logger = LogFactory.getLog((Class)(class$com$hp$hpl$jena$reasoner$test$TestReasoners == null ? (class$com$hp$hpl$jena$reasoner$test$TestReasoners = TestRDFSReasoners.class$("com.hp.hpl.jena.reasoner.test.TestReasoners")) : class$com$hp$hpl$jena$reasoner$test$TestReasoners));
    static /* synthetic */ Class class$com$hp$hpl$jena$reasoner$test$TestReasoners;

    public TestRDFSReasoners(String string) {
        super(string);
    }

    public static TestSuite suite() {
        TestSuite testSuite = new TestSuite();
        try {
            TestRDFSReasoners.constructQuerytests(testSuite, "rdfs/manifest-nodirect-noresource.rdf", RDFSFBRuleReasonerFactory.theInstance(), null);
            Resource resource = TestRDFSReasoners.newResource().addProperty(ReasonerVocabulary.PROPenableCMPScan, true);
            TestRDFSReasoners.constructRDFWGtests(testSuite, RDFSRuleReasonerFactory.theInstance(), null);
            TestRDFSReasoners.constructQuerytests(testSuite, "rdfs/manifest-standard.rdf", RDFSRuleReasonerFactory.theInstance(), resource);
            testSuite.addTest((Test)new TestRDFSMisc(RDFSRuleReasonerFactory.theInstance(), null));
            Resource resource2 = TestRDFSReasoners.newResource().addProperty(ReasonerVocabulary.PROPsetRDFSLevel, ReasonerVocabulary.RDFS_FULL);
            TestRDFSReasoners.constructQuerytests(testSuite, "rdfs/manifest.rdf", RDFSRuleReasonerFactory.theInstance(), resource2);
            Resource resource3 = TestRDFSReasoners.newResource().addProperty(ReasonerVocabulary.PROPsetRDFSLevel, ReasonerVocabulary.RDFS_SIMPLE);
            TestRDFSReasoners.constructQuerytests(testSuite, "rdfs/manifest-simple.rdf", RDFSRuleReasonerFactory.theInstance(), resource3);
        }
        catch (IOException iOException) {
            logger.error((Object)"Failed to construct RDFS test harness", (Throwable)iOException);
        }
        return testSuite;
    }

    private static void constructSingleQuerytests(TestSuite testSuite, String string, String string2, ReasonerFactory reasonerFactory, Resource resource) throws IOException {
        ReasonerTester reasonerTester = new ReasonerTester(string);
        Reasoner reasoner = reasonerFactory.create(resource);
        testSuite.addTest((Test)new TestReasonerFromManifest(reasonerTester, string2, reasoner));
    }

    private static void constructQuerytests(TestSuite testSuite, String string, ReasonerFactory reasonerFactory, Resource resource) throws IOException {
        ReasonerTester reasonerTester = new ReasonerTester(string);
        Reasoner reasoner = reasonerFactory.create(resource);
        Iterator iterator = reasonerTester.listTests().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            testSuite.addTest((Test)new TestReasonerFromManifest(reasonerTester, string2, reasoner));
        }
    }

    private static void constructRDFWGtests(TestSuite testSuite, ReasonerFactory reasonerFactory, Resource resource) throws IOException {
        WGReasonerTester wGReasonerTester = new WGReasonerTester("Manifest.rdf");
        Iterator iterator = wGReasonerTester.listTests().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            testSuite.addTest((Test)new TestReasonerWG(wGReasonerTester, string, reasonerFactory, resource));
        }
    }

    public static void constructQuerytests(TestSuite testSuite, String string, Reasoner reasoner) throws IOException {
        ReasonerTester reasonerTester = new ReasonerTester(string);
        Iterator iterator = reasonerTester.listTests().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            testSuite.addTest((Test)new TestReasonerFromManifest(reasonerTester, string2, reasoner));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class TestRDFSMisc
    extends TestCase {
        ReasonerFactory reasonerFactory;
        Resource config;

        TestRDFSMisc(ReasonerFactory reasonerFactory, Resource resource) {
            super("TestRDFSMisc");
            this.reasonerFactory = reasonerFactory;
            this.config = resource;
        }

        public void runTest() throws IOException {
            Object object;
            ReasonerTester reasonerTester = new ReasonerTester("rdfs/manifest.rdf");
            Resource resource = ReasonerTestBase.newResource();
            if (this.config != null) {
                object = this.config.listProperties();
                while (object.hasNext()) {
                    Statement statement = object.nextStatement();
                    resource.addProperty(statement.getPredicate(), statement.getObject());
                }
            }
            resource.addProperty(ReasonerVocabulary.PROPenableCMPScan, "false");
            TestRDFSMisc.assertTrue((String)"scanproperties off", (!reasonerTester.runTest("http://www.hpl.hp.com/semweb/2003/query_tester/rdfs/test17", this.reasonerFactory, null, resource) ? 1 : 0) != 0);
            object = this.reasonerFactory.create(null);
            TestRDFSMisc.assertTrue((boolean)object.supportsProperty(RDFS.subClassOf));
            TestRDFSMisc.assertTrue((boolean)object.supportsProperty(RDFS.domain));
            TestRDFSMisc.assertTrue((boolean)object.supportsProperty(RDFS.range));
            TestRDFSMisc.assertTrue((!this.doTestRDFSDTRange("dttest1.nt", this.reasonerFactory) ? 1 : 0) != 0);
            TestRDFSMisc.assertTrue((!this.doTestRDFSDTRange("dttest2.nt", this.reasonerFactory) ? 1 : 0) != 0);
            TestRDFSMisc.assertTrue((boolean)this.doTestRDFSDTRange("dttest3.nt", this.reasonerFactory));
        }

        private boolean doTestRDFSDTRange(String string, ReasonerFactory reasonerFactory) throws IOException {
            String string2 = "RDF/XML";
            if (string.endsWith(".nt")) {
                string2 = "N-TRIPLE";
            } else if (string.endsWith("n3")) {
                string2 = "N3";
            }
            Model model = ModelFactory.createNonreifyingModel();
            BufferedReader bufferedReader = new BufferedReader(new FileReader("testing/reasoners/rdfs/" + string));
            model.read(bufferedReader, "http://www.w3.org/2000/10/rdf-tests/rdfcore/" + string, string2);
            InfGraph infGraph = reasonerFactory.create(null).bind(model.getGraph());
            ValidityReport validityReport = infGraph.validate();
            if (!validityReport.isValid()) {
                logger.debug((Object)"Validation error report:");
                Iterator iterator = validityReport.getReports();
                while (iterator.hasNext()) {
                    logger.debug((Object)iterator.next().toString());
                }
            }
            return validityReport.isValid();
        }
    }

    static class TestReasonerWG
    extends TestCase {
        WGReasonerTester tester;
        String test;
        ReasonerFactory reasonerFactory;
        Resource config;

        TestReasonerWG(WGReasonerTester wGReasonerTester, String string, ReasonerFactory reasonerFactory, Resource resource) {
            super(string);
            this.tester = wGReasonerTester;
            this.test = string;
            this.reasonerFactory = reasonerFactory;
            this.config = resource;
        }

        public void runTest() throws IOException {
            this.tester.runTest(this.test, this.reasonerFactory, this, this.config);
        }
    }

    static class TestReasonerFromManifest
    extends TestCase {
        ReasonerTester tester;
        String test;
        Reasoner reasoner;

        TestReasonerFromManifest(ReasonerTester reasonerTester, String string, Reasoner reasoner) {
            super(string);
            this.tester = reasonerTester;
            this.test = string;
            this.reasoner = reasoner;
        }

        public void runTest() throws IOException {
            this.tester.runTest(this.test, this.reasoner, this);
        }
    }
}

