/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.transitiveReasoner;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.reasoner.Finder;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.NiceIterator;
import com.hp.hpl.jena.util.iterator.SingletonIterator;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class TransitiveGraphCache
implements Finder {
    protected HashMap nodeMap = new HashMap();
    protected HashMap cacheClosureForward = null;
    protected HashMap cacheClosureBackward = null;
    protected boolean cacheOn = false;
    protected Node directPredicate;
    protected Node closedPredicate;

    public TransitiveGraphCache(Node node, Node node2) {
        this.directPredicate = node;
        this.closedPredicate = node2;
    }

    public void addRelation(Node node, Node node2) {
        this.clearClosureCache();
        this.getGraphNode(node).addDirectLink(this.getGraphNode(node2));
    }

    public void removeRelation(Node node, Node node2) {
        this.clearClosureCache();
        this.getGraphNode(node).removeLink(this.getGraphNode(node2));
    }

    public void clear() {
        this.clearClosureCache();
        this.nodeMap.clear();
    }

    private void clearClosureCache() {
        if (this.cacheOn) {
            if (this.cacheClosureBackward.size() > 0) {
                this.cacheClosureBackward.clear();
            }
            if (this.cacheClosureForward.size() > 0) {
                this.cacheClosureForward.clear();
            }
        }
    }

    public void setCaching(boolean bl) {
        if (this.cacheOn != bl) {
            this.cacheOn = bl;
            if (bl) {
                this.cacheClosureBackward = new HashMap();
                this.cacheClosureForward = new HashMap();
            } else {
                this.cacheClosureBackward = null;
                this.cacheClosureBackward = null;
            }
        }
    }

    public boolean cacheAll(Finder finder, Node node) {
        ExtendedIterator extendedIterator = finder.find(new TriplePattern(null, node, null));
        boolean bl = extendedIterator.hasNext();
        while (extendedIterator.hasNext()) {
            Triple triple = (Triple)extendedIterator.next();
            this.addRelation(triple.getSubject(), triple.getObject());
        }
        extendedIterator.close();
        return bl;
    }

    public ExtendedIterator find(TriplePattern triplePattern) {
        Node node = triplePattern.getSubject();
        Node node2 = triplePattern.getPredicate();
        Node node3 = triplePattern.getObject();
        if (node2.isVariable() || node2.equals(this.directPredicate) || node2.equals(this.closedPredicate)) {
            boolean bl = !node2.equals(this.directPredicate);
            Node node4 = this.closedPredicate;
            if (node.isVariable()) {
                if (node3.isVariable()) {
                    ListAll listAll = new ListAll(this.nodeMap.values().iterator(), bl, node4);
                    return WrappedIterator.create(listAll);
                }
                GraphNode graphNode = (GraphNode)this.nodeMap.get(node3);
                if (graphNode == null) {
                    return new NiceIterator();
                }
                return new GraphWalker(graphNode, false, bl, node4);
            }
            GraphNode graphNode = (GraphNode)this.nodeMap.get(node);
            if (graphNode == null) {
                return new NiceIterator();
            }
            if (node3.isVariable()) {
                return new GraphWalker(graphNode, true, bl, node4);
            }
            GraphNode graphNode2 = (GraphNode)this.nodeMap.get(node3);
            if (graphNode2 == null) {
                return new NiceIterator();
            }
            if (graphNode.linksTo(graphNode2)) {
                return new SingletonIterator(new Triple(node, node4, node3));
            }
            return new NiceIterator();
        }
        return new NiceIterator();
    }

    public boolean contains(TriplePattern triplePattern) {
        ExtendedIterator extendedIterator = this.find(triplePattern);
        boolean bl = extendedIterator.hasNext();
        extendedIterator.close();
        return bl;
    }

    public ExtendedIterator listAllProperties() {
        return WrappedIterator.create(this.nodeMap.keySet().iterator());
    }

    public boolean isProperty(Node node) {
        return this.nodeMap.keySet().contains(node);
    }

    public TransitiveGraphCache deepCopy() {
        TransitiveGraphCache transitiveGraphCache = new TransitiveGraphCache(this.directPredicate, this.closedPredicate);
        ExtendedIterator extendedIterator = this.find(new TriplePattern(null, this.directPredicate, null));
        while (extendedIterator.hasNext()) {
            Triple triple = (Triple)extendedIterator.next();
            transitiveGraphCache.addRelation(triple.getSubject(), triple.getObject());
        }
        return transitiveGraphCache;
    }

    private ExtendedIterator walk(GraphNode graphNode, boolean bl, boolean bl2, Node node) {
        if (this.cacheOn && bl2) {
            HashMap hashMap = bl ? this.cacheClosureForward : this.cacheClosureBackward;
            ArrayList arrayList = (ArrayList)hashMap.get(graphNode);
            if (arrayList == null) {
                GraphWalker graphWalker = new GraphWalker(graphNode, bl, bl2, node);
                arrayList = new ArrayList();
                while (graphWalker.hasNext()) {
                    arrayList.add(graphWalker.next());
                }
                hashMap.put(graphNode, arrayList);
            }
            return WrappedIterator.create(arrayList.iterator());
        }
        return new GraphWalker(graphNode, bl, bl2, node);
    }

    public ExtendedIterator findWithContinuation(TriplePattern triplePattern, Finder finder) {
        Node node = triplePattern.getPredicate();
        if (node.isVariable()) {
            return this.find(triplePattern).andThen(finder.find(triplePattern));
        }
        if (node.equals(this.directPredicate) || node.equals(this.closedPredicate)) {
            return this.find(triplePattern);
        }
        return finder.find(triplePattern);
    }

    public Node getClosedPredicate() {
        return this.closedPredicate;
    }

    public Node getDirectPredicate() {
        return this.directPredicate;
    }

    protected GraphNode getGraphNode(Node node) {
        GraphNode graphNode = (GraphNode)this.nodeMap.get(node);
        if (graphNode == null) {
            graphNode = new GraphNode(node);
            this.nodeMap.put(node, graphNode);
            graphNode.addDirectLink(graphNode);
        }
        return graphNode;
    }

    protected void printAll() {
        Iterator iterator = this.nodeMap.values().iterator();
        while (iterator.hasNext()) {
            GraphNode graphNode = (GraphNode)iterator.next();
            System.out.println(graphNode.longString());
        }
    }

    private static void listFind(TransitiveGraphCache transitiveGraphCache, Node node, Node node2, Node node3) {
        System.out.print("Checking triple pattern: ");
        System.out.print(" " + node);
        System.out.print(" " + node2);
        System.out.print(" " + node3 + "\n");
        ExtendedIterator extendedIterator = transitiveGraphCache.find(new TriplePattern(node, node2, node3));
        while (extendedIterator.hasNext()) {
            System.out.println("  - " + extendedIterator.next());
        }
    }

    private static class GraphWalker
    extends NiceIterator
    implements ExtendedIterator {
        boolean isForward;
        boolean isDeep;
        GraphNode node;
        Node root;
        Node predicate;
        int index;
        ArrayList nodeStack = new ArrayList();
        int[] indexStack;
        Triple next;
        HashSet visited = new HashSet();

        GraphWalker(GraphNode graphNode, boolean bl, boolean bl2, Node node) {
            this.isForward = bl;
            this.isDeep = bl2;
            this.indexStack = new int[20];
            this.node = graphNode;
            this.root = graphNode.node;
            this.predicate = node;
            this.index = -1;
            this.walkOne();
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public Object next() {
            Triple triple = this.next;
            this.walkOne();
            return triple;
        }

        protected void walkOne() {
            ++this.index;
            if (this.index >= (this.isForward ? this.node.successors.size() : this.node.predecessors.size())) {
                if (this.nodeStack.isEmpty()) {
                    this.next = null;
                    return;
                }
                this.popStack();
                this.walkOne();
            } else {
                GraphNode graphNode = (GraphNode)(this.isForward ? this.node.successors.get(this.index) : this.node.predecessors.get(this.index));
                if (this.visited.contains(graphNode)) {
                    this.walkOne();
                    return;
                }
                this.visited.add(graphNode);
                if (this.isDeep) {
                    this.pushStack(graphNode);
                }
                this.next = this.isForward ? new Triple(this.root, this.predicate, graphNode.node) : new Triple(graphNode.node, this.predicate, this.root);
            }
        }

        protected void pushStack(GraphNode graphNode) {
            this.nodeStack.add(this.node);
            this.node = graphNode;
            int n = this.indexStack.length;
            if (this.nodeStack.size() > n) {
                int[] nArray = new int[n + n / 2];
                for (int i = 0; i < n; ++i) {
                    nArray[i] = this.indexStack[i];
                }
                this.indexStack = nArray;
            }
            this.indexStack[this.nodeStack.size() - 1] = this.index;
            this.index = -1;
        }

        protected void popStack() {
            int n = this.nodeStack.size() - 1;
            this.index = this.indexStack[n];
            this.node = (GraphNode)this.nodeStack.get(n);
            this.nodeStack.remove(n);
        }
    }

    private static class GraphNode {
        Node node;
        List successors;
        List predecessors;

        GraphNode(Node node) {
            this.node = node;
            this.successors = new ArrayList(2);
            this.predecessors = new ArrayList(2);
        }

        void addLink(GraphNode graphNode) {
            if (!this.successors.contains(graphNode)) {
                this.successors.add(graphNode);
                graphNode.predecessors.add(this);
            }
        }

        void removeLink(GraphNode graphNode) {
            this.successors.remove(graphNode);
            graphNode.predecessors.remove(this);
        }

        void addDirectLink(GraphNode graphNode) {
            if (this == graphNode) {
                this.addLink(graphNode);
                return;
            }
            if (this.linksTo(graphNode)) {
                return;
            }
            Iterator iterator = this.successors.iterator();
            while (iterator.hasNext()) {
                GraphNode graphNode2 = (GraphNode)iterator.next();
                if (graphNode2 == this || !graphNode.linksTo(graphNode2)) continue;
                iterator.remove();
                graphNode2.predecessors.remove(this);
            }
            this.addLink(graphNode);
        }

        boolean linksTo(GraphNode graphNode) {
            return this.linksToInternal(graphNode, new HashSet());
        }

        private boolean linksToInternal(GraphNode graphNode, HashSet hashSet) {
            Iterator iterator = this.successors.iterator();
            while (iterator.hasNext()) {
                GraphNode graphNode2 = (GraphNode)iterator.next();
                if (hashSet.contains(graphNode2)) continue;
                hashSet.add(graphNode2);
                if (graphNode2 == graphNode) {
                    return true;
                }
                if (!graphNode2.linksToInternal(graphNode, hashSet)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return this.node.toString();
        }

        public String longString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.node.toString());
            stringBuffer.append(" [");
            Iterator iterator = this.successors.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(iterator.next().toString() + " ");
            }
            stringBuffer.append("]");
            return stringBuffer.toString();
        }
    }

    private static class ListAll
    implements Iterator {
        boolean closed;
        Iterator nodes;
        Node predicate;
        Iterator listRelated;
        GraphNode current;
        Triple next;

        ListAll(Iterator iterator, boolean bl, Node node) {
            this.nodes = iterator;
            this.closed = bl;
            this.predicate = node;
            this.listRelated = null;
            this.walkOne();
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public Object next() {
            Triple triple = this.next;
            this.walkOne();
            return triple;
        }

        public void remove() {
            throw new UnsupportedOperationException("GraphCache does not yet implement remove operation");
        }

        private void walkOne() {
            if (this.listRelated != null && this.listRelated.hasNext()) {
                this.next = (Triple)this.listRelated.next();
            } else if (this.nodes.hasNext()) {
                this.current = (GraphNode)this.nodes.next();
                this.listRelated = new GraphWalker(this.current, true, this.closed, this.predicate);
                this.walkOne();
            } else {
                this.next = null;
                return;
            }
        }
    }
}

