/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.util;

import com.hp.hpl.jena.shared.JenaException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

public class FileUtils {
    private static int counter = 0;
    static /* synthetic */ Class class$com$hp$hpl$jena$reasoner$rulesys$Util;

    public static String readWholeFileAsUTF8(String string) throws IOException {
        int n;
        BufferedReader bufferedReader = new BufferedReader(FileUtils.asUTF8(new FileInputStream(string)), 1024);
        StringWriter stringWriter = new StringWriter(1024);
        char[] cArray = new char[1024];
        while (((Reader)bufferedReader).ready() && (n = bufferedReader.read(cArray)) > 0) {
            stringWriter.write(cArray, 0, n);
        }
        ((Reader)bufferedReader).close();
        stringWriter.close();
        return stringWriter.toString();
    }

    public static Reader asUTF8(InputStream inputStream) {
        try {
            return new InputStreamReader(inputStream, "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new Error("utf-8 *must* be a supported encoding.");
        }
    }

    public static Writer asUTF8(OutputStream outputStream) {
        try {
            return new OutputStreamWriter(outputStream, "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new Error("utf-8 *must* be a supported encoding.");
        }
    }

    public static File tempFileName(String string, String string2) {
        File file = new File(FileUtils.getTempDirectory(), string + FileUtils.randomNumber() + string2);
        if (file.exists()) {
            return FileUtils.tempFileName(string, string2);
        }
        file.deleteOnExit();
        return file;
    }

    private static int randomNumber() {
        return ++counter;
    }

    public static File getScratchDirectory(String string) {
        File file = new File(FileUtils.getTempDirectory(), string + FileUtils.randomNumber());
        if (file.exists()) {
            return FileUtils.getScratchDirectory(string);
        }
        if (!file.mkdir()) {
            throw new JenaException("mkdir failed on " + file);
        }
        file.deleteOnExit();
        return file;
    }

    public static String getTempDirectory() {
        return System.getProperty("java.io.tmpdir");
    }

    public static BufferedReader openResourceFile(String string) throws IOException {
        InputStream inputStream = FileUtils.openResourceFileAsStream(string);
        return new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
    }

    public static InputStream openResourceFileAsStream(String string) throws FileNotFoundException {
        InputStream inputStream = ClassLoader.getSystemResourceAsStream(string);
        if (inputStream == null && (inputStream = (class$com$hp$hpl$jena$reasoner$rulesys$Util == null ? (class$com$hp$hpl$jena$reasoner$rulesys$Util = FileUtils.class$("com.hp.hpl.jena.reasoner.rulesys.Util")) : class$com$hp$hpl$jena$reasoner$rulesys$Util).getResourceAsStream("/" + string)) == null) {
            inputStream = new FileInputStream(string);
        }
        return inputStream;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

