/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.util;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;

public class ResourceUtils {
    public static Collection maximalLowerElements(Collection collection, Property property, boolean bl) {
        return ResourceUtils.maximalLowerElements(collection.iterator(), property, bl);
    }

    public static Collection maximalLowerElements(Iterator iterator, Property property, boolean bl) {
        ArrayList arrayList = new ArrayList();
        ArrayList<Resource> arrayList2 = new ArrayList<Resource>();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        while (!arrayList.isEmpty()) {
            Resource resource;
            boolean bl2 = false;
            Resource resource2 = (Resource)arrayList.remove(0);
            Iterator iterator2 = arrayList.iterator();
            while (!bl2 && iterator2.hasNext()) {
                resource = (Resource)iterator2.next();
                bl2 = bl ? resource2.hasProperty(property, resource) : resource.hasProperty(property, resource2);
            }
            iterator2 = arrayList2.iterator();
            while (!bl2 && iterator2.hasNext()) {
                resource = (Resource)iterator2.next();
                bl2 = bl ? resource2.hasProperty(property, resource) : resource.hasProperty(property, resource2);
            }
            if (bl2) continue;
            arrayList2.add(resource2);
        }
        return arrayList2;
    }

    public static Resource renameResource(Resource resource, String string) {
        Model model = resource.getModel();
        ArrayList arrayList = new ArrayList();
        Object object = resource.listProperties();
        while (object.hasNext()) {
            arrayList.add(object.next());
        }
        object = model.listStatements(null, null, resource);
        while (object.hasNext()) {
            arrayList.add(object.next());
        }
        object = string == null ? model.createResource() : model.createResource(string);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Statement statement = (Statement)iterator.next();
            statement.remove();
            Object object2 = ((Object)statement.getSubject()).equals(resource) ? object : statement.getSubject();
            Object object3 = statement.getObject().equals(resource) ? object : statement.getObject();
            model.add((Resource)object2, statement.getPredicate(), (RDFNode)object3);
        }
        return object;
    }

    public static Model reachableClosure(Resource resource) {
        Model model = ModelFactory.createDefaultModel();
        HashSet<Resource> hashSet = new HashSet<Resource>();
        LinkedList<RDFNode> linkedList = new LinkedList<RDFNode>();
        linkedList.add(resource);
        while (!linkedList.isEmpty()) {
            Resource resource2 = (Resource)linkedList.remove(0);
            if (hashSet.contains(resource2)) continue;
            hashSet.add(resource2);
            StmtIterator stmtIterator = resource2.listProperties();
            while (stmtIterator.hasNext()) {
                Statement statement = stmtIterator.nextStatement();
                model.add(statement);
                if (!(statement.getObject() instanceof Resource)) continue;
                linkedList.add(statement.getObject());
            }
        }
        return model;
    }
}

