/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.util.iterator;

import com.hp.hpl.jena.util.iterator.ClosableIterator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.Filter;
import com.hp.hpl.jena.util.iterator.FilterIterator;
import com.hp.hpl.jena.util.iterator.Map1;
import com.hp.hpl.jena.util.iterator.Map1Iterator;
import java.util.NoSuchElementException;

public class NiceIterator
implements ExtendedIterator {
    public void close() {
    }

    public boolean hasNext() {
        return false;
    }

    public Object next() {
        return this.noElements("empty NiceIterator");
    }

    protected Object noElements(String string) {
        throw new NoSuchElementException(string);
    }

    public void remove() {
        throw new UnsupportedOperationException("remove not supported for this iterator");
    }

    public Object removeNext() {
        Object object = this.next();
        this.remove();
        return object;
    }

    public static ExtendedIterator andThen(final ClosableIterator closableIterator, final ClosableIterator closableIterator2) {
        return new NiceIterator(){
            private boolean walkingA = true;

            public boolean hasNext() {
                this.walkingA = closableIterator.hasNext();
                return this.walkingA || closableIterator2.hasNext();
            }

            public Object next() {
                this.walkingA = closableIterator.hasNext();
                return this.walkingA ? closableIterator.next() : closableIterator2.next();
            }

            public void close() {
                closableIterator.close();
                closableIterator2.close();
            }

            public void remove() {
                (this.walkingA ? closableIterator : closableIterator2).remove();
            }
        };
    }

    public ExtendedIterator andThen(ClosableIterator closableIterator) {
        return NiceIterator.andThen(this, closableIterator);
    }

    public ExtendedIterator filterKeep(Filter filter) {
        return new FilterIterator(filter, this);
    }

    public ExtendedIterator filterDrop(final Filter filter) {
        Filter filter2 = new Filter(){

            public boolean accept(Object object) {
                return !filter.accept(object);
            }
        };
        return new FilterIterator(filter2, this);
    }

    public ExtendedIterator mapWith(Map1 map1) {
        return new Map1Iterator(map1, this);
    }
}

