/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.xmloutput.test;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.impl.NTripleWriter;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.shared.NoWriterForLangException;
import com.hp.hpl.jena.xmloutput.impl.Abbreviated;
import com.hp.hpl.jena.xmloutput.impl.Basic;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;

public class testWriterInterface
extends ModelTestBase {
    private String lang;

    public testWriterInterface(String string, String string2) {
        super(string);
        this.lang = string2;
    }

    public void testInterface() {
        Model model = testWriterInterface.createMemModel();
        testWriterInterface.assertTrue((String)"Default writer should be Basic.", (boolean)(model.getWriter() instanceof Basic));
        testWriterInterface.assertTrue((String)"RDF/XML writer should be Basic.", (boolean)(model.getWriter() instanceof Basic));
        testWriterInterface.assertTrue((String)"RDF/XML-ABBREV writer should be Abbreviated.", (boolean)(model.getWriter("RDF/XML-ABBREV") instanceof Abbreviated));
        testWriterInterface.assertTrue((String)"N-TRIPLE writer should be NTripleWriter.", (boolean)(model.getWriter("N-TRIPLE") instanceof NTripleWriter));
    }

    public void testNoWriter() {
        Model model = testWriterInterface.createMemModel();
        try {
            model.setWriterClassName("foobar", "");
            model.getWriter("foobar");
            testWriterInterface.fail((String)"Missing Writer undetected.");
        }
        catch (NoWriterForLangException noWriterForLangException) {
            // empty catch block
        }
    }

    public void testAnotherWriter() {
        Model model = testWriterInterface.createMemModel();
        model.setWriterClassName("foobar", "com.hp.hpl.jena.xmloutput.impl.Basic");
        testWriterInterface.assertTrue((String)"Failed to access set writer", (boolean)(model.getWriter("foobar") instanceof Basic));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testWriting() {
        ByteArrayOutputStream byteArrayOutputStream;
        ByteArrayOutputStream byteArrayOutputStream2 = null;
        Model model = testWriterInterface.createMemModel();
        byteArrayOutputStream2 = byteArrayOutputStream = new ByteArrayOutputStream();
        model.write(byteArrayOutputStream2, this.lang);
        byteArrayOutputStream.reset();
        ((OutputStream)byteArrayOutputStream2).close();
        Object var5_5 = null;
        if (byteArrayOutputStream2 == null) return;
        try {
            ((OutputStream)byteArrayOutputStream2).close();
            return;
        }
        catch (Exception exception) {}
        return;
        {
            catch (Exception exception) {
                testWriterInterface.fail((String)exception.getMessage());
                Object var5_6 = null;
                if (byteArrayOutputStream2 == null) return;
                try {
                    ((OutputStream)byteArrayOutputStream2).close();
                    return;
                }
                catch (Exception exception2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (byteArrayOutputStream2 == null) throw throwable;
            try {
                ((OutputStream)byteArrayOutputStream2).close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }
}

