/*
 * Decompiled with CFR 0.152.
 */
package org.xmldb.xupdate.lexus.commands;

import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xmldb.common.xml.queries.XObject;
import org.xmldb.common.xml.queries.XPathQuery;
import org.xmldb.common.xml.queries.XPathQueryFactory;

public abstract class CommandObject {
    private static XPathQuery xpath = null;
    protected Document document = null;
    protected Node contextNode = null;
    protected NodeList selectionNodeList = null;
    protected Hashtable attributes = null;
    protected Vector characters = null;

    public CommandObject(Node node) throws Exception {
        if (node == null) {
            throw new IllegalArgumentException("Argument contextNode must not be null.");
        }
        if (xpath == null) {
            xpath = XPathQueryFactory.newInstance().newXPathQuery();
        }
        this.contextNode = node;
        switch (node.getNodeType()) {
            case 9: {
                this.document = (Document)node;
                break;
            }
            default: {
                this.document = node.getOwnerDocument();
            }
        }
        this.characters = new Vector();
    }

    public void reset() {
        this.characters.clear();
    }

    public synchronized void selectNodes(String string) throws Exception {
        if (string == null) {
            throw new IllegalArgumentException("Argument qString must not be null.");
        }
        xpath.setQString(string);
        XObject xObject = xpath.execute(this.contextNode);
        if (xObject.getType() != 4) {
            throw new Exception("XPath leads not to a Node or NodeList !");
        }
        this.selectionNodeList = xObject.nodeset();
        if (this.selectionNodeList.getLength() == 0) {
            throw new Exception("no nodes selected !");
        }
    }

    public void submitAttributes(Hashtable hashtable) {
        this.attributes = hashtable;
    }

    public void submitCharacters(String string) {
        this.characters.addElement(string);
    }

    public abstract boolean submitInstruction(int var1) throws Exception;

    public abstract boolean executeInstruction() throws Exception;

    public abstract Node execute() throws Exception;

    public static XPathQuery getXPath() {
        return xpath;
    }
}

