/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.common;

import java.util.Hashtable;
import java.util.Vector;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.slide.common.AbstractServiceBase;
import org.apache.slide.common.Service;

public abstract class AbstractService
extends AbstractServiceBase
implements Service {
    public static final int TX_IDLE = 0;
    public static final int TX_PREPARED = 1;
    public static final int TX_SUSPENDED = 2;
    protected Hashtable currentContexts = new Hashtable();

    public void commit(Xid xid, boolean onePhase) throws XAException {
        Xid currentContext;
        ContextTuple currentContextTuple = (ContextTuple)this.currentContexts.get(Thread.currentThread());
        Xid xid2 = currentContext = currentContextTuple != null ? currentContextTuple.getXid() : null;
        if (currentContext == null) {
            throw new XAException(-4);
        }
        if (xid == null) {
            throw new XAException(-5);
        }
        if (currentContext.getGlobalTransactionId() != xid.getGlobalTransactionId()) {
            throw new XAException(-6);
        }
        if (!onePhase && currentContextTuple.getStatus() != 1) {
            throw new XAException(-6);
        }
        if (onePhase && currentContextTuple.getStatus() != 0 && currentContextTuple.getStatus() != 2) {
            throw new XAException(-6);
        }
        if (((ContextTuple)this.currentContexts.get(Thread.currentThread())).getRollbackOnly()) {
            this.rollback(xid);
            throw new XAException(100);
        }
        this.currentContexts.remove(Thread.currentThread());
    }

    public void end(Xid xid, int flags) throws XAException {
        Xid currentContext;
        ContextTuple currentContextTuple = (ContextTuple)this.currentContexts.get(Thread.currentThread());
        Xid xid2 = currentContext = currentContextTuple != null ? currentContextTuple.getXid() : null;
        if (currentContext == null) {
            throw new XAException(-4);
        }
        if (xid == null) {
            throw new XAException(-5);
        }
        if (currentContext.getGlobalTransactionId() != xid.getGlobalTransactionId()) {
            throw new XAException(-6);
        }
        if (flags == 0x2000000) {
            currentContextTuple.setStatus(2);
        }
        if (flags == 0x20000000) {
            ((ContextTuple)this.currentContexts.get(Thread.currentThread())).setRollbackOnly(true);
        }
    }

    public void forget(Xid xid) throws XAException {
        Xid currentContext;
        ContextTuple currentContextTuple = (ContextTuple)this.currentContexts.get(Thread.currentThread());
        Xid xid2 = currentContext = currentContextTuple != null ? currentContextTuple.getXid() : null;
        if (currentContext == null) {
            throw new XAException(-4);
        }
        if (xid == null) {
            throw new XAException(-5);
        }
        if (currentContext.getGlobalTransactionId() != xid.getGlobalTransactionId()) {
            throw new XAException(-6);
        }
        this.currentContexts.remove(Thread.currentThread());
    }

    public int getTransactionTimeout() throws XAException {
        return ((ContextTuple)this.currentContexts.get(Thread.currentThread())).getTransactionTimeout();
    }

    public boolean isSameRM(XAResource xares) throws XAException {
        if (xares == null) {
            return false;
        }
        return this == xares;
    }

    public int prepare(Xid xid) throws XAException {
        Xid currentContext;
        ContextTuple currentContextTuple = (ContextTuple)this.currentContexts.get(Thread.currentThread());
        Xid xid2 = currentContext = currentContextTuple != null ? currentContextTuple.getXid() : null;
        if (currentContext == null) {
            throw new XAException(-4);
        }
        if (xid == null) {
            throw new XAException(-5);
        }
        if (currentContext.getGlobalTransactionId() != xid.getGlobalTransactionId()) {
            throw new XAException(-6);
        }
        if (currentContextTuple.getStatus() != 0 && currentContextTuple.getStatus() != 2) {
            throw new XAException(-6);
        }
        if (((ContextTuple)this.currentContexts.get(Thread.currentThread())).getRollbackOnly()) {
            throw new XAException(100);
        }
        currentContextTuple.setStatus(1);
        return 0;
    }

    public Xid[] recover(int flag) throws XAException {
        ContextTuple currentContextTuple = (ContextTuple)this.currentContexts.get(Thread.currentThread());
        Xid currentContext = currentContextTuple != null ? currentContextTuple.getXid() : null;
        Vector<Xid> list = new Vector<Xid>();
        if (currentContextTuple.getStatus() == 1 && currentContext != null) {
            list.addElement(currentContext);
        }
        return list.toArray(new Xid[list.size()]);
    }

    public void rollback(Xid xid) throws XAException {
        Xid currentContext;
        ContextTuple currentContextTuple = (ContextTuple)this.currentContexts.get(Thread.currentThread());
        Xid xid2 = currentContext = currentContextTuple != null ? currentContextTuple.getXid() : null;
        if (currentContext == null) {
            throw new XAException(-4);
        }
        if (xid == null) {
            throw new XAException(-5);
        }
        if (currentContext.getGlobalTransactionId() != xid.getGlobalTransactionId()) {
            throw new XAException(-6);
        }
        this.currentContexts.remove(Thread.currentThread());
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        ((ContextTuple)this.currentContexts.get(Thread.currentThread())).setTransactionTimeout(seconds);
        return true;
    }

    public void start(Xid xid, int flags) throws XAException {
        Xid currentContext;
        ContextTuple currentContextTuple = (ContextTuple)this.currentContexts.get(Thread.currentThread());
        Xid xid2 = currentContext = currentContextTuple != null ? currentContextTuple.getXid() : null;
        if (xid == null) {
            throw new XAException(-5);
        }
        if (currentContext != null && currentContext.getGlobalTransactionId() != xid.getGlobalTransactionId()) {
            throw new XAException(-9);
        }
        switch (flags) {
            case 0: {
                if (currentContext != null) {
                    throw new XAException(-5);
                }
                currentContext = xid;
                this.currentContexts.put(Thread.currentThread(), new ContextTuple(xid, 0, 30, false));
                break;
            }
            case 0x200000: {
                if (currentContext == null) {
                    throw new XAException(-4);
                }
                if (currentContext.getGlobalTransactionId() == xid.getGlobalTransactionId()) break;
                throw new XAException(-5);
            }
            case 0x8000000: {
                if (currentContext == null) {
                    throw new XAException(-4);
                }
                if (currentContextTuple.getStatus() != 2) {
                    throw new XAException(-5);
                }
                currentContextTuple.setStatus(0);
            }
        }
    }

    private class ContextTuple {
        private Xid xid;
        private int status;
        private int transactionTimeout;
        private boolean rollbackOnly;

        public ContextTuple(Xid xid, int status, int transactionTimeout, boolean rollbackOnly) {
            this.xid = xid;
            this.setStatus(status);
            this.setTransactionTimeout(transactionTimeout);
            this.setRollbackOnly(rollbackOnly);
        }

        public Xid getXid() {
            return this.xid;
        }

        public int getStatus() {
            return this.status;
        }

        public void setStatus(int status) {
            this.status = status;
        }

        public int getTransactionTimeout() {
            return this.transactionTimeout;
        }

        public void setTransactionTimeout(int transactionTimeout) {
            this.transactionTimeout = transactionTimeout;
        }

        public boolean getRollbackOnly() {
            return this.rollbackOnly;
        }

        public void setRollbackOnly(boolean rollbackOnly) {
            this.rollbackOnly = rollbackOnly;
        }
    }
}

