/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.common;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.apache.slide.authenticate.CredentialsToken;
import org.apache.slide.common.Domain;
import org.apache.slide.common.NamespaceAccessTokenImpl;
import org.apache.slide.common.NamespaceConfig;
import org.apache.slide.common.Scope;
import org.apache.slide.common.Service;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.ServiceConnectionFailedException;
import org.apache.slide.common.ServiceDisconnectionFailedException;
import org.apache.slide.common.ServiceInitializationFailedException;
import org.apache.slide.common.ServiceParameterErrorException;
import org.apache.slide.common.ServiceParameterMissingException;
import org.apache.slide.common.ServiceRegistrationFailedException;
import org.apache.slide.common.ServicesInitializationFailedException;
import org.apache.slide.common.ServicesShutDownFailedException;
import org.apache.slide.common.SlideException;
import org.apache.slide.common.SlideToken;
import org.apache.slide.common.SlideTokenImpl;
import org.apache.slide.common.SlideTokenWrapper;
import org.apache.slide.common.UnknownServiceDeclarationException;
import org.apache.slide.common.Uri;
import org.apache.slide.content.ContentInterceptor;
import org.apache.slide.extractor.Extractor;
import org.apache.slide.extractor.ExtractorManager;
import org.apache.slide.store.ContentStore;
import org.apache.slide.store.DefaultIndexer;
import org.apache.slide.store.IndexStore;
import org.apache.slide.store.LockStore;
import org.apache.slide.store.NodeStore;
import org.apache.slide.store.RevisionDescriptorStore;
import org.apache.slide.store.RevisionDescriptorsStore;
import org.apache.slide.store.SecurityStore;
import org.apache.slide.store.SequenceStore;
import org.apache.slide.store.Store;
import org.apache.slide.structure.ObjectAlreadyExistsException;
import org.apache.slide.structure.SubjectNode;
import org.apache.slide.transaction.SlideTransactionManager;
import org.apache.slide.util.conf.Configurable;
import org.apache.slide.util.conf.Configuration;
import org.apache.slide.util.conf.ConfigurationException;
import org.apache.slide.util.logger.Logger;

public final class Namespace {
    public static final String REFERENCE = "reference";
    public static final String NODE_STORE = "nodestore";
    public static final String SECURITY_STORE = "securitystore";
    public static final String LOCK_STORE = "lockstore";
    public static final String REVISION_DESCRIPTORS_STORE = "revisiondescriptorsstore";
    public static final String REVISION_DESCRIPTOR_STORE = "revisiondescriptorstore";
    public static final String CONTENT_STORE = "contentstore";
    public static final String PROPERTIES_INDEX_STORE = "propertiesindexer";
    public static final String CONTENT_INDEX_STORE = "contentindexer";
    public static final String SEQUENCE_STORE = "sequencestore";
    private static final String LOG_CHANNEL = (class$org$apache$slide$common$Namespace == null ? (class$org$apache$slide$common$Namespace = Namespace.class$("org.apache.slide.common.Namespace")) : class$org$apache$slide$common$Namespace).getName();
    protected static final String I_CREATESTORELISTENERCLASS = "createStoreListenerClass";
    protected static final String I_CREATESTORELISTENERCLASS_DEFAULT = "org.apache.slide.webdav.util.UriHandler";
    protected static Class createStoreListenerClass;
    private String name;
    private String searchClassName;
    private transient Vector connectedServices;
    private transient Hashtable stores;
    private NamespaceConfig config;
    private Hashtable uriCache;
    private String defaultStoreClassname = "org.apache.slide.store.ExtendedStore";
    private TransactionManager transactionManager = new SlideTransactionManager();
    private Logger logger;
    private Logger applicationLogger;
    static /* synthetic */ Class class$org$apache$slide$common$Namespace;
    static /* synthetic */ Class class$java$lang$String;

    Namespace() {
        this.stores = new Hashtable();
        this.connectedServices = new Vector();
        this.name = new String();
        this.uriCache = new Hashtable();
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setSearchClassName(String searchClassName) {
        this.searchClassName = searchClassName;
    }

    public String getSearchClassName() {
        return this.searchClassName;
    }

    public NamespaceConfig getConfig() {
        return this.config;
    }

    public Enumeration enumerateScopes() {
        return this.stores.keys();
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public Logger getLogger() {
        if (this.logger != null) {
            return this.logger;
        }
        return Domain.getLogger();
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
        if (this.transactionManager instanceof SlideTransactionManager) {
            ((SlideTransactionManager)this.transactionManager).setLogger(logger);
        }
    }

    public Logger getApplicationLogger() {
        if (this.applicationLogger != null) {
            return this.applicationLogger;
        }
        if (this.logger != null) {
            return this.logger;
        }
        return Domain.getLogger();
    }

    public void setApplicationLogger(Logger logger) {
        this.applicationLogger = logger;
    }

    public void registerStore(String storeName, Class storeClass, Hashtable parameters, Scope scope, Hashtable childStores) throws ServiceRegistrationFailedException, ServiceParameterErrorException, ServiceParameterMissingException {
        if (!this.stores.containsKey(scope)) {
            try {
                Store store = (Store)storeClass.newInstance();
                store.setName(storeName);
                store.setParameters(parameters);
                this.stores.put(scope, store);
                NodeStore nodeStore = (NodeStore)this.dereferenceStore(NODE_STORE, childStores);
                store.setNodeStore(nodeStore);
                SecurityStore securityStore = (SecurityStore)this.dereferenceStore(SECURITY_STORE, childStores);
                store.setSecurityStore(securityStore);
                LockStore lockStore = (LockStore)this.dereferenceStore(LOCK_STORE, childStores);
                store.setLockStore(lockStore);
                RevisionDescriptorsStore revisionDescriptorsStore = (RevisionDescriptorsStore)this.dereferenceStore(REVISION_DESCRIPTORS_STORE, childStores);
                store.setRevisionDescriptorsStore(revisionDescriptorsStore);
                RevisionDescriptorStore revisionDescriptorStore = (RevisionDescriptorStore)this.dereferenceStore(REVISION_DESCRIPTOR_STORE, childStores);
                store.setRevisionDescriptorStore(revisionDescriptorStore);
                ContentStore contentStore = (ContentStore)this.dereferenceStore(CONTENT_STORE, childStores);
                store.setContentStore(contentStore);
                IndexStore propertiesIndexer = (IndexStore)this.dereferenceStore(PROPERTIES_INDEX_STORE, childStores);
                if (propertiesIndexer == null) {
                    propertiesIndexer = new DefaultIndexer(revisionDescriptorStore);
                    childStores.put(PROPERTIES_INDEX_STORE, propertiesIndexer);
                }
                store.setPropertiesIndexer(propertiesIndexer);
                IndexStore contentIndexer = (IndexStore)this.dereferenceStore(CONTENT_INDEX_STORE, childStores);
                if (contentIndexer == null) {
                    contentIndexer = new DefaultIndexer(contentStore);
                    childStores.put(CONTENT_INDEX_STORE, contentIndexer);
                }
                store.setContentIndexer(contentIndexer);
                SequenceStore sequenceStore = (SequenceStore)this.dereferenceStore(SEQUENCE_STORE, childStores);
                store.setSequenceStore(sequenceStore);
                store.setScope(scope);
                this.notifyStoreCreated(this.name, scope.toString(), storeName);
            }
            catch (InstantiationException e) {
                throw new ServiceRegistrationFailedException(storeClass);
            }
            catch (IllegalAccessException e) {
                throw new ServiceRegistrationFailedException(storeClass);
            }
            catch (NullPointerException e) {
                throw new ServiceRegistrationFailedException(storeClass);
            }
            catch (ClassCastException e) {
                this.getLogger().log(e, LOG_CHANNEL, 2);
                throw new ServiceRegistrationFailedException(storeClass);
            }
        }
    }

    Object dereferenceStore(String storeType, Hashtable childStores) {
        Object o = childStores.get(storeType);
        Object result = o instanceof String ? childStores.get(o) : o;
        return result;
    }

    public void initializeServices() throws ServicesInitializationFailedException {
        ServicesInitializationFailedException nestedException = new ServicesInitializationFailedException();
        Enumeration serviceList = this.stores.elements();
        while (serviceList.hasMoreElements()) {
            Service service = (Service)serviceList.nextElement();
            try {
                this.getLogger().log("Initializing Store " + service, LOG_CHANNEL, 6);
                service.setNamespace(this);
                service.initialize(new NamespaceAccessTokenImpl(this));
            }
            catch (ServiceInitializationFailedException e) {
                nestedException.addException(e);
            }
        }
        if (!nestedException.isEmpty()) {
            throw nestedException;
        }
    }

    public void clearNamespace() {
        this.stores.clear();
    }

    public void connectService(Service service, CredentialsToken token) throws ServiceConnectionFailedException, ServiceAccessException {
        boolean newConnection = service.connectIfNeeded(token);
        if (newConnection) {
            this.connectedServices.addElement(service);
        }
    }

    public void disconnectServices() throws ServicesShutDownFailedException {
        ServicesShutDownFailedException nestedException = new ServicesShutDownFailedException();
        for (int i = 0; i < this.connectedServices.size(); ++i) {
            try {
                Service service = (Service)this.connectedServices.elementAt(i);
                if (!service.isConnected()) continue;
                this.getLogger().log("Shutting down service " + service, LOG_CHANNEL, 6);
                service.disconnect();
                continue;
            }
            catch (ServiceDisconnectionFailedException e) {
                nestedException.addException(e);
                continue;
            }
            catch (ServiceAccessException e) {
                nestedException.addException(e);
            }
        }
        this.connectedServices.removeAllElements();
        if (!nestedException.isEmpty()) {
            throw nestedException;
        }
    }

    public void unregisterStore(Scope scope) throws ServiceDisconnectionFailedException, ServiceAccessException {
        if (this.stores.containsKey(scope)) {
            Store store = (Store)this.stores.get(scope);
            if (store.isConnected()) {
                store.disconnect();
                this.connectedServices.removeElement(store);
            }
            this.stores.remove(scope);
            Object var2_2 = null;
        }
    }

    public Store getStore(Scope scope) {
        Store store = null;
        if (this.stores.containsKey(scope)) {
            store = (Store)this.stores.get(scope);
        }
        return store;
    }

    public Store retrieveStore(Scope scope, CredentialsToken token) throws ServiceConnectionFailedException, ServiceAccessException {
        Store store = this.getStore(scope);
        if (store != null) {
            this.connectService(store, token);
        }
        return store;
    }

    public Uri getUri(String uri) {
        return this.getUri(null, uri);
    }

    public Uri getUri(SlideToken token, String uri) {
        return this.getUri(token, uri, token == null ? false : token.isForceStoreEnlistment());
    }

    public Uri getUri(SlideToken token, String uri, boolean forcedEnlistment) {
        Uri result = null;
        Object temp = null;
        temp = this.uriCache.get(uri);
        if (temp == null) {
            result = new Uri(token, this, uri);
            this.uriCache.put(uri, result);
            if (this.uriCache.size() > 10000) {
                this.clearUriCache();
            }
        } else {
            result = temp;
            result = result.cloneObject();
            result.setToken(token);
            result.reconnectServices();
        }
        if (token != null && token.isForceStoreEnlistment() != forcedEnlistment) {
            SlideTokenWrapper wToken = new SlideTokenWrapper(token);
            wToken.setForceStoreEnlistment(forcedEnlistment);
            result.setToken(wToken);
        }
        return result;
    }

    void clearUriCache() {
        this.uriCache.clear();
    }

    public ContentInterceptor[] getContentInterceptors() {
        return this.config.getContentInterceptors();
    }

    void loadDefinition(Configuration definition) throws SlideException, ConfigurationException {
        this.getLogger().log("Loading namespace definition", LOG_CHANNEL, 6);
        Hashtable storesClass = new Hashtable();
        Hashtable storesParameters = new Hashtable();
        Hashtable childStores = new Hashtable();
        Enumeration storeDefinitions = definition.getConfigurations("store");
        while (storeDefinitions.hasMoreElements()) {
            this.loadStoreDefinition((Configuration)storeDefinitions.nextElement(), storesClass, storesParameters, childStores);
        }
        Enumeration scopeDefinitions = definition.getConfigurations("scope");
        while (scopeDefinitions.hasMoreElements()) {
            this.loadScopeDefinition((Configuration)scopeDefinitions.nextElement(), storesClass, storesParameters, childStores);
        }
        this.initializeServices();
    }

    void loadBaseData(Configuration namespaceBaseDataDefinition) throws SlideException, ConfigurationException {
        this.getLogger().log("Loading namespace " + this.getName() + " base data", LOG_CHANNEL, 6);
        try {
            this.getTransactionManager().begin();
            SlideTokenImpl slideToken = new SlideTokenImpl(new CredentialsToken(""));
            slideToken.setForceStoreEnlistment(true);
            Uri rootUri = this.getUri(slideToken, "/");
            SubjectNode rootNode = new SubjectNode("/");
            try {
                rootUri.getStore().createObject(rootUri, rootNode);
            }
            catch (ObjectAlreadyExistsException e) {
                this.getTransactionManager().rollback();
                this.getTransactionManager().begin();
            }
            this.getTransactionManager().commit();
            this.getLogger().log("Init namespace " + this.getName() + " configuration", LOG_CHANNEL, 6);
            this.config.initializeAsDummyConfig(this);
            NamespaceAccessTokenImpl token = new NamespaceAccessTokenImpl(this);
            token.begin();
            this.getLogger().log("Import data into namespace " + this.getName(), LOG_CHANNEL, 6);
            token.importData((SlideToken)slideToken, namespaceBaseDataDefinition);
            token.commit();
            this.getTransactionManager().begin();
            this.getLogger().log("Finish init namespace " + this.getName() + " configuration", LOG_CHANNEL, 6);
            rootNode = (SubjectNode)rootUri.getStore().retrieveObject(rootUri);
            rootUri.getStore().storeObject(rootUri, rootNode);
            this.getTransactionManager().commit();
        }
        catch (SlideException e) {
            e.printStackTrace();
            this.getLogger().log("Namespace base configuration was already done before", LOG_CHANNEL, 6);
            try {
                if (this.getTransactionManager().getStatus() == 0) {
                    this.getTransactionManager().rollback();
                }
            }
            catch (SystemException ex) {
                this.getLogger().log("Could not rollback namespace base configuration: " + ex.toString(), LOG_CHANNEL, 4);
            }
        }
        catch (Exception e) {
            this.getLogger().log("Unable to read Namespace base configuration file : ", LOG_CHANNEL, 2);
            this.getLogger().log(e, LOG_CHANNEL, 2);
            try {
                if (this.getTransactionManager().getStatus() == 0) {
                    this.getTransactionManager().rollback();
                }
            }
            catch (SystemException ex) {
                this.getLogger().log("Could not rollback namespace base configuration after load error: " + ex.toString(), LOG_CHANNEL, 4);
            }
        }
    }

    void loadConfiguration(Configuration namespaceConfigurationDefinition) throws SlideException {
        this.getLogger().log("Loading namespace " + this.getName() + " configuration", LOG_CHANNEL, 6);
        this.config = new NamespaceConfig();
        this.config.initializeNamespaceConfig(this, namespaceConfigurationDefinition);
    }

    void loadParameters(Configuration namespaceConfigurationDefinition) throws SlideException {
        this.getLogger().log("Loading namespace " + this.getName() + " parameters", LOG_CHANNEL, 6);
        this.config = new NamespaceConfig();
        this.config.initializeNamespaceParameters(this, namespaceConfigurationDefinition);
    }

    void loadExtractors(Configuration namespaceExtractorsDefinition) throws SlideException {
        this.getLogger().log("Loading namespace " + this.getName() + " extractors", LOG_CHANNEL, 6);
        Enumeration extractorConfigs = namespaceExtractorsDefinition.getConfigurations("extractor");
        while (extractorConfigs.hasMoreElements()) {
            Configuration extractorConfig = (Configuration)extractorConfigs.nextElement();
            String classname = extractorConfig.getAttribute("classname");
            String uri = extractorConfig.getAttribute("uri", null);
            String contentType = extractorConfig.getAttribute("content-type", null);
            String namespace = this.getName();
            try {
                Class<?> extractorClass = Class.forName(classname);
                Extractor extractor = null;
                Constructor<?> extractorConstructor = extractorClass.getConstructor(class$java$lang$String == null ? Namespace.class$("java.lang.String") : class$java$lang$String, class$java$lang$String == null ? Namespace.class$("java.lang.String") : class$java$lang$String, class$java$lang$String == null ? Namespace.class$("java.lang.String") : class$java$lang$String);
                extractor = (Extractor)extractorConstructor.newInstance(uri, contentType, namespace);
                if (extractor instanceof Configurable) {
                    ((Configurable)((Object)extractor)).configure(extractorConfig.getConfiguration("configuration"));
                }
                ExtractorManager.getInstance().addExtractor(extractor);
            }
            catch (ClassCastException e) {
                throw new ConfigurationException("Extractor '" + classname + "' is not of type Extractor", namespaceExtractorsDefinition);
            }
            catch (ConfigurationException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ConfigurationException("Extractor '" + classname + "' could not be loaded", namespaceExtractorsDefinition);
            }
        }
    }

    private void loadStoreDefinition(Configuration storeDefinition, Hashtable storesClass, Hashtable storesParameters, Hashtable childStores) throws ConfigurationException, SlideException {
        String storeName = storeDefinition.getAttribute("name");
        String storeClassname = this.defaultStoreClassname;
        try {
            storeClassname = storeDefinition.getAttribute("classname");
        }
        catch (ConfigurationException e) {
            // empty catch block
        }
        Enumeration storeParametersDefinitions = storeDefinition.getConfigurations("parameter");
        Class<?> storeClass = null;
        try {
            storeClass = Class.forName(storeClassname);
        }
        catch (Exception e) {
            this.getLogger().log(e, LOG_CHANNEL, 2);
            throw new SlideException(e.getMessage());
        }
        storesClass.put(storeName, storeClass);
        Hashtable<String, String> storeParameters = new Hashtable<String, String>();
        while (storeParametersDefinitions.hasMoreElements()) {
            Configuration parameterDefinition = (Configuration)storeParametersDefinitions.nextElement();
            String parameterName = parameterDefinition.getAttribute("name");
            String parameterValue = parameterDefinition.getValue();
            storeParameters.put(parameterName, parameterValue);
        }
        storesParameters.put(storeName, storeParameters);
        Hashtable currentStoreChildStores = new Hashtable();
        this.getChildStore(storeDefinition, NODE_STORE, currentStoreChildStores, storeParameters);
        this.getChildStore(storeDefinition, SECURITY_STORE, currentStoreChildStores, storeParameters);
        this.getChildStore(storeDefinition, LOCK_STORE, currentStoreChildStores, storeParameters);
        this.getChildStore(storeDefinition, REVISION_DESCRIPTORS_STORE, currentStoreChildStores, storeParameters);
        this.getChildStore(storeDefinition, REVISION_DESCRIPTOR_STORE, currentStoreChildStores, storeParameters);
        this.getChildStore(storeDefinition, CONTENT_STORE, currentStoreChildStores, storeParameters);
        this.getChildStore(storeDefinition, PROPERTIES_INDEX_STORE, currentStoreChildStores, storeParameters);
        this.getChildStore(storeDefinition, CONTENT_INDEX_STORE, currentStoreChildStores, storeParameters);
        this.getChildStore(storeDefinition, SEQUENCE_STORE, currentStoreChildStores, storeParameters);
        childStores.put(storeName, currentStoreChildStores);
    }

    private void getChildStore(Configuration storeDefinition, String key, Hashtable currentStoreChildStores, Hashtable storeParameters) throws SlideException {
        Configuration localStoreDefinition;
        try {
            localStoreDefinition = storeDefinition.getConfiguration(key);
        }
        catch (ConfigurationException e) {
            return;
        }
        try {
            try {
                Configuration referenceDefinition = localStoreDefinition.getConfiguration(REFERENCE);
                currentStoreChildStores.put(key, referenceDefinition.getAttribute("store"));
                this.getLogger().log(key + " references " + referenceDefinition.getAttribute("store"), LOG_CHANNEL, 6);
            }
            catch (ConfigurationException ex) {
                this.getLogger().log(key + ": " + localStoreDefinition.getAttribute("classname"), LOG_CHANNEL, 6);
                Service store = this.loadChildStore(localStoreDefinition, storeParameters);
                if (store != null) {
                    currentStoreChildStores.put(key, store);
                }
            }
        }
        catch (ConfigurationException e) {
            this.getLogger().log("Exception while loading " + key + "!", e, LOG_CHANNEL, 4);
        }
    }

    private Service loadChildStore(Configuration childStoreDefinition, Hashtable fatherParameters) throws ConfigurationException, SlideException {
        String childStoreClassname = childStoreDefinition.getAttribute("classname");
        Service childStore = null;
        try {
            Class<?> childStoreClass = Class.forName(childStoreClassname);
            childStore = (Service)childStoreClass.newInstance();
        }
        catch (Exception e) {
            this.getLogger().log(e, LOG_CHANNEL, 2);
            return null;
        }
        Hashtable childStoreParameters = new Hashtable();
        Enumeration fatherParametersKeys = fatherParameters.keys();
        while (fatherParametersKeys.hasMoreElements()) {
            Object key = fatherParametersKeys.nextElement();
            Object value = fatherParameters.get(key);
            childStoreParameters.put(key, value);
        }
        Enumeration childStoreParametersDefinitions = childStoreDefinition.getConfigurations("parameter");
        while (childStoreParametersDefinitions.hasMoreElements()) {
            Configuration parameterDefinition = (Configuration)childStoreParametersDefinitions.nextElement();
            String parameterName = parameterDefinition.getAttribute("name");
            String parameterValue = parameterDefinition.getValue();
            childStoreParameters.put(parameterName, parameterValue);
        }
        childStore.setParameters(childStoreParameters);
        return childStore;
    }

    private void loadScopeDefinition(Configuration scopeDefinition, Hashtable storesClass, Hashtable storesParameters, Hashtable childStores) throws ConfigurationException, UnknownServiceDeclarationException, ServiceParameterErrorException, ServiceParameterMissingException, ServiceRegistrationFailedException {
        String match = scopeDefinition.getAttribute("match");
        String storeName = scopeDefinition.getAttribute("store");
        if (storeName != null) {
            if (!storesClass.containsKey(storeName) || !storesParameters.containsKey(storeName)) {
                throw new UnknownServiceDeclarationException(storeName);
            }
            this.registerStore(storeName, (Class)storesClass.get(storeName), (Hashtable)storesParameters.get(storeName), new Scope(match), (Hashtable)childStores.get(storeName));
            this.getLogger().log("Registering Store " + storeName + " (" + storesClass.get(storeName) + ") with parameters " + storesParameters.get(storeName) + " on scope " + match, LOG_CHANNEL, 6);
        }
    }

    private void notifyStoreCreated(String namespaceName, String scope, String storeName) {
        if (createStoreListenerClass != null) {
            try {
                Method nsc = createStoreListenerClass.getMethod("notifyStoreCreated", class$java$lang$String == null ? (class$java$lang$String = Namespace.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = Namespace.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = Namespace.class$("java.lang.String")) : class$java$lang$String);
                nsc.invoke(null, namespaceName, scope, storeName);
            }
            catch (Exception x) {
                Domain.warn("Notification of store creation (namespace=" + namespaceName + ", scope=" + scope + ", store=" + storeName + ") failed: " + x.getMessage());
            }
        }
    }

    public String toString() {
        return this.getName();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            String createStoreListenerClassName = Domain.getParameter(I_CREATESTORELISTENERCLASS, I_CREATESTORELISTENERCLASS_DEFAULT);
            createStoreListenerClass = Class.forName(createStoreListenerClassName);
        }
        catch (Exception x) {
            Domain.warn("Loading of create_store_listener class failed: " + x.getMessage());
        }
    }
}

