/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.event;

import java.util.EventListener;
import java.util.EventObject;
import org.apache.slide.common.Namespace;
import org.apache.slide.common.SlideToken;
import org.apache.slide.content.NodeRevisionContent;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionDescriptors;
import org.apache.slide.event.AbstractEventMethod;
import org.apache.slide.event.ContentListener;
import org.apache.slide.event.ResourceEvent;
import org.apache.slide.event.VetoException;
import org.apache.slide.event.VetoableEventMethod;

public class ContentEvent
extends ResourceEvent {
    public static final Create CREATE = new Create();
    public static final Remove REMOVE = new Remove();
    public static final Retrieve RETRIEVE = new Retrieve();
    public static final Store STORE = new Store();
    public static final Fork FORK = new Fork();
    public static final Merge MERGE = new Merge();
    public static final String GROUP = "content";
    public static final AbstractEventMethod[] methods = new AbstractEventMethod[]{CREATE, REMOVE, RETRIEVE, STORE, FORK, MERGE};
    private SlideToken token;
    private Namespace namespace;
    private NodeRevisionDescriptors revisionDescriptors;
    private NodeRevisionDescriptor revisionDescriptor;
    private NodeRevisionContent revisionContent;

    public ContentEvent(Object source, SlideToken token, Namespace namespace, String uri, NodeRevisionDescriptors revisionDescriptors) {
        this(source, token, namespace, uri, revisionDescriptors, null, null);
    }

    public ContentEvent(Object source, SlideToken token, Namespace namespace, String uri, NodeRevisionDescriptors revisionDescriptors, NodeRevisionDescriptor revisionDescriptor) {
        this(source, token, namespace, uri, revisionDescriptors, revisionDescriptor, null);
    }

    public ContentEvent(Object source, SlideToken token, Namespace namespace, String uri, NodeRevisionDescriptor revisionDescriptor, NodeRevisionContent revisionContent) {
        this(source, token, namespace, uri, null, revisionDescriptor, revisionContent);
    }

    public ContentEvent(Object source, SlideToken token, Namespace namespace, String uri, NodeRevisionDescriptor revisionDescriptor) {
        this(source, token, namespace, uri, null, revisionDescriptor, null);
    }

    public ContentEvent(Object source, SlideToken token, Namespace namespace, String uri, NodeRevisionDescriptors revisionDescriptors, NodeRevisionDescriptor revisionDescriptor, NodeRevisionContent revisionContent) {
        super(source, uri);
        this.token = token;
        this.namespace = namespace;
        this.revisionDescriptors = revisionDescriptors;
        this.revisionDescriptor = revisionDescriptor;
        this.revisionContent = revisionContent;
    }

    public SlideToken getToken() {
        return this.token;
    }

    public NodeRevisionDescriptors getRevisionDescriptors() {
        return this.revisionDescriptors;
    }

    public NodeRevisionDescriptor getRevisionDescriptor() {
        return this.revisionDescriptor;
    }

    public NodeRevisionContent getRevisionContent() {
        return this.revisionContent;
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(256);
        buffer.append(this.getClass().getName()).append("[content");
        if (this.revisionDescriptors != null) {
            buffer.append(" uri=").append(this.revisionDescriptors.getUri());
        }
        if (this.revisionDescriptor != null) {
            buffer.append(" contentType=").append(this.revisionDescriptor.getContentType());
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static AbstractEventMethod[] getMethods() {
        return methods;
    }

    public static String getGroup() {
        return GROUP;
    }

    public static final class Fork
    extends VetoableEventMethod {
        public Fork() {
            super(ContentEvent.GROUP, "fork");
        }

        public void fireVetaoableEvent(EventListener listener, EventObject event) throws VetoException {
            if (listener instanceof ContentListener) {
                ((ContentListener)listener).fork((ContentEvent)event);
            }
        }
    }

    public static final class Merge
    extends VetoableEventMethod {
        public Merge() {
            super(ContentEvent.GROUP, "merge");
        }

        public void fireVetaoableEvent(EventListener listener, EventObject event) throws VetoException {
            if (listener instanceof ContentListener) {
                ((ContentListener)listener).merge((ContentEvent)event);
            }
        }
    }

    public static final class Retrieve
    extends VetoableEventMethod {
        public Retrieve() {
            super(ContentEvent.GROUP, "retrieve");
        }

        public void fireVetaoableEvent(EventListener listener, EventObject event) throws VetoException {
            if (listener instanceof ContentListener) {
                ((ContentListener)listener).retrieve((ContentEvent)event);
            }
        }
    }

    public static final class Store
    extends VetoableEventMethod {
        public Store() {
            super(ContentEvent.GROUP, "store");
        }

        public void fireVetaoableEvent(EventListener listener, EventObject event) throws VetoException {
            if (listener instanceof ContentListener) {
                ((ContentListener)listener).store((ContentEvent)event);
            }
        }
    }

    public static final class Remove
    extends VetoableEventMethod {
        public Remove() {
            super(ContentEvent.GROUP, "remove");
        }

        public void fireVetaoableEvent(EventListener listener, EventObject event) throws VetoException {
            if (listener instanceof ContentListener) {
                ((ContentListener)listener).remove((ContentEvent)event);
            }
        }
    }

    public static final class Create
    extends VetoableEventMethod {
        public Create() {
            super(ContentEvent.GROUP, "create");
        }

        public void fireVetaoableEvent(EventListener listener, EventObject event) throws VetoException {
            if (listener instanceof ContentListener) {
                ((ContentListener)listener).create((ContentEvent)event);
            }
        }
    }
}

