/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.event;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import org.apache.slide.event.AbstractEventMethod;
import org.apache.slide.event.EventMethod;
import org.apache.slide.event.GlobalListener;
import org.apache.slide.event.VetoException;
import org.apache.slide.event.VetoableEventMethod;
import org.apache.slide.util.conf.Configurable;
import org.apache.slide.util.conf.Configuration;
import org.apache.slide.util.conf.ConfigurationException;

public class EventDispatcher
implements Configurable {
    private static EventDispatcher eventDispatcher = new EventDispatcher();
    private List eventListeners = new ArrayList();

    private EventDispatcher() {
    }

    public static EventDispatcher getInstance() {
        return eventDispatcher;
    }

    public void addEventListener(EventListener listener) {
        this.eventListeners.add(listener);
    }

    public void fireVetoableEvent(VetoableEventMethod eventMethod, EventObject event) throws VetoException {
        Iterator i = this.eventListeners.iterator();
        while (i.hasNext()) {
            EventListener listener = (EventListener)i.next();
            if (listener instanceof GlobalListener) {
                ((GlobalListener)listener).vetoableEventFired(eventMethod, event);
                continue;
            }
            eventMethod.fireVetaoableEvent(listener, event);
        }
    }

    public void fireEvent(EventMethod eventMethod, EventObject event) {
        Iterator i = this.eventListeners.iterator();
        while (i.hasNext()) {
            EventListener listener = (EventListener)i.next();
            if (listener instanceof GlobalListener) {
                ((GlobalListener)listener).eventFired(eventMethod, event);
                continue;
            }
            eventMethod.fireEvent(listener, event);
        }
    }

    public void configure(Configuration config) throws ConfigurationException {
        Enumeration listenerConfigs = config.getConfigurations("listener");
        while (listenerConfigs.hasMoreElements()) {
            Configuration listenerConfig = (Configuration)listenerConfigs.nextElement();
            String classname = listenerConfig.getAttribute("classname");
            try {
                Class<?> listenerClass = Class.forName(classname);
                EventListener eventListener = null;
                try {
                    Method getInstanceMethod = listenerClass.getMethod("getInstance", new Class[0]);
                    eventListener = (EventListener)getInstanceMethod.invoke(null, null);
                }
                catch (NoSuchMethodException e) {
                    eventListener = (EventListener)listenerClass.newInstance();
                }
                if (eventListener instanceof Configurable) {
                    Configuration conf = null;
                    try {
                        conf = listenerConfig.getConfiguration("configuration");
                    }
                    catch (ConfigurationException e) {
                        // empty catch block
                    }
                    if (conf != null) {
                        ((Configurable)((Object)eventListener)).configure(conf);
                    }
                }
                this.addEventListener(eventListener);
            }
            catch (ClassCastException e) {
                throw new ConfigurationException("Event listener '" + classname + "' is not of type EventListener", config);
            }
            catch (Exception e) {
                throw new ConfigurationException("Event listener '" + classname + "' could not be loaded", config);
            }
        }
        Enumeration enableConfigs = config.getConfigurations("event");
        while (enableConfigs.hasMoreElements()) {
            Configuration enableConfig = (Configuration)enableConfigs.nextElement();
            String classname = enableConfig.getAttribute("classname");
            String method = enableConfig.getAttribute("method", null);
            boolean enable = enableConfig.getAttributeAsBoolean("enable", true);
            try {
                Class<?> eventClass = Class.forName(classname);
                Field methodsField = eventClass.getField("methods");
                AbstractEventMethod[] methods = (AbstractEventMethod[])methodsField.get(null);
                for (int i = 0; i < methods.length; ++i) {
                    if (method != null && !methods[i].getName().equals(method)) continue;
                    methods[i].setEnabled(enable);
                }
            }
            catch (NoSuchFieldException e) {
                throw new ConfigurationException("Event '" + classname + "' does not provide the required static member 'methods'", config);
            }
            catch (Exception e) {
                throw new ConfigurationException("Event '" + classname + "' could not be loaded", config);
            }
        }
    }
}

