/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.extractor;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.poi.hpsf.NoPropertySetStreamException;
import org.apache.poi.hpsf.Property;
import org.apache.poi.hpsf.PropertySet;
import org.apache.poi.hpsf.PropertySetFactory;
import org.apache.poi.hpsf.Section;
import org.apache.poi.poifs.eventfilesystem.POIFSReader;
import org.apache.poi.poifs.eventfilesystem.POIFSReaderEvent;
import org.apache.poi.poifs.eventfilesystem.POIFSReaderListener;
import org.apache.slide.extractor.AbstractPropertyExtractor;
import org.apache.slide.extractor.ExtractorException;
import org.apache.slide.util.conf.Configurable;
import org.apache.slide.util.conf.Configuration;
import org.apache.slide.util.conf.ConfigurationException;

public class OfficeExtractor
extends AbstractPropertyExtractor
implements Configurable {
    protected List instructions = new ArrayList();
    protected Map propertyMap = new HashMap();

    public OfficeExtractor(String uri, String contentType, String namespace) {
        super(uri, contentType, namespace);
    }

    public Map extract(InputStream content) throws ExtractorException {
        OfficePropertiesListener listener = new OfficePropertiesListener();
        try {
            POIFSReader r = new POIFSReader();
            r.registerListener((POIFSReaderListener)listener);
            r.read(content);
        }
        catch (Exception e) {
            throw new ExtractorException("Exception while extracting properties in OfficeExtractor");
        }
        return listener.getProperties();
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        Enumeration instructions = configuration.getConfigurations("instruction");
        while (instructions.hasMoreElements()) {
            Configuration extract = (Configuration)instructions.nextElement();
            String property = extract.getAttribute("property");
            String id = extract.getAttribute("id");
            this.propertyMap.put(id, property);
        }
    }

    class OfficePropertiesListener
    implements POIFSReaderListener {
        private HashMap properties = new HashMap();

        OfficePropertiesListener() {
        }

        public Map getProperties() {
            return this.properties;
        }

        public void processPOIFSReaderEvent(POIFSReaderEvent event) {
            PropertySet ps = null;
            try {
                ps = PropertySetFactory.create((InputStream)event.getStream());
            }
            catch (NoPropertySetStreamException ex) {
                return;
            }
            catch (Exception ex) {
                throw new RuntimeException("Property set stream \"" + event.getPath() + event.getName() + "\": " + ex);
            }
            String eventName = event.getName().trim();
            long sectionCount = ps.getSectionCount();
            List sections = ps.getSections();
            int nr = 0;
            Iterator i = sections.iterator();
            while (i.hasNext()) {
                Section sec = (Section)i.next();
                int propertyCount = sec.getPropertyCount();
                Property[] props = sec.getProperties();
                for (int i2 = 0; i2 < props.length; ++i2) {
                    Property p = props[i2];
                    int id = p.getID();
                    long type = p.getType();
                    Object value = p.getValue();
                    String key = eventName + "-" + nr + "-" + id;
                    if (!OfficeExtractor.this.propertyMap.containsKey(key)) continue;
                    this.properties.put(OfficeExtractor.this.propertyMap.get(key), value);
                }
            }
        }
    }
}

