/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.lock;

import java.util.Date;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;
import org.apache.slide.common.Namespace;
import org.apache.slide.common.NamespaceConfig;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.SlideException;
import org.apache.slide.common.SlideToken;
import org.apache.slide.common.Uri;
import org.apache.slide.event.EventDispatcher;
import org.apache.slide.event.LockEvent;
import org.apache.slide.event.VetoException;
import org.apache.slide.lock.Lock;
import org.apache.slide.lock.LockTokenNotFoundException;
import org.apache.slide.lock.NodeLock;
import org.apache.slide.lock.ObjectIsAlreadyLockedException;
import org.apache.slide.lock.ObjectLockedException;
import org.apache.slide.lock.UnlockListener;
import org.apache.slide.security.AccessDeniedException;
import org.apache.slide.security.Security;
import org.apache.slide.structure.ActionNode;
import org.apache.slide.structure.ObjectNode;
import org.apache.slide.structure.ObjectNotFoundException;
import org.apache.slide.structure.SubjectNode;
import org.apache.slide.util.Configuration;

public final class LockImpl
implements Lock {
    private Namespace namespace;
    private NamespaceConfig namespaceConfig;
    private Security securityHelper;

    public LockImpl(Namespace namespace, NamespaceConfig namespaceConfig, Security securityHelper) {
        this.namespace = namespace;
        this.namespaceConfig = namespaceConfig;
        this.securityHelper = securityHelper;
    }

    public void lock(SlideToken slideToken, NodeLock lockToken) throws ServiceAccessException, ObjectIsAlreadyLockedException, AccessDeniedException, ObjectNotFoundException, VetoException {
        boolean canLock;
        ObjectIsAlreadyLockedException nestedException = new ObjectIsAlreadyLockedException(lockToken.getObjectUri());
        Uri objectUri = this.namespace.getUri(slideToken, lockToken.getObjectUri(), true);
        boolean bl = canLock = !this.isLockedInternal(slideToken, lockToken, true, nestedException);
        if (!canLock) {
            throw nestedException;
        }
        ObjectNode lockedObject = objectUri.getStore().retrieveObject(objectUri);
        this.securityHelper.checkCredentials(slideToken, lockedObject, this.namespaceConfig.getLockObjectAction());
        objectUri.getStore().putLock(objectUri, lockToken);
        if (LockEvent.LOCK.isEnabled()) {
            EventDispatcher.getInstance().fireVetoableEvent(LockEvent.LOCK, new LockEvent(this, slideToken, this.namespace, objectUri));
        }
    }

    public boolean unlock(SlideToken slideToken, NodeLock lockToken) throws ServiceAccessException, LockTokenNotFoundException, VetoException {
        try {
            if (!this.checkLockOwner(slideToken, lockToken)) {
                return false;
            }
            if (slideToken.isEnforceLockTokens() && !this.checkLockToken(slideToken, lockToken)) {
                return false;
            }
        }
        catch (ObjectNotFoundException e) {
            return false;
        }
        Uri lockedUri = this.namespace.getUri(slideToken, lockToken.getObjectUri(), true);
        lockedUri.getStore().removeLock(lockedUri, lockToken);
        if (LockEvent.UNLOCK.isEnabled()) {
            EventDispatcher.getInstance().fireVetoableEvent(LockEvent.UNLOCK, new LockEvent(this, slideToken, this.namespace, lockedUri));
        }
        return true;
    }

    public void unlock(SlideToken slideToken, String objectUri, String lockId) throws ServiceAccessException, LockTokenNotFoundException, ObjectNotFoundException, VetoException {
        Enumeration locksList = this.enumerateLocks(slideToken, objectUri, false);
        while (locksList.hasMoreElements()) {
            NodeLock currentLock = (NodeLock)locksList.nextElement();
            if (!currentLock.getLockId().equals(lockId)) continue;
            if (slideToken.isEnforceLockTokens()) {
                slideToken.addLockToken(lockId);
            }
            this.unlock(slideToken, currentLock);
        }
    }

    public void renew(SlideToken slideToken, NodeLock lockToken, Date newExpirationDate) throws ServiceAccessException, LockTokenNotFoundException, VetoException {
        lockToken.setExpirationDate(newExpirationDate);
        Uri lockedUri = this.namespace.getUri(slideToken, lockToken.getObjectUri());
        lockedUri.getStore().renewLock(lockedUri, lockToken);
        if (LockEvent.RENEW.isEnabled()) {
            EventDispatcher.getInstance().fireVetoableEvent(LockEvent.RENEW, new LockEvent(this, slideToken, this.namespace, lockedUri));
        }
    }

    public void renew(SlideToken slideToken, String objectUri, String lockId, Date newExpirationDate) throws ServiceAccessException, LockTokenNotFoundException, ObjectNotFoundException, VetoException {
        Enumeration locksList = this.enumerateLocks(slideToken, objectUri, false);
        while (locksList.hasMoreElements()) {
            NodeLock currentLock = (NodeLock)locksList.nextElement();
            if (!currentLock.getLockId().equals(lockId)) continue;
            this.renew(slideToken, currentLock, newExpirationDate);
        }
    }

    public void kill(SlideToken slideToken, SubjectNode subject) throws ServiceAccessException, AccessDeniedException, LockTokenNotFoundException, ObjectNotFoundException, VetoException {
        Uri subjectUri = this.namespace.getUri(slideToken, subject.getUri());
        Enumeration locks = subjectUri.getStore().enumerateLocks(subjectUri);
        while (locks.hasMoreElements()) {
            this.securityHelper.checkCredentials(slideToken, subject, this.namespaceConfig.getKillLockAction());
            subjectUri.getStore().killLock(subjectUri, (NodeLock)locks.nextElement());
        }
        if (LockEvent.KILL.isEnabled()) {
            EventDispatcher.getInstance().fireVetoableEvent(LockEvent.KILL, new LockEvent(this, slideToken, this.namespace, subjectUri));
        }
    }

    public Enumeration enumerateLocks(SlideToken slideToken, String objectUri) throws ServiceAccessException, ObjectNotFoundException, LockTokenNotFoundException {
        return this.enumerateLocks(slideToken, objectUri, true);
    }

    public Enumeration enumerateLocks(SlideToken slideToken, String objectUri, boolean inherited) throws ServiceAccessException, ObjectNotFoundException, LockTokenNotFoundException {
        Uri subjectUri = this.namespace.getUri(slideToken, objectUri);
        Enumeration scopes = null;
        if (inherited) {
            scopes = subjectUri.getScopes();
        } else {
            Vector<String> scopeVector = new Vector<String>();
            scopeVector.add(subjectUri.toString());
            scopes = scopeVector.elements();
        }
        Vector<NodeLock> locksVector = new Vector<NodeLock>();
        while (scopes.hasMoreElements()) {
            String currentScope = (String)scopes.nextElement();
            Uri currentScopeUri = this.namespace.getUri(slideToken, currentScope);
            Enumeration currentLocks = currentScopeUri.getStore().enumerateLocks(currentScopeUri);
            while (currentLocks.hasMoreElements()) {
                NodeLock currentLockToken = (NodeLock)currentLocks.nextElement();
                if (currentLockToken.hasExpired()) {
                    try {
                        currentScopeUri.getStore().removeLock(currentScopeUri, currentLockToken);
                    }
                    catch (LockTokenNotFoundException ex) {}
                    continue;
                }
                locksVector.addElement(currentLockToken);
            }
        }
        return locksVector.elements();
    }

    public void checkLock(SlideToken token, ObjectNode object, ActionNode action) throws ServiceAccessException, ObjectNotFoundException, ObjectLockedException {
        if (!token.isForceLock()) {
            return;
        }
        if (Configuration.useIntegratedLocking()) {
            Boolean locked = token.checkLockCache(object, action);
            if (locked != null) {
                if (locked.booleanValue()) {
                    throw new ObjectLockedException(object.getUri());
                }
                return;
            }
            Uri objectUri = this.namespace.getUri(token, object.getUri());
            ObjectNode realObject = objectUri.getStore().retrieveObject(objectUri);
            try {
                this.checkLock(token, realObject, (SubjectNode)this.securityHelper.getPrincipal(token), action);
                token.cacheLock(object, action, false);
            }
            catch (ObjectLockedException e) {
                token.cacheLock(object, action, true);
                throw e;
            }
        }
    }

    public void checkLock(SlideToken slideToken, ObjectNode subject, SubjectNode user, ActionNode action) throws ServiceAccessException, ObjectNotFoundException, ObjectLockedException {
        if (action.equals(ActionNode.DEFAULT)) {
            return;
        }
        if (Configuration.useIntegratedLocking() && this.isLocked(slideToken, subject, user, action, false)) {
            throw new ObjectLockedException(subject.getUri());
        }
    }

    public boolean isLocked(SlideToken slideToken, ObjectNode subject, SubjectNode user, ActionNode action, boolean tryToLock) throws ServiceAccessException, ObjectNotFoundException {
        NodeLock token = new NodeLock(subject, user, action, new Date(), false);
        return this.isLocked(slideToken, token, tryToLock);
    }

    public boolean isLocked(SlideToken slideToken, ObjectNode subject, SubjectNode user, ActionNode action, boolean inheritance, boolean tryToLock) throws ServiceAccessException, ObjectNotFoundException {
        NodeLock token = new NodeLock(subject, user, action, new Date(), inheritance);
        return this.isLocked(slideToken, token, tryToLock);
    }

    public boolean isLocked(SlideToken slideToken, NodeLock token, boolean tryToLock) throws ServiceAccessException, ObjectNotFoundException {
        return this.isLockedInternal(slideToken, token, tryToLock, null);
    }

    public void clearExpiredLocks(SlideToken slideToken, String objectUri, UnlockListener listener) throws SlideException {
        Uri uri = this.namespace.getUri(slideToken, objectUri);
        Enumeration currentLocks = uri.getStore().enumerateLocks(uri);
        while (currentLocks.hasMoreElements()) {
            NodeLock currentLockToken = (NodeLock)currentLocks.nextElement();
            if (!currentLockToken.hasExpired()) continue;
            try {
                uri.getStore().removeLock(uri, currentLockToken);
                if (listener == null) continue;
                listener.afterUnlock(objectUri);
            }
            catch (LockTokenNotFoundException ex) {}
        }
    }

    public boolean checkLockToken(SlideToken slideToken, NodeLock token) {
        if (!slideToken.isEnforceLockTokens()) {
            return true;
        }
        if (Configuration.usePrincipalIdentifiedLocks()) {
            SubjectNode principalNode = null;
            SubjectNode ownerNode = SubjectNode.getSubjectNode(token.getSubjectUri());
            try {
                principalNode = (SubjectNode)this.securityHelper.getPrincipal(slideToken);
            }
            catch (SlideException e) {
                // empty catch block
            }
            if (ownerNode != null && !ownerNode.equals(SubjectNode.UNAUTHENTICATED) && ownerNode.equals(principalNode)) {
                return true;
            }
            return slideToken.checkLockToken(token.getLockId());
        }
        return slideToken.checkLockToken(token.getLockId());
    }

    public boolean checkLockOwner(SlideToken slideToken, NodeLock token) throws ObjectNotFoundException, ServiceAccessException {
        SubjectNode lockOwner;
        boolean canUnlock = true;
        SubjectNode principal = (SubjectNode)this.securityHelper.getPrincipal(slideToken);
        if (!this.securityHelper.matchPrincipal(slideToken, principal, lockOwner = SubjectNode.getSubjectNode(token.getSubjectUri()))) {
            try {
                this.securityHelper.checkCredentials(slideToken, SubjectNode.getSubjectNode(token.getObjectUri()), this.namespaceConfig.getKillLockAction());
            }
            catch (AccessDeniedException e) {
                canUnlock = false;
            }
        }
        return canUnlock;
    }

    private boolean isLockedInternal(SlideToken slideToken, NodeLock token, boolean tryToLock, ObjectIsAlreadyLockedException nestedException) throws ServiceAccessException, ObjectNotFoundException {
        Uri objectUri = this.namespace.getUri(slideToken, token.getObjectUri());
        ObjectNode initialObject = objectUri.getStore().retrieveObject(objectUri);
        Enumeration scopes = objectUri.getScopes();
        boolean isLocked = false;
        while (!isLocked && scopes.hasMoreElements()) {
            String currentScope = (String)scopes.nextElement();
            Uri currentScopeUri = this.namespace.getUri(slideToken, currentScope);
            Enumeration locks = currentScopeUri.getStore().enumerateLocks(currentScopeUri);
            while (locks.hasMoreElements()) {
                NodeLock currentLockToken = (NodeLock)locks.nextElement();
                if (this.isCompatible(slideToken, token, currentLockToken, tryToLock)) continue;
                isLocked = true;
                if (nestedException == null) continue;
                nestedException.addException(new ObjectLockedException(currentScopeUri.toString()));
            }
        }
        if (token.isInheritable()) {
            Stack<ObjectNode> childrenStack = new Stack<ObjectNode>();
            childrenStack.push(initialObject);
            while (!isLocked && !childrenStack.empty()) {
                ObjectNode currentObject = (ObjectNode)childrenStack.pop();
                Uri currentObjectUri = this.namespace.getUri(slideToken, currentObject.getUri());
                Enumeration locks = currentObjectUri.getStore().enumerateLocks(currentObjectUri);
                while (locks.hasMoreElements()) {
                    NodeLock currentLockToken = (NodeLock)locks.nextElement();
                    if (this.isCompatible(slideToken, token, currentLockToken, tryToLock)) continue;
                    isLocked = true;
                    if (nestedException == null) continue;
                    nestedException.addException(new ObjectLockedException(currentObjectUri.toString()));
                }
                Vector<ObjectNode> childrenVector = new Vector<ObjectNode>();
                Enumeration childrenUri = currentObject.enumerateChildren();
                while (childrenUri.hasMoreElements()) {
                    String childUri = (String)childrenUri.nextElement();
                    Uri tempUri = this.namespace.getUri(slideToken, childUri);
                    ObjectNode child = tempUri.getStore().retrieveObject(tempUri);
                    childrenVector.addElement(child);
                }
                Enumeration children = childrenVector.elements();
                while (children.hasMoreElements()) {
                    ObjectNode tempObject = (ObjectNode)children.nextElement();
                    childrenStack.push(tempObject);
                }
            }
        }
        return isLocked;
    }

    private boolean isCompatible(SlideToken slideToken, NodeLock checkToken, NodeLock matchToken, boolean tryToLock) throws ServiceAccessException {
        boolean condition0;
        boolean compatible = true;
        if (matchToken.hasExpired()) {
            try {
                if (slideToken.isForceStoreEnlistment()) {
                    Uri token2Uri = this.namespace.getUri(slideToken, matchToken.getObjectUri());
                    token2Uri.getStore().removeLock(token2Uri, matchToken);
                }
            }
            catch (LockTokenNotFoundException e) {
                // empty catch block
            }
            return true;
        }
        boolean bl = condition0 = matchToken.getObjectUri().equals(checkToken.getObjectUri()) || matchToken.isInheritable();
        if (!condition0) {
            return true;
        }
        boolean condition1 = matchToken.getTypeUri().equals(checkToken.getTypeUri());
        SubjectNode checkSubject = SubjectNode.getSubjectNode(checkToken.getSubjectUri());
        SubjectNode matchSubject = SubjectNode.getSubjectNode(matchToken.getSubjectUri());
        boolean condition2 = this.securityHelper.matchPrincipal(slideToken, checkSubject, matchSubject);
        ActionNode checkAction = ActionNode.getActionNode(checkToken.getTypeUri());
        ActionNode matchAction = ActionNode.getActionNode(matchToken.getTypeUri());
        boolean condition3 = this.securityHelper.matchAction(slideToken, checkAction, matchAction);
        boolean condition4 = checkToken.isExclusive();
        boolean condition5 = this.checkLockToken(slideToken, matchToken);
        boolean condition6 = slideToken.isEnforceLockTokens();
        if (tryToLock && condition1 && condition4 || condition3 && !condition2 && !condition6 || condition3 && !condition5 && condition6 || condition5 && !condition2) {
            compatible = false;
        }
        if (checkToken.isShared() && matchToken.isShared() && tryToLock && condition1) {
            compatible = true;
        }
        return compatible;
    }

    private boolean isCompatible_OLD(SlideToken slideToken, NodeLock token1, NodeLock token2, boolean tryToLock) {
        boolean compatible = true;
        if (token2.hasExpired()) {
            try {
                if (slideToken.isForceStoreEnlistment()) {
                    Uri token2Uri = this.namespace.getUri(slideToken, token2.getObjectUri());
                    token2Uri.getStore().removeLock(token2Uri, token2);
                }
            }
            catch (SlideException e) {
                e.printStackTrace();
            }
        } else {
            boolean condition7;
            boolean condition1 = token2.getTypeUri().equals(token1.getTypeUri());
            boolean condition2 = token1.getSubjectUri().startsWith(token2.getSubjectUri());
            boolean condition3 = token2.getTypeUri().startsWith(token1.getTypeUri());
            boolean condition4 = token1.isExclusive();
            boolean condition5 = this.checkLockToken(slideToken, token2);
            boolean condition6 = slideToken.isEnforceLockTokens();
            boolean bl = condition7 = token2.getObjectUri().equals(token1.getObjectUri()) || token2.isInheritable();
            if (tryToLock && condition1 && condition4 && condition7 || condition3 && !condition2 && !condition6 && condition7 || condition3 && !condition5 && condition6 && condition7) {
                compatible = false;
            }
            if (token1.isShared() && token2.isShared() && tryToLock && condition1) {
                compatible = true;
            }
        }
        return compatible;
    }
}

