/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.search;

import java.util.HashMap;
import java.util.Map;
import org.apache.slide.common.Namespace;
import org.apache.slide.common.NamespaceConfig;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.SlideToken;
import org.apache.slide.content.Content;
import org.apache.slide.event.EventDispatcher;
import org.apache.slide.event.SearchEvent;
import org.apache.slide.event.VetoException;
import org.apache.slide.search.BadQueryException;
import org.apache.slide.search.PropertyProvider;
import org.apache.slide.search.Search;
import org.apache.slide.search.SearchLanguage;
import org.apache.slide.search.SearchQuery;
import org.apache.slide.search.SearchQueryResult;
import org.apache.slide.search.SearchToken;
import org.apache.slide.search.basic.BasicSearchLanguage;
import org.apache.slide.structure.Structure;
import org.jdom.Element;

public final class SearchImpl
implements Search {
    private static final SearchLanguage[] SEARCH_LANGUAGES = new SearchLanguage[]{new BasicSearchLanguage()};
    private static final Map GRAMMAR_BY_URI = new HashMap();
    private static final String LOG_CHANNEL;
    private Namespace namespace;
    private Structure structureHelper;
    private NamespaceConfig namespaceConfig;
    private Content contentHelper;
    static /* synthetic */ Class class$org$apache$slide$search$SearchImpl;

    public SearchImpl(Namespace namespace, NamespaceConfig namespaceConfig, Structure structureHelper, Content contentHelper) {
        this.namespace = namespace;
        this.namespaceConfig = namespaceConfig;
        this.structureHelper = structureHelper;
        this.contentHelper = contentHelper;
    }

    public SearchQueryResult search(SlideToken token, SearchQuery query) throws ServiceAccessException, VetoException {
        if (SearchEvent.SEARCH.isEnabled()) {
            EventDispatcher.getInstance().fireVetoableEvent(SearchEvent.SEARCH, new SearchEvent(this, token, this.namespace, query));
        }
        return query.execute();
    }

    public SearchLanguage[] getSupportedLanguages() {
        return SEARCH_LANGUAGES;
    }

    public SearchLanguage getLanguage(String grammarUri) throws BadQueryException {
        SearchLanguage result = (SearchLanguage)GRAMMAR_BY_URI.get(grammarUri);
        if (result == null) {
            throw new BadQueryException("grammar not found: " + grammarUri);
        }
        return result;
    }

    public SearchQuery createSearchQuery(String grammarUri, Element queryElement, SlideToken token, int maxDepth) throws BadQueryException {
        return this.createSearchQuery(grammarUri, queryElement, token, maxDepth, (PropertyProvider)null);
    }

    public SearchQuery createSearchQuery(String grammarUri, Element searchRequestElement, SlideToken token, int maxDepth, PropertyProvider propertyProvider) throws BadQueryException {
        return this.createSearchQuery(grammarUri, searchRequestElement, token, maxDepth, propertyProvider, null);
    }

    public SearchQuery createSearchQuery(String grammarUri, Element queryElement, SlideToken token, int maxDepth, String requestUri) throws BadQueryException {
        return this.createSearchQuery(grammarUri, queryElement, token, maxDepth, null, requestUri);
    }

    public SearchQuery createSearchQuery(String grammarUri, Element searchRequestElement, SlideToken token, int maxDepth, PropertyProvider propertyProvider, String requestUri) throws BadQueryException {
        SearchQuery result = null;
        SearchToken searchToken = SearchToken.createSearchToken(token, this.contentHelper, this.structureHelper, maxDepth, requestUri, this.namespace);
        SearchLanguage language = this.getLanguage(grammarUri);
        result = language.parseQuery(searchRequestElement, searchToken, propertyProvider);
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        for (int i = 0; i < SEARCH_LANGUAGES.length; ++i) {
            GRAMMAR_BY_URI.put(SEARCH_LANGUAGES[i].getGrammarUri(), SEARCH_LANGUAGES[i]);
        }
        LOG_CHANNEL = (class$org$apache$slide$search$SearchImpl == null ? (class$org$apache$slide$search$SearchImpl = SearchImpl.class$("org.apache.slide.search.SearchImpl")) : class$org$apache$slide$search$SearchImpl).getName();
    }
}

