/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.search.basic;

import java.util.Collection;
import org.apache.slide.content.NodeProperty;
import org.apache.slide.search.BadQueryException;
import org.apache.slide.search.InvalidQueryException;
import org.apache.slide.search.PropertyProvider;
import org.apache.slide.search.basic.ComparableResourcesPool;
import org.apache.slide.search.basic.ComparableResourcesPoolImpl;
import org.apache.slide.search.basic.IBasicExpression;
import org.apache.slide.search.basic.IBasicExpressionFactory;
import org.apache.slide.search.basic.IBasicQuery;
import org.apache.slide.search.basic.expression.AndExpression;
import org.apache.slide.search.basic.expression.CompareExpression;
import org.apache.slide.search.basic.expression.ComparePropertyExpression;
import org.apache.slide.search.basic.expression.ContainsExpression;
import org.apache.slide.search.basic.expression.EQExpression;
import org.apache.slide.search.basic.expression.EmptyExpression;
import org.apache.slide.search.basic.expression.GTEExpression;
import org.apache.slide.search.basic.expression.GTExpression;
import org.apache.slide.search.basic.expression.GenericBasicExpression;
import org.apache.slide.search.basic.expression.IsCollectionExpression;
import org.apache.slide.search.basic.expression.IsDefinedExpression;
import org.apache.slide.search.basic.expression.IsPrincipalExpression;
import org.apache.slide.search.basic.expression.LTEExpression;
import org.apache.slide.search.basic.expression.LTExpression;
import org.apache.slide.search.basic.expression.NotContainsExpression;
import org.apache.slide.search.basic.expression.NotEQExpression;
import org.apache.slide.search.basic.expression.NotGTEExpression;
import org.apache.slide.search.basic.expression.NotGTExpression;
import org.apache.slide.search.basic.expression.NotIsCollectionExpression;
import org.apache.slide.search.basic.expression.NotIsDefinedExpression;
import org.apache.slide.search.basic.expression.NotIsPrincipalExpression;
import org.apache.slide.search.basic.expression.NotLTEExpression;
import org.apache.slide.search.basic.expression.NotLTExpression;
import org.apache.slide.search.basic.expression.NotPropContainsExpression;
import org.apache.slide.search.basic.expression.OrExpression;
import org.apache.slide.search.basic.expression.PropContainsExpression;
import org.jdom.Element;

public class BasicExpressionFactory
implements IBasicExpressionFactory {
    protected ComparableResourcesPool requestedResourcePool = null;
    protected IBasicQuery query = null;
    protected PropertyProvider propertyProvider = null;

    public BasicExpressionFactory() {
        this(null);
    }

    public BasicExpressionFactory(ComparableResourcesPool requestedResourcePool) {
        this.requestedResourcePool = requestedResourcePool;
    }

    public void init(IBasicQuery query, PropertyProvider propertyProvider) throws BadQueryException {
        this.query = query;
        this.propertyProvider = propertyProvider;
    }

    public IBasicQuery getQuery() {
        return this.query;
    }

    public PropertyProvider getPropertyProvider() {
        return this.propertyProvider;
    }

    public IBasicExpression createMergeExpression(String name, String namespace, Collection expressionsToMerge) throws BadQueryException {
        IBasicExpression result = null;
        if (name == null) {
            result = new EmptyExpression(this.getRequestedResourcePool());
        } else {
            if ("DAV:".equals(namespace)) {
                if (name.equals("and")) {
                    result = new AndExpression(new Element(name, NodeProperty.NamespaceCache.getNamespace(namespace)), expressionsToMerge);
                } else if (name.equals("or")) {
                    result = new OrExpression(new Element(name, NodeProperty.NamespaceCache.getNamespace(namespace)), expressionsToMerge);
                }
            }
            if (result == null) {
                throw new InvalidQueryException("operator <DAV::" + name + "> is an unprocessable entity");
            }
        }
        if (result != null) {
            result.setFactory(this);
        }
        return result;
    }

    public IBasicExpression createExpression(Element element) throws BadQueryException {
        IBasicExpression result = null;
        if (element == null) {
            result = new EmptyExpression(this.getRequestedResourcePool());
        } else {
            String namespace = element.getNamespace().getURI();
            String name = element.getName();
            if (namespace.equals("DAV:")) {
                result = this.createDAVExpression(element);
            } else if (namespace.equals("http://jakarta.apache.org/slide/")) {
                result = this.createNonDAVExpression(element, namespace);
            } else {
                throw new InvalidQueryException("operator <" + namespace + ":" + name + "> is an unprocessable entity");
            }
        }
        if (result != null) {
            result.setFactory(this);
        }
        return result;
    }

    private GenericBasicExpression createDAVExpression(Element e) throws BadQueryException {
        String name = e.getName();
        CompareExpression result = null;
        if (name.equals("gt")) {
            result = new GTExpression(e, this.getRequestedResourcePool());
        } else if (name.equals("not-gt")) {
            result = new NotGTExpression(e, this.getRequestedResourcePool());
        } else if (name.equals("gte")) {
            result = new GTEExpression(e, this.getRequestedResourcePool());
        } else if (name.equals("not-gte")) {
            result = new NotGTEExpression(e, this.getRequestedResourcePool());
        } else if (name.equals("lt")) {
            result = new LTExpression(e, this.getRequestedResourcePool());
        } else if (name.equals("not-lt")) {
            result = new NotLTExpression(e, this.getRequestedResourcePool());
        } else if (name.equals("lte")) {
            result = new LTEExpression(e, this.getRequestedResourcePool());
        } else if (name.equals("not-lte")) {
            result = new NotLTEExpression(e, this.getRequestedResourcePool());
        } else if (name.equals("eq")) {
            result = new EQExpression(e, this.getRequestedResourcePool());
        } else if (name.equals("not-eq")) {
            result = new NotEQExpression(e, this.getRequestedResourcePool());
        } else if (name.equals("contains")) {
            result = new ContainsExpression(e, this.getRequestedResourcePool());
        } else if (name.equals("not-contains")) {
            result = new NotContainsExpression(e, this.getRequestedResourcePool());
        } else if (name.equals("is-collection")) {
            result = new IsCollectionExpression(e, this.getRequestedResourcePool());
        } else if (name.equals("not-is-collection")) {
            result = new NotIsCollectionExpression(e, this.getRequestedResourcePool());
        } else if (name.equals("is-defined")) {
            result = new IsDefinedExpression(e, this.getRequestedResourcePool());
        } else if (name.equals("not-is-defined")) {
            result = new NotIsDefinedExpression(e, this.getRequestedResourcePool());
        } else {
            throw new InvalidQueryException("operator <DAV::" + name + "> is an unprocessable entity");
        }
        return result;
    }

    private GenericBasicExpression createNonDAVExpression(Element e, String namespace) throws BadQueryException {
        String name = e.getName();
        ComparePropertyExpression result = null;
        if (namespace.equals("http://jakarta.apache.org/slide/") && name.equals("is-principal")) {
            result = new IsPrincipalExpression(e, this.getRequestedResourcePool());
        } else if (namespace.equals("http://jakarta.apache.org/slide/") && name.equals("not-is-principal")) {
            result = new NotIsPrincipalExpression(e, this.getRequestedResourcePool());
        } else if (namespace.equals("http://jakarta.apache.org/slide/") && name.equals("propcontains")) {
            result = new PropContainsExpression(e, this.getRequestedResourcePool());
        } else if (namespace.equals("http://jakarta.apache.org/slide/") && name.equals("not-propcontains")) {
            result = new NotPropContainsExpression(e, this.getRequestedResourcePool());
        } else {
            throw new InvalidQueryException("operator <" + namespace + ":" + name + "> is an unprocessable entity");
        }
        return result;
    }

    protected ComparableResourcesPool getRequestedResourcePool() throws BadQueryException {
        if (this.requestedResourcePool == null) {
            this.requestedResourcePool = new ComparableResourcesPoolImpl(this.query.getSearchToken(), this.query.getScope(), this.getPropertyProvider());
        }
        return this.requestedResourcePool;
    }
}

