/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.search.basic;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.slide.common.PropertyName;
import org.apache.slide.search.CompareHint;
import org.apache.slide.search.InvalidQueryException;
import org.apache.slide.search.basic.ComparableResource;
import org.jdom.Attribute;
import org.jdom.DataConversionException;
import org.jdom.Element;
import org.jdom.Namespace;

public class OrderBy {
    private Comparator theComparator = new _Comparator();
    protected List orderByElements = new ArrayList();

    public void init(Element orderByElement) throws InvalidQueryException {
        Namespace nameSpace = orderByElement.getNamespace();
        Iterator it = orderByElement.getChildren("order", nameSpace).iterator();
        while (it.hasNext()) {
            Element order = (Element)it.next();
            PropertyName p = this.getProperty(order);
            boolean isAscending = this.isAscending(order);
            boolean isCaseSensitive = this.isCaseSensitive(order);
            this.orderByElements.add(this.createCompareHint(p, isAscending, isCaseSensitive));
        }
    }

    protected CompareHint createCompareHint(PropertyName prop, boolean isAscending, boolean isCaseSensitive) {
        return new CompareHint(prop, isAscending, isCaseSensitive);
    }

    public Comparator getComparator() {
        return this.theComparator;
    }

    private boolean isCaseSensitive(Element order) {
        boolean result = true;
        Attribute caseSens = order.getAttribute("casesensitive", order.getNamespace());
        if (caseSens != null) {
            try {
                result = caseSens.getBooleanValue();
            }
            catch (DataConversionException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    private boolean isAscending(Element order) throws InvalidQueryException {
        Element asc = order.getChild("ascending", order.getNamespace());
        Element desc = order.getChild("descending", order.getNamespace());
        boolean result = true;
        if (asc != null && desc != null) {
            throw new InvalidQueryException("either ascending or descending may be supplied");
        }
        if (desc != null) {
            result = false;
        }
        return result;
    }

    private PropertyName getProperty(Element orderElem) throws InvalidQueryException {
        List propList = orderElem.getChild("prop", orderElem.getNamespace()).getChildren();
        if (propList.size() != 1) {
            throw new InvalidQueryException("Expected exactly 1 prop element, found " + propList.size());
        }
        Element propElem = (Element)propList.get(0);
        return this.createProperty(propElem);
    }

    protected PropertyName createProperty(Element propElem) throws InvalidQueryException {
        String name = propElem.getName();
        String nameSpace = propElem.getNamespace().getURI();
        return new PropertyName(name, nameSpace);
    }

    private class _Comparator
    implements Comparator {
        private _Comparator() {
        }

        public int compare(Object o1, Object o2) {
            ComparableResource r1 = (ComparableResource)o1;
            ComparableResource r2 = (ComparableResource)o2;
            int result = 0;
            if (r1.getInternalHref().equals(r2.getInternalHref())) {
                result = 0;
            } else {
                Iterator it = OrderBy.this.orderByElements.iterator();
                while (it.hasNext() && result == 0) {
                    CompareHint obe = (CompareHint)it.next();
                    result = r1.compareTo(r2, obe);
                }
                if (result == 0) {
                    result = 1;
                }
            }
            return result;
        }
    }
}

