/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.security;

import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import org.apache.slide.common.Namespace;
import org.apache.slide.common.NamespaceConfig;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.SlideToken;
import org.apache.slide.common.Uri;
import org.apache.slide.content.NodeProperty;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionNumber;
import org.apache.slide.content.RevisionDescriptorNotFoundException;
import org.apache.slide.security.NodePermission;
import org.apache.slide.security.SecurityImpl;
import org.apache.slide.structure.ActionNode;
import org.apache.slide.structure.ObjectNode;
import org.apache.slide.structure.ObjectNotFoundException;
import org.apache.slide.structure.SubjectNode;
import org.apache.slide.util.XMLValue;
import org.jdom.JDOMException;

public class ACLSecurityImpl
extends SecurityImpl {
    private static final String LOG_CHANNEL = (class$org$apache$slide$security$ACLSecurityImpl == null ? (class$org$apache$slide$security$ACLSecurityImpl = ACLSecurityImpl.class$("org.apache.slide.security.ACLSecurityImpl")) : class$org$apache$slide$security$ACLSecurityImpl).getName();
    private static final Vector EMPTY_VECTOR = new Vector();
    static /* synthetic */ Class class$org$apache$slide$security$ACLSecurityImpl;

    public ACLSecurityImpl() {
    }

    public ACLSecurityImpl(Namespace namespace, NamespaceConfig namespaceConfig) {
        super(namespace, namespaceConfig);
    }

    public void init(Namespace namespace, NamespaceConfig namespaceConfig) {
        super.init(namespace, namespaceConfig);
    }

    public boolean hasPermission(ObjectNode object, SubjectNode subject, ActionNode action) throws ServiceAccessException, ObjectNotFoundException {
        throw new UnsupportedOperationException("Please use alternate signature: hasPermission(SlideToken token, ObjectNode object, ActionNode action)");
    }

    public boolean hasPermission(SlideToken token, ObjectNode objectNode, ActionNode actionNode) throws ServiceAccessException, ObjectNotFoundException {
        if (this.logger.isEnabled(LOG_CHANNEL, 7)) {
            try {
                this.logger.log("@@@ check object=" + objectNode + ", subject=" + this.getPrincipal(token) + ", action=" + actionNode, LOG_CHANNEL, 7);
            }
            catch (ObjectNotFoundException onfe) {
                // empty catch block
            }
        }
        if (actionNode == this.namespaceConfig.getDefaultAction()) {
            return true;
        }
        Enumeration permissions = this.enumeratePermissions(token, objectNode, true);
        return this.evaluateAcl(token, objectNode, actionNode, permissions);
    }

    public boolean hasRole(SlideToken token, String role) throws ServiceAccessException, ObjectNotFoundException {
        return this.hasRole(token, (SubjectNode)this.getPrincipal(token), role);
    }

    public boolean hasRole(SlideToken token, SubjectNode subjectNode, String role) throws ServiceAccessException, ObjectNotFoundException {
        SubjectNode roleNode = null;
        if (this.namespaceConfig.getRolesPath() != null && this.namespaceConfig.getRolesPath().length() != 0) {
            roleNode = SubjectNode.getSubjectNode(this.namespaceConfig.getRolesPath() + "/" + role);
        }
        if (roleNode != null && this.matchPrincipal(token, subjectNode, roleNode)) {
            return true;
        }
        SubjectNode groupNode = null;
        if (this.namespaceConfig.getGroupsPath() != null && this.namespaceConfig.getGroupsPath().length() != 0) {
            groupNode = SubjectNode.getSubjectNode(this.namespaceConfig.getGroupsPath() + "/" + role);
        }
        return groupNode != null && this.matchPrincipal(token, subjectNode, groupNode);
    }

    public boolean hasRole(ObjectNode object, String role) throws ServiceAccessException, ObjectNotFoundException {
        throw new UnsupportedOperationException("Please use alternate signature: hasRole(SlideToken token, String role)");
    }

    public Enumeration getRoles(SlideToken token) throws ServiceAccessException, ObjectNotFoundException {
        return this.getRoles(token, (SubjectNode)this.getPrincipal(token));
    }

    public Enumeration getRoles(SlideToken token, SubjectNode subjectNode) throws ServiceAccessException, ObjectNotFoundException {
        Uri subjectUri = this.namespace.getUri(token, subjectNode.getUri());
        subjectUri.getStore().retrieveObject(subjectUri);
        Vector<String> result = new Vector<String>();
        Uri rolesUri = null;
        ObjectNode rolesNode = null;
        if (this.namespaceConfig.getRolesPath() != null && this.namespaceConfig.getRolesPath().length() != 0) {
            rolesUri = this.namespace.getUri(token, this.namespaceConfig.getRolesPath());
            try {
                rolesNode = rolesUri.getStore().retrieveObject(rolesUri);
            }
            catch (ObjectNotFoundException e) {
                // empty catch block
            }
            if (rolesNode != null) {
                Enumeration rolesEnum = rolesNode.enumerateBindings();
                while (rolesEnum.hasMoreElements()) {
                    ObjectNode.Binding b = (ObjectNode.Binding)rolesEnum.nextElement();
                    String role = b.getName();
                    if (!this.hasRole(token, subjectNode, role)) continue;
                    result.add(role);
                }
            }
        }
        Uri groupsUri = null;
        ObjectNode groupsNode = null;
        if (this.namespaceConfig.getGroupsPath() != null && this.namespaceConfig.getGroupsPath().length() != 0 && (groupsNode = (groupsUri = this.namespace.getUri(token, this.namespaceConfig.getGroupsPath())).getStore().retrieveObject(groupsUri)) != null) {
            Enumeration groupsEnum = groupsNode.enumerateBindings();
            while (groupsEnum.hasMoreElements()) {
                ObjectNode.Binding b = (ObjectNode.Binding)groupsEnum.nextElement();
                String group = b.getName();
                if (!this.hasRole(token, subjectNode, group)) continue;
                result.add(group);
            }
        }
        return result.elements();
    }

    public Enumeration getGroupMembership(SlideToken token, SubjectNode subjectNode) throws ServiceAccessException, ObjectNotFoundException {
        Uri subjectUri = this.namespace.getUri(token, subjectNode.getUri());
        subjectUri.getStore().retrieveObject(subjectUri);
        Vector<String> result = new Vector<String>();
        Uri rolesUri = null;
        ObjectNode rolesNode = null;
        if (this.namespaceConfig.getRolesPath() != null && this.namespaceConfig.getRolesPath().length() != 0) {
            rolesUri = this.namespace.getUri(token, this.namespaceConfig.getRolesPath());
            try {
                rolesNode = rolesUri.getStore().retrieveObject(rolesUri);
            }
            catch (ObjectNotFoundException e) {
                // empty catch block
            }
            if (rolesNode != null) {
                Enumeration rolesEnum = rolesNode.enumerateBindings();
                while (rolesEnum.hasMoreElements()) {
                    ObjectNode.Binding b = (ObjectNode.Binding)rolesEnum.nextElement();
                    String role = b.getName();
                    Uri roleUri = this.namespace.getUri(token, this.namespaceConfig.getRolesPath() + "/" + role);
                    try {
                        XMLValue xmlVal;
                        List memberNodes;
                        NodeRevisionDescriptor nrd = roleUri.getStore().retrieveRevisionDescriptor(roleUri, new NodeRevisionNumber());
                        NodeProperty membersetProp = nrd.getProperty("group-member-set");
                        if (membersetProp == null || membersetProp.getValue() == null || !(memberNodes = (xmlVal = new XMLValue((String)membersetProp.getValue())).getHrefNodes()).contains(subjectNode)) continue;
                        result.add(roleUri.toString());
                    }
                    catch (RevisionDescriptorNotFoundException e) {
                    }
                    catch (JDOMException e) {}
                }
            }
        }
        Uri groupsUri = null;
        ObjectNode groupsNode = null;
        if (this.namespaceConfig.getGroupsPath() != null && this.namespaceConfig.getGroupsPath().length() != 0) {
            groupsUri = this.namespace.getUri(token, this.namespaceConfig.getGroupsPath());
            try {
                groupsNode = groupsUri.getStore().retrieveObject(groupsUri);
            }
            catch (ObjectNotFoundException e) {
                // empty catch block
            }
            if (groupsNode != null) {
                Enumeration rolesEnum = groupsNode.enumerateBindings();
                while (rolesEnum.hasMoreElements()) {
                    ObjectNode.Binding b = (ObjectNode.Binding)rolesEnum.nextElement();
                    String group = b.getName();
                    Uri roleUri = this.namespace.getUri(token, this.namespaceConfig.getGroupsPath() + "/" + group);
                    try {
                        XMLValue xmlVal;
                        List memberNodes;
                        NodeRevisionDescriptor nrd = roleUri.getStore().retrieveRevisionDescriptor(roleUri, new NodeRevisionNumber());
                        NodeProperty membersetProp = nrd.getProperty("group-member-set");
                        if (membersetProp == null || membersetProp.getValue() == null || !(memberNodes = (xmlVal = new XMLValue((String)membersetProp.getValue())).getHrefNodes()).contains(subjectNode)) continue;
                        result.add(roleUri.toString());
                    }
                    catch (RevisionDescriptorNotFoundException e) {
                    }
                    catch (JDOMException e) {}
                }
            }
        }
        return result.elements();
    }

    public Enumeration getRoles(ObjectNode object) {
        return EMPTY_VECTOR.elements();
    }

    private boolean evaluateAcl(SlideToken token, ObjectNode objectNode, ActionNode actionNode, Enumeration permissions) throws ServiceAccessException, ObjectNotFoundException {
        boolean result = false;
        SubjectNode subjectNode = (SubjectNode)this.getPrincipal(token);
        while (permissions.hasMoreElements()) {
            NodePermission permission = (NodePermission)permissions.nextElement();
            if (!this.match(token, objectNode, subjectNode, actionNode, permission)) continue;
            result = !permission.isNegative();
            break;
        }
        return result;
    }

    private boolean match(SlideToken token, ObjectNode objectNode, SubjectNode subjectNode, ActionNode actionNode, NodePermission permission) throws ServiceAccessException {
        boolean result = true;
        boolean bl = result = this.matchAction(token, actionNode, permission.getActionNode()) && this.matchSubject(token, objectNode, subjectNode, permission.getSubjectNode());
        if (this.logger.isEnabled(LOG_CHANNEL, 7)) {
            this.logger.log("    permission=" + permission + ", match=" + result, LOG_CHANNEL, 7);
        }
        return result;
    }

    private boolean matchSubject(SlideToken token, ObjectNode objectNode, SubjectNode checkSubject, SubjectNode permSubject) throws ServiceAccessException {
        if (permSubject.equals(SubjectNode.ALL)) {
            return true;
        }
        if (permSubject.equals(SubjectNode.AUTHENTICATED)) {
            return !checkSubject.equals(SubjectNode.UNAUTHENTICATED);
        }
        if (permSubject.equals(SubjectNode.UNAUTHENTICATED)) {
            return checkSubject.equals(SubjectNode.UNAUTHENTICATED);
        }
        if (permSubject.equals(SubjectNode.OWNER)) {
            return this.matchOwner(token, objectNode, checkSubject);
        }
        if (permSubject.equals(SubjectNode.SELF)) {
            return this.matchPrincipal(token, checkSubject, (SubjectNode)objectNode);
        }
        return this.matchPrincipal(token, checkSubject, permSubject);
    }

    private boolean matchOwner(SlideToken token, ObjectNode objectNode, SubjectNode checkSubject) throws ServiceAccessException {
        Uri objectUri = this.namespace.getUri(token, objectNode.getUri());
        try {
            NodeRevisionDescriptor nrd = objectUri.getStore().retrieveRevisionDescriptor(objectUri, new NodeRevisionNumber());
            NodeProperty ownerProp = nrd.getProperty("owner");
            if (ownerProp != null && ownerProp.getValue() != null) {
                String usersPath = this.namespace.getConfig().getUsersPath();
                SubjectNode ownerSubject = SubjectNode.getSubjectNode(usersPath + "/" + ownerProp.getValue());
                return ownerSubject.equals(checkSubject);
            }
            return false;
        }
        catch (RevisionDescriptorNotFoundException e) {
            return false;
        }
        catch (ServiceAccessException e) {
            throw e;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

