/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.store;

import java.util.Enumeration;
import java.util.Vector;
import org.apache.slide.common.Service;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.Uri;
import org.apache.slide.common.UriPath;
import org.apache.slide.content.NodeProperty;
import org.apache.slide.content.NodeRevisionContent;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionDescriptors;
import org.apache.slide.content.NodeRevisionNumber;
import org.apache.slide.content.RevisionAlreadyExistException;
import org.apache.slide.content.RevisionDescriptorNotFoundException;
import org.apache.slide.content.RevisionNotFoundException;
import org.apache.slide.lock.LockTokenNotFoundException;
import org.apache.slide.lock.NodeLock;
import org.apache.slide.security.NodePermission;
import org.apache.slide.store.ExtendedStore;
import org.apache.slide.store.NodeStore;
import org.apache.slide.store.ResourceId;
import org.apache.slide.structure.ObjectAlreadyExistsException;
import org.apache.slide.structure.ObjectNode;
import org.apache.slide.structure.ObjectNotFoundException;
import org.apache.slide.util.Configuration;
import org.apache.slide.util.XMLValue;
import org.jdom.Content;
import org.jdom.Element;

public class BindingStore
extends ExtendedStore {
    public ObjectNode retrieveObject(Uri uri) throws ServiceAccessException, ObjectNotFoundException {
        if (uri instanceof ResourceId) {
            return super.retrieveObject(uri);
        }
        return this.doRetrieveObjectNode(uri);
    }

    public void storeObject(Uri uri, ObjectNode object) throws ServiceAccessException, ObjectNotFoundException {
        if (uri instanceof ResourceId) {
            super.storeObject(uri, object);
        } else {
            ResourceId resourceId = this.obtainResourceId(uri);
            ObjectNode objectClone = object.cloneObject();
            objectClone.setUri(resourceId.getUuri());
            resourceId.getStore().storeObject(resourceId, objectClone);
        }
    }

    public void createObject(Uri uri, ObjectNode object) throws ServiceAccessException, ObjectAlreadyExistsException {
        if (uri instanceof ResourceId) {
            super.createObject(uri, object);
        } else {
            ResourceId resourceId = ResourceId.createNew(uri);
            object.setUuri(resourceId.getUuri());
            ObjectNode objectClone = object.cloneObject();
            objectClone.setUri(resourceId.getUuri());
            this.cacheResolve(uri, resourceId);
            resourceId.getStore().createObject(resourceId, objectClone);
        }
    }

    public void removeObject(Uri uri, ObjectNode object) throws ServiceAccessException, ObjectNotFoundException {
        if (uri instanceof ResourceId) {
            super.removeObject(uri, object);
        } else {
            ResourceId resourceId = this.obtainResourceId(uri);
            ObjectNode objectClone = object.cloneObject();
            objectClone.setUri(resourceId.getUuri());
            this.cacheResolve(uri, null);
            resourceId.getStore().removeObject(resourceId, objectClone);
        }
    }

    public void grantPermission(Uri uri, NodePermission permission) throws ServiceAccessException {
        if (uri instanceof ResourceId) {
            super.grantPermission(uri, permission);
        } else {
            try {
                ResourceId resourceId = this.obtainResourceId(uri);
                NodePermission permissionClone = permission.cloneObject();
                permissionClone.setObject(resourceId.getUuri());
                resourceId.getStore().grantPermission(resourceId, permissionClone);
            }
            catch (ObjectNotFoundException e) {
                throw new ServiceAccessException((Service)this, (Throwable)e);
            }
        }
    }

    public void revokePermission(Uri uri, NodePermission permission) throws ServiceAccessException {
        if (uri instanceof ResourceId) {
            super.revokePermission(uri, permission);
        } else {
            try {
                ResourceId resourceId = this.obtainResourceId(uri);
                NodePermission permissionClone = permission.cloneObject();
                permissionClone.setObject(resourceId.getUuri());
                resourceId.getStore().revokePermission(resourceId, permissionClone);
            }
            catch (ObjectNotFoundException e) {
                throw new ServiceAccessException((Service)this, (Throwable)e);
            }
        }
    }

    public void revokePermissions(Uri uri) throws ServiceAccessException {
        if (uri instanceof ResourceId) {
            super.revokePermissions(uri);
        } else {
            try {
                ResourceId resourceId = this.obtainResourceId(uri);
                resourceId.getStore().revokePermissions(resourceId);
            }
            catch (ObjectNotFoundException e) {
                throw new ServiceAccessException((Service)this, (Throwable)e);
            }
        }
    }

    public Enumeration enumeratePermissions(Uri uri) throws ServiceAccessException {
        if (uri instanceof ResourceId) {
            return super.enumeratePermissions(uri);
        }
        try {
            ResourceId resourceId = this.obtainResourceId(uri);
            Enumeration permissions = resourceId.getStore().enumeratePermissions(resourceId);
            Vector<NodePermission> result = new Vector<NodePermission>();
            while (permissions.hasMoreElements()) {
                NodePermission p = ((NodePermission)permissions.nextElement()).cloneObject();
                p.setObject(uri.toString());
                result.add(p);
            }
            return result.elements();
        }
        catch (ObjectNotFoundException e) {
            throw new ServiceAccessException((Service)this, (Throwable)e);
        }
    }

    public void putLock(Uri uri, NodeLock lock) throws ServiceAccessException {
        if (uri instanceof ResourceId) {
            super.putLock(uri, lock);
        } else {
            try {
                ResourceId resourceId = this.obtainResourceId(uri);
                NodeLock lockClone = lock.cloneObject();
                lockClone.setObjectUri(resourceId.getUuri());
                resourceId.getStore().putLock(resourceId, lockClone);
            }
            catch (ObjectNotFoundException e) {
                throw new ServiceAccessException((Service)this, (Throwable)e);
            }
        }
    }

    public void renewLock(Uri uri, NodeLock lock) throws ServiceAccessException, LockTokenNotFoundException {
        if (uri instanceof ResourceId) {
            super.renewLock(uri, lock);
        } else {
            try {
                ResourceId resourceId = this.obtainResourceId(uri);
                NodeLock lockClone = lock.cloneObject();
                lockClone.setObjectUri(resourceId.getUuri());
                resourceId.getStore().renewLock(resourceId, lockClone);
            }
            catch (ObjectNotFoundException e) {
                throw new ServiceAccessException((Service)this, (Throwable)e);
            }
        }
    }

    public void removeLock(Uri uri, NodeLock lock) throws ServiceAccessException, LockTokenNotFoundException {
        if (uri instanceof ResourceId) {
            super.removeLock(uri, lock);
        } else {
            try {
                ResourceId resourceId = this.obtainResourceId(uri);
                NodeLock lockClone = lock.cloneObject();
                lockClone.setObjectUri(resourceId.getUuri());
                resourceId.getStore().removeLock(resourceId, lockClone);
            }
            catch (ObjectNotFoundException e) {
                throw new ServiceAccessException((Service)this, (Throwable)e);
            }
        }
    }

    public void killLock(Uri uri, NodeLock lock) throws ServiceAccessException, LockTokenNotFoundException {
        if (uri instanceof ResourceId) {
            super.killLock(uri, lock);
        } else {
            try {
                ResourceId resourceId = this.obtainResourceId(uri);
                NodeLock lockClone = lock.cloneObject();
                lockClone.setObjectUri(resourceId.getUuri());
                resourceId.getStore().killLock(resourceId, lockClone);
            }
            catch (ObjectNotFoundException e) {
                throw new ServiceAccessException((Service)this, (Throwable)e);
            }
        }
    }

    public Enumeration enumerateLocks(Uri uri) throws ServiceAccessException {
        if (uri instanceof ResourceId) {
            return super.enumerateLocks(uri);
        }
        try {
            ResourceId resourceId = this.obtainResourceId(uri);
            Enumeration locks = resourceId.getStore().enumerateLocks(resourceId);
            Vector<NodeLock> result = new Vector<NodeLock>();
            while (locks.hasMoreElements()) {
                NodeLock l = ((NodeLock)locks.nextElement()).cloneObject();
                l.setObjectUri(uri.toString());
                result.add(l);
            }
            return result.elements();
        }
        catch (ObjectNotFoundException e) {
            throw new ServiceAccessException((Service)this, (Throwable)e);
        }
    }

    public NodeRevisionDescriptors retrieveRevisionDescriptors(Uri uri) throws ServiceAccessException, RevisionDescriptorNotFoundException {
        if (uri instanceof ResourceId) {
            return super.retrieveRevisionDescriptors(uri);
        }
        try {
            ResourceId resourceId = this.obtainResourceId(uri);
            NodeRevisionDescriptors nrdsClone = resourceId.getStore().retrieveRevisionDescriptors(resourceId).cloneObject();
            nrdsClone.setUri(uri.toString());
            return nrdsClone;
        }
        catch (ObjectNotFoundException e) {
            throw new ServiceAccessException((Service)this, (Throwable)e);
        }
    }

    public void createRevisionDescriptors(Uri uri, NodeRevisionDescriptors revisionDescriptors) throws ServiceAccessException {
        if (uri instanceof ResourceId) {
            super.createRevisionDescriptors(uri, revisionDescriptors);
        } else {
            try {
                ResourceId resourceId = this.obtainResourceId(uri);
                NodeRevisionDescriptors nrdsClone = revisionDescriptors.cloneObject();
                nrdsClone.setUri(resourceId.getUuri());
                resourceId.getStore().createRevisionDescriptors(resourceId, nrdsClone);
            }
            catch (ObjectNotFoundException e) {
                throw new ServiceAccessException((Service)this, (Throwable)e);
            }
        }
    }

    public void storeRevisionDescriptors(Uri uri, NodeRevisionDescriptors revisionDescriptors) throws ServiceAccessException, RevisionDescriptorNotFoundException {
        if (uri instanceof ResourceId) {
            super.storeRevisionDescriptors(uri, revisionDescriptors);
        } else {
            try {
                ResourceId resourceId = this.obtainResourceId(uri);
                NodeRevisionDescriptors nrdsClone = revisionDescriptors.cloneObject();
                nrdsClone.setUri(resourceId.getUuri());
                resourceId.getStore().storeRevisionDescriptors(resourceId, nrdsClone);
            }
            catch (ObjectNotFoundException e) {
                throw new ServiceAccessException((Service)this, (Throwable)e);
            }
        }
    }

    public void removeRevisionDescriptors(Uri uri) throws ServiceAccessException {
        if (uri instanceof ResourceId) {
            super.removeRevisionDescriptors(uri);
        } else {
            try {
                ResourceId resourceId = this.obtainResourceId(uri);
                resourceId.getStore().removeRevisionDescriptors(resourceId);
            }
            catch (ObjectNotFoundException e) {
                throw new ServiceAccessException((Service)this, (Throwable)e);
            }
        }
    }

    public NodeRevisionDescriptor retrieveRevisionDescriptor(Uri uri, NodeRevisionNumber revisionNumber) throws ServiceAccessException, RevisionDescriptorNotFoundException {
        if (uri instanceof ResourceId) {
            return super.retrieveRevisionDescriptor(uri, revisionNumber);
        }
        try {
            ObjectNode objectNode = this.doRetrieveObjectNode(uri);
            ResourceId resourceId = this.obtainResourceId(uri);
            NodeRevisionDescriptor nrd = resourceId.getStore().retrieveRevisionDescriptor(resourceId, revisionNumber);
            nrd.setProperty("resource-id", resourceId.asXml());
            nrd.setProperty("parent-set", this.getXmlParentSet(uri, objectNode));
            return nrd;
        }
        catch (ObjectNotFoundException e) {
            throw new ServiceAccessException((Service)this, (Throwable)e);
        }
    }

    public String getXmlParentSet(Uri uri, ObjectNode objectNode) throws ServiceAccessException, ObjectNotFoundException {
        ResourceId resourceId = this.obtainResourceId(uri);
        boolean useBinding = Configuration.useBinding(this) && !resourceId.isStoreRoot();
        XMLValue result = new XMLValue();
        Enumeration parentBindings = objectNode.enumerateParentBindings();
        while (parentBindings.hasMoreElements()) {
            String uriStr;
            ObjectNode.Binding parentBinding = (ObjectNode.Binding)parentBindings.nextElement();
            Element parentElm = new Element("parent", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
            Element hrefElm = new Element("href", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
            String parentUriStr = new UriPath(objectNode.getUri()).parent().toString();
            Uri parentUri = new Uri(uri.getToken(), uri.getNamespace(), parentUriStr);
            if (useBinding) {
                ResourceId parentResourceId = ResourceId.create(parentUri, parentBinding.getUuri());
                uriStr = this.getFirstMapping(parentResourceId);
            } else {
                uriStr = parentUriStr;
            }
            hrefElm.setText(uriStr);
            parentElm.addContent((Content)hrefElm);
            Element segmentElm = new Element("segment", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
            segmentElm.setText(parentBinding.getName());
            parentElm.addContent((Content)segmentElm);
            result.add(parentElm);
        }
        return result.toString();
    }

    private String getFirstMapping(ResourceId resourceId) throws ServiceAccessException, ObjectNotFoundException {
        String result = "";
        while (!resourceId.isStoreRoot()) {
            ObjectNode objectNode = resourceId.getStore().retrieveObject(resourceId);
            Enumeration enumeration = objectNode.enumerateParentBindings();
            if (!enumeration.hasMoreElements()) {
                throw new IllegalStateException();
            }
            ObjectNode.Binding parentBinding = (ObjectNode.Binding)enumeration.nextElement();
            String parentSegment = parentBinding.getName();
            result = "/" + parentSegment + result;
            resourceId = ResourceId.create(resourceId, parentBinding.getUuri());
        }
        return "/".equals(resourceId.getScope().toString()) ? result : resourceId.getScope() + result;
    }

    public void createRevisionDescriptor(Uri uri, NodeRevisionDescriptor revisionDescriptor) throws ServiceAccessException {
        if (uri instanceof ResourceId) {
            super.createRevisionDescriptor(uri, revisionDescriptor);
        } else {
            try {
                revisionDescriptor.removeProperty("resource-id");
                revisionDescriptor.removeProperty("parent-set");
                ResourceId resourceId = this.obtainResourceId(uri);
                resourceId.getStore().createRevisionDescriptor(resourceId, revisionDescriptor);
            }
            catch (ObjectNotFoundException e) {
                throw new ServiceAccessException((Service)this, (Throwable)e);
            }
        }
    }

    public void storeRevisionDescriptor(Uri uri, NodeRevisionDescriptor revisionDescriptor) throws ServiceAccessException, RevisionDescriptorNotFoundException {
        if (uri instanceof ResourceId) {
            super.storeRevisionDescriptor(uri, revisionDescriptor);
        } else {
            try {
                revisionDescriptor.removeProperty("resource-id");
                revisionDescriptor.removeProperty("parent-set");
                ResourceId resourceId = this.obtainResourceId(uri);
                resourceId.getStore().storeRevisionDescriptor(resourceId, revisionDescriptor);
            }
            catch (ObjectNotFoundException e) {
                throw new ServiceAccessException((Service)this, (Throwable)e);
            }
        }
    }

    public void removeRevisionDescriptor(Uri uri, NodeRevisionNumber number) throws ServiceAccessException {
        if (uri instanceof ResourceId) {
            super.removeRevisionDescriptor(uri, number);
        } else {
            try {
                ResourceId resourceId = this.obtainResourceId(uri);
                resourceId.getStore().removeRevisionDescriptor(resourceId, number);
            }
            catch (ObjectNotFoundException e) {
                throw new ServiceAccessException((Service)this, (Throwable)e);
            }
        }
    }

    public NodeRevisionContent retrieveRevisionContent(Uri uri, NodeRevisionDescriptor revisionDescriptor) throws ServiceAccessException, RevisionNotFoundException {
        if (uri instanceof ResourceId) {
            return super.retrieveRevisionContent(uri, revisionDescriptor);
        }
        try {
            ResourceId resourceId = this.obtainResourceId(uri);
            return resourceId.getStore().retrieveRevisionContent(resourceId, revisionDescriptor);
        }
        catch (ObjectNotFoundException e) {
            throw new ServiceAccessException((Service)this, (Throwable)e);
        }
    }

    public void createRevisionContent(Uri uri, NodeRevisionDescriptor revisionDescriptor, NodeRevisionContent revisionContent) throws ServiceAccessException, RevisionAlreadyExistException {
        if (uri instanceof ResourceId) {
            super.createRevisionContent(uri, revisionDescriptor, revisionContent);
        } else {
            try {
                ResourceId resourceId = this.obtainResourceId(uri);
                resourceId.getStore().createRevisionContent(resourceId, revisionDescriptor, revisionContent);
            }
            catch (ObjectNotFoundException e) {
                throw new ServiceAccessException((Service)this, (Throwable)e);
            }
        }
    }

    public void storeRevisionContent(Uri uri, NodeRevisionDescriptor revisionDescriptor, NodeRevisionContent revisionContent) throws ServiceAccessException, RevisionNotFoundException {
        if (uri instanceof ResourceId) {
            super.storeRevisionContent(uri, revisionDescriptor, revisionContent);
        } else {
            try {
                ResourceId resourceId = this.obtainResourceId(uri);
                resourceId.getStore().storeRevisionContent(resourceId, revisionDescriptor, revisionContent);
            }
            catch (ObjectNotFoundException e) {
                throw new ServiceAccessException((Service)this, (Throwable)e);
            }
        }
    }

    public void removeRevisionContent(Uri uri, NodeRevisionDescriptor revisionDescriptor) throws ServiceAccessException {
        if (uri instanceof ResourceId) {
            super.removeRevisionContent(uri, revisionDescriptor);
        } else {
            try {
                ResourceId resourceId = this.obtainResourceId(uri);
                resourceId.getStore().removeRevisionContent(resourceId, revisionDescriptor);
            }
            catch (ObjectNotFoundException e) {
                throw new ServiceAccessException((Service)this, (Throwable)e);
            }
        }
    }

    public NodeStore getNodeStore() {
        return this.nodeStore;
    }

    public boolean useBinding() {
        return !"false".equalsIgnoreCase((String)this.getParameter("useBinding"));
    }

    private ObjectNode doRetrieveObjectNode(Uri uri) throws ServiceAccessException, ObjectNotFoundException {
        ObjectNode result;
        if (Configuration.useBinding(this)) {
            result = this.doResolve(uri);
            result.setUuri(result.getUri());
            result.setUri(uri.toString());
        } else {
            ResourceId resourceId = ResourceId.create(uri, uri.toString());
            result = resourceId.getStore().retrieveObject(resourceId);
            result.setUuri(result.getUri());
        }
        return result;
    }

    private ObjectNode doResolve(Uri uri) throws ObjectNotFoundException, ServiceAccessException {
        ResourceId resourceId = this.checkResolveCache(uri);
        if (resourceId == null) {
            int start;
            UriPath uriPath = new UriPath(uri.toString());
            String[] segments = uriPath.tokens();
            String rootUriStr = uri.getScope().toString();
            if (!"/".equals(rootUriStr)) {
                rootUriStr = rootUriStr + "/";
            }
            String currentUriStr = rootUriStr;
            Uri currentUri = new Uri(uri.getToken(), uri.getNamespace(), currentUriStr);
            ResourceId currentResourceId = ResourceId.create(currentUri, currentUriStr);
            for (int i = start = new UriPath(rootUriStr).tokens().length; i < segments.length; ++i) {
                ObjectNode objectNode = currentResourceId.getStore().retrieveObject(currentResourceId);
                objectNode.setUri(currentUriStr);
                currentUriStr = uriPath.subUriPath(0, i + 1).toString();
                currentUri = new Uri(uri.getToken(), uri.getNamespace(), currentUriStr);
                String currentUuri = objectNode.getBindingUuri(segments[i]);
                if (currentUuri == null) {
                    throw new ObjectNotFoundException(currentUriStr);
                }
                currentResourceId = ResourceId.create(currentUri, currentUuri);
            }
            resourceId = currentResourceId;
            this.cacheResolve(uri, resourceId);
        }
        return resourceId.getStore().retrieveObject(resourceId);
    }

    private void cacheResolve(Uri uri, ResourceId resourceId) {
        if (uri.getToken() != null) {
            uri.getToken().cacheResolve(uri, resourceId);
        }
    }

    private ResourceId checkResolveCache(Uri uri) {
        ResourceId resourceId = null;
        if (uri.getToken() != null) {
            resourceId = uri.getToken().checkResolveCache(uri);
        }
        return resourceId;
    }

    private ResourceId obtainResourceId(Uri uri) throws ServiceAccessException, ObjectNotFoundException {
        ObjectNode objectNode = this.doRetrieveObjectNode(uri);
        ResourceId resourceId = ResourceId.create(uri, objectNode.getUuri());
        return resourceId;
    }
}

