/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.structure;

import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import org.apache.slide.common.Namespace;
import org.apache.slide.common.NamespaceConfig;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.SlideToken;
import org.apache.slide.common.Uri;
import org.apache.slide.common.UriPath;
import org.apache.slide.common.UriTokenizer;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionNumber;
import org.apache.slide.content.RevisionDescriptorNotFoundException;
import org.apache.slide.event.EventDispatcher;
import org.apache.slide.event.StructureEvent;
import org.apache.slide.event.VetoException;
import org.apache.slide.lock.Lock;
import org.apache.slide.lock.ObjectLockedException;
import org.apache.slide.security.AccessDeniedException;
import org.apache.slide.security.Security;
import org.apache.slide.store.Store;
import org.apache.slide.structure.CrossServerBindingException;
import org.apache.slide.structure.LinkNode;
import org.apache.slide.structure.LinkedObjectNotFoundException;
import org.apache.slide.structure.ObjectAlreadyExistsException;
import org.apache.slide.structure.ObjectHasChildrenException;
import org.apache.slide.structure.ObjectNode;
import org.apache.slide.structure.ObjectNotFoundException;
import org.apache.slide.structure.Structure;
import org.apache.slide.util.Configuration;

public final class StructureImpl
implements Structure {
    private Namespace namespace;
    private NamespaceConfig namespaceConfig;
    private Security securityHelper;
    private Lock lockHelper;

    public StructureImpl(Namespace namespace, NamespaceConfig namespaceConfig, Security securityHelper, Lock lockHelper) {
        this.namespace = namespace;
        this.namespaceConfig = namespaceConfig;
        this.securityHelper = securityHelper;
        this.lockHelper = lockHelper;
    }

    public String generateUniqueUri(SlideToken token, String parentUri) throws ServiceAccessException {
        String sequenceName = parentUri.replace('/', '-');
        Uri uri = this.namespace.getUri(token, parentUri);
        Store store = uri.getStore();
        if (!store.isSequenceSupported()) {
            return null;
        }
        if (!store.sequenceExists(sequenceName)) {
            store.createSequence(sequenceName);
        }
        long next = store.nextSequenceValue(sequenceName);
        String uniqueUri = parentUri + "/" + next;
        return uniqueUri;
    }

    public Enumeration getChildren(SlideToken token, ObjectNode object) throws ServiceAccessException, ObjectNotFoundException, LinkedObjectNotFoundException, VetoException {
        Enumeration childrenUri = object.enumerateChildren();
        Vector<ObjectNode> result = new Vector<ObjectNode>();
        while (childrenUri.hasMoreElements()) {
            String childUri = (String)childrenUri.nextElement();
            try {
                ObjectNode child = this.retrieve(token, childUri, false);
                result.addElement(child);
            }
            catch (AccessDeniedException e) {}
        }
        return result.elements();
    }

    public ObjectNode getParent(SlideToken token, ObjectNode object) throws ServiceAccessException, ObjectNotFoundException, LinkedObjectNotFoundException, AccessDeniedException, VetoException {
        String objectUriStr = object.getUri();
        Uri parentUri = this.namespace.getUri(token, objectUriStr).getParentUri();
        if (parentUri == null) {
            return null;
        }
        String parentUriStr = parentUri.toString();
        ObjectNode parent = this.retrieve(token, parentUriStr);
        return parent;
    }

    public ObjectNode retrieve(SlideToken token, String strUri) throws ServiceAccessException, ObjectNotFoundException, LinkedObjectNotFoundException, AccessDeniedException, VetoException {
        return this.retrieve(token, strUri, true);
    }

    public ObjectNode retrieve(SlideToken token, String strUri, boolean translateLastUriElement) throws ServiceAccessException, ObjectNotFoundException, LinkedObjectNotFoundException, AccessDeniedException, VetoException {
        Uri uri = this.namespace.getUri(token, strUri);
        ObjectNode result = null;
        if (StructureEvent.RETRIEVE.isEnabled()) {
            EventDispatcher.getInstance().fireVetoableEvent(StructureEvent.RETRIEVE, new StructureEvent((Object)this, token, this.namespace, strUri));
        }
        try {
            result = uri.getStore().retrieveObject(uri);
            this.securityHelper.checkCredentials(token, result, this.namespaceConfig.getReadObjectAction());
            if (translateLastUriElement && result instanceof LinkNode) {
                LinkNode link = (LinkNode)result;
                Uri linkedUri = this.namespace.getUri(token, link.getLinkedUri());
                result = linkedUri.getStore().retrieveObject(linkedUri);
                this.securityHelper.checkCredentials(token, result, this.namespaceConfig.getReadObjectAction());
            }
        }
        catch (ObjectNotFoundException e) {
            // empty catch block
        }
        if (result == null) {
            String resolvedUri = uri.toString();
            UriTokenizer uriTokenizer = new UriTokenizer(token, uri.getNamespace(), resolvedUri);
            Uri courUri = null;
            ObjectNode courObject = null;
            while (uriTokenizer.hasMoreElements()) {
                courUri = uriTokenizer.nextUri();
                courObject = courUri.getStore().retrieveObject(courUri);
                this.securityHelper.checkCredentials(token, courObject, this.namespaceConfig.getReadObjectAction());
                if ((!translateLastUriElement || !(courObject instanceof LinkNode)) && (translateLastUriElement || !uriTokenizer.hasMoreElements() || !(courObject instanceof LinkNode))) continue;
                Uri linkedUri = this.namespace.getUri(token, ((LinkNode)courObject).getLinkedUri());
                String courStrUri = courUri.toString();
                resolvedUri = linkedUri.toString() + resolvedUri.substring(courStrUri.length());
                uriTokenizer = new UriTokenizer(token, uri.getNamespace(), resolvedUri);
                boolean isUriFound = false;
                while (!isUriFound && uriTokenizer.hasMoreElements()) {
                    if (!linkedUri.equals(uriTokenizer.nextUri())) continue;
                    isUriFound = true;
                }
                if (isUriFound) continue;
                throw new LinkedObjectNotFoundException(courUri, resolvedUri);
            }
            result = courObject;
        }
        return result;
    }

    public void create(SlideToken token, ObjectNode object, String strUri) throws ServiceAccessException, ObjectAlreadyExistsException, ObjectNotFoundException, LinkedObjectNotFoundException, AccessDeniedException, ObjectLockedException, VetoException {
        if (StructureEvent.CREATE.isEnabled()) {
            EventDispatcher.getInstance().fireVetoableEvent(StructureEvent.CREATE, new StructureEvent((Object)this, token, this.namespace, strUri));
        }
        Enumeration roles = this.securityHelper.getRoles(object);
        while (roles.hasMoreElements()) {
            if (this.securityHelper.hasRole(token, (String)roles.nextElement())) continue;
            Uri rootUri = this.namespace.getUri(token, "/");
            ObjectNode rootObject = rootUri.getStore().retrieveObject(rootUri);
            this.securityHelper.checkCredentials(token, rootObject, this.namespaceConfig.getGrantPermissionAction());
            break;
        }
        String resolvedUri = strUri;
        UriTokenizer uriTokenizer = new UriTokenizer(token, this.namespace, resolvedUri);
        Uri courUri = null;
        ObjectNode courObject = null;
        ObjectNode parentObject = null;
        boolean alreadyExists = false;
        while (uriTokenizer.hasMoreElements()) {
            parentObject = courObject;
            courUri = uriTokenizer.nextUri();
            try {
                courObject = courUri.getStore().retrieveObject(courUri);
                this.securityHelper.checkCredentials(token, courObject, this.namespaceConfig.getReadObjectAction());
                if (!uriTokenizer.hasMoreElements()) {
                    alreadyExists = true;
                }
            }
            catch (ObjectNotFoundException e) {
                ObjectNode newObject = null;
                if (uriTokenizer.hasMoreElements()) {
                    throw new ObjectNotFoundException(courUri);
                }
                newObject = object;
                if (parentObject != null) {
                    String bindingName;
                    if (!token.isExternalTransaction()) {
                        this.namespace.getUri(token, parentObject.getUri()).getStore().exclusiveTransientLock(parentObject.getUri().toString());
                    }
                    this.securityHelper.checkCredentials(token, courObject, this.namespaceConfig.getBindMemberAction());
                    newObject.setUri(courUri.toString());
                    courUri.getStore().createObject(courUri, newObject);
                    Uri parentUri = this.namespace.getUri(token, parentObject.getUri());
                    parentObject = parentUri.getStore().retrieveObject(parentUri);
                    ObjectNode oldChild = null;
                    if (Configuration.useBinding(parentUri.getStore()) && parentObject.hasBinding(bindingName = newObject.getPath().lastSegment())) {
                        oldChild = this.retrieve(token, parentObject.getUri() + "/" + bindingName, false);
                        parentObject.removeChild(oldChild);
                        this.store(token, oldChild);
                    }
                } else {
                    throw new ObjectNotFoundException(courUri);
                }
                this.lockHelper.checkLock(token, parentObject, this.namespaceConfig.getCreateObjectAction());
                parentObject.addChild(newObject);
                this.store(token, parentObject, true);
                this.store(token, newObject);
                courObject = newObject;
            }
            if (!uriTokenizer.hasMoreElements() || !(courObject instanceof LinkNode)) continue;
            Uri linkedUri = this.namespace.getUri(token, ((LinkNode)courObject).getLinkedUri());
            String courStrUri = courUri.toString();
            resolvedUri = linkedUri.toString() + resolvedUri.substring(courStrUri.length());
            uriTokenizer = new UriTokenizer(token, this.namespace, resolvedUri);
            boolean isUriFound = false;
            while (!isUriFound && uriTokenizer.hasMoreElements()) {
                if (!linkedUri.equals(uriTokenizer.nextUri())) continue;
                isUriFound = true;
            }
            if (isUriFound) continue;
            throw new LinkedObjectNotFoundException(courUri, resolvedUri);
        }
        if (alreadyExists) {
            if (courUri.isStoreRoot() && parentObject != null && !parentObject.hasChild(courObject)) {
                parentObject.addChild(courObject);
                this.store(token, parentObject, true);
            }
            throw new ObjectAlreadyExistsException(strUri);
        }
    }

    public void createLink(SlideToken token, LinkNode link, String linkUri, ObjectNode linkedObject) throws ServiceAccessException, ObjectAlreadyExistsException, ObjectNotFoundException, LinkedObjectNotFoundException, AccessDeniedException, ObjectLockedException, VetoException {
        link.setLinkedUri(linkedObject.getUri());
        if (StructureEvent.CREATE.isEnabled()) {
            EventDispatcher.getInstance().fireVetoableEvent(StructureEvent.CREATE_LINK, new StructureEvent((Object)this, token, link, linkUri));
        }
        this.create(token, link, linkUri);
    }

    public void store(SlideToken token, ObjectNode object) throws ServiceAccessException, ObjectNotFoundException, AccessDeniedException, LinkedObjectNotFoundException, VetoException {
        this.store(token, object, false);
    }

    protected void store(SlideToken token, ObjectNode object, boolean setModificationDate) throws ServiceAccessException, ObjectNotFoundException, AccessDeniedException, LinkedObjectNotFoundException, VetoException {
        if (StructureEvent.STORE.isEnabled()) {
            EventDispatcher.getInstance().fireVetoableEvent(StructureEvent.STORE, new StructureEvent((Object)this, token, this.namespace, object));
        }
        Enumeration roles = this.securityHelper.getRoles(object);
        while (roles.hasMoreElements()) {
            if (this.securityHelper.hasRole(token, (String)roles.nextElement())) continue;
            Uri rootUri = this.namespace.getUri(token, "/");
            ObjectNode rootObject = rootUri.getStore().retrieveObject(rootUri);
            this.securityHelper.checkCredentials(token, rootObject, this.namespaceConfig.getGrantPermissionAction());
            break;
        }
        this.securityHelper.checkCredentials(token, object, this.namespaceConfig.getCreateObjectAction());
        Uri uri = this.namespace.getUri(token, object.getUri());
        Store store = uri.getStore();
        store.storeObject(uri, object);
        if (setModificationDate) {
            try {
                NodeRevisionDescriptor revisionDescriptor = store.retrieveRevisionDescriptor(uri, new NodeRevisionNumber());
                revisionDescriptor.setModificationDate(new Date());
                revisionDescriptor.setModificationUser(this.securityHelper.getPrincipal(token).getPath().lastSegment());
                store.storeRevisionDescriptor(uri, revisionDescriptor);
            }
            catch (RevisionDescriptorNotFoundException e) {
                // empty catch block
            }
        }
    }

    public void remove(SlideToken token, ObjectNode object) throws ServiceAccessException, ObjectNotFoundException, ObjectHasChildrenException, AccessDeniedException, LinkedObjectNotFoundException, ObjectLockedException, VetoException {
        ObjectNode nodeToDelete = this.retrieve(token, object.getUri(), false);
        Uri uri = this.namespace.getUri(token, nodeToDelete.getUri());
        if (StructureEvent.REMOVE.isEnabled()) {
            EventDispatcher.getInstance().fireVetoableEvent(StructureEvent.REMOVE, new StructureEvent((Object)this, token, object, uri.toString()));
        }
        if (!object.getUri().equals("/")) {
            Uri curUri = this.namespace.getUri(token, nodeToDelete.getUri());
            Uri parentUri = curUri.getParentUri();
            if (!token.isExternalTransaction()) {
                parentUri.getStore().exclusiveTransientLock(parentUri.toString());
            }
            ObjectNode parentNode = parentUri.getStore().retrieveObject(parentUri);
            this.securityHelper.checkCredentials(token, nodeToDelete, this.namespaceConfig.getRemoveObjectAction());
            this.securityHelper.checkCredentials(token, parentNode, this.namespaceConfig.getUnbindMemberAction());
            this.lockHelper.checkLock(token, nodeToDelete, this.namespaceConfig.getRemoveObjectAction());
            this.lockHelper.checkLock(token, parentNode, this.namespaceConfig.getUnbindMemberAction());
            parentNode.removeChild(nodeToDelete);
            this.store(token, parentNode, true);
            if (Configuration.useBinding(curUri.getStore()) && nodeToDelete.numberOfParentBindings() > 0) {
                this.store(token, nodeToDelete);
            } else {
                Enumeration enumeration = nodeToDelete.enumerateChildren();
                if (enumeration.hasMoreElements()) {
                    throw new ObjectHasChildrenException(uri);
                }
                uri.getStore().removeObject(uri, nodeToDelete);
            }
        }
    }

    public void addBinding(SlideToken token, ObjectNode collectionNode, String segment, ObjectNode sourceNode) throws ServiceAccessException, ObjectNotFoundException, AccessDeniedException, LinkedObjectNotFoundException, ObjectLockedException, CrossServerBindingException, VetoException {
        if (Configuration.useBinding(this.namespace.getUri(token, collectionNode.getUri()).getStore())) {
            collectionNode = this.retrieve(token, collectionNode.getUri(), false);
            sourceNode = this.retrieve(token, sourceNode.getUri(), false);
            Uri collectionUri = this.namespace.getUri(token, collectionNode.getUri());
            if (StructureEvent.ADD_BINDING.isEnabled()) {
                EventDispatcher.getInstance().fireVetoableEvent(StructureEvent.ADD_BINDING, new StructureEvent((Object)this, token, sourceNode, collectionUri.toString()));
            }
            this.lockHelper.checkLock(token, collectionNode, this.namespaceConfig.getCreateObjectAction());
            ObjectNode oldChild = null;
            if (collectionNode.hasBinding(segment)) {
                oldChild = this.retrieve(token, collectionNode.getUri() + "/" + segment, false);
                this.lockHelper.checkLock(token, oldChild, this.namespaceConfig.getCreateObjectAction());
                collectionNode.removeChild(oldChild);
                this.store(token, oldChild);
            }
            collectionNode.addBinding(segment, sourceNode);
            this.store(token, collectionNode, true);
            this.store(token, sourceNode);
        }
    }

    public void removeBinding(SlideToken token, ObjectNode collectionNode, String segment) throws ServiceAccessException, ObjectNotFoundException, AccessDeniedException, LinkedObjectNotFoundException, ObjectLockedException, VetoException {
        if (Configuration.useBinding(this.namespace.getUri(token, collectionNode.getUri()).getStore())) {
            collectionNode = this.retrieve(token, collectionNode.getUri(), false);
            ObjectNode childNode = this.retrieve(token, collectionNode.getUri() + "/" + segment, false);
            if (StructureEvent.REMOVE_BINDING.isEnabled()) {
                EventDispatcher.getInstance().fireVetoableEvent(StructureEvent.REMOVE_BINDING, new StructureEvent((Object)this, token, childNode, collectionNode.getUri()));
            }
            this.lockHelper.checkLock(token, collectionNode, this.namespaceConfig.getCreateObjectAction());
            this.lockHelper.checkLock(token, childNode, this.namespaceConfig.getCreateObjectAction());
            collectionNode.removeChild(childNode);
            this.store(token, childNode);
            this.store(token, collectionNode, true);
        }
    }

    public List getParents(SlideToken token, ObjectNode object, boolean pathOnly, boolean storeOnly, boolean includeSelf) throws ServiceAccessException, ObjectNotFoundException, LinkedObjectNotFoundException, AccessDeniedException, VetoException {
        ArrayList<ObjectNode> result = new ArrayList<ObjectNode>();
        if (pathOnly) {
            String[] uriTokens = object.getPath().tokens();
            UriPath path = new UriPath("/");
            Uri currentUri = this.namespace.getUri(token, path.toString());
            Uri objectUri = this.namespace.getUri(token, object.getUri());
            if (!storeOnly || currentUri.getStore() == objectUri.getStore()) {
                result.add(this.retrieve(token, path.toString()));
            }
            for (int i = 0; i < uriTokens.length; ++i) {
                path = path.child(uriTokens[i]);
                currentUri = this.namespace.getUri(token, path.toString());
                if (i == uriTokens.length - 1 && !includeSelf) break;
                if (storeOnly && currentUri.getStore() != objectUri.getStore()) continue;
                result.add(this.retrieve(token, path.toString()));
            }
        }
        return result;
    }
}

