/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.util;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.slide.content.NodeProperty;
import org.apache.slide.structure.SubjectNode;
import org.jdom.CDATA;
import org.jdom.Comment;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.EntityRef;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.ProcessingInstruction;
import org.jdom.Text;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLFilter;
import org.xml.sax.helpers.XMLFilterImpl;

public class XMLValue
implements Cloneable,
Comparable {
    public static final String ELEMENT_MUST_NOT_BE_NULL = "'null' Element is not allowed";
    public static final String TYPE_MISMATCH = "Only objects of type Element are allowed";
    protected static final String START_TAG = "<root>";
    protected static final String END_TAG = "</root>";
    protected static final String E_HREF = "href";
    protected ArrayList elementList = new ArrayList();

    public XMLValue() {
        this((List)null);
    }

    public XMLValue(Element element) throws IllegalArgumentException {
        this((List)null);
        this.add(element);
    }

    public XMLValue(List elementList) throws IllegalArgumentException {
        this.add(elementList);
    }

    public XMLValue(String xmlString) throws JDOMException {
        this(xmlString, null);
    }

    public XMLValue(String xmlString, Namespace defaultNamespace) throws JDOMException {
        this((List)null);
        this.add(xmlString, defaultNamespace);
    }

    public void add(Element element) throws IllegalArgumentException {
        if (element == null) {
            throw new IllegalArgumentException(ELEMENT_MUST_NOT_BE_NULL);
        }
        this.elementList.add(element);
    }

    public void add(Text text) throws IllegalArgumentException {
        if (text == null) {
            throw new IllegalArgumentException(ELEMENT_MUST_NOT_BE_NULL);
        }
        this.elementList.add(text);
    }

    public void add(Comment comment) throws IllegalArgumentException {
        if (comment == null) {
            throw new IllegalArgumentException(ELEMENT_MUST_NOT_BE_NULL);
        }
        this.elementList.add(comment);
    }

    public void add(ProcessingInstruction pi) throws IllegalArgumentException {
        if (pi == null) {
            throw new IllegalArgumentException(ELEMENT_MUST_NOT_BE_NULL);
        }
        this.elementList.add(pi);
    }

    public void add(CDATA cdata) throws IllegalArgumentException {
        if (cdata == null) {
            throw new IllegalArgumentException(ELEMENT_MUST_NOT_BE_NULL);
        }
        this.elementList.add(cdata);
    }

    public void add(EntityRef eref) throws IllegalArgumentException {
        if (eref == null) {
            throw new IllegalArgumentException(ELEMENT_MUST_NOT_BE_NULL);
        }
        this.elementList.add(eref);
    }

    public void add(List content) throws IllegalArgumentException {
        if (content != null) {
            Iterator iterator = content.iterator();
            while (iterator.hasNext()) {
                Object o = iterator.next();
                if (o == null) {
                    throw new IllegalArgumentException(ELEMENT_MUST_NOT_BE_NULL);
                }
                if (o instanceof Element) {
                    this.add((Element)o);
                    continue;
                }
                if (o instanceof Text) {
                    Text t = (Text)o;
                    t.setText(t.getTextTrim());
                    this.add(t);
                    continue;
                }
                if (o instanceof Comment) {
                    this.add((Comment)o);
                    continue;
                }
                if (o instanceof ProcessingInstruction) {
                    this.add((ProcessingInstruction)o);
                    continue;
                }
                if (o instanceof CDATA) {
                    this.add((CDATA)o);
                    continue;
                }
                if (o instanceof EntityRef) {
                    this.add((EntityRef)o);
                    continue;
                }
                throw new IllegalArgumentException(TYPE_MISMATCH);
            }
        }
    }

    public void add(String xmlString) throws JDOMException {
        this.add(xmlString, null);
    }

    public void add(String xmlString, Namespace defaultNamespace) throws JDOMException {
        if (xmlString != null && xmlString.length() > 0) {
            if ("<collection/>".equals(xmlString)) {
                this.add(new Element("collection", defaultNamespace));
            } else {
                StringBuffer buffer = new StringBuffer(START_TAG.length() + xmlString.length() + END_TAG.length());
                buffer.append(START_TAG);
                buffer.append(xmlString);
                buffer.append(END_TAG);
                SAXBuilder builder = new SAXBuilder();
                if (defaultNamespace != null) {
                    builder.setXMLFilter((XMLFilter)new DefaultNamespaceXMLFilter(defaultNamespace));
                }
                try {
                    Document document = builder.build((Reader)new StringReader(buffer.toString()));
                    List content = document.getRootElement().getContent();
                    this.add(content);
                    content.clear();
                }
                catch (Exception e) {
                    throw new JDOMException(e.getMessage());
                }
            }
        }
    }

    public void addHref(String path) {
        Element href = new Element(E_HREF, NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        href.setText(path);
        this.add(href);
    }

    public List getHrefStrings() {
        ArrayList<String> result = new ArrayList<String>();
        Iterator i = this.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (!(o instanceof Element) || !E_HREF.equals(((Element)o).getName())) continue;
            result.add(((Element)o).getTextTrim());
        }
        return result;
    }

    public List getHrefNodes() {
        ArrayList<SubjectNode> result = new ArrayList<SubjectNode>();
        Iterator i = this.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (!(o instanceof Element) || !E_HREF.equals(((Element)o).getName())) continue;
            result.add(SubjectNode.getSubjectNode(((Element)o).getTextTrim()));
        }
        return result;
    }

    public void stripServletContext(String servletContext) {
        Iterator i = this.iterator();
        while (i.hasNext()) {
            Element hrefElm;
            String href;
            Object o = i.next();
            if (!(o instanceof Element) || !E_HREF.equals(((Element)o).getName()) || !(href = (hrefElm = (Element)o).getTextTrim()).startsWith(servletContext)) continue;
            hrefElm.setContent(Arrays.asList(new Text(href.substring(servletContext.length()))));
        }
    }

    public Iterator iterator() {
        return this.elementList.iterator();
    }

    public int size() {
        return this.elementList.size();
    }

    public List getList() {
        return (List)this.elementList.clone();
    }

    public boolean equals(Object other) {
        if (!(other instanceof XMLValue)) {
            return false;
        }
        return this.toString().equals(other.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public Object clone() {
        return new XMLValue(this.elementList);
    }

    public String toString() {
        XMLOutputter outputter = new XMLOutputter();
        StringWriter stringWriter = new StringWriter();
        Iterator iterator = this.elementList.iterator();
        while (iterator.hasNext()) {
            try {
                Object o = iterator.next();
                if (o instanceof Element) {
                    outputter.output((Element)o, (Writer)stringWriter);
                    continue;
                }
                if (o instanceof Text) {
                    outputter.output((Text)o, (Writer)stringWriter);
                    continue;
                }
                if (o instanceof Comment) {
                    outputter.output((Comment)o, (Writer)stringWriter);
                    continue;
                }
                if (o instanceof ProcessingInstruction) {
                    outputter.output((ProcessingInstruction)o, (Writer)stringWriter);
                    continue;
                }
                if (o instanceof CDATA) {
                    outputter.output((CDATA)o, (Writer)stringWriter);
                    continue;
                }
                if (!(o instanceof EntityRef)) continue;
                outputter.output((EntityRef)o, (Writer)stringWriter);
            }
            catch (IOException e) {
                throw new RuntimeException("IOException occurred: " + e.getMessage());
            }
        }
        return stringWriter.toString();
    }

    public String getTextValue() {
        Iterator it = this.elementList.iterator();
        StringBuffer sb = new StringBuffer();
        while (it.hasNext()) {
            Object o = it.next();
            if (!(o instanceof Element)) continue;
            sb.append(((Element)o).getTextTrim());
        }
        return sb.toString();
    }

    public int compareTo(Object o) {
        String s1 = this.getTextValue();
        String s2 = ((XMLValue)o).getTextValue();
        return s1.compareTo(s2);
    }

    protected static class DefaultNamespaceXMLFilter
    extends XMLFilterImpl {
        Namespace defaultNamespace = null;

        public DefaultNamespaceXMLFilter(Namespace defaultNamespace) {
            this.defaultNamespace = defaultNamespace;
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            if (namespaceURI == null || namespaceURI.length() == 0) {
                namespaceURI = this.defaultNamespace.getURI();
                qName = this.defaultNamespace.getPrefix() + ":" + qName;
            }
            super.startElement(namespaceURI, localName, qName, atts);
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            if (namespaceURI == null || namespaceURI.length() == 0) {
                namespaceURI = this.defaultNamespace.getURI();
                qName = this.defaultNamespace.getPrefix() + ":" + qName;
            }
            super.endElement(namespaceURI, localName, qName);
        }
    }
}

